/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.AutoValue_Call;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OperandPosition;
import com.google.template.soy.jssrc.dsl.Operation;

@Immutable
abstract class Call
extends Operation {
    Call() {
    }

    abstract CodeChunk.WithValue receiver();

    abstract ImmutableList<CodeChunk.WithValue> args();

    static Call create(CodeChunk.WithValue receiver, ImmutableList<CodeChunk.WithValue> args) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(receiver.initialStatements());
        for (CodeChunk.WithValue arg : args) {
            builder.addAll(arg.initialStatements());
        }
        return new AutoValue_Call((ImmutableSet<CodeChunk>)builder.build(), receiver, args);
    }

    @Override
    int precedence() {
        return Integer.MAX_VALUE;
    }

    @Override
    Operator.Associativity associativity() {
        return Operator.Associativity.LEFT;
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        this.receiver().collectRequires(collector);
        for (CodeChunk.WithValue arg : this.args()) {
            arg.collectRequires(collector);
        }
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        this.formatOperand(this.receiver(), OperandPosition.LEFT, ctx);
        ctx.append('(');
        boolean first = true;
        for (CodeChunk.WithValue arg : this.args()) {
            if (first) {
                first = false;
            } else {
                ctx.append(", ");
            }
            arg.doFormatOutputExpr(ctx);
        }
        ctx.append(')');
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        ctx.appendInitialStatements(this.receiver());
        for (CodeChunk.WithValue arg : this.args()) {
            ctx.appendInitialStatements(arg);
        }
    }
}

