/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.runtime;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.restricted.SoyString;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.runtime.TombstoneValue;
import java.io.IOException;
import javax.annotation.Nullable;

public abstract class DetachableContentProvider
implements SoyValueProvider {
    @Nullable
    private final SanitizedContent.ContentKind contentKind;
    private SoyString resolvedValue;
    private LoggingAdvisingAppendable builder;

    protected DetachableContentProvider(@Nullable SanitizedContent.ContentKind contentKind) {
        this.contentKind = contentKind;
    }

    @Override
    public final SoyValue resolve() {
        SoyString local = this.resolvedValue;
        Preconditions.checkState((local != null ? 1 : 0) != 0, (Object)"called resolve() before status() returned ready.");
        Preconditions.checkState((local != TombstoneValue.INSTANCE ? 1 : 0) != 0, (Object)"called resolve() after calling renderAndResolve with isLast == true");
        return local;
    }

    @Override
    public final RenderResult status() {
        if (this.resolvedValue != null) {
            return RenderResult.done();
        }
        LoggingAdvisingAppendable.BufferingAppendable currentBuilder = (LoggingAdvisingAppendable.BufferingAppendable)this.builder;
        if (currentBuilder == null) {
            currentBuilder = LoggingAdvisingAppendable.buffering();
            this.builder = currentBuilder;
        }
        return this.doRenderIntoBufferingAppendable(currentBuilder);
    }

    @Override
    public RenderResult renderAndResolve(LoggingAdvisingAppendable appendable, boolean isLast) throws IOException {
        SoyString value = this.resolvedValue;
        if (value != null) {
            value.render(appendable);
            return RenderResult.done();
        }
        if (isLast) {
            RenderResult result = this.doRender(appendable);
            if (result.isDone()) {
                this.resolvedValue = TombstoneValue.INSTANCE;
            }
            return result;
        }
        TeeAdvisingAppendable currentBuilder = (TeeAdvisingAppendable)this.builder;
        if (currentBuilder == null) {
            currentBuilder = new TeeAdvisingAppendable(appendable);
            this.builder = currentBuilder;
        }
        return this.doRenderIntoBufferingAppendable(currentBuilder);
    }

    private RenderResult doRenderIntoBufferingAppendable(LoggingAdvisingAppendable target) {
        RenderResult result = this.doRender(target);
        if (result.isDone()) {
            this.resolvedValue = this.contentKind != null ? UnsafeSanitizedContentOrdainer.ordainAsSafe(target.toString(), this.contentKind) : StringData.forValue(target.toString());
        }
        return result;
    }

    protected abstract RenderResult doRender(LoggingAdvisingAppendable var1);

    private static final class TeeAdvisingAppendable
    extends LoggingAdvisingAppendable {
        final StringBuilder buffer = new StringBuilder();
        final LoggingAdvisingAppendable delegate;

        TeeAdvisingAppendable(LoggingAdvisingAppendable delegate) {
            this.delegate = delegate;
        }

        @Override
        public TeeAdvisingAppendable append(CharSequence csq) throws IOException {
            this.delegate.append(csq);
            this.buffer.append(csq);
            return this;
        }

        @Override
        public TeeAdvisingAppendable append(CharSequence csq, int start, int end) throws IOException {
            this.delegate.append(csq, start, end);
            this.buffer.append(csq, start, end);
            return this;
        }

        @Override
        public TeeAdvisingAppendable append(char c) throws IOException {
            this.delegate.append(c);
            this.buffer.append(c);
            return this;
        }

        @Override
        public boolean softLimitReached() {
            return this.delegate.softLimitReached();
        }

        public String toString() {
            return this.buffer.toString();
        }
    }
}

