/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.base.Ascii;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import com.google.template.soy.jbcsrc.api.Continuations;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.api.SoySauce;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyIdRenamingMap;
import com.google.template.soy.shared.internal.ApiCallScopeUtils;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;

public final class SoySauceImpl
implements SoySauce {
    private final CompiledTemplates templates;
    private final GuiceSimpleScope apiCallScope;
    private final SoyValueConverter converter;
    private final ImmutableMap<String, SoyJavaFunction> functions;
    private final ImmutableMap<String, SoyJavaPrintDirective> printDirectives;

    private SoySauceImpl(CompiledTemplates templates, GuiceSimpleScope apiCallScope, SoyValueConverter converter, ImmutableMap<String, ? extends SoyJavaFunction> functions, ImmutableMap<String, ? extends SoyJavaPrintDirective> printDirectives) {
        this.templates = (CompiledTemplates)Preconditions.checkNotNull((Object)templates);
        this.apiCallScope = (GuiceSimpleScope)Preconditions.checkNotNull((Object)apiCallScope);
        this.converter = (SoyValueConverter)Preconditions.checkNotNull((Object)converter);
        this.functions = ImmutableMap.copyOf(functions);
        this.printDirectives = ImmutableMap.copyOf(printDirectives);
    }

    public ImmutableSortedSet<String> getTransitiveIjParamsForTemplate(String templateName) {
        return this.templates.getTransitiveIjParamsForTemplate(templateName);
    }

    @Override
    public RendererImpl renderTemplate(String template) {
        CompiledTemplate.Factory factory = this.templates.getTemplateFactory(template);
        return new RendererImpl(template, factory, this.templates.getTemplateContentKind(template));
    }

    private static SoySauce.WriteContinuation doRender(CompiledTemplate template, Scoper scoper, LoggingAdvisingAppendable out, RenderContext context) throws IOException {
        RenderResult result;
        try (GuiceSimpleScope.InScope scope = scoper.enter();){
            result = template.render(out, context);
        }
        catch (Throwable t) {
            Names.rewriteStackTrace(t);
            Throwables.throwIfInstanceOf((Throwable)t, IOException.class);
            throw t;
        }
        if (result.isDone()) {
            return Continuations.done();
        }
        return new WriteContinuationImpl(result, scoper, context, out, template);
    }

    static /* synthetic */ ImmutableMap access$100(SoySauceImpl x0) {
        return x0.printDirectives;
    }

    static /* synthetic */ ImmutableMap access$200(SoySauceImpl x0) {
        return x0.functions;
    }

    static /* synthetic */ CompiledTemplates access$300(SoySauceImpl x0) {
        return x0.templates;
    }

    private static final class Scoper {
        final GuiceSimpleScope scope;
        final BidiGlobalDir dir;
        final String localeString;

        Scoper(GuiceSimpleScope scope, BidiGlobalDir dir, String localeString) {
            this.scope = scope;
            this.dir = dir;
            this.localeString = localeString;
        }

        GuiceSimpleScope.InScope enter() {
            GuiceSimpleScope.InScope withScope = this.scope.enter();
            ApiCallScopeUtils.seedSharedParams(withScope, this.dir, this.localeString);
            return withScope;
        }
    }

    private static final class WriteContinuationImpl
    implements SoySauce.WriteContinuation {
        final RenderResult result;
        final Scoper scoper;
        final RenderContext context;
        final LoggingAdvisingAppendable out;
        final CompiledTemplate template;
        boolean hasContinueBeenCalled;

        WriteContinuationImpl(RenderResult result, Scoper scoper, RenderContext context, LoggingAdvisingAppendable out, CompiledTemplate template) {
            Preconditions.checkArgument((!result.isDone() ? 1 : 0) != 0);
            this.result = (RenderResult)Preconditions.checkNotNull((Object)result);
            this.scoper = (Scoper)Preconditions.checkNotNull((Object)scoper);
            this.context = (RenderContext)Preconditions.checkNotNull((Object)context);
            this.out = (LoggingAdvisingAppendable)Preconditions.checkNotNull((Object)out);
            this.template = (CompiledTemplate)Preconditions.checkNotNull((Object)template);
        }

        @Override
        public RenderResult result() {
            return this.result;
        }

        @Override
        public SoySauce.WriteContinuation continueRender() throws IOException {
            if (this.hasContinueBeenCalled) {
                throw new IllegalStateException("continueRender() has already been called.");
            }
            this.hasContinueBeenCalled = true;
            return SoySauceImpl.doRender(this.template, this.scoper, this.out, this.context);
        }
    }

    private final class RendererImpl
    implements SoySauce.Renderer {
        private final String templateName;
        private final CompiledTemplate.Factory templateFactory;
        private final Optional<SanitizedContent.ContentKind> contentKind;
        private Predicate<String> activeDelegatePackages = Predicates.alwaysFalse();
        private SoyMsgBundle msgs = SoyMsgBundle.EMPTY;
        private final RenderContext.Builder contextBuilder = new RenderContext.Builder().withCompiledTemplates(SoySauceImpl.access$300(SoySauceImpl.this)).withSoyFunctions((ImmutableMap<String, SoyJavaFunction>)SoySauceImpl.access$200(SoySauceImpl.this)).withSoyPrintDirectives((Map<String, ? extends SoyJavaPrintDirective>)SoySauceImpl.access$100(SoySauceImpl.this));
        private SoyRecord data = SoyValueConverter.EMPTY_DICT;
        private SoyRecord ij = SoyValueConverter.EMPTY_DICT;
        private SanitizedContent.ContentKind expectedContentKind = SanitizedContent.ContentKind.HTML;
        private boolean contentKindExplicitlySet;

        RendererImpl(String templateName, CompiledTemplate.Factory templateFactory, Optional<SanitizedContent.ContentKind> contentKind) {
            this.templateName = templateName;
            this.templateFactory = (CompiledTemplate.Factory)Preconditions.checkNotNull((Object)templateFactory);
            this.contentKind = contentKind;
        }

        @Override
        public RendererImpl setIj(Map<String, ?> record) {
            this.ij = SoySauceImpl.this.converter.newDictFromMap((Map)Preconditions.checkNotNull(record));
            return this;
        }

        @Override
        public RendererImpl setData(Map<String, ?> record) {
            this.data = SoySauceImpl.this.converter.newDictFromMap((Map)Preconditions.checkNotNull(record));
            return this;
        }

        @Override
        public RendererImpl setActiveDelegatePackageSelector(Predicate<String> active) {
            this.activeDelegatePackages = (Predicate)Preconditions.checkNotNull(active);
            return this;
        }

        @Override
        public RendererImpl setCssRenamingMap(SoyCssRenamingMap cssRenamingMap) {
            this.contextBuilder.withCssRenamingMap(cssRenamingMap);
            return this;
        }

        @Override
        public RendererImpl setXidRenamingMap(SoyIdRenamingMap xidRenamingMap) {
            this.contextBuilder.withXidRenamingMap(xidRenamingMap);
            return this;
        }

        @Override
        public RendererImpl setMsgBundle(SoyMsgBundle msgs) {
            this.msgs = (SoyMsgBundle)Preconditions.checkNotNull((Object)msgs);
            return this;
        }

        @Override
        public RendererImpl setDebugSoyTemplateInfo(boolean debugSoyTemplateInfo) {
            this.contextBuilder.withDebugSoyTemplateInfo(debugSoyTemplateInfo);
            return this;
        }

        @Override
        public SoySauce.Renderer setExpectedContentKind(SanitizedContent.ContentKind expectedContentKind) {
            Preconditions.checkNotNull(this.contentKind);
            this.contentKindExplicitlySet = true;
            this.expectedContentKind = expectedContentKind;
            return this;
        }

        @Override
        public SoySauce.WriteContinuation render(AdvisingAppendable out) throws IOException {
            if (this.contentKindExplicitlySet || this.contentKind.isPresent()) {
                this.enforceContentKind();
            }
            return this.startRender(LoggingAdvisingAppendable.delegating(out));
        }

        @Override
        public SoySauce.Continuation<String> render() {
            if (this.contentKindExplicitlySet || this.contentKind.isPresent()) {
                this.enforceContentKind();
            }
            LoggingAdvisingAppendable.BufferingAppendable buf = LoggingAdvisingAppendable.buffering();
            try {
                return Continuations.stringContinuation(this.startRender(buf), buf);
            }
            catch (IOException e) {
                throw new AssertionError("impossible", e);
            }
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderStrict() {
            this.enforceContentKind();
            LoggingAdvisingAppendable.BufferingAppendable buf = LoggingAdvisingAppendable.buffering();
            try {
                return Continuations.strictContinuation(this.startRender(buf), buf, this.expectedContentKind);
            }
            catch (IOException e) {
                throw new AssertionError("impossible", e);
            }
        }

        private <T> SoySauce.WriteContinuation startRender(LoggingAdvisingAppendable out) throws IOException {
            RenderContext context = this.contextBuilder.withMessageBundle(this.msgs).withActiveDelPackageSelector(this.activeDelegatePackages).build();
            Scoper scoper = new Scoper(SoySauceImpl.this.apiCallScope, BidiGlobalDir.forStaticIsRtl(this.msgs.isRtl()), this.msgs.getLocaleString());
            CompiledTemplate template = this.templateFactory.create(this.data, this.ij);
            return SoySauceImpl.doRender(template, scoper, out, context);
        }

        private void enforceContentKind() {
            if (this.expectedContentKind == SanitizedContent.ContentKind.TEXT) {
                return;
            }
            if (!this.contentKind.isPresent()) {
                throw new IllegalStateException("Cannot render a non strict template as '" + Ascii.toLowerCase((String)this.expectedContentKind.name()) + "'");
            }
            if (this.expectedContentKind != this.contentKind.get()) {
                throw new IllegalStateException("Expected template to be kind=\"" + Ascii.toLowerCase((String)this.expectedContentKind.name()) + "\" but was kind=\"" + Ascii.toLowerCase((String)((SanitizedContent.ContentKind)((Object)this.contentKind.get())).name()) + "\": " + this.templateName);
            }
        }
    }

    public static final class Factory {
        private final GuiceSimpleScope apiCallScopeProvider;
        private final Provider<SoyValueConverter> converterProvider;

        @Inject
        Factory(@ApiCallScopeBindingAnnotations.ApiCall GuiceSimpleScope apiCallScopeProvider, Provider<SoyValueConverter> converterProvider) {
            this.apiCallScopeProvider = apiCallScopeProvider;
            this.converterProvider = converterProvider;
        }

        public SoySauceImpl create(CompiledTemplates templates, ImmutableMap<String, ? extends SoyFunction> soyFunctionMap, ImmutableMap<String, ? extends SoyPrintDirective> printDirectives) {
            ImmutableMap.Builder soyJavaFunctions = ImmutableMap.builder();
            for (Map.Entry entry : soyFunctionMap.entrySet()) {
                SoyFunction function = (SoyFunction)entry.getValue();
                if (!(function instanceof SoyJavaFunction)) continue;
                soyJavaFunctions.put(entry.getKey(), (Object)((SoyJavaFunction)function));
            }
            ImmutableMap.Builder soyJavaPrintDirectives = ImmutableMap.builder();
            for (Map.Entry entry : printDirectives.entrySet()) {
                SoyPrintDirective printDirective = (SoyPrintDirective)entry.getValue();
                if (!(printDirective instanceof SoyJavaPrintDirective)) continue;
                soyJavaPrintDirectives.put(entry.getKey(), (Object)((SoyJavaPrintDirective)printDirective));
            }
            return new SoySauceImpl(templates, this.apiCallScopeProvider, (SoyValueConverter)this.converterProvider.get(), soyJavaFunctions.build(), soyJavaPrintDirectives.build());
        }
    }
}

