/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.base.internal.UniqueNameGenerator;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.jbcsrc.AnnotationRef;
import com.google.template.soy.jbcsrc.AppendableExpression;
import com.google.template.soy.jbcsrc.AutoAnnotation_TemplateCompiler_createDefaultDelTemplateMetadata;
import com.google.template.soy.jbcsrc.AutoAnnotation_TemplateCompiler_createDelTemplateMetadata;
import com.google.template.soy.jbcsrc.AutoAnnotation_TemplateCompiler_createTemplateMetadata;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.ClassData;
import com.google.template.soy.jbcsrc.CodeBuilder;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.CompiledTemplateRegistry;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.FieldRef;
import com.google.template.soy.jbcsrc.InnerClasses;
import com.google.template.soy.jbcsrc.JbcSrcNameGenerators;
import com.google.template.soy.jbcsrc.LocalVariable;
import com.google.template.soy.jbcsrc.MethodRef;
import com.google.template.soy.jbcsrc.SoyClassWriter;
import com.google.template.soy.jbcsrc.SoyNodeCompiler;
import com.google.template.soy.jbcsrc.Statement;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.TemplateFactoryCompiler;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.TypeInfo;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.TemplateMetadata;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class TemplateCompiler {
    private static final AnnotationRef<TemplateMetadata> TEMPLATE_METADATA_REF = AnnotationRef.forType(TemplateMetadata.class);
    private static final TypeInfo TEMPLATE_TYPE = TypeInfo.create(CompiledTemplate.class);
    private final CompiledTemplateRegistry registry;
    private final FieldRef paramsField;
    private final FieldRef ijField;
    private final FieldRef stateField;
    private final UniqueNameGenerator fieldNames = JbcSrcNameGenerators.forFieldNames();
    private final ImmutableMap<String, FieldRef> paramFields;
    private final CompiledTemplateMetadata template;
    private final InnerClasses innerClasses;
    private SoyClassWriter writer;

    TemplateCompiler(CompiledTemplateRegistry registry, CompiledTemplateMetadata template) {
        this.registry = registry;
        this.template = template;
        TypeInfo ownerType = template.typeInfo();
        this.paramsField = FieldRef.createFinalField(ownerType, "$params", SoyRecord.class).asNonNull();
        this.ijField = FieldRef.createFinalField(ownerType, "$ij", SoyRecord.class).asNonNull();
        this.stateField = FieldRef.createField(ownerType, "$state", Type.INT_TYPE);
        this.innerClasses = new InnerClasses(ownerType);
        this.fieldNames.claimName("$params");
        this.fieldNames.claimName("$ij");
        this.fieldNames.claimName("$state");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TemplateParam param : template.node().getAllParams()) {
            String name = param.name();
            this.fieldNames.claimName(name);
            builder.put((Object)name, (Object)FieldRef.createFinalField(ownerType, name, SoyValueProvider.class).asNonNull());
        }
        this.paramFields = builder.build();
    }

    Iterable<ClassData> compile() {
        ArrayList<ClassData> classes = new ArrayList<ClassData>();
        if (this.template.node().getVisibility() != Visibility.PRIVATE) {
            new TemplateFactoryCompiler(this.template, this.innerClasses).compile();
        }
        this.writer = SoyClassWriter.builder(this.template.typeInfo()).setAccess(49).implementing(TEMPLATE_TYPE).sourceFileName(this.template.node().getSourceLocation().getFileName()).build();
        this.generateTemplateMetadata();
        this.generateKindMethod();
        this.stateField.defineField(this.writer);
        this.paramsField.defineField(this.writer);
        this.ijField.defineField(this.writer);
        for (FieldRef field : this.paramFields.values()) {
            field.defineField(this.writer);
        }
        Statement fieldInitializers = this.generateRenderMethod();
        this.generateConstructor(fieldInitializers);
        this.innerClasses.registerAllInnerClasses(this.writer);
        this.writer.visitEnd();
        classes.add(this.writer.toClassData());
        classes.addAll((Collection<ClassData>)this.innerClasses.getInnerClassData());
        this.writer = null;
        return classes;
    }

    private void generateKindMethod() {
        Statement.returnExpression(BytecodeUtils.constantSanitizedContentKindAsContentKind(this.template.node().getContentKind())).writeMethod(17, this.template.kindMethod().method(), this.writer);
    }

    private void generateTemplateMetadata() {
        TemplateDelegateNode delegateNode;
        SanitizedContentKind contentKind = this.template.node().getContentKind();
        String kind = contentKind == null ? "" : contentKind.name();
        LinkedHashSet<String> uniqueIjs = new LinkedHashSet<String>();
        for (VarRefNode var : SoyTreeUtils.getAllNodesOfType(this.template.node(), VarRefNode.class)) {
            if (!var.isInjected()) continue;
            uniqueIjs.add(var.getName());
        }
        LinkedHashSet<String> callees = new LinkedHashSet<String>();
        for (CallBasicNode call : SoyTreeUtils.getAllNodesOfType(this.template.node(), CallBasicNode.class)) {
            callees.add(call.getCalleeName());
        }
        LinkedHashSet<String> delCallees = new LinkedHashSet<String>();
        for (CallDelegateNode call : SoyTreeUtils.getAllNodesOfType(this.template.node(), CallDelegateNode.class)) {
            delCallees.add(call.getDelCalleeName());
        }
        TemplateMetadata.DelTemplateMetadata deltemplateMetadata = this.template.node().getKind() == SoyNode.Kind.TEMPLATE_DELEGATE_NODE ? TemplateCompiler.createDelTemplateMetadata((delegateNode = (TemplateDelegateNode)this.template.node()).getDelPackageName() == null ? "" : delegateNode.getDelPackageName(), delegateNode.getDelTemplateName(), delegateNode.getDelTemplateVariant()) : TemplateCompiler.createDefaultDelTemplateMetadata();
        TemplateMetadata metadata = TemplateCompiler.createTemplateMetadata(kind, uniqueIjs, callees, delCallees, deltemplateMetadata);
        TEMPLATE_METADATA_REF.write(metadata, this.writer);
    }

    static TemplateMetadata createTemplateMetadata(String contentKind, Set<String> injectedParams, Set<String> callees, Set<String> delCallees, TemplateMetadata.DelTemplateMetadata deltemplateMetadata) {
        return new AutoAnnotation_TemplateCompiler_createTemplateMetadata(contentKind, injectedParams, callees, delCallees, deltemplateMetadata);
    }

    static TemplateMetadata.DelTemplateMetadata createDefaultDelTemplateMetadata() {
        return new AutoAnnotation_TemplateCompiler_createDefaultDelTemplateMetadata();
    }

    static TemplateMetadata.DelTemplateMetadata createDelTemplateMetadata(String delPackage, String name, String variant) {
        return new AutoAnnotation_TemplateCompiler_createDelTemplateMetadata(delPackage, name, variant);
    }

    private Statement generateRenderMethod() {
        final Label start = new Label();
        final Label end = new Label();
        final LocalVariable thisVar = LocalVariable.createThisVar(this.template.typeInfo(), start, end);
        final LocalVariable appendableVar = LocalVariable.createLocal("appendable", 1, BytecodeUtils.LOGGING_ADVISING_APPENDABLE_TYPE, start, end).asNonNullable();
        final LocalVariable contextVar = LocalVariable.createLocal("context", 2, BytecodeUtils.RENDER_CONTEXT_TYPE, start, end).asNonNullable();
        final TemplateVariableManager variableSet = new TemplateVariableManager(this.fieldNames, this.template.typeInfo(), thisVar, this.template.renderMethod().method());
        TemplateNode node = this.template.node();
        TemplateVariables variables = new TemplateVariables(variableSet, thisVar, contextVar);
        final SoyNodeCompiler.CompiledMethodBody methodBody = SoyNodeCompiler.create(this.registry, this.innerClasses, this.stateField, thisVar, AppendableExpression.forLocal(appendableVar), variableSet, variables).compile(node);
        final Statement returnDone = Statement.returnExpression(MethodRef.RENDER_RESULT_DONE.invoke(new Expression[0]));
        new Statement(){

            @Override
            void doGen(CodeBuilder adapter) {
                adapter.mark(start);
                methodBody.body().gen(adapter);
                adapter.mark(end);
                returnDone.gen(adapter);
                thisVar.tableEntry(adapter);
                appendableVar.tableEntry(adapter);
                contextVar.tableEntry(adapter);
                variableSet.generateTableEntries(adapter);
            }
        }.writeIOExceptionMethod(1, this.template.renderMethod().method(), this.writer);
        this.writer.setNumDetachStates(methodBody.numberOfDetachStates());
        variableSet.defineStaticFields(this.writer);
        return variableSet.defineFields(this.writer);
    }

    private void generateConstructor(Statement fieldInitializers) {
        final Label start = new Label();
        final Label end = new Label();
        final LocalVariable thisVar = LocalVariable.createThisVar(this.template.typeInfo(), start, end);
        final LocalVariable paramsVar = LocalVariable.createLocal("params", 1, BytecodeUtils.SOY_RECORD_TYPE, start, end);
        final LocalVariable ijVar = LocalVariable.createLocal("ij", 2, BytecodeUtils.SOY_RECORD_TYPE, start, end);
        final ArrayList<Statement> assignments = new ArrayList<Statement>();
        assignments.add(fieldInitializers);
        assignments.add(this.paramsField.putInstanceField(thisVar, paramsVar));
        assignments.add(this.ijField.putInstanceField(thisVar, ijVar));
        for (TemplateParam param : this.template.node().getAllParams()) {
            Expression paramProvider = TemplateCompiler.getParam(paramsVar, ijVar, param);
            assignments.add(((FieldRef)this.paramFields.get((Object)param.name())).putInstanceField(thisVar, paramProvider));
        }
        Statement constructorBody = new Statement(){

            @Override
            void doGen(CodeBuilder ga) {
                ga.mark(start);
                thisVar.gen(ga);
                ga.invokeConstructor(BytecodeUtils.OBJECT.type(), BytecodeUtils.NULLARY_INIT);
                for (Statement assignment : assignments) {
                    assignment.gen(ga);
                }
                ga.visitInsn(177);
                ga.visitLabel(end);
                thisVar.tableEntry(ga);
                paramsVar.tableEntry(ga);
                ijVar.tableEntry(ga);
            }
        };
        constructorBody.writeMethod(1, this.template.constructor().method(), this.writer);
    }

    private static Expression getParam(LocalVariable paramsVar, LocalVariable ijVar, TemplateParam param) {
        Expression fieldName = BytecodeUtils.constant(param.name());
        LocalVariable record = param.isInjected() ? ijVar : paramsVar;
        return MethodRef.RUNTIME_GET_FIELD_PROVIDER.invoke(record, fieldName);
    }

    private final class TemplateVariables
    implements TemplateParameterLookup {
        private final TemplateVariableManager variableSet;
        private final Expression thisRef;
        private final Expression renderContext;

        TemplateVariables(TemplateVariableManager variableSet, Expression thisRef, Expression renderContext) {
            this.variableSet = variableSet;
            this.thisRef = thisRef;
            this.renderContext = renderContext;
        }

        @Override
        public Expression getParam(TemplateParam param) {
            return ((FieldRef)TemplateCompiler.this.paramFields.get((Object)param.name())).accessor(this.thisRef);
        }

        @Override
        public Expression getLocal(LocalVar local) {
            return this.variableSet.getVariable(local.name()).local();
        }

        @Override
        public Expression getLocal(SyntheticVarName varName) {
            return this.variableSet.getVariable(varName).local();
        }

        @Override
        public Expression getRenderContext() {
            return this.renderContext;
        }

        @Override
        public Expression getParamsRecord() {
            return TemplateCompiler.this.paramsField.accessor(this.thisRef);
        }

        @Override
        public Expression getIjRecord() {
            return TemplateCompiler.this.ijField.accessor(this.thisRef);
        }
    }
}

