/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.CodeBuilder;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.FieldRef;
import com.google.template.soy.jbcsrc.MethodRef;
import com.google.template.soy.jbcsrc.SoyRuntimeType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.aggregate.ListType;
import com.google.template.soy.types.primitive.BoolType;
import com.google.template.soy.types.primitive.FloatType;
import com.google.template.soy.types.primitive.IntType;
import com.google.template.soy.types.primitive.NullType;
import com.google.template.soy.types.primitive.SanitizedType;
import com.google.template.soy.types.primitive.StringType;
import com.google.template.soy.types.primitive.UnknownType;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class SoyExpression
extends Expression {
    static final SoyExpression NULL = new SoyExpression(SoyExpression.getUnboxedType(NullType.getInstance()), new Expression(BytecodeUtils.OBJECT.type(), Expression.Feature.CHEAP, new Expression.Feature[0]){

        @Override
        void doGen(CodeBuilder cb) {
            cb.pushNull();
        }
    });
    static final SoyExpression NULL_BOXED = new SoyExpression(SoyRuntimeType.getBoxedType(NullType.getInstance()), new Expression(BytecodeUtils.SOY_VALUE_TYPE, Expression.Feature.CHEAP, new Expression.Feature[0]){

        @Override
        void doGen(CodeBuilder cb) {
            cb.pushNull();
        }
    });
    static final SoyExpression TRUE = SoyExpression.forBool(BytecodeUtils.constant(true));
    static final SoyExpression FALSE = SoyExpression.forBool(BytecodeUtils.constant(false));
    private final SoyRuntimeType soyRuntimeType;
    private final Expression delegate;

    static SoyExpression forSoyValue(SoyType type, Expression delegate) {
        return new SoyExpression(SoyRuntimeType.getBoxedType(type), delegate);
    }

    static SoyExpression forBool(Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedType(BoolType.getInstance()), delegate);
    }

    static SoyExpression forFloat(Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedType(FloatType.getInstance()), delegate);
    }

    static SoyExpression forInt(Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedType(IntType.getInstance()), delegate);
    }

    static SoyExpression forString(Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedType(StringType.getInstance()), delegate);
    }

    static SoyExpression forSanitizedString(Expression delegate, SanitizedContentKind kind) {
        return new SoyExpression(SoyExpression.getUnboxedType(SanitizedType.getTypeForContentKind(kind)), delegate);
    }

    static SoyExpression forList(ListType listType, Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedType(listType), delegate);
    }

    static SoyExpression forProto(SoyRuntimeType type, Expression delegate) {
        Preconditions.checkArgument((type.soyType().getKind() == SoyType.Kind.PROTO ? 1 : 0) != 0);
        return new SoyExpression(type, delegate);
    }

    static Expression asBoxedList(List<SoyExpression> items) {
        ArrayList<SoyExpression> childExprs = new ArrayList<SoyExpression>(items.size());
        for (SoyExpression child : items) {
            childExprs.add(child.box());
        }
        return BytecodeUtils.asList(childExprs);
    }

    private static SoyRuntimeType getUnboxedType(SoyType soyType) {
        return (SoyRuntimeType)SoyRuntimeType.getUnboxedType(soyType).get();
    }

    private SoyExpression(SoyRuntimeType soyRuntimeType, Expression delegate) {
        super(delegate.resultType(), delegate.features());
        Preconditions.checkArgument((boolean)BytecodeUtils.isPossiblyAssignableFrom(soyRuntimeType.runtimeType(), delegate.resultType()), (String)"Expecting SoyExpression type of %s, found delegate with type of %s", (Object)soyRuntimeType.runtimeType(), (Object)delegate.resultType());
        this.soyRuntimeType = soyRuntimeType;
        this.delegate = delegate;
    }

    final SoyType soyType() {
        return this.soyRuntimeType.soyType();
    }

    final SoyRuntimeType soyRuntimeType() {
        return this.soyRuntimeType;
    }

    @Override
    final void doGen(CodeBuilder adapter) {
        this.delegate.gen(adapter);
    }

    @Override
    SoyExpression withSourceLocation(SourceLocation location) {
        return this.withSource(this.delegate.withSourceLocation(location));
    }

    boolean assignableToNullableInt() {
        return this.soyRuntimeType.assignableToNullableInt();
    }

    boolean assignableToNullableFloat() {
        return this.soyRuntimeType.assignableToNullableFloat();
    }

    boolean assignableToNullableNumber() {
        return this.soyRuntimeType.assignableToNullableNumber();
    }

    boolean assignableToNullableString() {
        return this.soyRuntimeType.assignableToNullableString();
    }

    boolean isBoxed() {
        return this.soyRuntimeType.isBoxed();
    }

    Expression boxAsSoyValueProvider() {
        if (this.soyType().equals(NullType.getInstance())) {
            if (this.delegate == NULL || this.delegate == NULL_BOXED) {
                return FieldRef.NULL_PROVIDER.accessor();
            }
            return this.toStatement().then(FieldRef.NULL_PROVIDER.accessor());
        }
        if (this.delegate.isNonNullable()) {
            return this.box();
        }
        if (this.isBoxed()) {
            return new Expression(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE, this.delegate.features().plus(Expression.Feature.NON_NULLABLE)){

                @Override
                void doGen(CodeBuilder adapter) {
                    Label end = new Label();
                    SoyExpression.this.delegate.gen(adapter);
                    adapter.dup();
                    adapter.ifNonNull(end);
                    adapter.pop();
                    FieldRef.NULL_PROVIDER.accessStaticUnchecked(adapter);
                    adapter.mark(end);
                }
            };
        }
        return new Expression(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE, this.delegate.features().plus(Expression.Feature.NON_NULLABLE)){

            @Override
            void doGen(CodeBuilder adapter) {
                Label end = new Label();
                SoyExpression.this.delegate.gen(adapter);
                adapter.dup();
                Label nonNull = new Label();
                adapter.ifNonNull(nonNull);
                adapter.pop();
                FieldRef.NULL_PROVIDER.accessStaticUnchecked(adapter);
                adapter.goTo(end);
                adapter.mark(nonNull);
                SoyExpression.doBox(adapter, SoyExpression.this.soyRuntimeType);
                adapter.mark(end);
            }
        };
    }

    SoyExpression box() {
        if (this.isBoxed()) {
            return this;
        }
        if (this.soyType().equals(NullType.getInstance())) {
            if (this.delegate == NULL) {
                return NULL_BOXED;
            }
            return this.asBoxed(this.toStatement().then(NULL_BOXED));
        }
        if (this.soyRuntimeType.isKnownBool()) {
            return this.asBoxed(MethodRef.BOOLEAN_DATA_FOR_VALUE.invoke(this.delegate));
        }
        if (this.soyRuntimeType.isKnownInt()) {
            return this.asBoxed(MethodRef.INTEGER_DATA_FOR_VALUE.invoke(this.delegate));
        }
        if (this.soyRuntimeType.isKnownFloat()) {
            return this.asBoxed(MethodRef.FLOAT_DATA_FOR_VALUE.invoke(this.delegate));
        }
        final boolean isNonNullable = this.delegate.isNonNullable();
        return this.asBoxed(new Expression(this.soyRuntimeType.box().runtimeType(), this.features()){

            @Override
            void doGen(CodeBuilder adapter) {
                Label end = null;
                SoyExpression.this.delegate.gen(adapter);
                if (!isNonNullable) {
                    end = new Label();
                    BytecodeUtils.nullCoalesce(adapter, end);
                }
                SoyExpression.doBox(adapter, SoyExpression.this.soyRuntimeType.asNonNullable());
                if (end != null) {
                    adapter.mark(end);
                }
            }
        });
    }

    private static void doBox(CodeBuilder adapter, SoyRuntimeType type) {
        if (type.isKnownSanitizedContent()) {
            FieldRef.enumReference(SanitizedContent.ContentKind.valueOf(((SanitizedType)type.soyType()).getContentKind().name())).accessStaticUnchecked(adapter);
            MethodRef.ORDAIN_AS_SAFE.invokeUnchecked(adapter);
        } else if (type.isKnownString()) {
            MethodRef.STRING_DATA_FOR_VALUE.invokeUnchecked(adapter);
        } else if (type.isKnownList()) {
            MethodRef.LIST_IMPL_FOR_PROVIDER_LIST.invokeUnchecked(adapter);
        } else if (type.isKnownMap()) {
            MethodRef.DICT_IMPL_FOR_PROVIDER_MAP.invokeUnchecked(adapter);
        } else if (type.isKnownProto()) {
            MethodRef.SOY_PROTO_VALUE_IMPL_CREATE.invokeUnchecked(adapter);
        } else {
            throw new IllegalStateException("Can't box soy expression of type " + type);
        }
    }

    private SoyExpression asBoxed(Expression expr) {
        return new SoyExpression(this.soyRuntimeType.box(), expr);
    }

    SoyExpression coerceToBoolean() {
        if (BytecodeUtils.isPrimitive(this.resultType())) {
            return this.coercePrimitiveToBoolean();
        }
        if (this.soyType().equals(NullType.getInstance())) {
            return FALSE;
        }
        if (this.delegate.isNonNullable()) {
            return this.coerceNonNullableReferenceTypeToBoolean();
        }
        final Label end = new Label();
        return this.withSource(new Expression(this.delegate.resultType(), this.delegate.features()){

            @Override
            void doGen(CodeBuilder adapter) {
                SoyExpression.this.delegate.gen(adapter);
                adapter.dup();
                Label nonNull = new Label();
                adapter.ifNonNull(nonNull);
                adapter.pop();
                adapter.pushBoolean(false);
                adapter.goTo(end);
                adapter.mark(nonNull);
            }
        }).asNonNullable().coerceToBoolean().labelEnd(end);
    }

    private SoyExpression coercePrimitiveToBoolean() {
        if (this.resultType().equals((Object)Type.BOOLEAN_TYPE)) {
            return this;
        }
        if (this.resultType().equals((Object)Type.DOUBLE_TYPE)) {
            return SoyExpression.forBool(MethodRef.RUNTIME_COERCE_DOUBLE_TO_BOOLEAN.invoke(this.delegate));
        }
        if (this.resultType().equals((Object)Type.LONG_TYPE)) {
            return SoyExpression.forBool(BytecodeUtils.compare(154, this.delegate, BytecodeUtils.constant(0L)));
        }
        throw new AssertionError((Object)("resultType(): " + this.resultType() + " is not a valid type for a SoyExpression"));
    }

    private SoyExpression coerceNonNullableReferenceTypeToBoolean() {
        if (this.isBoxed()) {
            return SoyExpression.forBool(this.delegate.invoke(MethodRef.SOY_VALUE_COERCE_TO_BOOLEAN, new Expression[0]));
        }
        if (this.soyRuntimeType.isKnownString()) {
            return SoyExpression.forBool(BytecodeUtils.logicalNot(this.delegate.invoke(MethodRef.STRING_IS_EMPTY, new Expression[0])));
        }
        return SoyExpression.forBool(new Expression(Type.BOOLEAN_TYPE, this.delegate.features()){

            @Override
            void doGen(CodeBuilder adapter) {
                SoyExpression.this.delegate.gen(adapter);
                adapter.pop();
                adapter.pushBoolean(true);
            }
        });
    }

    SoyExpression coerceToString() {
        if (this.soyRuntimeType.isKnownString() && !this.isBoxed()) {
            return this;
        }
        if (BytecodeUtils.isPrimitive(this.resultType())) {
            if (this.resultType().equals((Object)Type.BOOLEAN_TYPE)) {
                return SoyExpression.forString(MethodRef.BOOLEAN_TO_STRING.invoke(this.delegate));
            }
            if (this.resultType().equals((Object)Type.DOUBLE_TYPE)) {
                return SoyExpression.forString(MethodRef.DOUBLE_TO_STRING.invoke(this.delegate));
            }
            if (this.resultType().equals((Object)Type.LONG_TYPE)) {
                return SoyExpression.forString(MethodRef.LONG_TO_STRING.invoke(this.delegate));
            }
            throw new AssertionError((Object)("resultType(): " + this.resultType() + " is not a valid type for a SoyExpression"));
        }
        if (!this.isBoxed()) {
            return SoyExpression.forString(MethodRef.STRING_VALUE_OF.invoke(this.delegate));
        }
        return SoyExpression.forString(MethodRef.RUNTIME_COERCE_TO_STRING.invoke(this.delegate));
    }

    SoyExpression coerceToDouble() {
        if (!this.isBoxed()) {
            if (this.soyRuntimeType.isKnownFloat()) {
                return this;
            }
            if (this.soyRuntimeType.isKnownInt()) {
                return SoyExpression.forFloat(BytecodeUtils.numericConversion(this.delegate, Type.DOUBLE_TYPE));
            }
            throw new UnsupportedOperationException("Can't convert " + this.resultType() + " to a double");
        }
        if (this.soyRuntimeType.isKnownFloat()) {
            return SoyExpression.forFloat(this.delegate.invoke(MethodRef.SOY_VALUE_FLOAT_VALUE, new Expression[0]));
        }
        return SoyExpression.forFloat(this.delegate.invoke(MethodRef.SOY_VALUE_NUMBER_VALUE, new Expression[0]));
    }

    SoyExpression unboxAs(Class<?> asType) {
        Preconditions.checkArgument((!SoyValue.class.isAssignableFrom(asType) ? 1 : 0) != 0, (String)"Cannot use unboxAs() to convert to a SoyValue: %s, use .box() instead", asType);
        if (BytecodeUtils.isDefinitelyAssignableFrom(Type.getType(asType), this.soyRuntimeType.runtimeType())) {
            return this;
        }
        if (asType.equals(Message.class) && this.soyRuntimeType.isKnownProto() && !this.isBoxed()) {
            return this;
        }
        if (!this.isBoxed()) {
            throw new IllegalStateException("Trying to unbox an unboxed value (" + this.soyRuntimeType + ") into " + asType + " doesn't make sense. Should you be using a type coercion? e.g. coerceToBoolean()");
        }
        if (asType.equals(Boolean.TYPE)) {
            return SoyExpression.forBool(this.delegate.invoke(MethodRef.SOY_VALUE_BOOLEAN_VALUE, new Expression[0]));
        }
        if (asType.equals(Long.TYPE)) {
            return SoyExpression.forInt(this.delegate.invoke(MethodRef.SOY_VALUE_LONG_VALUE, new Expression[0]));
        }
        if (asType.equals(Double.TYPE)) {
            return SoyExpression.forFloat(this.delegate.invoke(MethodRef.SOY_VALUE_FLOAT_VALUE, new Expression[0]));
        }
        if (this.delegate.isNonNullable()) {
            if (asType.equals(String.class)) {
                Expression unboxedString = this.delegate.invoke(MethodRef.SOY_VALUE_STRING_VALUE, new Expression[0]);
                return this.soyRuntimeType.isKnownSanitizedContent() ? SoyExpression.forSanitizedString(unboxedString, ((SanitizedType)this.soyType()).getContentKind()) : SoyExpression.forString(unboxedString);
            }
            if (asType.equals(List.class)) {
                return this.unboxAsList();
            }
            if (asType.equals(Message.class)) {
                SoyRuntimeType runtimeType = SoyExpression.getUnboxedType(this.soyType());
                return SoyExpression.forProto(runtimeType, this.delegate.invoke(MethodRef.SOY_PROTO_VALUE_GET_PROTO, new Expression[0]).checkedCast(runtimeType.runtimeType()));
            }
        } else {
            final Label end = new Label();
            Expression nonNullDelegate = new Expression(this.resultType(), this.features()){

                @Override
                void doGen(CodeBuilder adapter) {
                    SoyExpression.this.delegate.gen(adapter);
                    BytecodeUtils.nullCoalesce(adapter, end);
                }
            };
            return this.withSource(nonNullDelegate).asNonNullable().unboxAs(asType).asNullable().labelEnd(end);
        }
        throw new UnsupportedOperationException("Can't unbox " + this.soyRuntimeType + " as " + asType);
    }

    private SoyExpression unboxAsList() {
        ListType asListType;
        if (this.soyRuntimeType.isKnownList()) {
            asListType = (ListType)this.soyType();
        } else {
            SoyType.Kind kind = this.soyType().getKind();
            if (kind == SoyType.Kind.UNKNOWN) {
                asListType = ListType.of(UnknownType.getInstance());
            } else {
                throw new UnsupportedOperationException("Can't convert " + this.soyRuntimeType + " to List");
            }
        }
        return SoyExpression.forList(asListType, this.delegate.checkedCast(BytecodeUtils.SOY_LIST_TYPE).invoke(MethodRef.SOY_LIST_AS_JAVA_LIST, new Expression[0]));
    }

    SoyExpression withSource(Expression expr) {
        if (expr == this.delegate) {
            return this;
        }
        return new SoyExpression(this.soyRuntimeType, expr);
    }

    SoyExpression applyPrintDirective(Expression renderContext, String directive) {
        return this.applyPrintDirective(renderContext, directive, MethodRef.IMMUTABLE_LIST_OF.invoke(new Expression[0]));
    }

    SoyExpression applyPrintDirective(Expression renderContext, String directive, Expression argsList) {
        return SoyExpression.forSoyValue(UnknownType.getInstance(), MethodRef.RUNTIME_APPLY_PRINT_DIRECTIVE.invoke(renderContext.invoke(MethodRef.RENDER_CONTEXT_GET_PRINT_DIRECTIVE, BytecodeUtils.constant(directive)), this.box(), argsList));
    }

    @Override
    SoyExpression asCheap() {
        return this.withSource(this.delegate.asCheap());
    }

    @Override
    SoyExpression asNonNullable() {
        return new SoyExpression(this.soyRuntimeType.asNonNullable(), this.delegate.asNonNullable());
    }

    @Override
    SoyExpression asNullable() {
        return new SoyExpression(this.soyRuntimeType.asNullable(), this.delegate.asNullable());
    }

    @Override
    SoyExpression labelStart(Label label) {
        return this.withSource(this.delegate.labelStart(label));
    }

    @Override
    SoyExpression labelEnd(Label label) {
        return this.withSource(this.delegate.labelEnd(label));
    }
}

