/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.protobuf.GeneratedMessage;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.ClassData;
import com.google.template.soy.jbcsrc.Flags;
import com.google.template.soy.jbcsrc.TypeInfo;
import com.google.template.soy.jbcsrc.shared.Names;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.CheckClassAdapter;

final class SoyClassWriter
extends ClassVisitor {
    private final Writer writer;
    private final TypeInfo typeInfo;
    private int numFields;
    private int numDetachStates;

    static Builder builder(TypeInfo type) {
        return new Builder(type);
    }

    private SoyClassWriter(Writer writer, Builder builder) {
        super(writer.api(), (ClassVisitor)(Flags.DEBUG ? new CheckClassAdapter((ClassVisitor)writer, false) : writer));
        this.writer = writer;
        this.typeInfo = builder.type;
        super.visit(51, builder.access, builder.type.internalName(), null, builder.baseClass.internalName(), builder.interfaces.toArray(new String[builder.interfaces.size()]));
        if (builder.fileName != null) {
            super.visitSource(builder.fileName, null);
        }
    }

    void setNumDetachStates(int numDetachStates) {
        Preconditions.checkArgument((numDetachStates >= 0 ? 1 : 0) != 0);
        this.numDetachStates = numDetachStates;
    }

    @Deprecated
    public void visitSource(String source, String debug) {
        throw new UnsupportedOperationException("Don't call visitSource(), SoyClassWriter calls it for you");
    }

    @Deprecated
    public void visit(int v, int a, String n, String s, String b, String[] i) {
        throw new UnsupportedOperationException("Don't call visit(), SoyClassWriter calls it for you");
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        ++this.numFields;
        return super.visitField(access, name, desc, signature, value);
    }

    ClassData toClassData() {
        return ClassData.create(this.typeInfo, this.writer.toByteArray(), this.numFields, this.numDetachStates);
    }

    private static final class Writer
    extends ClassWriter {
        private static final String PROTO_EXTENDABLE_BUILDER = Type.getInternalName(GeneratedMessage.ExtendableBuilder.class);

        Writer() {
            super(3);
        }

        int api() {
            return this.api;
        }

        protected String getCommonSuperClass(String left, String right) {
            boolean leftIsGenerated = left.startsWith(Names.INTERNAL_CLASS_PREFIX);
            boolean rightIsGenerated = right.startsWith(Names.INTERNAL_CLASS_PREFIX);
            if (!leftIsGenerated && !rightIsGenerated) {
                if (left.equals(PROTO_EXTENDABLE_BUILDER) && right.endsWith("$Builder") || right.equals(PROTO_EXTENDABLE_BUILDER) && left.endsWith("$Builder")) {
                    return PROTO_EXTENDABLE_BUILDER;
                }
                try {
                    return super.getCommonSuperClass(left, right);
                }
                catch (RuntimeException re) {
                    throw new RuntimeException("unable to calculate common base class of: " + left + " and " + right);
                }
            }
            return BytecodeUtils.OBJECT.internalName();
        }
    }

    static final class Builder {
        private final TypeInfo type;
        private int access = 48;
        private TypeInfo baseClass = BytecodeUtils.OBJECT;
        private List<String> interfaces = new ArrayList<String>();
        private String fileName;

        private Builder(TypeInfo type) {
            this.type = (TypeInfo)Preconditions.checkNotNull((Object)type);
        }

        Builder setAccess(int access) {
            this.access = access;
            return this;
        }

        Builder extending(TypeInfo baseClass) {
            this.baseClass = (TypeInfo)Preconditions.checkNotNull((Object)baseClass);
            return this;
        }

        Builder implementing(TypeInfo typeInfo) {
            this.interfaces.add(typeInfo.internalName());
            return this;
        }

        Builder sourceFileName(String fileName) {
            this.fileName = (String)Preconditions.checkNotNull((Object)fileName);
            return this;
        }

        SoyClassWriter build() {
            return new SoyClassWriter(new Writer(), this);
        }
    }
}

