/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.protobuf.Message;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.AutoValue_MethodRef;
import com.google.template.soy.jbcsrc.CodeBuilder;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.Statement;
import com.google.template.soy.jbcsrc.TypeInfo;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.runtime.JbcSrcRuntime;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.shared.internal.SharedRuntime;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.google.template.soy.types.proto.SoyProtoValueImpl;
import com.ibm.icu.util.ULocale;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

abstract class MethodRef {
    static final MethodRef ADVISING_STRING_BUILDER_GET_AND_CLEAR = MethodRef.create(LoggingAdvisingAppendable.BufferingAppendable.class, "getAndClearBuffer", new Class[0]).asNonNullable();
    static final MethodRef ARRAY_LIST_ADD = MethodRef.create(ArrayList.class, "add", Object.class);
    static final MethodRef BOOLEAN_DATA_FOR_VALUE = MethodRef.create(BooleanData.class, "forValue", Boolean.TYPE).asNonNullable();
    static final MethodRef BOOLEAN_VALUE = MethodRef.create(Boolean.class, "booleanValue", new Class[0]).asCheap();
    static final MethodRef BOOLEAN_TO_STRING = MethodRef.create(Boolean.class, "toString", Boolean.TYPE).asCheap().asNonNullable();
    static final MethodRef COMPILED_TEMPLATE_RENDER = MethodRef.create(CompiledTemplate.class, "render", LoggingAdvisingAppendable.class, RenderContext.class).asNonNullable();
    static final MethodRef DICT_IMPL_FOR_PROVIDER_MAP = MethodRef.create(DictImpl.class, "forProviderMap", Map.class).asNonNullable();
    static final MethodRef DOUBLE_TO_STRING = MethodRef.create(Double.class, "toString", Double.TYPE).asNonNullable();
    static final MethodRef EQUALS = MethodRef.create(Object.class, "equals", Object.class);
    static final MethodRef STRING_COMPARE_TO = MethodRef.create(String.class, "compareTo", String.class);
    static final MethodRef FLOAT_DATA_FOR_VALUE = MethodRef.create(FloatData.class, "forValue", Double.TYPE).asNonNullable();
    static final MethodRef IMMUTABLE_LIST_OF = MethodRef.create(ImmutableList.class, "of", new Class[0]).asCheap().asNonNullable();
    static final MethodRef IMMUTABLE_LIST_COPY_OF_COLLECTION = MethodRef.create(ImmutableList.class, "copyOf", Collection.class).asCheap().asNonNullable();
    static final MethodRef INTEGER_DATA_FOR_VALUE = MethodRef.create(IntegerData.class, "forValue", Long.TYPE).asNonNullable();
    static final MethodRef INTS_CHECKED_CAST = MethodRef.create(Ints.class, "checkedCast", Long.TYPE).asCheap();
    static final MethodRef LINKED_HASH_MAP_CLEAR = MethodRef.create(LinkedHashMap.class, "clear", new Class[0]);
    static final MethodRef LINKED_HASH_MAP_PUT = MethodRef.create(LinkedHashMap.class, "put", Object.class, Object.class);
    static final MethodRef LIST_GET = MethodRef.create(List.class, "get", Integer.TYPE).asCheap();
    static final MethodRef LIST_SIZE = MethodRef.create(List.class, "size", new Class[0]).asCheap();
    static final MethodRef LIST_IMPL_FOR_PROVIDER_LIST = MethodRef.create(ListImpl.class, "forProviderList", List.class);
    static final MethodRef LONG_PARSE_LONG = MethodRef.create(Long.class, "parseLong", String.class).asCheap().asNonNullable();
    static final MethodRef LONG_TO_STRING = MethodRef.create(Long.class, "toString", Long.TYPE);
    static final MethodRef NUMBER_DOUBLE_VALUE = MethodRef.create(Number.class, "doubleValue", new Class[0]).asCheap();
    static final MethodRef NUMBER_LONG_VALUE = MethodRef.create(Number.class, "longValue", new Class[0]).asCheap();
    static final MethodRef OBJECT_TO_STRING = MethodRef.create(Object.class, "toString", new Class[0]);
    static final MethodRef ORDAIN_AS_SAFE = MethodRef.create(UnsafeSanitizedContentOrdainer.class, "ordainAsSafe", String.class, SanitizedContent.ContentKind.class);
    static final MethodRef PARAM_STORE_SET_FIELD = MethodRef.create(ParamStore.class, "setField", String.class, SoyValueProvider.class);
    static final MethodRef PRINT_STREAM_PRINTLN = MethodRef.create(PrintStream.class, "println", new Class[0]);
    static final MethodRef SOY_PROTO_VALUE_IMPL_CREATE = MethodRef.create(SoyProtoValueImpl.class, "create", Message.class).asNonNullable();
    static final MethodRef RENDER_CONTEXT_GET_DELTEMPLATE = MethodRef.create(RenderContext.class, "getDelTemplate", String.class, String.class, Boolean.TYPE, SoyRecord.class, SoyRecord.class);
    static final MethodRef RENDER_CONTEXT_GET_FUNCTION = MethodRef.create(RenderContext.class, "getFunction", String.class);
    static final MethodRef RENDER_CONTEXT_GET_LOCALE = MethodRef.create(RenderContext.class, "getLocale", new Class[0]);
    static final MethodRef RENDER_CONTEXT_GET_PRINT_DIRECTIVE = MethodRef.create(RenderContext.class, "getPrintDirective", String.class);
    static final MethodRef RENDER_CONTEXT_GET_SOY_MSG_PARTS = MethodRef.create(RenderContext.class, "getSoyMsgParts", Long.TYPE, ImmutableList.class);
    static final MethodRef RENDER_CONTEXT_RENAME_CSS_SELECTOR = MethodRef.create(RenderContext.class, "renameCssSelector", String.class).asNonNullable();
    static final MethodRef RENDER_CONTEXT_RENAME_XID = MethodRef.create(RenderContext.class, "renameXid", String.class).asNonNullable();
    static final MethodRef RENDER_CONTEXT_USE_PRIMARY_MSG = MethodRef.create(RenderContext.class, "usePrimaryMsg", Long.TYPE, Long.TYPE);
    static final MethodRef RENDER_CONTEXT_GET_DEBUG_SOY_TEMPLATE_INFO = MethodRef.create(RenderContext.class, "getDebugSoyTemplateInfo", new Class[0]);
    static final MethodRef RENDER_RESULT_DONE = MethodRef.create(RenderResult.class, "done", new Class[0]).asCheap().asNonNullable();
    static final MethodRef RENDER_RESULT_IS_DONE = MethodRef.create(RenderResult.class, "isDone", new Class[0]).asCheap();
    static final MethodRef RENDER_RESULT_LIMITED = MethodRef.create(RenderResult.class, "limited", new Class[0]).asCheap().asNonNullable();
    static final MethodRef RUNTIME_APPLY_ESCAPERS_DYNAMIC = MethodRef.create(JbcSrcRuntime.class, "applyEscapersDynamic", CompiledTemplate.class, List.class);
    static final MethodRef RUNTIME_APPLY_ESCAPERS = MethodRef.create(JbcSrcRuntime.class, "applyEscapers", CompiledTemplate.class, SanitizedContent.ContentKind.class, List.class);
    static final MethodRef RUNTIME_APPLY_PRINT_DIRECTIVE = MethodRef.create(JbcSrcRuntime.class, "applyPrintDirective", SoyJavaPrintDirective.class, SoyValue.class, List.class);
    static final MethodRef RUNTIME_CALL_SOY_FUNCTION = MethodRef.create(JbcSrcRuntime.class, "callSoyFunction", SoyJavaFunction.class, List.class);
    static final MethodRef RUNTIME_COERCE_DOUBLE_TO_BOOLEAN = MethodRef.create(JbcSrcRuntime.class, "coerceToBoolean", Double.TYPE);
    static final MethodRef RUNTIME_COERCE_TO_STRING = MethodRef.create(JbcSrcRuntime.class, "coerceToString", SoyValue.class).asNonNullable();
    static final MethodRef RUNTIME_EQUAL = MethodRef.create(SharedRuntime.class, "equal", SoyValue.class, SoyValue.class);
    static final MethodRef RUNTIME_COMPARE_STRING = MethodRef.create(SharedRuntime.class, "compareString", String.class, SoyValue.class);
    static final MethodRef RUNTIME_GET_FIELD_PROVIDER = MethodRef.create(JbcSrcRuntime.class, "getFieldProvider", SoyRecord.class, String.class).asNonNullable();
    static final MethodRef RUNTIME_GET_LIST_ITEM = MethodRef.create(JbcSrcRuntime.class, "getSoyListItem", List.class, Long.TYPE);
    static final MethodRef RUNTIME_GET_LIST_STATUS = MethodRef.create(JbcSrcRuntime.class, "getListStatus", List.class);
    static final MethodRef RUNTIME_GET_MAP_ITEM = MethodRef.create(JbcSrcRuntime.class, "getSoyMapItem", SoyMap.class, SoyValue.class);
    static final MethodRef RUNTIME_LESS_THAN = MethodRef.create(SharedRuntime.class, "lessThan", SoyValue.class, SoyValue.class).asNonNullable();
    static final MethodRef RUNTIME_LESS_THAN_OR_EQUAL = MethodRef.create(SharedRuntime.class, "lessThanOrEqual", SoyValue.class, SoyValue.class).asNonNullable();
    static final MethodRef RUNTIME_LOGGER = MethodRef.create(JbcSrcRuntime.class, "logger", new Class[0]).asCheap().asNonNullable();
    static final MethodRef RUNTIME_MINUS = MethodRef.create(SharedRuntime.class, "minus", SoyValue.class, SoyValue.class).asNonNullable();
    static final MethodRef RUNTIME_NEGATIVE = MethodRef.create(SharedRuntime.class, "negative", SoyValue.class).asNonNullable();
    static final MethodRef RUNTIME_PLUS = MethodRef.create(SharedRuntime.class, "plus", SoyValue.class, SoyValue.class).asNonNullable();
    static final MethodRef RUNTIME_RENDER_SOY_MSG_PARTS_WITH_PLACEHOLDERS = MethodRef.create(JbcSrcRuntime.class, "renderSoyMsgPartsWithPlaceholders", ImmutableList.class, ULocale.class, Map.class, Appendable.class);
    static final MethodRef RUNTIME_STRING_EQUALS_AS_NUMBER = MethodRef.create(JbcSrcRuntime.class, "stringEqualsAsNumber", String.class, Double.TYPE).asNonNullable();
    static final MethodRef RUNTIME_TIMES = MethodRef.create(SharedRuntime.class, "times", SoyValue.class, SoyValue.class).asNonNullable();
    static final MethodRef RUNTIME_UNEXPECTED_STATE_ERROR = MethodRef.create(JbcSrcRuntime.class, "unexpectedStateError", Integer.TYPE).asNonNullable();
    static final MethodRef SOY_LIST_AS_JAVA_LIST = MethodRef.create(SoyList.class, "asJavaList", new Class[0]).asNonNullable();
    static final MethodRef SOY_MSG_RAW_TEXT_PART_GET_RAW_TEXT = MethodRef.create(SoyMsgRawTextPart.class, "getRawText", new Class[0]).asCheap().asNonNullable();
    static final MethodRef SOY_PROTO_VALUE_GET_PROTO_FIELD = MethodRef.create(SoyProtoValueImpl.class, "getProtoField", String.class).asCheap().asNonNullable();
    static final MethodRef SOY_PROTO_VALUE_GET_PROTO = MethodRef.create(SoyProtoValueImpl.class, "getProto", new Class[0]).asCheap().asNonNullable();
    static final MethodRef SOY_VALUE_COERCE_TO_BOOLEAN = MethodRef.create(SoyValue.class, "coerceToBoolean", new Class[0]).asCheap();
    static final MethodRef SOY_VALUE_BOOLEAN_VALUE = MethodRef.create(SoyValue.class, "booleanValue", new Class[0]).asCheap();
    static final MethodRef SOY_VALUE_FLOAT_VALUE = MethodRef.create(SoyValue.class, "floatValue", new Class[0]).asCheap();
    static final MethodRef SOY_VALUE_LONG_VALUE = MethodRef.create(SoyValue.class, "longValue", new Class[0]).asCheap();
    static final MethodRef SOY_VALUE_NUMBER_VALUE = MethodRef.create(SoyValue.class, "numberValue", new Class[0]).asNonNullable();
    static final MethodRef SOY_VALUE_STRING_VALUE = MethodRef.create(SoyValue.class, "stringValue", new Class[0]).asCheap().asNonNullable();
    static final MethodRef SOY_VALUE_PROVIDER_RENDER_AND_RESOLVE = MethodRef.create(SoyValueProvider.class, "renderAndResolve", LoggingAdvisingAppendable.class, Boolean.TYPE).asNonNullable();
    static final MethodRef SOY_VALUE_PROVIDER_RESOLVE = MethodRef.create(JbcSrcRuntime.class, "resolveSoyValueProvider", SoyValueProvider.class);
    static final MethodRef SOY_VALUE_PROVIDER_STATUS = MethodRef.create(SoyValueProvider.class, "status", new Class[0]).asNonNullable();
    static final MethodRef STRING_CONCAT = MethodRef.create(String.class, "concat", String.class).asNonNullable();
    static final MethodRef STRING_IS_EMPTY = MethodRef.create(String.class, "isEmpty", new Class[0]);
    static final MethodRef STRING_VALUE_OF = MethodRef.create(String.class, "valueOf", Object.class).asNonNullable();
    static final MethodRef STRING_DATA_FOR_VALUE = MethodRef.create(StringData.class, "forValue", String.class).asCheap().asNonNullable();
    static final MethodRef LOGGING_ADVISING_APPENDABLE_BUFFERING = MethodRef.create(LoggingAdvisingAppendable.class, "buffering", new Class[0]).asNonNullable();

    MethodRef() {
    }

    static MethodRef create(Class<?> clazz, String methodName, Class<?> ... params) {
        java.lang.reflect.Method m;
        try {
            m = clazz.getMethod(methodName, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return MethodRef.create(m);
    }

    static MethodRef create(java.lang.reflect.Method method) {
        Class<?> clazz = method.getDeclaringClass();
        TypeInfo ownerType = TypeInfo.create(method.getDeclaringClass());
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        ImmutableList argTypes = isStatic ? ImmutableList.copyOf((Object[])Type.getArgumentTypes((java.lang.reflect.Method)method)) : ImmutableList.builder().add((Object)ownerType.type()).add((Object[])Type.getArgumentTypes((java.lang.reflect.Method)method)).build();
        return new AutoValue_MethodRef(clazz.isInterface() ? 185 : (isStatic ? 184 : 182), ownerType, Method.getMethod((java.lang.reflect.Method)method), Type.getType(method.getReturnType()), (ImmutableList<Type>)argTypes, Expression.Features.of());
    }

    static MethodRef createInstanceMethod(TypeInfo owner, Method method) {
        return new AutoValue_MethodRef(182, owner, method, method.getReturnType(), (ImmutableList<Type>)ImmutableList.builder().add((Object)owner.type()).add((Object[])method.getArgumentTypes()).build(), Expression.Features.of());
    }

    static MethodRef createStaticMethod(TypeInfo owner, Method method) {
        return new AutoValue_MethodRef(184, owner, method, method.getReturnType(), (ImmutableList<Type>)ImmutableList.builder().add((Object[])method.getArgumentTypes()).build(), Expression.Features.of());
    }

    abstract int opcode();

    abstract TypeInfo owner();

    abstract Method method();

    abstract Type returnType();

    abstract ImmutableList<Type> argTypes();

    abstract Expression.Features features();

    Statement invokeVoid(Expression ... args) {
        return this.invokeVoid(Arrays.asList(args));
    }

    Statement invokeVoid(final Iterable<? extends Expression> args) {
        Preconditions.checkState((boolean)Type.VOID_TYPE.equals((Object)this.returnType()), (Object)"Method return type is not void.");
        Expression.checkTypes(this.argTypes(), args);
        return new Statement(){

            @Override
            void doGen(CodeBuilder adapter) {
                MethodRef.this.doInvoke(adapter, args);
            }
        };
    }

    Expression invoke(Expression ... args) {
        return this.invoke(Arrays.asList(args));
    }

    Expression invoke(final Iterable<? extends Expression> args) {
        Preconditions.checkState((!Type.VOID_TYPE.equals((Object)this.returnType()) ? 1 : 0) != 0, (Object)"Cannot produce an expression from a void method.");
        Expression.checkTypes(this.argTypes(), args);
        Expression.Features features = this.features();
        if (!Expression.areAllCheap(args)) {
            features = features.minus(Expression.Feature.CHEAP);
        }
        return new Expression(this.returnType(), features){

            @Override
            void doGen(CodeBuilder mv) {
                MethodRef.this.doInvoke(mv, args);
            }
        };
    }

    MethodRef asCheap() {
        return this.withFeature(Expression.Feature.CHEAP);
    }

    MethodRef asNonNullable() {
        return this.withFeature(Expression.Feature.NON_NULLABLE);
    }

    private MethodRef withFeature(Expression.Feature feature) {
        if (this.features().has(feature)) {
            return this;
        }
        return new AutoValue_MethodRef(this.opcode(), this.owner(), this.method(), this.returnType(), this.argTypes(), this.features().plus(feature));
    }

    void invokeUnchecked(CodeBuilder cb) {
        cb.visitMethodInsn(this.opcode(), this.owner().internalName(), this.method().getName(), this.method().getDescriptor(), this.opcode() == 185);
    }

    private void doInvoke(CodeBuilder mv, Iterable<? extends Expression> args) {
        for (Expression expression : args) {
            expression.gen(mv);
        }
        this.invokeUnchecked(mv);
    }
}

