/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.ForOverride;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.jbcsrc.BytecodeProducer;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.CodeBuilder;
import com.google.template.soy.jbcsrc.Flags;
import com.google.template.soy.jbcsrc.MethodRef;
import com.google.template.soy.jbcsrc.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

abstract class Expression
extends BytecodeProducer {
    private final Features features;
    private final Type resultType;

    static boolean areAllCheap(Iterable<? extends Expression> args) {
        for (Expression expression : args) {
            if (expression.isCheap()) continue;
            return false;
        }
        return true;
    }

    static boolean areAllCheap(Expression first, Expression ... rest) {
        return Expression.areAllCheap((Iterable<? extends Expression>)ImmutableList.builder().add((Object)first).add((Object[])rest).build());
    }

    static void checkTypes(ImmutableList<Type> types, Expression ... exprs) {
        if (Flags.DEBUG) {
            Expression.checkTypes(types, Arrays.asList(exprs));
        }
    }

    static void checkTypes(ImmutableList<Type> types, Iterable<? extends Expression> exprs) {
        if (Flags.DEBUG) {
            int size = Iterables.size(exprs);
            Preconditions.checkArgument((size == types.size() ? 1 : 0) != 0, (String)"Supplied the wrong number of parameters. Expected %s, got %s", (int)types.size(), (int)size);
            int i = 0;
            for (Expression expression : exprs) {
                expression.checkAssignableTo((Type)types.get(i), "Parameter %s", i);
                ++i;
            }
        }
    }

    Expression(Type resultType) {
        this(resultType, Features.of());
    }

    Expression(Type resultType, Feature first, Feature ... rest) {
        this(resultType, Features.of(first, rest));
    }

    Expression(Type resultType, Features features) {
        this(resultType, features, SourceLocation.UNKNOWN);
    }

    Expression(Type resultType, Features features, SourceLocation location) {
        super(location);
        this.resultType = (Type)Preconditions.checkNotNull((Object)resultType);
        this.features = Features.forType(resultType, features);
    }

    @Override
    abstract void doGen(CodeBuilder var1);

    Expression withSourceLocation(SourceLocation location) {
        Preconditions.checkNotNull((Object)location);
        if (location.equals(this.location)) {
            return this;
        }
        return new Expression(this.resultType, this.features, location){

            @Override
            void doGen(CodeBuilder adapter) {
                Expression.this.gen(adapter);
            }
        };
    }

    final Type resultType() {
        return this.resultType;
    }

    boolean isCheap() {
        return this.features.has(Feature.CHEAP);
    }

    boolean isNonNullable() {
        return this.features.has(Feature.NON_NULLABLE);
    }

    Features features() {
        return this.features;
    }

    final void checkAssignableTo(Type expected) {
        this.checkAssignableTo(expected, "", new Object[0]);
    }

    final void checkAssignableTo(Type expected, String fmt, Object ... args) {
        if (Flags.DEBUG && !BytecodeUtils.isPossiblyAssignableFrom(expected, this.resultType())) {
            String message = String.format("Type mismatch. %s not assignable to %s.", this.resultType().getClassName(), expected.getClassName());
            if (!fmt.isEmpty()) {
                message = String.format(fmt, args) + ". " + message;
            }
            throw new IllegalArgumentException(message);
        }
    }

    Statement toStatement() {
        return new Statement(){

            @Override
            void doGen(CodeBuilder adapter) {
                Expression.this.gen(adapter);
                switch (Expression.this.resultType().getSize()) {
                    case 0: {
                        throw new AssertionError((Object)"void expressions are not allowed");
                    }
                    case 1: {
                        adapter.pop();
                        break;
                    }
                    case 2: {
                        adapter.pop2();
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        };
    }

    Expression asCheap() {
        if (this.isCheap()) {
            return this;
        }
        return new Expression(this.resultType, this.features.plus(Feature.CHEAP)){

            @Override
            void doGen(CodeBuilder adapter) {
                Expression.this.gen(adapter);
            }
        };
    }

    Expression asNonNullable() {
        if (this.isNonNullable()) {
            return this;
        }
        return new Expression(this.resultType, this.features.plus(Feature.NON_NULLABLE)){

            @Override
            void doGen(CodeBuilder adapter) {
                Expression.this.gen(adapter);
            }
        };
    }

    Expression asNullable() {
        if (!this.isNonNullable()) {
            return this;
        }
        return new Expression(this.resultType, this.features.minus(Feature.NON_NULLABLE)){

            @Override
            void doGen(CodeBuilder adapter) {
                Expression.this.gen(adapter);
            }
        };
    }

    Expression checkedCast(Type target) {
        Preconditions.checkArgument((target.getSort() == 10 ? 1 : 0) != 0, (String)"cast targets must be reference types. (%s)", (Object)target.getClassName());
        Preconditions.checkArgument((this.resultType().getSort() == 10 ? 1 : 0) != 0, (String)"you may only cast from reference types. (%s)", (Object)this.resultType().getClassName());
        if (BytecodeUtils.isDefinitelyAssignableFrom(target, this.resultType())) {
            return this;
        }
        return new Expression(target, this.features()){

            @Override
            void doGen(CodeBuilder adapter) {
                Expression.this.gen(adapter);
                adapter.checkCast(this.resultType());
            }
        };
    }

    Expression checkedCast(Class<?> target) {
        return this.checkedCast(Type.getType(target));
    }

    Expression invoke(MethodRef method, Expression ... args) {
        return method.invoke((Iterable<? extends Expression>)ImmutableList.builder().add((Object)this).add((Object[])args).build());
    }

    Statement invokeVoid(MethodRef method, Expression ... args) {
        return method.invokeVoid((Iterable<? extends Expression>)ImmutableList.builder().add((Object)this).add((Object[])args).build());
    }

    Expression labelStart(final Label label) {
        return new Expression(this.resultType(), this.features){

            @Override
            void doGen(CodeBuilder adapter) {
                adapter.mark(label);
                Expression.this.gen(adapter);
            }
        };
    }

    Expression labelEnd(final Label label) {
        return new Expression(this.resultType(), this.features){

            @Override
            void doGen(CodeBuilder adapter) {
                Expression.this.gen(adapter);
                adapter.mark(label);
            }
        };
    }

    @ForOverride
    protected void extraToStringProperties(MoreObjects.ToStringHelper helper) {
    }

    public String toString() {
        String name = this.getClass().getSimpleName();
        if (name.isEmpty()) {
            name = "Expression";
        }
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)name).omitNullValues();
        helper.add("type", (Object)this.resultType());
        this.extraToStringProperties(helper);
        helper.add("cheap", (Object)(this.features.has(Feature.CHEAP) ? "true" : null));
        helper.add("non-null", this.features.has(Feature.NON_NULLABLE) && !BytecodeUtils.isPrimitive(this.resultType) ? "true" : null);
        return helper + ":\n" + this.trace();
    }

    static final class Features {
        private static final Features EMPTY = new Features(EnumSet.noneOf(Feature.class));
        private final EnumSet<Feature> set;

        static Features of() {
            return EMPTY;
        }

        static Features of(Feature first, Feature ... rest) {
            EnumSet<Feature> set = EnumSet.of(first);
            Collections.addAll(set, rest);
            return new Features(set);
        }

        private static Features forType(Type expressionType, Features features) {
            switch (expressionType.getSort()) {
                case 9: 
                case 10: {
                    return features;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return features.plus(Feature.NON_NULLABLE);
                }
                case 0: 
                case 11: {
                    throw new IllegalArgumentException("Invalid type: " + expressionType);
                }
            }
            throw new AssertionError((Object)("unexpected type " + expressionType));
        }

        private Features(EnumSet<Feature> set) {
            this.set = (EnumSet)Preconditions.checkNotNull(set);
        }

        boolean has(Feature feature) {
            return this.set.contains((Object)feature);
        }

        Features plus(Feature feature) {
            if (this.set.contains((Object)feature)) {
                return this;
            }
            EnumSet<Feature> newSet = this.copyFeatures();
            newSet.add(feature);
            return new Features(newSet);
        }

        Features minus(Feature feature) {
            if (!this.set.contains((Object)feature)) {
                return this;
            }
            EnumSet<Feature> newSet = this.copyFeatures();
            newSet.remove((Object)feature);
            return new Features(newSet);
        }

        private EnumSet<Feature> copyFeatures() {
            EnumSet<Feature> newSet = EnumSet.noneOf(Feature.class);
            newSet.addAll(this.set);
            return newSet;
        }
    }

    static enum Feature {
        NON_NULLABLE,
        CHEAP;

    }
}

