/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.jbcsrc.UnexpectedCompilerFailureException;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.defn.InjectedParam;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.soytree.defn.TemplateParam;

abstract class EnhancedAbstractExprNodeVisitor<T>
extends AbstractReturningExprNodeVisitor<T> {
    EnhancedAbstractExprNodeVisitor() {
    }

    @Override
    protected T visit(ExprNode node) {
        try {
            return (T)super.visit(node);
        }
        catch (UnexpectedCompilerFailureException e) {
            e.addLocation(node);
            throw e;
        }
        catch (Throwable t) {
            throw new UnexpectedCompilerFailureException(node, t);
        }
    }

    @Override
    protected final T visitVarRefNode(VarRefNode node) {
        VarDefn defn = node.getDefnDecl();
        switch (defn.kind()) {
            case LOCAL_VAR: {
                LocalVar local = (LocalVar)defn;
                SoyNode.LocalVarNode declaringNode = local.declaringNode();
                switch (declaringNode.getKind()) {
                    case FOR_NODE: {
                        return this.visitForLoopIndex(node, local);
                    }
                    case FOREACH_NONEMPTY_NODE: {
                        return this.visitForeachLoopVar(node, local);
                    }
                    case LET_CONTENT_NODE: 
                    case LET_VALUE_NODE: {
                        return this.visitLetNodeVar(node, local);
                    }
                }
                throw new AssertionError((Object)("Unexpected local variable: " + local));
            }
            case PARAM: {
                return this.visitParam(node, (TemplateParam)defn);
            }
            case IJ_PARAM: {
                return this.visitIjParam(node, (InjectedParam)defn);
            }
            case UNDECLARED: {
                throw new RuntimeException("undeclared params are not supported by jbcsrc");
            }
        }
        throw new AssertionError();
    }

    @Override
    protected final T visitFunctionNode(FunctionNode node) {
        SoyFunction function = node.getSoyFunction();
        if (function instanceof BuiltinFunction) {
            BuiltinFunction builtinFn = (BuiltinFunction)function;
            switch (builtinFn) {
                case IS_FIRST: {
                    return this.visitIsFirstFunction(node);
                }
                case IS_LAST: {
                    return this.visitIsLastFunction(node);
                }
                case INDEX: {
                    return this.visitIndexFunction(node);
                }
                case QUOTE_KEYS_IF_JS: {
                    return (T)this.visitMapLiteralNode((MapLiteralNode)node.getChild(0));
                }
                case CHECK_NOT_NULL: {
                    return this.visitCheckNotNullFunction(node);
                }
                case CSS: {
                    return this.visitCssFunction(node);
                }
                case XID: {
                    return this.visitXidFunction(node);
                }
                case V1_EXPRESSION: {
                    throw new AssertionError();
                }
            }
            throw new AssertionError();
        }
        return this.visitPluginFunction(node);
    }

    T visitForLoopIndex(VarRefNode varRef, LocalVar local) {
        return (T)this.visitExprNode(varRef);
    }

    T visitForeachLoopVar(VarRefNode varRef, LocalVar local) {
        return (T)this.visitExprNode(varRef);
    }

    T visitLetNodeVar(VarRefNode node, LocalVar local) {
        return (T)this.visitExprNode(node);
    }

    T visitParam(VarRefNode varRef, TemplateParam param) {
        return (T)this.visitExprNode(varRef);
    }

    T visitIjParam(VarRefNode varRef, InjectedParam ij) {
        return (T)this.visitExprNode(varRef);
    }

    T visitIsFirstFunction(FunctionNode node) {
        return (T)this.visitExprNode(node);
    }

    T visitIsLastFunction(FunctionNode node) {
        return (T)this.visitExprNode(node);
    }

    T visitIndexFunction(FunctionNode node) {
        return (T)this.visitExprNode(node);
    }

    T visitCheckNotNullFunction(FunctionNode node) {
        return (T)this.visitExprNode(node);
    }

    T visitCssFunction(FunctionNode node) {
        return (T)this.visitExprNode(node);
    }

    T visitXidFunction(FunctionNode node) {
        return (T)this.visitExprNode(node);
    }

    T visitPluginFunction(FunctionNode node) {
        return (T)this.visitExprNode(node);
    }
}

