/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlCommentNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.XidNode;
import java.util.ArrayDeque;
import java.util.IdentityHashMap;

final class HtmlContextVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind INVALID_NODE_LOCATION_OUTSIDE_OF_ATTRIBUTE_VALUE = SoyErrorKind.of("The incremental HTML Soy backend does not allow '{'{0}'}' nodes to appear in HTML outside of attribute values.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DYNAMIC_TAG_NAME = SoyErrorKind.of("IncrementalDom does not support dynamic tag names.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DYNAMIC_ATTRIBUTE_NAME = SoyErrorKind.of("IncrementalDom does not support dynamic attribute names.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOY_TAG_BEFORE_ATTR_VALUE = SoyErrorKind.of("Soy statements are not allowed before an attribute value. They should be moved inside a quotation mark.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_SELF_CLOSING_TAG = SoyErrorKind.of("Invalid self-closing tag for \"{0}\". Self-closing tags are only valid for void tags and SVG content (partially supported). For a list of void elements, see https://www.w3.org/TR/html5/syntax.html#void-elements.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNSUPPORTED_HTML_COMMENTS_FOR_IDOM = SoyErrorKind.of("Found HTML comments \"{0}\". HTML comments in Soy templates are incompatible with Incremental DOM backend.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private final ArrayDeque<HtmlContext> stateStack = new ArrayDeque();
    private final ArrayDeque<HtmlOpenTagNode> openTagStack = new ArrayDeque();
    private final IdentityHashMap<HtmlOpenTagNode, InferredElementNamespace> openTagToInferredNamesapce = new IdentityHashMap();

    public HtmlContextVisitor(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        Preconditions.checkState((boolean)this.stateStack.isEmpty());
        SanitizedContentKind contentKind = node.getContentKind();
        this.pushState(this.contextForKind(contentKind));
        this.visitChildren(node);
        this.popState();
        Preconditions.checkState((boolean)this.stateStack.isEmpty());
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        this.pushState(this.contextForKind(node.getContentKind()));
        this.visitChildren(node);
        this.popState();
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        this.pushState(this.contextForKind(node.getContentKind()));
        this.visitChildren(node);
        this.popState();
    }

    @Override
    protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
        if (!node.getTagName().isStatic()) {
            this.errorReporter.report(node.getTagName().getTagLocation(), DYNAMIC_TAG_NAME, new Object[0]);
            return;
        }
        this.pushState(HtmlContext.HTML_TAG_NAME);
        this.visitChildren(node);
        this.popState();
        boolean tagMatches = false;
        while (!this.openTagStack.isEmpty() && !tagMatches) {
            HtmlOpenTagNode htmlOpenTagNode = this.openTagStack.pop();
            tagMatches = htmlOpenTagNode.getTagName().getStaticTagNameAsLowerCase().equals(node.getTagName().getStaticTagNameAsLowerCase());
        }
    }

    @Override
    protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
        if (!node.getTagName().isStatic()) {
            this.errorReporter.report(node.getTagName().getTagLocation(), DYNAMIC_TAG_NAME, new Object[0]);
            return;
        }
        String tagName = node.getTagName().getStaticTagNameAsLowerCase();
        InferredElementNamespace namespace = this.getNamespace(tagName);
        if (node.isSelfClosing() && namespace == InferredElementNamespace.XHTML && !node.getTagName().isDefinitelyVoid()) {
            this.errorReporter.report(node.getTagName().getTagLocation(), INVALID_SELF_CLOSING_TAG, tagName);
        } else {
            this.openTagStack.push(node);
            this.openTagToInferredNamesapce.put(node, namespace);
        }
        this.pushState(HtmlContext.HTML_TAG_NAME);
        this.visit((SoyNode)node.getChild(0));
        this.popState();
        this.pushState(HtmlContext.HTML_TAG);
        for (int i = 1; i < node.numChildren(); ++i) {
            this.visit((SoyNode)node.getChild(i));
        }
        this.popState();
    }

    @Override
    protected void visitHtmlAttributeNode(HtmlAttributeNode node) {
        this.visit((SoyNode)node.getChild(0));
        if (node.hasValue()) {
            SoyNode.StandaloneNode attributeValue;
            if (((SoyNode.StandaloneNode)node.getChild(0)).getKind() != SoyNode.Kind.RAW_TEXT_NODE) {
                this.errorReporter.report(((SoyNode.StandaloneNode)node.getChild(0)).getSourceLocation(), DYNAMIC_ATTRIBUTE_NAME, new Object[0]);
            }
            if ((attributeValue = (SoyNode.StandaloneNode)node.getChild(1)).getKind() != SoyNode.Kind.HTML_ATTRIBUTE_VALUE_NODE) {
                this.errorReporter.report(attributeValue.getSourceLocation(), SOY_TAG_BEFORE_ATTR_VALUE, new Object[0]);
            }
            for (int i = 1; i < node.numChildren(); ++i) {
                this.visit((SoyNode)node.getChild(i));
            }
        }
    }

    @Override
    protected void visitHtmlAttributeValueNode(HtmlAttributeValueNode node) {
        this.pushState(HtmlContext.HTML_NORMAL_ATTR_VALUE);
        super.visitHtmlAttributeValueNode(node);
        this.popState();
    }

    @Override
    protected void visitHtmlCommentNode(HtmlCommentNode node) {
        this.errorReporter.report(node.getSourceLocation(), UNSUPPORTED_HTML_COMMENTS_FOR_IDOM, node.toSourceString());
    }

    @Override
    protected void visitLogNode(LogNode node) {
        this.pushState(HtmlContext.TEXT);
        this.visitChildren(node);
        this.popState();
    }

    @Override
    protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        node.setHtmlContext(this.getState());
        this.visitChildren(node);
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        node.setHtmlContext(this.getState());
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        node.setHtmlContext(this.getState());
    }

    @Override
    protected void visitCssNode(CssNode node) {
        if (this.getState() != HtmlContext.HTML_NORMAL_ATTR_VALUE && this.getState() != HtmlContext.TEXT) {
            this.errorReporter.report(node.getSourceLocation(), INVALID_NODE_LOCATION_OUTSIDE_OF_ATTRIBUTE_VALUE, "css");
        }
        super.visitCssNode(node);
    }

    @Override
    protected void visitXidNode(XidNode node) {
        if (this.getState() != HtmlContext.HTML_NORMAL_ATTR_VALUE && this.getState() != HtmlContext.TEXT) {
            this.errorReporter.report(node.getSourceLocation(), INVALID_NODE_LOCATION_OUTSIDE_OF_ATTRIBUTE_VALUE, "xid");
        }
        super.visitXidNode(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    private InferredElementNamespace getNamespace(String tagName) {
        if (tagName.equalsIgnoreCase("svg")) {
            return InferredElementNamespace.SVG;
        }
        if (tagName.equalsIgnoreCase("foreignObject") || this.openTagStack.isEmpty()) {
            return InferredElementNamespace.XHTML;
        }
        return this.openTagToInferredNamesapce.get(this.openTagStack.peek());
    }

    private void pushState(HtmlContext context) {
        this.stateStack.push(context);
    }

    private void popState() {
        this.stateStack.pop();
    }

    private HtmlContext getState() {
        return this.stateStack.peek();
    }

    private HtmlContext contextForKind(SanitizedContentKind contentKind) {
        switch (contentKind) {
            case HTML: {
                return HtmlContext.HTML_PCDATA;
            }
            case ATTRIBUTES: {
                return HtmlContext.HTML_TAG;
            }
        }
        return HtmlContext.TEXT;
    }

    private static enum InferredElementNamespace {
        SVG,
        XHTML;

    }
}

