/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.error.SoyError;

public final class SoyCompilationException
extends SoySyntaxException {
    private final ImmutableList<SoyError> errors;

    public SoyCompilationException(Iterable<SoyError> specificErrors) {
        this.errors = Ordering.natural().immutableSortedCopy(specificErrors);
        boolean hasError = false;
        for (SoyError error : this.errors) {
            if (error.isWarning()) continue;
            hasError = true;
            break;
        }
        Preconditions.checkArgument((boolean)hasError, (Object)"Cannot construct a compilation exception with no errors");
    }

    public ImmutableList<SoyError> getErrors() {
        return this.errors;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder("errors during Soy compilation\n");
        Joiner.on((char)'\n').appendTo(sb, this.errors);
        int numErrors = 0;
        int numWarnings = 0;
        for (SoyError error : this.errors) {
            if (error.isWarning()) {
                ++numWarnings;
                continue;
            }
            ++numErrors;
        }
        SoyCompilationException.formatNumber(numErrors, "error", sb);
        if (numWarnings > 0) {
            sb.append(' ');
            SoyCompilationException.formatNumber(numWarnings, "warning", sb);
        }
        return sb.append('\n').toString();
    }

    private static void formatNumber(int n, String type, StringBuilder to) {
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
        to.append(n).append(' ').append(type).append(n == 1 ? "" : "s");
    }
}

