/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.conformance;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.conformance.Rule;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.SoyFileNode;
import java.util.regex.Pattern;

public final class BannedTextEverywhereExceptComments
extends Rule<SoyFileNode> {
    private final ImmutableSet<String> bannedTexts;
    private static final Pattern COMMENTS_PATTERN = Pattern.compile("/\\*\\*.*?\\*/", 32);

    public BannedTextEverywhereExceptComments(ImmutableSet<String> bannedTexts, SoyErrorKind error) {
        super(error);
        this.bannedTexts = bannedTexts;
    }

    @Override
    public void checkConformance(SoyFileNode node, ErrorReporter errorReporter) {
        String sourceString = node.toSourceString();
        for (String bannedText : this.bannedTexts) {
            if (!sourceString.contains(bannedText) || !BannedTextEverywhereExceptComments.bannedTextOccursOutsideJsDoc(sourceString, bannedText)) continue;
            errorReporter.report(new SourceLocation(node.getFilePath()), this.error, new Object[0]);
        }
    }

    private static boolean bannedTextOccursOutsideJsDoc(String sourceString, String bannedText) {
        String withoutComments = COMMENTS_PATTERN.matcher(sourceString).replaceAll("");
        return withoutComments.contains(bannedText);
    }
}

