/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.conformance;

import com.google.common.base.Ascii;
import com.google.template.soy.conformance.Rule;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;

public final class BanInlineEventHandlers
extends Rule<SoyFileNode> {
    public BanInlineEventHandlers(SoyErrorKind error) {
        super(error);
    }

    @Override
    protected void checkConformance(SoyFileNode node, ErrorReporter errorReporter) {
        for (HtmlAttributeNode attributeNode : SoyTreeUtils.getAllNodesOfType(node, HtmlAttributeNode.class)) {
            SoyNode.StandaloneNode attrName;
            if (!attributeNode.hasValue() || !((attrName = (SoyNode.StandaloneNode)attributeNode.getChild(0)) instanceof RawTextNode) || !Ascii.toLowerCase((String)((RawTextNode)attrName).getRawText()).startsWith("on")) continue;
            errorReporter.report(((SoyNode.StandaloneNode)attributeNode.getChild(0)).getSourceLocation(), this.error, new Object[0]);
        }
    }
}

