/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@SoyPureFunction
public final class ParseIntFunction
implements SoyJavaFunction,
SoyLibraryAssistedJsSrcFunction,
SoyPySrcFunction {
    @Inject
    ParseIntFunction() {
    }

    @Override
    public String getName() {
        return "parseInt";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1);
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        String toParse = args.get(0).stringValue();
        try {
            return IntegerData.forValue(Long.parseLong(toParse));
        }
        catch (NumberFormatException e) {
            return NullData.INSTANCE;
        }
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        String arg = args.get(0).getText();
        return new JsExpr(String.format("soy.$$parseInt(%s)", arg), Integer.MAX_VALUE);
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return ImmutableSet.of((Object)"soy");
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        String arg = args.get(0).getText();
        return new PyExpr(String.format("runtime.parse_int(%s)", arg), Integer.MAX_VALUE);
    }
}

