/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.SoyJarFileWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.kohsuke.args4j.Option;

public final class SoyParseInfoGenerator
extends AbstractSoyCompiler {
    @Option(name="--allowExternalCalls", usage="Whether to allow external calls. New projects should set this to false, and existing projects should remove existing external calls and then set this to false. It will save you a lot of headaches. Currently defaults to true for backward compatibility.")
    private boolean allowExternalCalls = true;
    @Option(name="--outputDirectory", usage="[Optional] The path to the output directory. If files with the same names already exist at this location, they will be overwritten. Either --outputDirectory or --outputJar must be set")
    private String outputDirectory = "";
    @Option(name="--outputSrcJar", usage="[Optional] The path to the source jar to write. If a file with the same name already exist at this location, it will be overwritten. Either --outputDirectory or --outputJar must be set")
    private File outputSrcJar;
    @Option(name="--javaPackage", required=true, usage="[Required] The Java package name to use for the generated classes.")
    private String javaPackage = "";
    @Option(name="--javaClassNameSource", required=true, usage="[Required] The source for the generated class names. Valid values are \"filename\", \"namespace\", and \"generic\". Option \"filename\" turns a Soy file name AaaBbb.soy or aaa_bbb.soy into AaaBbbSoyInfo. Option \"namespace\" turns a namespace aaa.bbb.cccDdd into CccDddSoyInfo (note it only uses the last part of the namespace). Option \"generic\" generates class names such as File1SoyInfo, File2SoyInfo.")
    private String javaClassNameSource = "";

    SoyParseInfoGenerator(ClassLoader loader) {
        super(loader);
    }

    SoyParseInfoGenerator() {
    }

    public static void main(String[] args) throws IOException {
        new SoyParseInfoGenerator().runMain(args);
    }

    @Override
    void validateFlags() {
        if (this.outputDirectory.isEmpty() == (this.outputSrcJar == null)) {
            SoyParseInfoGenerator.exitWithError("Must provide exactly one of --outputDirectory or --outputSrcJar");
        }
        if (this.javaPackage.length() == 0) {
            SoyParseInfoGenerator.exitWithError("Must provide Java package.");
        }
        if (this.javaClassNameSource.length() == 0) {
            SoyParseInfoGenerator.exitWithError("Must provide Java class name source.");
        }
    }

    @Override
    void compile(SoyFileSet.Builder sfsBuilder) throws IOException {
        sfsBuilder.setAllowExternalCalls(this.allowExternalCalls);
        SoyFileSet sfs = sfsBuilder.build();
        ImmutableMap<String, String> parseInfo = sfs.generateParseInfo(this.javaPackage, this.javaClassNameSource);
        if (this.outputSrcJar == null) {
            for (Map.Entry entry : parseInfo.entrySet()) {
                File outputFile = new File(this.outputDirectory, (String)entry.getKey());
                BaseUtils.ensureDirsExistInPath(outputFile.getPath());
                Files.asCharSink((File)outputFile, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)entry.getValue());
            }
        } else {
            String resourcePath = this.javaPackage.replace('.', '/') + "/";
            try (SoyJarFileWriter writer = new SoyJarFileWriter(new FileOutputStream(this.outputSrcJar));){
                for (Map.Entry entry : parseInfo.entrySet()) {
                    writer.writeEntry(resourcePath + (String)entry.getKey(), CharSource.wrap((CharSequence)((CharSequence)entry.getValue())).asByteSource(StandardCharsets.UTF_8));
                }
            }
        }
    }
}

