/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.Optional;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgBundleHandler;
import com.google.template.soy.xliffmsgplugin.XliffMsgPluginModule;
import java.io.File;
import java.io.IOException;
import org.kohsuke.args4j.Option;

public final class SoyMsgExtractor
extends AbstractSoyCompiler {
    @Option(name="--allowExternalCalls", usage="Whether to allow external calls. New projects should set this to false, and existing projects should remove existing external calls and then set this to false. It will save you a lot of headaches. Currently defaults to true for backward compatibility.")
    private boolean allowExternalCalls = true;
    @Option(name="--outputFile", required=true, usage="The path to the output file to write. If a file already exists at this location, it will be overwritten. The file extension must match the output format requested.")
    private File outputFile;
    @Option(name="--sourceLocaleString", usage="The locale string of the source language (default 'en').")
    private String sourceLocaleString = "en";
    @Option(name="--targetLocaleString", usage="The locale string of the target language (default empty). If empty, then the output messages file will not specify a target locale string. Note that this option may not be applicable for certain message plugins (in which case this value will be ignored by the message plugin).")
    private String targetLocaleString = "";
    @Option(name="--messagePluginModule", usage="Specifies the full class name of a Guice module that binds a SoyMsgPlugin. If not specified, the default is com.google.template.soy.xliffmsgplugin.XliffMsgPluginModule, which binds the XliffMsgPlugin.")
    private Module messagePluginModule = new XliffMsgPluginModule();

    public static void main(String ... args) throws IOException {
        new SoyMsgExtractor().runMain(args);
    }

    SoyMsgExtractor(ClassLoader loader) {
        super(loader);
    }

    SoyMsgExtractor() {
    }

    @Override
    Optional<Module> msgPluginModule() {
        return Optional.of((Object)this.messagePluginModule);
    }

    @Override
    void compile(SoyFileSet.Builder sfsBuilder, Injector injector) throws IOException {
        sfsBuilder.setAllowExternalCalls(this.allowExternalCalls);
        SoyFileSet sfs = sfsBuilder.build();
        SoyMsgBundle msgBundle = sfs.extractMsgs();
        SoyMsgBundleHandler.OutputFileOptions options = new SoyMsgBundleHandler.OutputFileOptions();
        options.setSourceLocaleString(this.sourceLocaleString);
        if (this.targetLocaleString.length() > 0) {
            options.setTargetLocaleString(this.targetLocaleString);
        }
        ((SoyMsgBundleHandler)injector.getInstance(SoyMsgBundleHandler.class)).writeToExtractedMsgsFile(msgBundle, options, this.outputFile);
    }
}

