/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.ForOverride;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.template.soy.SoyCmdLineParser;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyModule;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.conformance.ConformanceConfig;
import com.google.template.soy.conformance.ValidatedConformanceConfig;
import com.google.template.soy.error.SoyCompilationException;
import com.google.template.soy.logging.LoggingConfig;
import com.google.template.soy.logging.ValidatedLoggingConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;

abstract class AbstractSoyCompiler {
    private final String usagePrefix = "Usage:\njava " + this.getClass().getName() + " \\\n" + "     [<flag1> <flag2> ...] --jar <jarName>  \\\n" + "     --srcs <soyFilePath>,... [--deps <soyFilePath>,...]\n";
    @Option(name="--inputPrefix", usage="If provided, this path prefix will be prepended to each input file path listed on the command line. This is a literal string prefix, so you'll need to include a trailing slash if necessary.")
    protected String inputPrefix = "";
    @Option(name="--srcs", usage="The list of source Soy files. Extra arguments are treated as srcs. Sources are required from either this flag or as extra arguments.", handler=SoyCmdLineParser.StringListOptionHandler.class)
    private List<String> srcs = new ArrayList<String>();
    @Option(name="--deps", usage="The list of dependency Soy files (if applicable). The compiler needs deps for analysis/checking, but will not generate code for dep files.", handler=SoyCmdLineParser.StringListOptionHandler.class)
    private List<String> deps = new ArrayList<String>();
    @Option(name="--indirectDeps", usage="Soy files required by deps, but which may not be used by srcs.", handler=SoyCmdLineParser.StringListOptionHandler.class)
    private List<String> indirectDeps = new ArrayList<String>();
    @Option(name="--compileTimeGlobalsFile", usage="The path to a file containing the mappings for global names to be substituted at compile time. Each line of the file should have the format \"<global_name> = <primitive_data>\" where primitive_data is a valid Soy expression literal for a primitive type (null, boolean, integer, float, or string). Empty lines and lines beginning with \"//\" are ignored. The file should be encoded in UTF-8. If you need to generate a file in this format from Java, consider using the utility SoyUtils.generateCompileTimeGlobalsFile().")
    private File globalsFile = null;
    @Option(name="--pluginModules", usage="Specifies the full class names of Guice modules for function plugins and print directive plugins (comma-delimited list).", handler=SoyCmdLineParser.ModuleListOptionHandler.class)
    private List<Module> pluginModules = new ArrayList<Module>();
    @Option(name="--protoFileDescriptors", usage="Location of protocol buffer definitions in the form of a file descriptor set.The compiler needs defs for parameter type checking and generating direct access support for proto types.", handler=SoyCmdLineParser.FileListOptionHandler.class)
    private final List<File> protoFileDescriptors = new ArrayList<File>();
    @Option(name="--conformanceConfig", usage="Location of conformance config protos in binary proto format.")
    private File conformanceConfig = null;
    @Option(name="--loggingConfig", usage="Location of logging config protos in binary proto format. Optional.")
    private File loggingConfig = null;
    @Option(name="--enableExperimentalFeatures", usage="Enable experimental features that are not generally available. These experimental features may change, break, or disappear at any time. We make absolutely no guarantees about what may happen if you turn one of these experiments on. Please proceed with caution at your own risk.", handler=SoyCmdLineParser.StringListOptionHandler.class)
    private final List<String> experimentalFeatures = new ArrayList<String>();
    @Option(name="--disableOptimizerForTestingUseOnly", usage="Disable optimizer in Soy compiler. Optimzer tries to simplify the Soy AST and improves the performance in general. This flag should only be set in integration test environment.")
    private boolean disableOptimizer = false;
    @Argument
    private final List<String> arguments = new ArrayList<String>();
    private final ClassLoader pluginClassLoader;

    AbstractSoyCompiler(ClassLoader pluginClassLoader) {
        this.pluginClassLoader = pluginClassLoader;
    }

    AbstractSoyCompiler() {
        this(AbstractSoyCompiler.class.getClassLoader());
    }

    final void runMain(String ... args) {
        int status = this.run(args, System.err);
        System.exit(status);
    }

    @CheckReturnValue
    @VisibleForTesting
    int run(String[] args, PrintStream err) {
        try {
            this.doMain(args, err);
            return 0;
        }
        catch (SoyCompilationException compilationException) {
            err.println(compilationException.getMessage());
            return 1;
        }
        catch (CommandLineError e) {
            err.println(e.getMessage());
            return 1;
        }
        catch (Exception e) {
            err.println("INTERNAL SOY ERROR.\nPlease open an issue at https://github.com/google/closure-templates/issues with this stack trace and repro steps");
            e.printStackTrace(err);
            return 1;
        }
    }

    private void doMain(String[] args, PrintStream err) throws IOException {
        SoyCmdLineParser cmdLineParser = new SoyCmdLineParser(this, this.pluginClassLoader);
        try {
            cmdLineParser.parseArgument(args);
        }
        catch (CmdLineException cle) {
            StringWriter sw = new StringWriter();
            cmdLineParser.setUsageWidth(100);
            cmdLineParser.printUsage(sw, null);
            AbstractSoyCompiler.exitWithError(String.format("%s\n\n%s\n%s", cle.getMessage(), this.usagePrefix, sw.toString()));
        }
        this.validateFlags();
        if (!this.arguments.isEmpty() && !this.acceptsSourcesAsArguments()) {
            AbstractSoyCompiler.exitWithError("Found old style sources passed on the command line, use --srcs=... instead");
        }
        if (this.srcs.isEmpty() && this.arguments.isEmpty()) {
            AbstractSoyCompiler.exitWithError("Must provide list of source Soy files (--srcs).");
        }
        if (!this.srcs.isEmpty() && !this.arguments.isEmpty()) {
            AbstractSoyCompiler.exitWithError("Found source Soy files from --srcs and from args (please use --srcs only).");
        }
        ArrayList<SoyModule> modules = new ArrayList<SoyModule>();
        modules.add(new SoyModule());
        modules.addAll(this.pluginModules);
        modules.addAll(this.msgPluginModule().asSet());
        Injector injector = Guice.createInjector(modules);
        SoyFileSet.Builder sfsBuilder = ((SoyFileSet.Builder)injector.getInstance(SoyFileSet.Builder.class)).setWarningSink(err).setConformanceConfig(this.parseConformanceConfig()).setValidatedLoggingConfig(this.parseLoggingConfig()).setExperimentalFeatures(this.experimentalFeatures);
        if (!this.protoFileDescriptors.isEmpty()) {
            sfsBuilder.addProtoDescriptorsFromFiles(this.protoFileDescriptors);
        }
        AbstractSoyCompiler.addSoyFilesToBuilder(sfsBuilder, this.inputPrefix, (Collection<String>)ImmutableSet.builder().addAll(this.srcs).addAll(this.arguments).build(), this.deps, this.indirectDeps);
        if (this.globalsFile != null) {
            sfsBuilder.setCompileTimeGlobals(this.globalsFile);
        }
        if (this.disableOptimizer) {
            sfsBuilder.disableOptimizer();
        }
        this.compile(sfsBuilder, injector);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ValidatedConformanceConfig parseConformanceConfig() {
        if (this.conformanceConfig == null) return ValidatedConformanceConfig.EMPTY;
        try (FileInputStream stream = new FileInputStream(this.conformanceConfig);){
            ValidatedConformanceConfig validatedConformanceConfig = ValidatedConformanceConfig.create(ConformanceConfig.parseFrom(stream));
            return validatedConformanceConfig;
        }
        catch (IllegalArgumentException e) {
            throw new CommandLineError("Error parsing conformance proto: " + this.conformanceConfig + ": " + e.getMessage());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CommandLineError("Invalid conformance proto: " + this.conformanceConfig + ": " + e.getMessage());
        }
        catch (IOException e) {
            throw new CommandLineError("Unable to read conformance proto: " + this.conformanceConfig + ": " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ValidatedLoggingConfig parseLoggingConfig() {
        if (this.loggingConfig == null) return ValidatedLoggingConfig.EMPTY;
        try (FileInputStream stream = new FileInputStream(this.loggingConfig);){
            ValidatedLoggingConfig validatedLoggingConfig = ValidatedLoggingConfig.create(LoggingConfig.parseFrom(stream));
            return validatedLoggingConfig;
        }
        catch (IllegalArgumentException e) {
            throw new CommandLineError("Error parsing logging config proto: " + this.loggingConfig + ": " + e.getMessage());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CommandLineError("Invalid conformance proto: " + this.loggingConfig + ": " + e.getMessage());
        }
        catch (IOException e) {
            throw new CommandLineError("Unable to read conformance proto: " + this.loggingConfig + ": " + e.getMessage());
        }
    }

    @ForOverride
    boolean acceptsSourcesAsArguments() {
        return true;
    }

    @ForOverride
    Optional<Module> msgPluginModule() {
        return Optional.absent();
    }

    @ForOverride
    void validateFlags() {
    }

    @ForOverride
    void compile(SoyFileSet.Builder sfsBuilder, Injector injector) throws IOException {
        this.compile(sfsBuilder);
    }

    @ForOverride
    void compile(SoyFileSet.Builder sfsBuilder) throws IOException {
        throw new AbstractMethodError("must override at least one overload of compile()");
    }

    static final RuntimeException exitWithError(String errorMsg) {
        throw new CommandLineError("Error: " + errorMsg);
    }

    private static void addSoyFilesToBuilder(SoyFileSet.Builder sfsBuilder, String inputPrefix, Collection<String> srcs, Collection<String> deps, Collection<String> indirectDeps) {
        HashSet<String> soFar = new HashSet<String>();
        AbstractSoyCompiler.addAllIfNotPresent(sfsBuilder, SoyFileKind.SRC, inputPrefix, srcs, soFar);
        AbstractSoyCompiler.addAllIfNotPresent(sfsBuilder, SoyFileKind.DEP, inputPrefix, deps, soFar);
        AbstractSoyCompiler.addAllIfNotPresent(sfsBuilder, SoyFileKind.INDIRECT_DEP, inputPrefix, indirectDeps, soFar);
    }

    private static void addAllIfNotPresent(SoyFileSet.Builder builder, SoyFileKind kind, String inputPrefix, Collection<String> files, Set<String> soFar) {
        for (String file : files) {
            if (!soFar.add(file)) continue;
            builder.addWithKind(new File(inputPrefix + file), kind);
        }
    }

    private static final class CommandLineError
    extends Error {
        CommandLineError(String msg) {
            super(msg);
        }
    }
}

