/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.proto.AmbiguousFieldSet;
import com.google.template.soy.types.proto.ExtensionField;
import com.google.template.soy.types.proto.Field;
import com.google.template.soy.types.proto.JavaQualifiedNames;
import com.google.template.soy.types.proto.NormalField;
import com.google.template.soy.types.proto.ProtoUtils;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class SoyProtoType
implements SoyType {
    private static final Logger logger = Logger.getLogger(SoyProtoType.class.getName());
    private final Descriptors.Descriptor typeDescriptor;
    private final ImmutableMap<String, Field> fields;

    SoyProtoType(SoyTypeRegistry typeRegistry, Descriptors.Descriptor descriptor, Set<Descriptors.FieldDescriptor> extensions) {
        this.typeDescriptor = descriptor;
        ImmutableMap.Builder fields = ImmutableMap.builder();
        for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            if (ProtoUtils.shouldJsIgnoreField(fieldDescriptor)) continue;
            NormalField normalField = new NormalField(typeRegistry, fieldDescriptor);
            fields.put((Object)normalField.getName(), (Object)normalField);
        }
        SetMultimap extensionsBySoyName = MultimapBuilder.hashKeys().hashSetValues().build();
        for (Descriptors.FieldDescriptor fieldDescriptor : extensions) {
            ExtensionField field = new ExtensionField(typeRegistry, fieldDescriptor);
            extensionsBySoyName.put((Object)field.getName(), (Object)field);
        }
        for (Map.Entry entry : Multimaps.asMap((SetMultimap)extensionsBySoyName).entrySet()) {
            String fieldName = (String)entry.getKey();
            Set ambiguousFields = (Set)entry.getValue();
            if (ambiguousFields.size() == 1) {
                fields.put((Object)fieldName, Iterables.getOnlyElement((Iterable)ambiguousFields));
                continue;
            }
            AmbiguousFieldSet value = new AmbiguousFieldSet(fieldName, ambiguousFields);
            logger.severe("Proto " + descriptor.getFullName() + " has multiple extensions with the name \"" + fieldName + "\": " + value.getFullFieldNames() + "\nThis field will not be accessible from soy");
            fields.put((Object)fieldName, (Object)value);
        }
        this.fields = fields.build();
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.PROTO;
    }

    @Override
    public boolean isAssignableFrom(SoyType fromType) {
        return fromType == this;
    }

    @Override
    public boolean isInstance(SoyValue value) {
        return value instanceof SoyProtoValue && ((SoyProtoValue)value).getProto().getDescriptorForType() == this.typeDescriptor;
    }

    public Descriptors.Descriptor getDescriptor() {
        return this.typeDescriptor;
    }

    public String getDescriptorExpression() {
        Descriptors.Descriptor descriptor = this.typeDescriptor;
        while (descriptor.getContainingType() != null) {
            descriptor = descriptor.getContainingType();
        }
        return JavaQualifiedNames.getQualifiedName(descriptor) + ".getDescriptor()";
    }

    public Descriptors.FieldDescriptor getFieldDescriptor(String fieldName) {
        return ((Field)this.fields.get((Object)fieldName)).getDescriptor();
    }

    @Nullable
    public Field getField(String name) {
        return (Field)this.fields.get((Object)name);
    }

    @Nullable
    public SoyType getFieldType(String fieldName) {
        Field field = (Field)this.fields.get((Object)fieldName);
        return field != null ? field.getType() : null;
    }

    public ImmutableSet<String> getFieldNames() {
        return this.fields.keySet();
    }

    public String getNameForBackend(SoyBackendKind backend) {
        switch (backend) {
            case JS_SRC: {
                return ProtoUtils.calculateQualifiedJsName((Descriptors.GenericDescriptor)this.typeDescriptor);
            }
            case TOFU: 
            case JBC_SRC: {
                return JavaQualifiedNames.getClassName(this.typeDescriptor);
            }
        }
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.typeDescriptor.getFullName();
    }
}

