/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.aggregate.UnionType;
import com.google.template.soy.types.primitive.ErrorType;
import com.google.template.soy.types.primitive.FloatType;
import com.google.template.soy.types.primitive.IntType;
import com.google.template.soy.types.primitive.NullType;
import java.util.Collection;

public final class SoyTypes {
    public static final SoyType NUMBER_TYPE = UnionType.of(IntType.getInstance(), FloatType.getInstance());
    private static final ImmutableSet<SoyType.Kind> ALWAYS_COMPARABLE_KINDS = Sets.immutableEnumSet((Enum)SoyType.Kind.UNKNOWN, (Enum[])new SoyType.Kind[]{SoyType.Kind.ANY, SoyType.Kind.NULL});
    private static final ImmutableSet<SoyType.Kind> BOOLEAN_AND_NUMERIC_PRIMITIVES = Sets.immutableEnumSet((Enum)SoyType.Kind.BOOL, (Enum[])new SoyType.Kind[]{SoyType.Kind.INT, SoyType.Kind.FLOAT, SoyType.Kind.PROTO_ENUM});

    public static boolean isDefiniteComparable(SoyType type) {
        return ALWAYS_COMPARABLE_KINDS.contains((Object)type.getKind());
    }

    public static boolean isNumericPrimitive(SoyType type) {
        SoyType.Kind kind = type.getKind();
        if (BOOLEAN_AND_NUMERIC_PRIMITIVES.contains((Object)kind)) {
            return true;
        }
        return type.isAssignableFrom(NUMBER_TYPE) || NUMBER_TYPE.isAssignableFrom(type);
    }

    public static boolean isDefinitePrimitive(SoyType type) {
        return SoyTypes.isNumericPrimitive(type) || type.getKind().isKnownStringOrSanitizedContent();
    }

    public static SoyType removeNull(SoyType type) {
        Preconditions.checkArgument((!NullType.getInstance().equals(type) ? 1 : 0) != 0, (Object)"Can't remove null from null");
        if (type.getKind() == SoyType.Kind.UNION) {
            return ((UnionType)type).removeNullability();
        }
        return type;
    }

    public static SoyType makeNullable(SoyType type) {
        if (SoyTypes.isNullable(type)) {
            return type;
        }
        return UnionType.of(type, NullType.getInstance());
    }

    public static boolean isNullable(SoyType type) {
        return type.equals(NullType.getInstance()) || type.getKind() == SoyType.Kind.UNION && ((UnionType)type).isNullable();
    }

    public static boolean isNumericOrUnknown(SoyType type) {
        return type.getKind() == SoyType.Kind.UNKNOWN || NUMBER_TYPE.isAssignableFrom(type);
    }

    public static SoyType computeLowestCommonType(SoyTypeRegistry typeRegistry, SoyType t0, SoyType t1) {
        if (t0 == ErrorType.getInstance() || t1 == ErrorType.getInstance()) {
            return ErrorType.getInstance();
        }
        if (t0.isAssignableFrom(t1)) {
            return t0;
        }
        if (t1.isAssignableFrom(t0)) {
            return t1;
        }
        return typeRegistry.getOrCreateUnionType(t0, t1);
    }

    public static SoyType computeLowestCommonType(SoyTypeRegistry typeRegistry, Collection<SoyType> types) {
        SoyType result = null;
        for (SoyType type : types) {
            result = result == null ? type : SoyTypes.computeLowestCommonType(typeRegistry, result, type);
        }
        return result;
    }

    public static Optional<SoyType> computeLowestCommonTypeArithmetic(SoyType t0, SoyType t1) {
        if (t0 == ErrorType.getInstance() || t1 == ErrorType.getInstance()) {
            return Optional.of((Object)ErrorType.getInstance());
        }
        if (!SoyTypes.isNumericOrUnknown(t0) || !SoyTypes.isNumericOrUnknown(t1)) {
            return Optional.absent();
        }
        if (t0.isAssignableFrom(t1)) {
            return Optional.of((Object)t0);
        }
        if (t1.isAssignableFrom(t0)) {
            return Optional.of((Object)t1);
        }
        return Optional.of((Object)FloatType.getInstance());
    }
}

