/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeProvider;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.aggregate.ListType;
import com.google.template.soy.types.aggregate.MapType;
import com.google.template.soy.types.aggregate.RecordType;
import com.google.template.soy.types.aggregate.UnionType;
import com.google.template.soy.types.ast.GenericTypeNode;
import com.google.template.soy.types.ast.NamedTypeNode;
import com.google.template.soy.types.ast.RecordTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.TypeNodeVisitor;
import com.google.template.soy.types.ast.UnionTypeNode;
import com.google.template.soy.types.primitive.AnyType;
import com.google.template.soy.types.primitive.BoolType;
import com.google.template.soy.types.primitive.ErrorType;
import com.google.template.soy.types.primitive.FloatType;
import com.google.template.soy.types.primitive.IntType;
import com.google.template.soy.types.primitive.NullType;
import com.google.template.soy.types.primitive.SanitizedType;
import com.google.template.soy.types.primitive.StringType;
import com.google.template.soy.types.primitive.UnknownType;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class SoyTypeRegistry {
    private static final SoyErrorKind UNKNOWN_TYPE = SoyErrorKind.of("Unknown type ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_RECORD_FIELD = SoyErrorKind.of("Duplicate field ''{0}'' in record declaration.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_TYPE_PARAM = SoyErrorKind.of("Unexpected type parameter: ''{0}'' only has {1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind EXPECTED_TYPE_PARAM = SoyErrorKind.of("Expected a type parameter: ''{0}'' has {1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind NOT_A_GENERIC_TYPE = SoyErrorKind.of("''{0}'' is not a generic type, expected ''list'' or ''map''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MISSING_GENERIC_TYPE_PARAMTERS = SoyErrorKind.of("''{0}'' is a generic type, expected {1}.", new SoyErrorKind.StyleAllowance[0]);
    public static final SoyTypeRegistry DEFAULT_UNKNOWN = new SoyTypeRegistry((Set<SoyTypeProvider>)ImmutableSet.of((Object)new SoyTypeProvider(){

        @Override
        public SoyType getType(String typeName, SoyTypeRegistry typeRegistry) {
            return UnknownType.getInstance();
        }
    }));
    private static final ImmutableMap<String, SoyType> BUILTIN_TYPES = ImmutableMap.builder().put((Object)"?", (Object)UnknownType.getInstance()).put((Object)"any", (Object)AnyType.getInstance()).put((Object)"null", (Object)NullType.getInstance()).put((Object)"bool", (Object)BoolType.getInstance()).put((Object)"int", (Object)IntType.getInstance()).put((Object)"float", (Object)FloatType.getInstance()).put((Object)"string", (Object)StringType.getInstance()).put((Object)"number", (Object)SoyTypes.NUMBER_TYPE).put((Object)"html", (Object)SanitizedType.HtmlType.getInstance()).put((Object)"attributes", (Object)SanitizedType.AttributesType.getInstance()).put((Object)"css", (Object)SanitizedType.CssType.getInstance()).put((Object)"uri", (Object)SanitizedType.UriType.getInstance()).put((Object)"trusted_resource_url", (Object)SanitizedType.TrustedResourceUriType.getInstance()).put((Object)"js", (Object)SanitizedType.JsType.getInstance()).build();
    private final ImmutableSet<SoyTypeProvider> typeProviders;
    private final Interner<ListType> listTypes = Interners.newStrongInterner();
    private final Interner<MapType> mapTypes = Interners.newStrongInterner();
    private final Interner<UnionType> unionTypes = Interners.newStrongInterner();
    private final Interner<RecordType> recordTypes = Interners.newStrongInterner();
    private static final ImmutableMap<String, GenericTypeInfo> GENERIC_TYPES = ImmutableMap.of((Object)"list", (Object)new GenericTypeInfo(1){

        @Override
        SoyType create(List<SoyType> types, SoyTypeRegistry registry) {
            return registry.getOrCreateListType(types.get(0));
        }
    }, (Object)"map", (Object)new GenericTypeInfo(2){

        @Override
        SoyType create(List<SoyType> types, SoyTypeRegistry registry) {
            return registry.getOrCreateMapType(types.get(0), types.get(1));
        }
    });

    @Inject
    public SoyTypeRegistry(Set<SoyTypeProvider> typeProviders) {
        this.typeProviders = ImmutableSet.copyOf(typeProviders);
    }

    @VisibleForTesting
    public SoyTypeRegistry() {
        this.typeProviders = ImmutableSet.of();
    }

    @Nullable
    public SoyType getType(String typeName) {
        SoyType result = (SoyType)BUILTIN_TYPES.get((Object)typeName);
        if (result != null) {
            return result;
        }
        for (SoyTypeProvider provider : this.typeProviders) {
            result = provider.getType(typeName, this);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public ListType getOrCreateListType(SoyType elementType) {
        return (ListType)this.listTypes.intern((Object)ListType.of(elementType));
    }

    public MapType getOrCreateMapType(SoyType keyType, SoyType valueType) {
        return (MapType)this.mapTypes.intern((Object)MapType.of(keyType, valueType));
    }

    public SoyType getOrCreateUnionType(Collection<SoyType> members) {
        SoyType type = UnionType.of(members);
        if (type.getKind() == SoyType.Kind.UNION) {
            type = (SoyType)this.unionTypes.intern((Object)((UnionType)type));
        }
        return type;
    }

    public SoyType getOrCreateUnionType(SoyType ... members) {
        return this.getOrCreateUnionType(Arrays.asList(members));
    }

    public RecordType getOrCreateRecordType(Map<String, SoyType> fields) {
        return (RecordType)this.recordTypes.intern((Object)RecordType.of(fields));
    }

    public SoyType getOrCreateType(TypeNode node, ErrorReporter errorReporter) {
        return node.accept(new TypeNodeConverter(errorReporter));
    }

    private final class TypeNodeConverter
    implements TypeNodeVisitor<SoyType>,
    Function<TypeNode, SoyType> {
        final ErrorReporter errorReporter;

        TypeNodeConverter(ErrorReporter errorReporter) {
            this.errorReporter = errorReporter;
        }

        @Override
        public SoyType visit(NamedTypeNode node) {
            String name = node.name();
            SoyType type = SoyTypeRegistry.this.getType(name);
            if (type == null) {
                GenericTypeInfo genericType = (GenericTypeInfo)GENERIC_TYPES.get((Object)name);
                if (genericType != null) {
                    this.errorReporter.report(node.sourceLocation(), MISSING_GENERIC_TYPE_PARAMTERS, name, genericType.formatNumTypeParams());
                } else {
                    this.errorReporter.report(node.sourceLocation(), UNKNOWN_TYPE, name);
                }
                type = ErrorType.getInstance();
            }
            return type;
        }

        @Override
        public SoyType visit(GenericTypeNode node) {
            ImmutableList<TypeNode> args = node.arguments();
            String name = node.name();
            GenericTypeInfo genericType = (GenericTypeInfo)GENERIC_TYPES.get((Object)name);
            if (genericType != null) {
                if (args.size() < genericType.numParams) {
                    this.errorReporter.report(node.sourceLocation().getEndLocation(), EXPECTED_TYPE_PARAM, name, genericType.formatNumTypeParams());
                    return ErrorType.getInstance();
                }
                if (args.size() > genericType.numParams) {
                    this.errorReporter.report(((TypeNode)args.get(genericType.numParams)).sourceLocation(), UNEXPECTED_TYPE_PARAM, name, genericType.formatNumTypeParams());
                    return ErrorType.getInstance();
                }
                return genericType.create(Lists.transform(args, (Function)this), SoyTypeRegistry.this);
            }
            this.errorReporter.report(node.sourceLocation(), NOT_A_GENERIC_TYPE, name);
            return ErrorType.getInstance();
        }

        @Override
        public SoyType visit(UnionTypeNode node) {
            return SoyTypeRegistry.this.getOrCreateUnionType(Collections2.transform(node.candidates(), (Function)this));
        }

        @Override
        public SoyType visit(RecordTypeNode node) {
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (RecordTypeNode.Property property : node.properties()) {
                SoyType oldType = map.put(property.name(), property.type().accept(this));
                if (oldType == null) continue;
                this.errorReporter.report(property.nameLocation(), DUPLICATE_RECORD_FIELD, property.name());
                map.put(property.name(), oldType);
            }
            return SoyTypeRegistry.this.getOrCreateRecordType(map);
        }

        public SoyType apply(TypeNode node) {
            return node.accept(this);
        }
    }

    private static abstract class GenericTypeInfo {
        final int numParams;

        GenericTypeInfo(int numParams) {
            this.numParams = numParams;
        }

        final String formatNumTypeParams() {
            return this.numParams + " type parameter" + (this.numParams > 1 ? "s" : "");
        }

        abstract SoyType create(List<SoyType> var1, SoyTypeRegistry var2);
    }
}

