/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.shared.SoyIdRenamingMap;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.SoyNode;

public final class XidNode
extends AbstractCommandNode
implements SoyNode.StandaloneNode,
SoyNode.StatementNode {
    private final String text;
    private volatile Pair<SoyIdRenamingMap, String> renameCache;

    public XidNode(int id, SourceLocation sourceLocation, String text) {
        super(id, sourceLocation, "xid");
        this.text = text;
    }

    private XidNode(XidNode orig, CopyState copyState) {
        super(orig, copyState);
        this.text = orig.text;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.XID_NODE;
    }

    public String getText() {
        return this.text;
    }

    public String getRenamedText(SoyIdRenamingMap idRenamingMap) {
        Pair<SoyIdRenamingMap, String> cache = this.renameCache;
        if (cache != null && cache.first == idRenamingMap) {
            return (String)cache.second;
        }
        String mappedText = idRenamingMap.get(this.text);
        if (mappedText != null) {
            this.renameCache = Pair.of(idRenamingMap, mappedText);
            return mappedText;
        }
        return this.text + "_";
    }

    @Override
    public String getCommandText() {
        return this.text;
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public XidNode copy(CopyState copyState) {
        return new XidNode(this, copyState);
    }
}

