/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Set;

public enum Visibility {
    PRIVATE("private"),
    LEGACY_PRIVATE("legacy-private"),
    PUBLIC("public");

    private final String attributeValue;
    private static final ImmutableMap<String, Visibility> attrValuesToVisibilityLevels;

    private Visibility(String attributeValue) {
        this.attributeValue = attributeValue;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public static Set<String> getAttributeValues() {
        return attrValuesToVisibilityLevels.keySet();
    }

    public static Visibility forAttributeValue(String attributeValue) {
        return (Visibility)((Object)attrValuesToVisibilityLevels.get((Object)attributeValue));
    }

    static {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Visibility v : Visibility.values()) {
            if (v == LEGACY_PRIVATE) continue;
            builder.put((Object)v.attributeValue, (Object)v);
        }
        attrValuesToVisibilityLevels = builder.build();
    }
}

