/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.NodeVisitor;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.soytree.AbstractBlockNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TagName;
import javax.annotation.Nullable;

public final class MsgHtmlTagNode
extends AbstractBlockNode
implements SoyNode.MsgPlaceholderInitialNode {
    private static final SoyErrorKind DYNAMIC_TAG_NAME_IN_MSG_BLOCK = SoyErrorKind.of("HTML tags within within ''msg'' blocks must use constant tag names.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_PHNAME_ATTRIBUTE = SoyErrorKind.of("''phname'' attribute is not a valid identifier.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MULTIPLE_PHNAME_ATTRIBUTES = SoyErrorKind.of("Multiple ''phname'' attributes in HTML tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final ImmutableMap<String, String> LC_TAG_NAME_TO_PLACEHOLDER_NAME_MAP = ImmutableMap.builder().put((Object)"a", (Object)"link").put((Object)"br", (Object)"break").put((Object)"b", (Object)"bold").put((Object)"i", (Object)"italic").put((Object)"li", (Object)"item").put((Object)"ol", (Object)"ordered_list").put((Object)"ul", (Object)"unordered_list").put((Object)"p", (Object)"paragraph").put((Object)"img", (Object)"image").put((Object)"em", (Object)"emphasis").build();
    private final String lcTagName;
    private final boolean isSelfEnding;
    private final boolean isOnlyRawText;
    @Nullable
    private final String fullTagText;
    @Nullable
    private final String userSuppliedPlaceholderName;
    private static final CharMatcher INVALID_PLACEHOLDER_CHARS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.is((char)'_')).negate().precomputed();

    public static MsgHtmlTagNode fromNode(int id, HtmlTagNode tagNode, ErrorReporter errorReporter) {
        String fullTagText = MsgHtmlTagNode.getFullTagText(tagNode);
        String userSpecifiedPhName = MsgHtmlTagNode.getUserSpecifiedPhName(tagNode, errorReporter);
        String lcTagName = MsgHtmlTagNode.getLcTagName(errorReporter, tagNode.getTagName());
        if (tagNode instanceof HtmlCloseTagNode) {
            lcTagName = "/" + lcTagName;
        }
        return new MsgHtmlTagNode(id, tagNode.getSourceLocation(), userSpecifiedPhName, lcTagName, tagNode instanceof HtmlOpenTagNode && ((HtmlOpenTagNode)tagNode).isSelfClosing(), fullTagText != null, fullTagText, tagNode);
    }

    @Nullable
    private static String getFullTagText(HtmlTagNode openTagNode) {
        final boolean[] isConstantContent = new boolean[]{true};
        SoyTreeUtils.visitAllNodes(openTagNode, (NodeVisitor<? super Node, Boolean>)new NodeVisitor<Node, Boolean>(){

            @Override
            public Boolean exec(Node node) {
                if (node instanceof RawTextNode || node instanceof HtmlAttributeNode || node instanceof HtmlAttributeValueNode || node instanceof HtmlOpenTagNode || node instanceof HtmlCloseTagNode) {
                    return true;
                }
                isConstantContent[0] = false;
                return false;
            }
        });
        if (isConstantContent[0]) {
            return openTagNode.toSourceString();
        }
        return null;
    }

    @Nullable
    private static String getUserSpecifiedPhName(HtmlTagNode tagNode, ErrorReporter errorReporter) {
        HtmlAttributeNode phNameAttribute = tagNode.getPhNameNode();
        if (phNameAttribute == null) {
            return null;
        }
        String userSpecifiedPhName = MsgHtmlTagNode.getUserSpecifiedPhName(phNameAttribute, errorReporter);
        tagNode.removeChild(phNameAttribute);
        phNameAttribute = tagNode.getPhNameNode();
        if (phNameAttribute != null) {
            errorReporter.report(phNameAttribute.getSourceLocation(), MULTIPLE_PHNAME_ATTRIBUTES, new Object[0]);
        }
        return userSpecifiedPhName;
    }

    @Nullable
    private static String getUserSpecifiedPhName(HtmlAttributeNode htmlAttributeNode, ErrorReporter errorReporter) {
        String attributeName;
        HtmlAttributeValueNode attributeValueNode;
        SoyNode.StandaloneNode valueNode = (SoyNode.StandaloneNode)htmlAttributeNode.getChild(1);
        if (valueNode instanceof HtmlAttributeValueNode && (attributeValueNode = (HtmlAttributeValueNode)valueNode).numChildren() == 1 && attributeValueNode.getChild(0) instanceof RawTextNode && BaseUtils.isIdentifier(attributeName = ((RawTextNode)attributeValueNode.getChild(0)).getRawText())) {
            return attributeName;
        }
        errorReporter.report(valueNode.getSourceLocation(), INVALID_PHNAME_ATTRIBUTE, new Object[0]);
        return null;
    }

    private static String getLcTagName(ErrorReporter errorReporter, TagName tagName) {
        String lcTagName;
        if (!tagName.isStatic()) {
            errorReporter.report(tagName.getTagLocation(), DYNAMIC_TAG_NAME_IN_MSG_BLOCK, new Object[0]);
            lcTagName = "error";
        } else {
            lcTagName = tagName.getStaticTagNameAsLowerCase();
        }
        return lcTagName;
    }

    private MsgHtmlTagNode(int id, SourceLocation sourceLocation, String userSuppliedPlaceholderName, String lcTagName, boolean isSelfEnding, boolean isOnlyRawText, String fullTagText, SoyNode.StandaloneNode child) {
        super(id, sourceLocation);
        this.userSuppliedPlaceholderName = userSuppliedPlaceholderName;
        this.lcTagName = lcTagName;
        this.isSelfEnding = isSelfEnding;
        this.isOnlyRawText = isOnlyRawText;
        this.fullTagText = fullTagText;
        this.addChild(child);
    }

    private MsgHtmlTagNode(MsgHtmlTagNode orig, CopyState copyState) {
        super(orig, copyState);
        this.lcTagName = orig.lcTagName;
        this.isSelfEnding = orig.isSelfEnding;
        this.isOnlyRawText = orig.isOnlyRawText;
        this.fullTagText = orig.fullTagText;
        this.userSuppliedPlaceholderName = orig.userSuppliedPlaceholderName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_HTML_TAG_NODE;
    }

    public String getLcTagName() {
        return this.lcTagName;
    }

    @Nullable
    public String getFullTagText() {
        return this.fullTagText;
    }

    @Override
    @Nullable
    public String getUserSuppliedPhName() {
        return this.userSuppliedPlaceholderName;
    }

    @Override
    public String genBasePhName() {
        String basePlaceholderName;
        String baseLcTagName;
        boolean isEndTag;
        if (this.userSuppliedPlaceholderName != null) {
            return BaseUtils.convertToUpperUnderscore(this.userSuppliedPlaceholderName);
        }
        if (this.lcTagName.startsWith("/")) {
            isEndTag = true;
            baseLcTagName = this.lcTagName.substring(1);
        } else {
            isEndTag = false;
            baseLcTagName = this.lcTagName;
        }
        String string = basePlaceholderName = LC_TAG_NAME_TO_PLACEHOLDER_NAME_MAP.containsKey((Object)baseLcTagName) ? (String)LC_TAG_NAME_TO_PLACEHOLDER_NAME_MAP.get((Object)baseLcTagName) : baseLcTagName;
        if (isEndTag) {
            basePlaceholderName = "end_" + basePlaceholderName;
        } else if (!this.isSelfEnding) {
            basePlaceholderName = "start_" + basePlaceholderName;
        }
        basePlaceholderName = INVALID_PLACEHOLDER_CHARS.replaceFrom((CharSequence)basePlaceholderName, '_');
        return Ascii.toUpperCase((String)basePlaceholderName);
    }

    @Override
    public Object genSamenessKey() {
        return this.isOnlyRawText ? Pair.of(this.userSuppliedPlaceholderName, this.fullTagText) : this;
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        this.appendSourceStringForChildren(sb);
        if (this.userSuppliedPlaceholderName != null) {
            int indexBeforeClose;
            if (this.isSelfEnding ? !sb.substring(indexBeforeClose = sb.length() - 2).equals("/>") : !sb.substring(indexBeforeClose = sb.length() - 1).equals(">")) {
                throw new AssertionError();
            }
            sb.insert(indexBeforeClose, " phname=\"" + this.userSuppliedPlaceholderName + "\"");
        }
        return sb.toString();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public MsgHtmlTagNode copy(CopyState copyState) {
        return new MsgHtmlTagNode(this, copyState);
    }
}

