/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.AutoValue_ForNode_RangeArgs;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.defn.LocalVar;
import java.util.List;

public final class ForNode
extends AbstractBlockCommandNode
implements SoyNode.StandaloneNode,
SoyNode.StatementNode,
SoyNode.ConditionalBlockNode,
SoyNode.LoopNode,
SoyNode.ExprHolderNode,
SoyNode.LocalVarBlockNode {
    private static final SoyErrorKind RANGE_OUT_OF_RANGE = SoyErrorKind.of("Range specification is too large: {0}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final LocalVar var;
    private final RangeArgs rangeArgs;

    public ForNode(int id, SourceLocation location, ErrorReporter errorReporter, VarRefNode var, List<ExprNode> rangeArgs) {
        super(id, location, "for");
        this.var = new LocalVar(var.getName(), this, null);
        if (rangeArgs.isEmpty()) {
            this.rangeArgs = RangeArgs.error(location);
        } else {
            ExprNode start = rangeArgs.size() >= 2 ? rangeArgs.get(0) : new IntegerNode(0L, location);
            ExprNode limit = rangeArgs.get(rangeArgs.size() == 1 ? 0 : 1);
            ExprNode increment = rangeArgs.size() == 3 ? rangeArgs.get(2) : new IntegerNode(1L, location);
            ForNode.checkValue(start, errorReporter);
            ForNode.checkValue(limit, errorReporter);
            ForNode.checkValue(increment, errorReporter);
            this.rangeArgs = RangeArgs.create(start, limit, increment);
        }
    }

    private ForNode(ForNode orig, CopyState copyState) {
        super(orig, copyState);
        this.var = new LocalVar(orig.var, this);
        this.rangeArgs = orig.rangeArgs.copy(copyState);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.FOR_NODE;
    }

    @Override
    public final LocalVar getVar() {
        return this.var;
    }

    @Override
    public final String getVarName() {
        return this.var.name();
    }

    public RangeArgs getRangeArgs() {
        return this.rangeArgs;
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.rangeArgs.start(), (Object)this.rangeArgs.limit(), (Object)this.rangeArgs.increment());
    }

    @Override
    public String getCommandText() {
        return "$" + this.getVarName() + " in range(" + this.rangeArgs.start().toSourceString() + ", " + this.rangeArgs.limit().toSourceString() + ", " + this.rangeArgs.increment().toSourceString() + ")";
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public ForNode copy(CopyState copyState) {
        return new ForNode(this, copyState);
    }

    private static void checkValue(ExprNode node, ErrorReporter errorReporter) {
        long n;
        if (node instanceof IntegerNode && ((n = ((IntegerNode)node).getValue()) > Integer.MAX_VALUE || n < Integer.MIN_VALUE)) {
            errorReporter.report(node.getSourceLocation(), RANGE_OUT_OF_RANGE, n);
        }
    }

    public static abstract class RangeArgs {
        static RangeArgs create(ExprNode start, ExprNode limit, ExprNode increment) {
            return new AutoValue_ForNode_RangeArgs(new ExprRootNode(start), new ExprRootNode(limit), new ExprRootNode(increment));
        }

        static RangeArgs error(SourceLocation location) {
            VarRefNode error = VarRefNode.error(location);
            return RangeArgs.create(error, error, error);
        }

        public abstract ExprRootNode start();

        public abstract ExprRootNode limit();

        public abstract ExprRootNode increment();

        public final boolean definitelyNotEmpty() {
            if (!(this.start().getRoot() instanceof IntegerNode)) {
                return false;
            }
            long start = ((IntegerNode)this.start().getRoot()).getValue();
            if (!(this.limit().getRoot() instanceof IntegerNode)) {
                return false;
            }
            long limit = ((IntegerNode)this.limit().getRoot()).getValue();
            return start < limit;
        }

        private RangeArgs copy(CopyState copyState) {
            return RangeArgs.create(this.start().getRoot().copy(copyState), this.limit().getRoot().copy(copyState), this.increment().getRoot().copy(copyState));
        }
    }
}

