/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class CallBasicNode
extends CallNode {
    private String fullCalleeName;
    private String sourceCalleeName;
    @Nullable
    private ImmutableList<TemplateParam> paramsToRuntimeTypeCheck = null;

    public CallBasicNode(int id, SourceLocation location, String sourceCalleeName, String fullCalleeName, List<CommandTagAttribute> attributes, ErrorReporter errorReporter) {
        super(id, location, "call", attributes);
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(fullCalleeName));
        this.sourceCalleeName = sourceCalleeName;
        this.fullCalleeName = fullCalleeName;
        block7: for (CommandTagAttribute attr : attributes) {
            String name;
            switch (name = attr.getName().identifier()) {
                case "data": 
                case "phname": {
                    continue block7;
                }
            }
            errorReporter.report(attr.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, name, "call", ImmutableList.of((Object)"data", (Object)"phname"));
        }
    }

    private CallBasicNode(CallBasicNode orig, CopyState copyState) {
        super(orig, copyState);
        this.sourceCalleeName = orig.sourceCalleeName;
        this.fullCalleeName = orig.fullCalleeName;
        this.paramsToRuntimeTypeCheck = orig.paramsToRuntimeTypeCheck;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_BASIC_NODE;
    }

    public String getSourceCalleeName() {
        return this.sourceCalleeName;
    }

    public String getCalleeName() {
        return this.fullCalleeName;
    }

    public void setNewCalleeName(String name) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(name));
        this.sourceCalleeName = name;
        this.fullCalleeName = name;
    }

    public void setParamsToRuntimeCheck(Collection<TemplateParam> paramNames) {
        Preconditions.checkState((this.paramsToRuntimeTypeCheck == null ? 1 : 0) != 0);
        this.paramsToRuntimeTypeCheck = ImmutableList.copyOf(paramNames);
    }

    @Override
    public ImmutableList<TemplateParam> getParamsToRuntimeCheck(TemplateNode callee) {
        return this.paramsToRuntimeTypeCheck == null ? callee.getParams() : this.paramsToRuntimeTypeCheck;
    }

    @Override
    public String getCommandText() {
        StringBuilder commandText = new StringBuilder(this.sourceCalleeName);
        if (this.isPassingAllData()) {
            commandText.append(" data=\"all\"");
        } else if (this.getDataExpr() != null) {
            commandText.append(" data=\"").append(this.getDataExpr().toSourceString()).append('\"');
        }
        if (this.getUserSuppliedPhName() != null) {
            commandText.append(" phname=\"").append(this.getUserSuppliedPhName()).append('\"');
        }
        return commandText.toString();
    }

    @Override
    public CallBasicNode copy(CopyState copyState) {
        return new CallBasicNode(this, copyState);
    }
}

