/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TagName;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.XidNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@VisibleForTesting
public final class HtmlRewritePass
extends CompilerFilePass {
    private static final boolean DEBUG = false;
    private static final SoyErrorKind BLOCK_CHANGES_CONTEXT = SoyErrorKind.of("{0} changes context from ''{1}'' to ''{2}''.{3}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind BLOCK_ENDS_IN_INVALID_STATE = SoyErrorKind.of("''{0}'' block ends in an invalid state ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BLOCK_TRANSITION_DISALLOWED = SoyErrorKind.of("{0} started in ''{1}'', cannot create a {2}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CONDITIONAL_BLOCK_ISNT_GUARANTEED_TO_PRODUCE_ONE_ATTRIBUTE_VALUE = SoyErrorKind.of("Expected exactly one attribute value, the {0} isn''t guaranteed to produce exactly one.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CONTROL_FLOW_IN_HTML_TAG_NAME = SoyErrorKind.of("Invalid location for a ''{0}'' node, html tag names can only be constants or print nodes.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EXPECTED_ATTRIBUTE_NAME = SoyErrorKind.of("Expected an attribute name.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EXPECTED_ATTRIBUTE_VALUE = SoyErrorKind.of("Expected an attribute value.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EXPECTED_TAG_NAME = SoyErrorKind.of("Expected an html tag name.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EXPECTED_WS_EQ_OR_CLOSE_AFTER_ATTRIBUTE_NAME = SoyErrorKind.of("Expected whitespace, ''='' or tag close after an attribute name.  If you are trying to create an attribute from a mix of text and print nodes, try moving it all inside the print node. For example, instead of ''data-'{$foo}''' write '''{'''data-'' + $foo'}'''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EXPECTED_WS_OR_CLOSE_AFTER_TAG_OR_ATTRIBUTE = SoyErrorKind.of("Expected whitespace or tag close after a tag name or attribute. If you are trying to create an attribute or tag name from a mix of text and print nodes, try moving it all inside the print node. For example, instead of ''data-'{$foo}''' write '''{'''data-'' + $foo'}'''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind FOUND_END_OF_ATTRIBUTE_STARTED_IN_ANOTHER_BLOCK = SoyErrorKind.of("Found the end of an html attribute that was started in another block. Html attributes should be opened and closed in the same block.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind FOUND_END_TAG_STARTED_IN_ANOTHER_BLOCK = SoyErrorKind.of("Found the end of a tag that was started in another block. Html tags should be opened and closed in the same block.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind FOUND_EQ_WITH_ATTRIBUTE_IN_ANOTHER_BLOCK = SoyErrorKind.of("Found an ''='' character in a different block than the attribute name.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind HTML_COMMENT_WITHIN_MSG_BLOCK = SoyErrorKind.of("Found HTML comment within ''msg'' block. This is not allowed.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ILLEGAL_HTML_ATTRIBUTE_CHARACTER = SoyErrorKind.of("Illegal unquoted attribute value character.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_TAG_NAME = SoyErrorKind.of("Illegal tag name character.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_ATTRIBUTE_NAME = SoyErrorKind.of("Illegal attribute name character.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_LOCATION_FOR_NONPRINTABLE = SoyErrorKind.of("Invalid location for a non-printable node: {0}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind INVALID_TAG_NAME = SoyErrorKind.of("Tag names may only be raw text or print nodes, consider extracting a '''{'let...'' variable.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SELF_CLOSING_CLOSE_TAG = SoyErrorKind.of("Close tags should not be self closing.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_CLOSE_TAG_CONTENT = SoyErrorKind.of("Unexpected close tag content, only whitespace is allowed in close tags.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_WS_AFTER_LT = SoyErrorKind.of("Unexpected whitespace after ''<'', did you mean ''&lt;''?", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_CLOSE_TAG = SoyErrorKind.of("Unexpected close tag for context-changing tag.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    public HtmlRewritePass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        new Visitor(nodeIdGen, file.getFilePath(), this.errorReporter).exec(file);
        for (HtmlCloseTagNode closeTag : SoyTreeUtils.getAllNodesOfType(file, HtmlCloseTagNode.class)) {
            List children = closeTag.getChildren();
            HtmlAttributeNode phNameAttribute = closeTag.getPhNameNode();
            for (int i = 1; i < children.size(); ++i) {
                SoyNode.StandaloneNode child = (SoyNode.StandaloneNode)children.get(i);
                if (child == phNameAttribute) continue;
                this.errorReporter.report(child.getSourceLocation(), UNEXPECTED_CLOSE_TAG_CONTENT, new Object[0]);
            }
        }
    }

    private static List<? extends SoyNode.MsgBlockNode> collectMsgBranches(MsgFallbackGroupNode node) {
        ArrayList<SoyNode.MsgBlockNode> msgBranches = new ArrayList<SoyNode.MsgBlockNode>();
        for (MsgNode child : node.getChildren()) {
            HtmlRewritePass.collectMsgBranches(child, msgBranches);
        }
        return msgBranches;
    }

    private static void collectMsgBranches(SoyNode.MsgBlockNode parent, List<SoyNode.MsgBlockNode> msgBranches) {
        SoyNode.StandaloneNode firstChild = (SoyNode.StandaloneNode)Iterables.getFirst(parent.getChildren(), null);
        if (firstChild instanceof MsgPluralNode) {
            for (CaseOrDefaultNode caseOrDefault : ((MsgPluralNode)firstChild).getChildren()) {
                HtmlRewritePass.collectMsgBranches((SoyNode.MsgBlockNode)((Object)caseOrDefault), msgBranches);
            }
        } else if (firstChild instanceof MsgSelectNode) {
            for (CaseOrDefaultNode caseOrDefault : ((MsgSelectNode)firstChild).getChildren()) {
                HtmlRewritePass.collectMsgBranches((SoyNode.MsgBlockNode)((Object)caseOrDefault), msgBranches);
            }
        } else {
            msgBranches.add(parent);
        }
    }

    private static final class AbortParsingBlockError
    extends Error {
        private AbortParsingBlockError() {
        }
    }

    private static final class ParsingContext {
        final String blockName;
        final State startingState;
        final String filePath;
        final IdGenerator nodeIdGen;
        final ErrorReporter errorReporter;
        final AstEdits edits;
        State state;
        SourceLocation.Point stateTransitionPoint;
        boolean isCloseTag;
        SourceLocation.Point tagStartPoint;
        RawTextNode tagStartNode;
        TagName tagName;
        State tagStartState;
        final List<SoyNode.StandaloneNode> directTagChildren = new ArrayList<SoyNode.StandaloneNode>();
        SoyNode.StandaloneNode attributeName;
        SourceLocation.Point equalsSignLocation;
        SoyNode.StandaloneNode attributeValue;
        SourceLocation.Point quotedAttributeValueStart;
        final List<SoyNode.StandaloneNode> attributeValueChildren = new ArrayList<SoyNode.StandaloneNode>();

        ParsingContext(String blockName, State startingState, SourceLocation.Point startPoint, String filePath, AstEdits edits, ErrorReporter errorReporter, IdGenerator nodeIdGen) {
            this.blockName = (String)Preconditions.checkNotNull((Object)blockName);
            this.startingState = (State)((Object)Preconditions.checkNotNull((Object)((Object)startingState)));
            this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)startingState)));
            this.stateTransitionPoint = (SourceLocation.Point)Preconditions.checkNotNull((Object)startPoint);
            this.filePath = (String)Preconditions.checkNotNull((Object)filePath);
            this.nodeIdGen = (IdGenerator)Preconditions.checkNotNull((Object)nodeIdGen);
            this.edits = (AstEdits)Preconditions.checkNotNull((Object)edits);
            this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
        }

        void finishBlock() {
            if (this.startingState.isTagState()) {
                this.maybeFinishPendingAttribute(this.stateTransitionPoint);
            }
        }

        void reparentAttributeValueChildren(SoyNode.BlockNode parent) {
            this.edits.addChildren(parent, this.attributeValueChildren);
            this.attributeValueChildren.clear();
        }

        void reparentDirectTagChildren(SoyNode.BlockNode parent) {
            if (this.attributeValue != null) {
                this.edits.addChild(parent, this.attributeValue);
                this.attributeValue = null;
            }
            this.edits.addChildren(parent, this.directTagChildren);
            this.directTagChildren.clear();
        }

        boolean hasUnquotedAttributeValueParts() {
            return this.quotedAttributeValueStart == null && !this.attributeValueChildren.isEmpty();
        }

        boolean hasQuotedAttributeValueParts() {
            return this.quotedAttributeValueStart != null;
        }

        boolean hasTagStart() {
            return this.tagStartNode != null && this.tagStartPoint != null;
        }

        void addTagChild(SoyNode.StandaloneNode node) {
            this.maybeFinishPendingAttribute(node.getSourceLocation().getBeginPoint());
            Preconditions.checkNotNull((Object)node);
            this.directTagChildren.add(node);
            this.edits.remove(node);
            this.setState(State.AFTER_TAG_NAME_OR_ATTRIBUTE, node.getSourceLocation().getEndPoint());
        }

        void checkEmpty(String fmt, Object ... args) {
            StringBuilder error = null;
            if (!this.directTagChildren.isEmpty()) {
                error = ParsingContext.format(error, "Expected directTagChildren to be empty, got: %s", this.directTagChildren);
            }
            if (this.attributeName != null) {
                error = ParsingContext.format(error, "Expected attributeName to be null, got: %s", this.attributeName);
            }
            if (this.equalsSignLocation != null) {
                error = ParsingContext.format(error, "Expected equalsSignLocation to be null, got: %s", this.equalsSignLocation);
            }
            if (this.attributeValue != null) {
                error = ParsingContext.format(error, "Expected attributeValue to be null, got: %s", this.attributeValue);
            }
            if (!this.attributeValueChildren.isEmpty()) {
                error = ParsingContext.format(error, "Expected attributeValueChildren to be empty, got: %s", this.attributeValueChildren);
            }
            if (this.tagStartPoint != null) {
                error = ParsingContext.format(error, "Expected tagStartPoint to be null, got: %s", this.tagStartPoint);
            }
            if (this.tagName != null) {
                error = ParsingContext.format(error, "Expected tagName to be null, got: %s", this.tagName);
            }
            if (this.tagStartNode != null) {
                error = ParsingContext.format(error, "Expected tagStartNode to be null, got: %s", this.tagStartNode);
            }
            if (this.tagStartState != null) {
                error = ParsingContext.format(error, "Expected tagStartState to be null, got: %s", new Object[]{this.tagStartState});
            }
            if (this.quotedAttributeValueStart != null) {
                error = ParsingContext.format(error, "Expected quotedAttributeValueStart to be null, got: %s", this.quotedAttributeValueStart);
            }
            if (this.tagName != null) {
                error = ParsingContext.format(error, "Expected tagName to be null, got: %s", this.tagName);
            }
            if (error != null) {
                throw new IllegalStateException(String.format(fmt + "\n", args) + error);
            }
        }

        private static StringBuilder format(StringBuilder error, String fmt, Object ... args) {
            if (error == null) {
                error = new StringBuilder();
            }
            error.append(String.format(fmt, args));
            error.append('\n');
            return error;
        }

        void reset() {
            this.tagStartPoint = null;
            this.tagStartNode = null;
            this.tagName = null;
            this.tagStartState = null;
            this.directTagChildren.clear();
            this.resetAttribute();
        }

        void resetAttribute() {
            this.attributeName = null;
            this.equalsSignLocation = null;
            this.attributeValue = null;
            this.quotedAttributeValueStart = null;
            this.attributeValueChildren.clear();
        }

        void startTag(RawTextNode tagStartNode, boolean isCloseTag, SourceLocation.Point point) {
            Preconditions.checkState((this.tagStartPoint == null ? 1 : 0) != 0);
            Preconditions.checkState((this.tagStartNode == null ? 1 : 0) != 0);
            Preconditions.checkState((this.tagStartState == null ? 1 : 0) != 0);
            Preconditions.checkState((boolean)this.directTagChildren.isEmpty());
            if (this.startingState != State.PCDATA) {
                this.errorReporter.report(point.asLocation(this.filePath), BLOCK_TRANSITION_DISALLOWED, new Object[]{this.blockName, this.startingState, "tag"});
                throw new AbortParsingBlockError();
            }
            this.tagStartState = this.state;
            this.tagStartPoint = (SourceLocation.Point)Preconditions.checkNotNull((Object)point);
            this.tagStartNode = (RawTextNode)Preconditions.checkNotNull((Object)tagStartNode);
            this.isCloseTag = isCloseTag;
        }

        SourceLocation tagStartLocation() {
            return this.tagStartPoint.asLocation(this.filePath);
        }

        void setTagName(TagName tagName) {
            this.tagName = (TagName)Preconditions.checkNotNull((Object)tagName);
            this.edits.remove(tagName.getNode());
            this.setState(State.AFTER_TAG_NAME_OR_ATTRIBUTE, tagName.getTagLocation().getEndPoint());
        }

        void startAttribute(SoyNode.StandaloneNode attrName) {
            this.maybeFinishPendingAttribute(attrName.getSourceLocation().getBeginPoint());
            Preconditions.checkNotNull((Object)attrName);
            Preconditions.checkState((this.attributeName == null ? 1 : 0) != 0);
            if (this.startingState == State.BEFORE_ATTRIBUTE_VALUE) {
                this.errorReporter.report(attrName.getSourceLocation(), BLOCK_TRANSITION_DISALLOWED, new Object[]{this.blockName, this.startingState, "attribute"});
                throw new AbortParsingBlockError();
            }
            this.edits.remove(attrName);
            this.attributeName = attrName;
            this.setState(State.AFTER_ATTRIBUTE_NAME, attrName.getSourceLocation().getEndPoint());
        }

        void setEqualsSignLocation(SourceLocation.Point equalsSignPoint, SourceLocation.Point stateTransitionPoint) {
            Preconditions.checkNotNull((Object)equalsSignPoint);
            if (this.attributeName == null) {
                this.errorReporter.report(stateTransitionPoint.asLocation(this.filePath), FOUND_EQ_WITH_ATTRIBUTE_IN_ANOTHER_BLOCK, new Object[0]);
                throw new AbortParsingBlockError();
            }
            Preconditions.checkState((this.equalsSignLocation == null ? 1 : 0) != 0);
            this.equalsSignLocation = equalsSignPoint;
            this.setState(State.BEFORE_ATTRIBUTE_VALUE, stateTransitionPoint);
        }

        void setAttributeValue(SoyNode.StandaloneNode node) {
            Preconditions.checkNotNull((Object)node);
            Preconditions.checkState((this.attributeValue == null ? 1 : 0) != 0, (String)"attribute value already set at: %s", (Object)node.getSourceLocation());
            this.edits.remove(node);
            this.attributeValue = node;
            this.setState(State.AFTER_TAG_NAME_OR_ATTRIBUTE, node.getSourceLocation().getEndPoint());
        }

        void startQuotedAttributeValue(RawTextNode node, SourceLocation.Point point, State nextState) {
            Preconditions.checkState((!this.hasQuotedAttributeValueParts() ? 1 : 0) != 0);
            Preconditions.checkState((!this.hasUnquotedAttributeValueParts() ? 1 : 0) != 0);
            this.edits.remove(node);
            this.quotedAttributeValueStart = (SourceLocation.Point)Preconditions.checkNotNull((Object)point);
            this.setState(nextState, point);
        }

        void addAttributeValuePart(SoyNode.StandaloneNode node) {
            this.attributeValueChildren.add(node);
            this.edits.remove(node);
        }

        void createUnquotedAttributeValue(SourceLocation.Point endPoint) {
            if (!this.hasUnquotedAttributeValueParts()) {
                if (this.attributeName == null) {
                    this.errorReporter.report(endPoint.asLocation(this.filePath), FOUND_END_OF_ATTRIBUTE_STARTED_IN_ANOTHER_BLOCK, new Object[0]);
                    throw new AbortParsingBlockError();
                }
                this.errorReporter.report(endPoint.asLocation(this.filePath), EXPECTED_ATTRIBUTE_VALUE, new Object[0]);
                this.resetAttribute();
                this.setState(State.AFTER_TAG_NAME_OR_ATTRIBUTE, endPoint);
                return;
            }
            HtmlAttributeValueNode valueNode = new HtmlAttributeValueNode(this.nodeIdGen.genId(), ParsingContext.getLocationOf(this.attributeValueChildren), HtmlAttributeValueNode.Quotes.NONE);
            this.edits.addChildren(valueNode, this.attributeValueChildren);
            this.attributeValueChildren.clear();
            this.setAttributeValue(valueNode);
        }

        void createQuotedAttributeValue(RawTextNode end, boolean doubleQuoted, SourceLocation.Point endPoint) {
            HtmlAttributeValueNode valueNode = new HtmlAttributeValueNode(this.nodeIdGen.genId(), new SourceLocation(this.filePath, this.quotedAttributeValueStart, endPoint), doubleQuoted ? HtmlAttributeValueNode.Quotes.DOUBLE : HtmlAttributeValueNode.Quotes.SINGLE);
            this.edits.remove(end);
            this.edits.addChildren(valueNode, this.attributeValueChildren);
            this.attributeValueChildren.clear();
            this.quotedAttributeValueStart = null;
            this.setAttributeValue(valueNode);
        }

        State createTag(RawTextNode tagEndNode, boolean selfClosing, SourceLocation.Point endPoint) {
            HtmlTagNode replacement;
            this.maybeFinishPendingAttribute(endPoint);
            SourceLocation sourceLocation = new SourceLocation(this.filePath, this.tagStartPoint, endPoint);
            if (this.isCloseTag) {
                if (selfClosing) {
                    this.errorReporter.report(endPoint.asLocation(this.filePath).offsetStartCol(-1), SELF_CLOSING_CLOSE_TAG, new Object[0]);
                }
                replacement = new HtmlCloseTagNode(this.nodeIdGen.genId(), this.tagName, sourceLocation);
            } else {
                replacement = new HtmlOpenTagNode(this.nodeIdGen.genId(), this.tagName, sourceLocation, selfClosing);
            }
            State nextState = ParsingContext.getNextState(this.tagName);
            if (this.isCloseTag && nextState.isRcDataState() && this.tagStartState != nextState) {
                this.errorReporter.report(this.tagStartLocation(), UNEXPECTED_CLOSE_TAG, new Object[0]);
            }
            if (selfClosing || this.isCloseTag) {
                nextState = State.PCDATA;
            }
            this.edits.remove(tagEndNode);
            this.edits.addChild(replacement, this.tagName.getNode());
            this.edits.addChildren(replacement, this.directTagChildren);
            this.edits.replace((SoyNode.StandaloneNode)this.tagStartNode, replacement);
            this.directTagChildren.clear();
            this.tagStartPoint = null;
            this.tagName = null;
            this.tagStartState = null;
            this.tagStartNode = null;
            this.checkEmpty("Expected state to be empty after completing a tag", new Object[0]);
            return nextState;
        }

        private static State getNextState(TagName tagName) {
            if (tagName.getRcDataTagName() == null) {
                return State.PCDATA;
            }
            switch (tagName.getRcDataTagName()) {
                case SCRIPT: {
                    return State.RCDATA_SCRIPT;
                }
                case STYLE: {
                    return State.RCDATA_STYLE;
                }
                case TEXTAREA: {
                    return State.RCDATA_TEXTAREA;
                }
                case TITLE: {
                    return State.RCDATA_TITLE;
                }
                case XMP: {
                    return State.RCDATA_XMP;
                }
            }
            throw new AssertionError((Object)tagName.getRcDataTagName());
        }

        void maybeFinishPendingAttribute(SourceLocation.Point currentPoint) {
            if (this.hasUnquotedAttributeValueParts()) {
                this.createUnquotedAttributeValue(currentPoint);
            } else if (this.hasQuotedAttributeValueParts()) {
                this.errorReporter.report(currentPoint.asLocation(this.filePath), FOUND_END_OF_ATTRIBUTE_STARTED_IN_ANOTHER_BLOCK, new Object[0]);
                throw new AbortParsingBlockError();
            }
            if (this.attributeName != null) {
                HtmlAttributeNode attribute;
                SourceLocation location = this.attributeName.getSourceLocation();
                if (this.attributeValue != null) {
                    attribute = new HtmlAttributeNode(this.nodeIdGen.genId(), location, (SourceLocation.Point)Preconditions.checkNotNull((Object)this.equalsSignLocation));
                    location = location.extend(this.attributeValue.getSourceLocation());
                    this.edits.addChild(attribute, this.attributeName);
                    this.edits.addChild(attribute, this.attributeValue);
                } else {
                    attribute = new HtmlAttributeNode(this.nodeIdGen.genId(), location, null);
                    this.edits.addChild(attribute, this.attributeName);
                }
                this.attributeName = null;
                this.equalsSignLocation = null;
                this.attributeValue = null;
                this.directTagChildren.add(attribute);
                this.edits.remove(attribute);
            }
        }

        State setState(State s, SourceLocation.Point point) {
            State old = this.state;
            this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)s)));
            this.stateTransitionPoint = (SourceLocation.Point)Preconditions.checkNotNull((Object)point);
            return old;
        }

        State getState() {
            Preconditions.checkState((this.state != null ? 1 : 0) != 0);
            return this.state;
        }

        SourceLocation.Point getStateTransitionPoint() {
            Preconditions.checkState((this.stateTransitionPoint != null ? 1 : 0) != 0);
            return this.stateTransitionPoint;
        }

        static SourceLocation getLocationOf(List<SoyNode.StandaloneNode> nodes) {
            SourceLocation location = nodes.get(0).getSourceLocation();
            if (nodes.size() > 1) {
                location = location.extend(((SoyNode.StandaloneNode)Iterables.getLast(nodes)).getSourceLocation());
            }
            return location;
        }
    }

    private static final class AstEdits {
        final Set<SoyNode.StandaloneNode> toRemove = new LinkedHashSet<SoyNode.StandaloneNode>();
        final ListMultimap<SoyNode.StandaloneNode, SoyNode.StandaloneNode> replacements = MultimapBuilder.linkedHashKeys().arrayListValues().build();
        final ListMultimap<SoyNode.ParentSoyNode<SoyNode.StandaloneNode>, SoyNode.StandaloneNode> newChildren = MultimapBuilder.linkedHashKeys().arrayListValues().build();

        private AstEdits() {
        }

        void apply() {
            for (SoyNode.StandaloneNode standaloneNode : this.toRemove) {
                SoyNode.ParentSoyNode<SoyNode.StandaloneNode> parent = standaloneNode.getParent();
                int index = parent.getChildIndex(standaloneNode);
                parent.removeChild(index);
                List children = this.replacements.get((Object)standaloneNode);
                if (children.isEmpty()) continue;
                parent.addChildren(index, children);
            }
            for (Map.Entry entry : Multimaps.asMap(this.newChildren).entrySet()) {
                ((SoyNode.ParentSoyNode)entry.getKey()).addChildren((List)entry.getValue());
            }
            this.clear();
        }

        void remove(SoyNode.StandaloneNode node) {
            Preconditions.checkNotNull((Object)node);
            if (node.getParent() != null) {
                this.toRemove.add(node);
            }
        }

        void addChildren(SoyNode.ParentSoyNode<SoyNode.StandaloneNode> parent, Iterable<SoyNode.StandaloneNode> children) {
            Preconditions.checkNotNull(parent);
            this.newChildren.putAll(parent, children);
        }

        void addChild(SoyNode.ParentSoyNode<SoyNode.StandaloneNode> parent, SoyNode.StandaloneNode child) {
            Preconditions.checkNotNull(parent);
            Preconditions.checkNotNull((Object)child);
            this.newChildren.put(parent, (Object)child);
        }

        void replace(SoyNode.StandaloneNode oldNode, Iterable<SoyNode.StandaloneNode> newNodes) {
            Preconditions.checkState((oldNode.getParent() != null ? 1 : 0) != 0, (Object)"oldNode must be in the tree in order to replace it");
            this.remove(oldNode);
            this.replacements.putAll((Object)oldNode, newNodes);
        }

        void replace(SoyNode.StandaloneNode oldNode, SoyNode.StandaloneNode newNode) {
            this.replace(oldNode, (Iterable<SoyNode.StandaloneNode>)ImmutableList.of((Object)newNode));
        }

        void clear() {
            this.toRemove.clear();
            this.replacements.clear();
            this.newChildren.clear();
        }
    }

    private static final class Visitor
    extends AbstractSoyNodeVisitor<Void> {
        static final Pattern TAG_NAME = Pattern.compile("[a-z][a-z0-9:-]*", 2);
        static final Pattern ATTRIBUTE_NAME = Pattern.compile("[a-z_$](?:[a-z0-9_:?$\\\\-]*[a-z0-9?$_])?", 2);
        static final CharMatcher TAG_DELIMITER_MATCHER = CharMatcher.whitespace().or(CharMatcher.anyOf((CharSequence)">=/")).or(new CharMatcher(){

            public boolean matches(char c) {
                return Character.getType(c) == 15;
            }
        }).negate().precomputed();
        static final CharMatcher UNQUOTED_ATTRIBUTE_VALUE_MATCHER = CharMatcher.whitespace().or(CharMatcher.anyOf((CharSequence)"<>='\"`")).negate().precomputed();
        static final CharMatcher UNQUOTED_ATTRIBUTE_VALUE_DELIMITER = CharMatcher.whitespace().or(CharMatcher.is((char)'>')).precomputed();
        static final CharMatcher NOT_DOUBLE_QUOTE = CharMatcher.isNot((char)'\"').precomputed();
        static final CharMatcher NOT_SINGLE_QUOTE = CharMatcher.isNot((char)'\'').precomputed();
        static final CharMatcher NOT_LT = CharMatcher.isNot((char)'<').precomputed();
        static final CharMatcher NOT_RSQUARE_BRACE = CharMatcher.isNot((char)']').precomputed();
        static final CharMatcher NOT_HYPHEN = CharMatcher.isNot((char)'-').precomputed();
        static final CharMatcher XML_DECLARATION_NON_DELIMITERS = CharMatcher.noneOf((CharSequence)">\"'").precomputed();
        final IdGenerator nodeIdGen;
        final String filePath;
        final AstEdits edits = new AstEdits();
        final ErrorReporter errorReporter;
        private AutoescapeMode autoescapeMode;
        RawTextNode currentRawTextNode;
        String currentRawText;
        int currentRawTextOffset;
        int currentRawTextIndex;
        ParsingContext context;
        boolean inMsgNode;

        Visitor(IdGenerator nodeIdGen, String filePath, ErrorReporter errorReporter) {
            this.nodeIdGen = nodeIdGen;
            this.filePath = filePath;
            this.errorReporter = errorReporter;
        }

        @Override
        protected void visitRawTextNode(RawTextNode node) {
            this.currentRawTextNode = node;
            this.currentRawText = node.getRawText();
            this.currentRawTextOffset = 0;
            this.currentRawTextIndex = 0;
            int prevStartIndex = -1;
            while (this.currentRawTextIndex < this.currentRawText.length()) {
                int startIndex = this.currentRawTextIndex;
                if (startIndex != prevStartIndex && this.currentRawTextNode.missingWhitespaceAt(startIndex)) {
                    this.handleJoinedWhitespace(this.currentPoint());
                }
                prevStartIndex = startIndex;
                State startState = this.context.getState();
                switch (startState) {
                    case NONE: {
                        this.currentRawTextIndex = this.currentRawTextOffset = this.currentRawText.length();
                        break;
                    }
                    case PCDATA: {
                        this.handlePcData();
                        break;
                    }
                    case DOUBLE_QUOTED_ATTRIBUTE_VALUE: {
                        this.handleQuotedAttributeValue(true);
                        break;
                    }
                    case SINGLE_QUOTED_ATTRIBUTE_VALUE: {
                        this.handleQuotedAttributeValue(false);
                        break;
                    }
                    case BEFORE_ATTRIBUTE_VALUE: {
                        this.handleBeforeAttributeValue();
                        break;
                    }
                    case AFTER_TAG_NAME_OR_ATTRIBUTE: {
                        this.handleAfterTagNameOrAttribute();
                        break;
                    }
                    case BEFORE_ATTRIBUTE_NAME: {
                        this.handleBeforeAttributeName();
                        break;
                    }
                    case UNQUOTED_ATTRIBUTE_VALUE: {
                        this.handleUnquotedAttributeValue();
                        break;
                    }
                    case AFTER_ATTRIBUTE_NAME: {
                        this.handleAfterAttributeName();
                        break;
                    }
                    case HTML_TAG_NAME: {
                        this.handleHtmlTagName();
                        break;
                    }
                    case RCDATA_STYLE: {
                        this.handleRcData(TagName.RcDataTagName.STYLE);
                        break;
                    }
                    case RCDATA_TITLE: {
                        this.handleRcData(TagName.RcDataTagName.TITLE);
                        break;
                    }
                    case RCDATA_XMP: {
                        this.handleRcData(TagName.RcDataTagName.XMP);
                        break;
                    }
                    case RCDATA_SCRIPT: {
                        this.handleRcData(TagName.RcDataTagName.SCRIPT);
                        break;
                    }
                    case RCDATA_TEXTAREA: {
                        this.handleRcData(TagName.RcDataTagName.TEXTAREA);
                        break;
                    }
                    case CDATA: {
                        this.handleCData();
                        break;
                    }
                    case HTML_COMMENT: {
                        this.handleHtmlComment();
                        break;
                    }
                    case XML_DECLARATION: {
                        this.handleXmlDeclaration();
                        break;
                    }
                    case DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE: {
                        this.handleXmlAttributeQuoted(true);
                        break;
                    }
                    case SINGLE_QUOTED_XML_ATTRIBUTE_VALUE: {
                        this.handleXmlAttributeQuoted(false);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("cant yet handle: " + (Object)((Object)startState));
                    }
                }
                if (this.context.getState() == startState && startIndex == this.currentRawTextIndex) {
                    throw new IllegalStateException("failed to make progress in state: " + startState.name() + " at " + this.currentLocation());
                }
                if (this.currentRawTextOffset <= this.currentRawTextIndex) continue;
                throw new IllegalStateException("offset is greater than index! offset: " + this.currentRawTextOffset + " index: " + this.currentRawTextIndex);
            }
            if (this.currentRawTextIndex != this.currentRawText.length()) {
                throw new AssertionError((Object)"failed to visit all of the raw text");
            }
            if (this.currentRawTextOffset < this.currentRawTextIndex && this.currentRawTextOffset != 0) {
                RawTextNode suffix = this.consumeAsRawText();
                this.edits.replace((SoyNode.StandaloneNode)node, suffix);
            }
            if (this.currentRawTextNode.missingWhitespaceAt(this.currentRawText.length())) {
                this.handleJoinedWhitespace(this.currentRawTextNode.getSourceLocation().getEndPoint());
            }
        }

        void handleJoinedWhitespace(SourceLocation.Point point) {
            switch (this.context.getState()) {
                case UNQUOTED_ATTRIBUTE_VALUE: {
                    this.context.createUnquotedAttributeValue(point);
                }
                case AFTER_TAG_NAME_OR_ATTRIBUTE: {
                    this.context.setState(State.BEFORE_ATTRIBUTE_NAME, point);
                    return;
                }
                case AFTER_ATTRIBUTE_NAME: {
                    int currentChar = this.currentChar();
                    if (currentChar == -1 || !CharMatcher.whitespace().matches((char)currentChar) && '=' != (char)currentChar) {
                        this.context.setState(State.BEFORE_ATTRIBUTE_NAME, point);
                        return;
                    }
                }
                case NONE: 
                case PCDATA: 
                case RCDATA_STYLE: 
                case RCDATA_TITLE: 
                case RCDATA_XMP: 
                case RCDATA_SCRIPT: 
                case RCDATA_TEXTAREA: 
                case DOUBLE_QUOTED_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_ATTRIBUTE_VALUE: 
                case BEFORE_ATTRIBUTE_VALUE: 
                case HTML_COMMENT: 
                case HTML_TAG_NAME: 
                case XML_DECLARATION: 
                case CDATA: 
                case DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_XML_ATTRIBUTE_VALUE: 
                case BEFORE_ATTRIBUTE_NAME: {
                    return;
                }
            }
            throw new AssertionError();
        }

        void handleRcData(TagName.RcDataTagName tagName) {
            boolean foundLt = this.advanceWhileMatches(NOT_LT);
            if (foundLt) {
                if (this.matchPrefixIgnoreCase("</" + (Object)((Object)tagName), false)) {
                    this.handlePcData();
                } else {
                    this.advance();
                }
            }
        }

        void handleCData() {
            boolean foundBrace = this.advanceWhileMatches(NOT_RSQUARE_BRACE);
            if (foundBrace) {
                if (this.matchPrefix("]]>", true)) {
                    this.context.setState(State.PCDATA, this.currentPointOrEnd());
                } else {
                    this.advance();
                }
            }
        }

        void handleHtmlComment() {
            boolean foundHyphen = this.advanceWhileMatches(NOT_HYPHEN);
            if (foundHyphen) {
                if (this.matchPrefix("-->", true)) {
                    this.context.setState(State.PCDATA, this.currentPointOrEnd());
                } else {
                    this.advance();
                }
            }
        }

        void handleXmlDeclaration() {
            boolean foundDelimiter = this.advanceWhileMatches(XML_DECLARATION_NON_DELIMITERS);
            if (foundDelimiter) {
                int c = this.currentChar();
                SourceLocation.Point currentPoint = this.currentPoint();
                this.advance();
                if (c == 34) {
                    this.context.setState(State.DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE, currentPoint);
                } else if (c == 39) {
                    this.context.setState(State.SINGLE_QUOTED_XML_ATTRIBUTE_VALUE, currentPoint);
                } else if (c == 62) {
                    this.context.setState(State.PCDATA, currentPoint);
                } else {
                    throw new AssertionError((Object)("unexpected character: " + c));
                }
            }
        }

        void handleXmlAttributeQuoted(boolean doubleQuoted) {
            boolean foundQuote = this.advanceWhileMatches(doubleQuoted ? NOT_DOUBLE_QUOTE : NOT_SINGLE_QUOTE);
            if (foundQuote) {
                this.advance();
                this.context.setState(State.XML_DECLARATION, this.currentPoint());
            }
        }

        void handlePcData() {
            boolean foundLt = this.advanceWhileMatches(NOT_LT);
            RawTextNode node = this.consumeAsRawText();
            if (node != null) {
                this.edits.replace((SoyNode.StandaloneNode)this.currentRawTextNode, node);
            }
            if (foundLt) {
                SourceLocation.Point ltPoint = this.currentPoint();
                if (this.matchPrefix("<!--", true)) {
                    if (this.inMsgNode) {
                        this.errorReporter.report(ltPoint.asLocation(this.filePath).offsetEndCol(4), HTML_COMMENT_WITHIN_MSG_BLOCK, new Object[0]);
                    }
                    this.context.setState(State.HTML_COMMENT, ltPoint);
                } else if (this.matchPrefixIgnoreCase("<![cdata", true)) {
                    this.context.setState(State.CDATA, ltPoint);
                } else if (this.matchPrefix("<!", true) || this.matchPrefix("<?", true)) {
                    this.context.setState(State.XML_DECLARATION, ltPoint);
                } else {
                    boolean isCloseTag = this.matchPrefix("</", false);
                    this.context.startTag(this.currentRawTextNode, isCloseTag, this.currentPoint());
                    this.advance();
                    if (isCloseTag) {
                        this.advance();
                    }
                    this.consume();
                    this.context.setState(State.HTML_TAG_NAME, ltPoint);
                }
            }
        }

        void handleHtmlTagName() {
            if (this.consumeWhitespace()) {
                this.errorReporter.report(this.context.tagStartLocation(), UNEXPECTED_WS_AFTER_LT, new Object[0]);
                this.context.reset();
                this.context.setState(State.PCDATA, this.currentPointOrEnd());
                return;
            }
            RawTextNode node = this.consumeHtmlIdentifier(EXPECTED_TAG_NAME);
            if (node == null) {
                this.context.setTagName(new TagName(new RawTextNode(this.nodeIdGen.genId(), "$parse-error$", this.currentLocation())));
            } else {
                this.validateIdentifier(node, TAG_NAME, BAD_TAG_NAME);
                this.context.setTagName(new TagName(node));
            }
        }

        void handleAfterTagNameOrAttribute() {
            if (this.consumeWhitespace()) {
                this.context.setState(State.BEFORE_ATTRIBUTE_NAME, this.currentPointOrEnd());
                return;
            }
            if (!this.tryCreateTagEnd()) {
                this.errorReporter.report(this.currentLocation(), EXPECTED_WS_OR_CLOSE_AFTER_TAG_OR_ATTRIBUTE, new Object[0]);
                this.context.setState(State.BEFORE_ATTRIBUTE_NAME, this.currentPoint());
                this.advance();
            }
        }

        void handleBeforeAttributeName() {
            if (this.tryCreateTagEnd()) {
                return;
            }
            if (this.consumeWhitespace()) {
                return;
            }
            RawTextNode identifier = this.consumeHtmlIdentifier(EXPECTED_ATTRIBUTE_NAME);
            if (identifier == null) {
                this.context.resetAttribute();
                return;
            }
            this.validateIdentifier(identifier, ATTRIBUTE_NAME, BAD_ATTRIBUTE_NAME);
            this.context.startAttribute(identifier);
        }

        private void validateIdentifier(RawTextNode identifier, Pattern validator, SoyErrorKind badIdentifierError) {
            Matcher matcher = validator.matcher(identifier.getRawText());
            if (!matcher.matches()) {
                matcher.reset();
                int startErrorIndex = 0;
                int endErrorIndex = identifier.getRawText().length();
                if (matcher.find()) {
                    if (matcher.start() > 0) {
                        endErrorIndex = matcher.start();
                    } else {
                        startErrorIndex = matcher.end();
                    }
                }
                this.errorReporter.report(identifier.substringLocation(startErrorIndex, endErrorIndex), badIdentifierError, new Object[0]);
            }
        }

        void handleAfterAttributeName() {
            boolean ws = this.consumeWhitespace();
            int current = this.currentChar();
            if (current == 61) {
                SourceLocation.Point equalsSignPoint = this.currentPoint();
                this.advance();
                this.consume();
                this.consumeWhitespace();
                this.context.setEqualsSignLocation(equalsSignPoint, this.currentPointOrEnd());
            } else {
                this.context.setState(ws ? State.BEFORE_ATTRIBUTE_NAME : State.AFTER_TAG_NAME_OR_ATTRIBUTE, this.currentPointOrEnd());
            }
        }

        void handleBeforeAttributeValue() {
            boolean ws = this.consumeWhitespace();
            if (ws) {
                return;
            }
            int c = this.currentChar();
            if (c == 39 || c == 34) {
                SourceLocation.Point quotePoint = this.currentPoint();
                this.context.startQuotedAttributeValue(this.currentRawTextNode, quotePoint, c == 34 ? State.DOUBLE_QUOTED_ATTRIBUTE_VALUE : State.SINGLE_QUOTED_ATTRIBUTE_VALUE);
                this.advance();
                this.consume();
            } else {
                this.context.setState(State.UNQUOTED_ATTRIBUTE_VALUE, this.currentPoint());
            }
        }

        void handleUnquotedAttributeValue() {
            boolean foundDelimiter = this.advanceWhileMatches(UNQUOTED_ATTRIBUTE_VALUE_MATCHER);
            RawTextNode node = this.consumeAsRawText();
            if (node != null) {
                this.context.addAttributeValuePart(node);
            }
            if (foundDelimiter) {
                this.context.createUnquotedAttributeValue(this.currentPoint());
                char c = (char)this.currentChar();
                if (!UNQUOTED_ATTRIBUTE_VALUE_DELIMITER.matches(c)) {
                    this.errorReporter.report(this.currentLocation(), ILLEGAL_HTML_ATTRIBUTE_CHARACTER, new Object[0]);
                    this.advance();
                    this.consume();
                }
            }
        }

        void handleQuotedAttributeValue(boolean doubleQuoted) {
            boolean hasQuote = this.advanceWhileMatches(doubleQuoted ? NOT_DOUBLE_QUOTE : NOT_SINGLE_QUOTE);
            RawTextNode data = this.consumeAsRawText();
            if (data != null) {
                this.context.addAttributeValuePart(data);
            }
            if (hasQuote) {
                if (!this.context.hasQuotedAttributeValueParts()) {
                    this.errorReporter.report(this.currentLocation(), FOUND_END_OF_ATTRIBUTE_STARTED_IN_ANOTHER_BLOCK, new Object[0]);
                    throw new AbortParsingBlockError();
                }
                this.context.createQuotedAttributeValue(this.currentRawTextNode, doubleQuoted, this.currentPoint());
                this.advance();
                this.consume();
            }
        }

        boolean tryCreateTagEnd() {
            int c = this.currentChar();
            if (c == 62) {
                if (!this.context.hasTagStart()) {
                    this.errorReporter.report(this.currentLocation(), FOUND_END_TAG_STARTED_IN_ANOTHER_BLOCK, new Object[0]);
                    throw new AbortParsingBlockError();
                }
                SourceLocation.Point point = this.currentPoint();
                this.context.setState(this.context.createTag(this.currentRawTextNode, false, point), point);
                this.advance();
                this.consume();
                return true;
            }
            if (this.matchPrefix("/>", false)) {
                this.advance();
                if (!this.context.hasTagStart()) {
                    this.errorReporter.report(this.currentLocation(), FOUND_END_TAG_STARTED_IN_ANOTHER_BLOCK, new Object[0]);
                    throw new AbortParsingBlockError();
                }
                SourceLocation.Point point = this.currentPoint();
                this.context.setState(this.context.createTag(this.currentRawTextNode, true, point), point);
                this.advance();
                this.consume();
                return true;
            }
            return false;
        }

        boolean advanceWhileMatches(CharMatcher c) {
            int next = this.currentChar();
            while (next != -1 && c.matches((char)next)) {
                this.advance();
                next = this.currentChar();
            }
            return next != -1;
        }

        boolean consumeWhitespace() {
            int startIndex = this.currentRawTextIndex;
            this.advanceWhileMatches(CharMatcher.whitespace());
            this.consume();
            this.edits.remove(this.currentRawTextNode);
            return this.currentRawTextIndex != startIndex;
        }

        @Nullable
        RawTextNode consumeHtmlIdentifier(SoyErrorKind errorForMissingIdentifier) {
            this.advanceWhileMatches(TAG_DELIMITER_MATCHER);
            RawTextNode node = this.consumeAsRawText();
            if (node == null) {
                this.errorReporter.report(this.currentLocation(), errorForMissingIdentifier, new Object[0]);
            }
            return node;
        }

        @Nullable
        RawTextNode consumeAsRawText() {
            if (this.currentRawTextIndex == this.currentRawTextOffset) {
                return null;
            }
            this.edits.remove(this.currentRawTextNode);
            RawTextNode node = this.currentRawTextNode.substring(this.nodeIdGen.genId(), this.currentRawTextOffset, this.currentRawTextIndex);
            this.consume();
            return node;
        }

        SourceLocation currentLocation() {
            return this.currentRawTextNode.substringLocation(this.currentRawTextIndex, this.currentRawTextIndex + 1);
        }

        SourceLocation.Point currentPoint() {
            return this.currentRawTextNode.locationOf(this.currentRawTextIndex);
        }

        SourceLocation.Point currentPointOrEnd() {
            if (this.currentRawText.length() > this.currentRawTextIndex) {
                return this.currentPoint();
            }
            return this.currentRawTextNode.getSourceLocation().getEndPoint();
        }

        int currentChar() {
            if (this.currentRawTextIndex < this.currentRawText.length()) {
                return this.currentRawText.charAt(this.currentRawTextIndex);
            }
            return -1;
        }

        void advance(int n) {
            Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
            for (int i = 0; i < n; ++i) {
                this.advance();
            }
        }

        void advance() {
            if (this.currentRawTextIndex >= this.currentRawText.length()) {
                throw new AssertionError((Object)"already advanced to the end, shouldn't advance any more");
            }
            ++this.currentRawTextIndex;
        }

        void consume() {
            this.currentRawTextOffset = this.currentRawTextIndex;
        }

        boolean matchPrefix(String prefix, boolean advance) {
            if (this.currentRawText.startsWith(prefix, this.currentRawTextIndex)) {
                if (advance) {
                    this.advance(prefix.length());
                }
                return true;
            }
            return false;
        }

        boolean matchPrefixIgnoreCase(String s, boolean advance) {
            if (this.currentRawTextIndex + s.length() <= this.currentRawText.length()) {
                for (int i = 0; i < s.length(); ++i) {
                    char c2;
                    char c1 = s.charAt(i);
                    if (c1 == (c2 = this.currentRawText.charAt(i + this.currentRawTextIndex)) || Ascii.toLowerCase((char)c1) == Ascii.toLowerCase((char)c2)) continue;
                    return false;
                }
                if (advance) {
                    this.advance(s.length());
                }
                return true;
            }
            return false;
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            this.edits.clear();
            this.context = null;
            this.autoescapeMode = node.getAutoescapeMode();
            ErrorReporter.Checkpoint checkPoint = this.errorReporter.checkpoint();
            this.visitScopedBlock(node.getContentKind(), node, "template");
            if (!this.errorReporter.errorsSince(checkPoint)) {
                this.edits.apply();
            }
            this.autoescapeMode = null;
        }

        @Override
        protected void visitLetValueNode(LetValueNode node) {
            this.processNonPrintableNode(node);
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            this.visitScopedBlock(node.getContentKind(), node, "let");
            this.processNonPrintableNode(node);
        }

        @Override
        protected void visitDebuggerNode(DebuggerNode node) {
            this.processNonPrintableNode(node);
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            this.visitScopedBlock(node.getContentKind(), node, "param");
        }

        @Override
        protected void visitCallParamValueNode(CallParamValueNode node) {
        }

        @Override
        protected void visitCallNode(CallNode node) {
            boolean oldInMsgNode = this.inMsgNode;
            this.inMsgNode = false;
            this.visitChildren(node);
            this.inMsgNode = oldInMsgNode;
            this.processPrintableNode(node);
            if (this.context.getState() == State.PCDATA) {
                node.setIsPcData(true);
            }
        }

        @Override
        protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
            this.visitControlFlowStructure(node, HtmlRewritePass.collectMsgBranches(node), "msg", (Function<? super SoyNode.BlockNode, String>)new Function<SoyNode.BlockNode, String>(){

                public String apply(SoyNode.BlockNode input) {
                    switch (input.getKind()) {
                        case MSG_FALLBACK_GROUP_NODE: {
                            return "fallbackmsg";
                        }
                        case MSG_NODE: {
                            return "msg";
                        }
                        case MSG_PLURAL_CASE_NODE: 
                        case MSG_SELECT_CASE_NODE: {
                            return "case block";
                        }
                        case MSG_PLURAL_DEFAULT_NODE: 
                        case MSG_SELECT_DEFAULT_NODE: {
                            return "default block";
                        }
                    }
                    throw new AssertionError((Object)("unexepected node: " + input));
                }
            }, true, true);
        }

        @Override
        protected void visitForNode(ForNode node) {
            this.visitControlFlowStructure(node, (List<? extends SoyNode.BlockNode>)ImmutableList.of((Object)node), "for loop", (Function<? super SoyNode.BlockNode, String>)Functions.constant((Object)"loop body"), false, false);
        }

        @Override
        protected void visitForeachNode(ForeachNode node) {
            this.visitControlFlowStructure(node, node.getChildren(), "foreach loop", (Function<? super SoyNode.BlockNode, String>)new Function<SoyNode.BlockNode, String>(){

                public String apply(@Nullable SoyNode.BlockNode input) {
                    if (input instanceof ForeachNonemptyNode) {
                        return "loop body";
                    }
                    return "ifempty block";
                }
            }, false, node.hasIfEmptyBlock());
        }

        @Override
        protected void visitIfNode(final IfNode node) {
            boolean hasElse = node.hasElse();
            this.visitControlFlowStructure(node, node.getChildren(), "if", (Function<? super SoyNode.BlockNode, String>)new Function<SoyNode.BlockNode, String>(){

                public String apply(@Nullable SoyNode.BlockNode input) {
                    if (input instanceof IfCondNode) {
                        if (node.getChild(0) == input) {
                            return "if block";
                        }
                        return "elseif block";
                    }
                    return "else block";
                }
            }, hasElse, hasElse);
        }

        @Override
        protected void visitSwitchNode(SwitchNode node) {
            boolean hasDefault = node.hasDefaultCase();
            this.visitControlFlowStructure(node, node.getChildren(), "switch", (Function<? super SoyNode.BlockNode, String>)new Function<SoyNode.BlockNode, String>(){

                public String apply(@Nullable SoyNode.BlockNode input) {
                    if (input instanceof SwitchCaseNode) {
                        return "case block";
                    }
                    return "default block";
                }
            }, hasDefault, hasDefault);
        }

        @Override
        protected void visitLogNode(LogNode node) {
            State oldState = this.context.setState(State.NONE, node.getSourceLocation().getBeginPoint());
            this.visitChildren(node);
            this.context.setState(oldState, node.getSourceLocation().getEndPoint());
            this.processNonPrintableNode(node);
        }

        @Override
        protected void visitCssNode(CssNode node) {
            this.processPrintableNode(node);
        }

        @Override
        protected void visitPrintNode(PrintNode node) {
            this.processPrintableNode(node);
        }

        @Override
        protected void visitXidNode(XidNode node) {
            this.processPrintableNode(node);
        }

        void processNonPrintableNode(SoyNode.StandaloneNode node) {
            switch (this.context.getState()) {
                case AFTER_ATTRIBUTE_NAME: 
                case BEFORE_ATTRIBUTE_NAME: 
                case AFTER_TAG_NAME_OR_ATTRIBUTE: {
                    this.context.addTagChild(node);
                    break;
                }
                case BEFORE_ATTRIBUTE_VALUE: {
                    this.errorReporter.report(node.getSourceLocation(), INVALID_LOCATION_FOR_NONPRINTABLE, "move it before the start of the tag or after the tag name");
                    break;
                }
                case HTML_TAG_NAME: {
                    this.errorReporter.report(node.getSourceLocation(), INVALID_LOCATION_FOR_NONPRINTABLE, "it creates ambiguity with an unquoted attribute value");
                    break;
                }
                case DOUBLE_QUOTED_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_ATTRIBUTE_VALUE: 
                case UNQUOTED_ATTRIBUTE_VALUE: {
                    this.context.addAttributeValuePart(node);
                    break;
                }
                case NONE: 
                case PCDATA: 
                case RCDATA_STYLE: 
                case RCDATA_TITLE: 
                case RCDATA_XMP: 
                case RCDATA_SCRIPT: 
                case RCDATA_TEXTAREA: 
                case HTML_COMMENT: 
                case XML_DECLARATION: 
                case CDATA: 
                case DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_XML_ATTRIBUTE_VALUE: {
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        void processPrintableNode(SoyNode.StandaloneNode node) {
            Preconditions.checkState((node.getKind() != SoyNode.Kind.RAW_TEXT_NODE ? 1 : 0) != 0);
            switch (this.context.getState()) {
                case AFTER_TAG_NAME_OR_ATTRIBUTE: {
                    this.errorReporter.report(node.getSourceLocation(), EXPECTED_WS_OR_CLOSE_AFTER_TAG_OR_ATTRIBUTE, new Object[0]);
                    break;
                }
                case AFTER_ATTRIBUTE_NAME: {
                    this.errorReporter.report(node.getSourceLocation(), EXPECTED_WS_EQ_OR_CLOSE_AFTER_ATTRIBUTE_NAME, new Object[0]);
                    break;
                }
                case BEFORE_ATTRIBUTE_NAME: {
                    this.context.startAttribute(node);
                    break;
                }
                case HTML_TAG_NAME: {
                    if (node.getKind() == SoyNode.Kind.PRINT_NODE) {
                        this.context.setTagName(new TagName((PrintNode)node));
                        this.edits.remove(node);
                        break;
                    }
                    this.errorReporter.report(node.getSourceLocation(), INVALID_TAG_NAME, new Object[0]);
                    break;
                }
                case BEFORE_ATTRIBUTE_VALUE: {
                    this.context.setState(State.UNQUOTED_ATTRIBUTE_VALUE, node.getSourceLocation().getBeginPoint());
                }
                case DOUBLE_QUOTED_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_ATTRIBUTE_VALUE: 
                case UNQUOTED_ATTRIBUTE_VALUE: {
                    this.context.addAttributeValuePart(node);
                    break;
                }
                case NONE: 
                case PCDATA: 
                case RCDATA_STYLE: 
                case RCDATA_TITLE: 
                case RCDATA_XMP: 
                case RCDATA_SCRIPT: 
                case RCDATA_TEXTAREA: 
                case HTML_COMMENT: 
                case XML_DECLARATION: 
                case CDATA: 
                case DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_XML_ATTRIBUTE_VALUE: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected state: " + (Object)((Object)this.context.getState())));
                }
            }
        }

        @Override
        protected void visitSoyFileNode(SoyFileNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            throw new UnsupportedOperationException((Object)((Object)node.getKind()) + " isn't supported yet");
        }

        void visitScopedBlock(@Nullable SanitizedContent.ContentKind blockKind, SoyNode.BlockNode parent, String name) {
            if (blockKind == null) {
                switch (this.autoescapeMode) {
                    case CONTEXTUAL: 
                    case NONCONTEXTUAL: {
                        blockKind = SanitizedContent.ContentKind.HTML;
                        break;
                    }
                    case STRICT: {
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            State startState = State.fromKind(blockKind);
            ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
            ParsingContext newCtx = this.newParsingContext(name, startState, parent.getSourceLocation().getBeginPoint());
            ParsingContext oldCtx = this.setContext(newCtx);
            this.visitBlock(startState, parent, name, checkpoint);
            this.setContext(oldCtx);
        }

        void visitControlFlowStructure(SoyNode.StandaloneNode parent, List<? extends SoyNode.BlockNode> children, String overallName, Function<? super SoyNode.BlockNode, String> blockNamer, boolean willExactlyOneBranchExecuteOnce, boolean willAtLeastOneBranchExecute) {
            if (children.isEmpty()) {
                return;
            }
            State startingState = this.context.getState();
            State endingState = this.visitBranches(children, blockNamer);
            SourceLocation.Point endPoint = parent.getSourceLocation().getEndPoint();
            switch (startingState) {
                case AFTER_ATTRIBUTE_NAME: 
                case BEFORE_ATTRIBUTE_NAME: 
                case AFTER_TAG_NAME_OR_ATTRIBUTE: {
                    this.context.addTagChild(parent);
                    this.context.setState(endingState, endPoint);
                    break;
                }
                case HTML_TAG_NAME: {
                    this.errorReporter.report(parent.getSourceLocation(), CONTROL_FLOW_IN_HTML_TAG_NAME, overallName);
                    throw new AbortParsingBlockError();
                }
                case BEFORE_ATTRIBUTE_VALUE: {
                    if (!willExactlyOneBranchExecuteOnce) {
                        this.errorReporter.report(parent.getSourceLocation(), CONDITIONAL_BLOCK_ISNT_GUARANTEED_TO_PRODUCE_ONE_ATTRIBUTE_VALUE, overallName);
                    }
                    if (willAtLeastOneBranchExecute && endingState == State.UNQUOTED_ATTRIBUTE_VALUE) {
                        this.context.addAttributeValuePart(parent);
                        this.context.setState(State.UNQUOTED_ATTRIBUTE_VALUE, endPoint);
                        break;
                    }
                    this.context.setAttributeValue(parent);
                    if (!willAtLeastOneBranchExecute || endingState != State.BEFORE_ATTRIBUTE_NAME) break;
                    this.context.setState(State.BEFORE_ATTRIBUTE_NAME, endPoint);
                    break;
                }
                case DOUBLE_QUOTED_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_ATTRIBUTE_VALUE: 
                case UNQUOTED_ATTRIBUTE_VALUE: {
                    this.context.addAttributeValuePart(parent);
                    break;
                }
                case NONE: 
                case PCDATA: 
                case RCDATA_STYLE: 
                case RCDATA_TITLE: 
                case RCDATA_XMP: 
                case RCDATA_SCRIPT: 
                case RCDATA_TEXTAREA: 
                case HTML_COMMENT: 
                case XML_DECLARATION: 
                case CDATA: 
                case DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_XML_ATTRIBUTE_VALUE: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected control flow starting state: " + (Object)((Object)startingState)));
                }
            }
        }

        State visitBranches(List<? extends SoyNode.BlockNode> children, Function<? super SoyNode.BlockNode, String> blockNamer) {
            ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
            State startState = this.context.getState();
            State endingState = null;
            for (SoyNode.BlockNode blockNode : children) {
                if (blockNode instanceof SoyNode.MsgBlockNode) {
                    this.inMsgNode = true;
                }
                String blockName = (String)blockNamer.apply((Object)blockNode);
                ParsingContext newCtx = this.newParsingContext(blockName, startState, blockNode.getSourceLocation().getBeginPoint());
                ParsingContext oldCtx = this.setContext(newCtx);
                endingState = this.visitBlock(startState, blockNode, blockName, checkpoint);
                this.setContext(oldCtx);
                if (!(blockNode instanceof SoyNode.MsgBlockNode)) continue;
                this.inMsgNode = false;
            }
            if (this.errorReporter.errorsSince(checkpoint)) {
                return startState;
            }
            return endingState;
        }

        State visitBlock(State startState, SoyNode.BlockNode node, String blockName, ErrorReporter.Checkpoint checkpoint) {
            try {
                this.visitChildren(node);
            }
            catch (AbortParsingBlockError abortProcessingError) {
                switch (startState) {
                    case DOUBLE_QUOTED_ATTRIBUTE_VALUE: 
                    case SINGLE_QUOTED_ATTRIBUTE_VALUE: 
                    case BEFORE_ATTRIBUTE_VALUE: 
                    case HTML_TAG_NAME: 
                    case AFTER_ATTRIBUTE_NAME: 
                    case UNQUOTED_ATTRIBUTE_VALUE: 
                    case BEFORE_ATTRIBUTE_NAME: 
                    case AFTER_TAG_NAME_OR_ATTRIBUTE: {
                        this.context.resetAttribute();
                        this.context.setState(State.BEFORE_ATTRIBUTE_NAME, node.getSourceLocation().getEndPoint());
                        break;
                    }
                    case NONE: 
                    case PCDATA: 
                    case RCDATA_STYLE: 
                    case RCDATA_TITLE: 
                    case RCDATA_XMP: 
                    case RCDATA_SCRIPT: 
                    case RCDATA_TEXTAREA: 
                    case HTML_COMMENT: 
                    case XML_DECLARATION: 
                    case CDATA: 
                    case DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE: 
                    case SINGLE_QUOTED_XML_ATTRIBUTE_VALUE: {
                        this.context.reset();
                        this.context.setState(startState, node.getSourceLocation().getEndPoint());
                    }
                }
            }
            this.context.finishBlock();
            State finalState = this.context.getState();
            SourceLocation.Point finalStateTransitionPoint = this.context.getStateTransitionPoint();
            if (finalState.isInvalidForEndOfBlock()) {
                this.errorReporter.report(node.getSourceLocation(), BLOCK_ENDS_IN_INVALID_STATE, new Object[]{blockName, finalState});
                finalState = startState;
            }
            if (!this.errorReporter.errorsSince(checkpoint)) {
                State reconciled = startState.reconcile(finalState);
                if (reconciled == null) {
                    String suggestion = Visitor.reconciliationFailureHint(startState, finalState);
                    this.errorReporter.report(finalStateTransitionPoint.asLocation(this.filePath), BLOCK_CHANGES_CONTEXT, new Object[]{blockName, startState, finalState, suggestion != null ? " " + suggestion : ""});
                } else {
                    finalState = reconciled;
                    Visitor.reparentNodes(node, this.context, finalState);
                }
            } else {
                finalState = startState;
            }
            this.context.setState(finalState, node.getSourceLocation().getEndPoint());
            return finalState;
        }

        static void reparentNodes(SoyNode.BlockNode parent, ParsingContext blockCtx, State finalState) {
            switch (finalState) {
                case AFTER_TAG_NAME_OR_ATTRIBUTE: {
                    blockCtx.maybeFinishPendingAttribute(parent.getSourceLocation().getEndPoint());
                }
                case AFTER_ATTRIBUTE_NAME: 
                case BEFORE_ATTRIBUTE_NAME: {
                    blockCtx.reparentDirectTagChildren(parent);
                    break;
                }
                case DOUBLE_QUOTED_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_ATTRIBUTE_VALUE: 
                case UNQUOTED_ATTRIBUTE_VALUE: {
                    blockCtx.reparentAttributeValueChildren(parent);
                    break;
                }
                case NONE: 
                case PCDATA: 
                case RCDATA_STYLE: 
                case RCDATA_TITLE: 
                case RCDATA_XMP: 
                case RCDATA_SCRIPT: 
                case RCDATA_TEXTAREA: 
                case HTML_COMMENT: 
                case XML_DECLARATION: 
                case CDATA: 
                case DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_XML_ATTRIBUTE_VALUE: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("found non-empty context for unexpected state: " + (Object)((Object)blockCtx.getState())));
                }
            }
            blockCtx.checkEmpty("context not fully reparented after '%s'", new Object[]{finalState});
        }

        static String reconciliationFailureHint(State startState, State finalState) {
            switch (finalState) {
                case PCDATA: {
                    return null;
                }
                case BEFORE_ATTRIBUTE_VALUE: {
                    return "Expected an attribute value before the end of the block";
                }
                case CDATA: {
                    return Visitor.didYouForgetToCloseThe("CDATA section");
                }
                case DOUBLE_QUOTED_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_ATTRIBUTE_VALUE: 
                case DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_XML_ATTRIBUTE_VALUE: {
                    return Visitor.didYouForgetToCloseThe("attribute value");
                }
                case HTML_COMMENT: {
                    return Visitor.didYouForgetToCloseThe("html comment");
                }
                case RCDATA_SCRIPT: {
                    return Visitor.didYouForgetToCloseThe("<script> block");
                }
                case RCDATA_STYLE: {
                    return Visitor.didYouForgetToCloseThe("<style> block");
                }
                case RCDATA_TEXTAREA: {
                    return Visitor.didYouForgetToCloseThe("<textare> block");
                }
                case RCDATA_TITLE: {
                    return Visitor.didYouForgetToCloseThe("<title> block");
                }
                case RCDATA_XMP: {
                    return Visitor.didYouForgetToCloseThe("<xmp> block");
                }
                case HTML_TAG_NAME: 
                case XML_DECLARATION: 
                case AFTER_ATTRIBUTE_NAME: 
                case UNQUOTED_ATTRIBUTE_VALUE: 
                case BEFORE_ATTRIBUTE_NAME: 
                case AFTER_TAG_NAME_OR_ATTRIBUTE: {
                    if (startState == State.PCDATA) {
                        return "Did you forget to close the tag?";
                    }
                    return null;
                }
            }
            throw new AssertionError((Object)("unexpected final state: " + (Object)((Object)finalState)));
        }

        static String didYouForgetToCloseThe(String thing) {
            return "Did you forget to close the " + thing + "?";
        }

        ParsingContext setContext(ParsingContext ctx) {
            ParsingContext old = this.context;
            this.context = ctx;
            return old;
        }

        ParsingContext newParsingContext(String blockName, State state, SourceLocation.Point startPoint) {
            return new ParsingContext(blockName, state, startPoint, this.filePath, this.edits, this.errorReporter, this.nodeIdGen);
        }
    }

    private static enum State {
        NONE(new StateFeature[0]),
        PCDATA(new StateFeature[0]),
        RCDATA_SCRIPT(StateFeature.RCDATA),
        RCDATA_TEXTAREA(StateFeature.RCDATA),
        RCDATA_TITLE(StateFeature.RCDATA),
        RCDATA_STYLE(StateFeature.RCDATA),
        RCDATA_XMP(StateFeature.RCDATA),
        HTML_COMMENT(new StateFeature[0]),
        CDATA(new StateFeature[0]),
        XML_DECLARATION(new StateFeature[0]),
        SINGLE_QUOTED_XML_ATTRIBUTE_VALUE(new StateFeature[0]),
        DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE(new StateFeature[0]),
        HTML_TAG_NAME(new StateFeature[0]),
        AFTER_ATTRIBUTE_NAME(StateFeature.TAG),
        BEFORE_ATTRIBUTE_VALUE(StateFeature.INVALID_END_STATE_FOR_BLOCK),
        SINGLE_QUOTED_ATTRIBUTE_VALUE(new StateFeature[0]),
        DOUBLE_QUOTED_ATTRIBUTE_VALUE(new StateFeature[0]),
        UNQUOTED_ATTRIBUTE_VALUE(new StateFeature[0]),
        AFTER_TAG_NAME_OR_ATTRIBUTE(StateFeature.TAG),
        BEFORE_ATTRIBUTE_NAME(StateFeature.TAG);

        private final ImmutableSet<StateFeature> stateTypes;

        static State fromKind(@Nullable SanitizedContent.ContentKind kind) {
            if (kind == null) {
                return NONE;
            }
            switch (kind) {
                case ATTRIBUTES: {
                    return BEFORE_ATTRIBUTE_NAME;
                }
                case HTML: {
                    return PCDATA;
                }
                case CSS: 
                case JS: 
                case TEXT: 
                case TRUSTED_RESOURCE_URI: 
                case URI: {
                    return NONE;
                }
            }
            throw new AssertionError((Object)("unhandled kind: " + (Object)((Object)kind)));
        }

        private State(StateFeature ... stateTypes) {
            EnumSet<StateFeature> set = EnumSet.noneOf(StateFeature.class);
            Collections.addAll(set, stateTypes);
            this.stateTypes = Sets.immutableEnumSet(set);
        }

        @Nullable
        State reconcile(State that) {
            Preconditions.checkNotNull((Object)((Object)that));
            if (that == this) {
                return this;
            }
            if (this.compareTo(that) > 0) {
                return that.reconcile(this);
            }
            if (this == BEFORE_ATTRIBUTE_VALUE && (that == UNQUOTED_ATTRIBUTE_VALUE || that == AFTER_TAG_NAME_OR_ATTRIBUTE || that == BEFORE_ATTRIBUTE_NAME)) {
                return that;
            }
            if (this.isTagState() && that.isTagState()) {
                return AFTER_TAG_NAME_OR_ATTRIBUTE;
            }
            switch (this) {
                case NONE: 
                case PCDATA: 
                case RCDATA_STYLE: 
                case RCDATA_TITLE: 
                case RCDATA_XMP: 
                case RCDATA_SCRIPT: 
                case RCDATA_TEXTAREA: 
                case DOUBLE_QUOTED_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_ATTRIBUTE_VALUE: 
                case BEFORE_ATTRIBUTE_VALUE: 
                case HTML_COMMENT: 
                case HTML_TAG_NAME: 
                case XML_DECLARATION: 
                case CDATA: 
                case DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_XML_ATTRIBUTE_VALUE: 
                case AFTER_ATTRIBUTE_NAME: 
                case UNQUOTED_ATTRIBUTE_VALUE: 
                case BEFORE_ATTRIBUTE_NAME: 
                case AFTER_TAG_NAME_OR_ATTRIBUTE: {
                    return null;
                }
            }
            throw new AssertionError((Object)("unexpected state: " + (Object)((Object)this)));
        }

        boolean isTagState() {
            return this.stateTypes.contains((Object)StateFeature.TAG);
        }

        boolean isInvalidForEndOfBlock() {
            return this.stateTypes.contains((Object)StateFeature.INVALID_END_STATE_FOR_BLOCK);
        }

        boolean isRcDataState() {
            return this.stateTypes.contains((Object)StateFeature.RCDATA);
        }

        public String toString() {
            return Ascii.toLowerCase((String)this.name().replace('_', ' '));
        }
    }

    private static enum StateFeature {
        TAG,
        RCDATA,
        INVALID_END_STATE_FOR_BLOCK;

    }
}

