/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;

final class CheckEscapingSanityFileSetPass
extends CompilerFileSetPass {
    private static final SoyErrorKind ILLEGAL_PRINT_DIRECTIVE = SoyErrorKind.of("{0} can only be used internally by the Soy compiler.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind RENDER_UNIT_WITHOUT_KIND = SoyErrorKind.of("In strict templates, '{'{0}'}'...'{'/{0}'}' blocks require an explicit kind=\"<html|css|text|attributes>\".", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind STRICT_TEXT_CALL_FROM_NONCONTEXTUAL_TEMPLATE = SoyErrorKind.of("Calls to strict templates with ''kind=\"text\"'' are not allowed in non-contextually autoescaped templates.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    CheckEscapingSanityFileSetPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileSetNode fileSet, TemplateRegistry registry) {
        new Visitor(this.errorReporter, registry).exec(fileSet);
    }

    private static final class Visitor
    extends AbstractSoyNodeVisitor<Void> {
        AutoescapeMode autoescapeMode;
        final TemplateRegistry templateRegistry;
        final ErrorReporter errorReporter;

        Visitor(ErrorReporter errorReporter, TemplateRegistry templateRegistry) {
            this.errorReporter = errorReporter;
            this.templateRegistry = templateRegistry;
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            this.autoescapeMode = node.getAutoescapeMode();
            this.visitChildren(node);
        }

        @Override
        protected void visitPrintDirectiveNode(PrintDirectiveNode node) {
            EscapingMode escapingMode = EscapingMode.fromDirective(node.getName());
            if (escapingMode != null && escapingMode.isInternalOnly) {
                this.errorReporter.report(node.getSourceLocation(), ILLEGAL_PRINT_DIRECTIVE, node.getName());
            }
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            this.visitRenderUnitNode(node);
        }

        @Override
        protected void visitCallBasicNode(CallBasicNode node) {
            TemplateBasicNode callee;
            if (this.autoescapeMode == AutoescapeMode.NONCONTEXTUAL && (callee = this.templateRegistry.getBasicTemplate(node.getCalleeName())) != null && callee.getContentKind() == SanitizedContent.ContentKind.TEXT) {
                this.errorReporter.report(node.getSourceLocation(), STRICT_TEXT_CALL_FROM_NONCONTEXTUAL_TEMPLATE, new Object[0]);
            }
            this.visitChildren(node);
        }

        @Override
        protected void visitCallDelegateNode(CallDelegateNode node) {
            TemplateNode callee;
            ImmutableList divisions;
            if (this.autoescapeMode == AutoescapeMode.NONCONTEXTUAL && !(divisions = this.templateRegistry.getDelTemplateSelector().delTemplateNameToValues().get((Object)node.getDelCalleeName())).isEmpty() && (callee = (TemplateNode)divisions.get(0)).getContentKind() == SanitizedContent.ContentKind.TEXT) {
                this.errorReporter.report(node.getSourceLocation(), STRICT_TEXT_CALL_FROM_NONCONTEXTUAL_TEMPLATE, new Object[0]);
            }
            this.visitChildren(node);
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            this.visitRenderUnitNode(node);
        }

        private void visitRenderUnitNode(SoyNode.RenderUnitNode node) {
            AutoescapeMode oldMode = this.autoescapeMode;
            if (node.getContentKind() != null) {
                this.autoescapeMode = AutoescapeMode.STRICT;
            } else if (this.autoescapeMode == AutoescapeMode.STRICT) {
                this.errorReporter.report(node.getSourceLocation(), RENDER_UNIT_WITHOUT_KIND, node.getKind() == SoyNode.Kind.LET_CONTENT_NODE ? "let" : "param");
            }
            this.visitChildren(node);
            this.autoescapeMode = oldMode;
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }
}

