/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.parsepasses.contextautoesc.SoyAutoescapeException;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.PrintDirectiveNode;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@Immutable
public final class Context {
    public final HtmlContext state;
    public final ElementType elType;
    public final AttributeType attrType;
    public final AttributeEndDelimiter delimType;
    public final JsFollowingSlash slashType;
    public final UriPart uriPart;
    public final UriType uriType;
    public final int templateNestDepth;
    public final int jsTemplateLiteralNestDepth;
    public static final Context HTML_PCDATA = new Context(HtmlContext.HTML_PCDATA);
    private static final int N_STATE_BITS = 5;
    private static final int N_ELEMENT_BITS = 4;
    private static final int N_ATTR_BITS = 3;
    private static final int N_DELIM_BITS = 2;
    private static final int N_JS_SLASH_BITS = 2;
    private static final int N_URI_PART_BITS = 4;
    private static final int N_URI_TYPE_BITS = 2;
    private static final ImmutableMap<HtmlContext, SanitizedContent.ContentKind> STATE_TO_CONTENT_KIND;
    private static final ImmutableSet<String> URI_ATTR_NAMES;
    private static final Pattern CUSTOM_URI_ATTR_NAMING_CONVENTION;

    private Context(HtmlContext state, ElementType elType, AttributeType attrType, AttributeEndDelimiter delimType, JsFollowingSlash slashType, UriPart uriPart, UriType uriType, int templateNestDepth, int jsTemplateLiteralNestDepth) {
        this.state = state;
        this.elType = elType;
        this.attrType = attrType;
        this.delimType = delimType;
        this.slashType = slashType;
        this.uriPart = uriPart;
        this.uriType = uriType;
        Preconditions.checkArgument((uriPart == UriPart.NONE || uriType != UriType.NONE ? 1 : 0) != 0, (String)"If in a URI, the type of URI must be specified. UriType = %s but UriPart = %s", (Object)((Object)uriType), (Object)((Object)uriPart));
        this.templateNestDepth = templateNestDepth;
        this.jsTemplateLiteralNestDepth = jsTemplateLiteralNestDepth;
    }

    private Context(HtmlContext state) {
        this(state, ElementType.NONE, AttributeType.NONE, AttributeEndDelimiter.NONE, JsFollowingSlash.NONE, UriPart.NONE, UriType.NONE, 0, 0);
    }

    public Context derive(HtmlContext state) {
        return state == this.state ? this : this.toBuilder().withState(state).build();
    }

    public Context derive(JsFollowingSlash slashType) {
        return slashType == this.slashType ? this : this.toBuilder().withSlashType(slashType).build();
    }

    public Context derive(UriPart uriPart) {
        return uriPart == this.uriPart ? this : this.toBuilder().withUriPart(uriPart).build();
    }

    Builder toBuilder() {
        return new Builder(this);
    }

    public Context getContextAfterDynamicValue() {
        if (this.state == HtmlContext.JS) {
            switch (this.slashType) {
                case DIV_OP: 
                case UNKNOWN: {
                    return this;
                }
                case REGEX: {
                    return this.derive(JsFollowingSlash.DIV_OP);
                }
            }
            throw new IllegalStateException(this.slashType.name());
        }
        if (this.state == HtmlContext.HTML_BEFORE_OPEN_TAG_NAME || this.state == HtmlContext.HTML_BEFORE_CLOSE_TAG_NAME) {
            return this.toBuilder().withState(HtmlContext.HTML_TAG_NAME).withElType(ElementType.NORMAL).build();
        }
        if (this.state == HtmlContext.HTML_TAG) {
            return this.toBuilder().withState(HtmlContext.HTML_ATTRIBUTE_NAME).withAttrType(AttributeType.PLAIN_TEXT).build();
        }
        if (this.uriPart == UriPart.START) {
            return this.derive(UriPart.MAYBE_VARIABLE_SCHEME);
        }
        return this;
    }

    Context getContextBeforeDynamicValue() {
        if (this.state == HtmlContext.HTML_BEFORE_ATTRIBUTE_VALUE) {
            return Context.computeContextAfterAttributeDelimiter(this.elType, this.attrType, AttributeEndDelimiter.SPACE_OR_TAG_END, this.uriType, this.templateNestDepth);
        }
        return this;
    }

    static Context computeContextAfterAttributeDelimiter(ElementType elType, AttributeType attrType, AttributeEndDelimiter delim, UriType uriType, int templateNestDepth) {
        HtmlContext state;
        JsFollowingSlash slash = JsFollowingSlash.NONE;
        UriPart uriPart = UriPart.NONE;
        switch (attrType) {
            case PLAIN_TEXT: {
                state = HtmlContext.HTML_NORMAL_ATTR_VALUE;
                break;
            }
            case SCRIPT: {
                state = HtmlContext.JS;
                slash = JsFollowingSlash.REGEX;
                break;
            }
            case STYLE: {
                state = HtmlContext.CSS;
                break;
            }
            case URI: {
                state = HtmlContext.URI;
                uriPart = UriPart.START;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected attribute type " + (Object)((Object)attrType)));
            }
        }
        Preconditions.checkArgument((uriType != UriType.NONE == (attrType == AttributeType.URI) ? 1 : 0) != 0, (String)"uriType=%s but attrType=%s", (Object)((Object)uriType), (Object)((Object)attrType));
        return new Context(state, elType, attrType, delim, slash, uriPart, uriType, templateNestDepth, 0);
    }

    public ImmutableList<EscapingMode> getEscapingModes(List<PrintDirectiveNode> printDirectives) {
        EscapingMode escapingMode = this.state.getEscapingMode();
        if (escapingMode == null) {
            throw SoyAutoescapeException.createWithoutMetaInfo(this.state.getErrorMessage());
        }
        EscapingMode extraEscapingMode = null;
        EscapingMode truMode = null;
        if (this.uriType == UriType.TRUSTED_RESOURCE) {
            truMode = EscapingMode.FILTER_TRUSTED_RESOURCE_URI;
            for (PrintDirectiveNode directive : printDirectives) {
                if (!directive.getName().equals("|blessStringAsTrustedResourceUrlForLegacy")) continue;
                truMode = null;
                break;
            }
        }
        switch (this.uriPart) {
            case QUERY: {
                escapingMode = EscapingMode.ESCAPE_URI;
                break;
            }
            case START: {
                if (truMode != null) break;
                if (escapingMode != EscapingMode.NORMALIZE_URI) {
                    extraEscapingMode = escapingMode;
                }
                if (this.uriType == UriType.MEDIA) {
                    escapingMode = EscapingMode.FILTER_NORMALIZE_MEDIA_URI;
                    break;
                }
                escapingMode = EscapingMode.FILTER_NORMALIZE_URI;
                break;
            }
            case UNKNOWN: 
            case UNKNOWN_PRE_FRAGMENT: {
                throw SoyAutoescapeException.createWithoutMetaInfo("Cannot determine which part of the URL this dynamic value is in. Most likely, a preceding conditional block began a ?query or #fragment, but only on one branch.");
            }
            case MAYBE_VARIABLE_SCHEME: {
                throw SoyAutoescapeException.createWithoutMetaInfo("Soy can't prove this URI concatenation has a safe scheme at compile time. Either combine adjacent print statements (e.g. {$x + $y} instead of {$x}{$y}), or introduce disambiguating characters (e.g. {$x}/{$y}, {$x}?y={$y}, {$x}&y={$y}, {$x}#{$y})");
            }
            case MAYBE_SCHEME: {
                throw SoyAutoescapeException.createWithoutMetaInfo("Soy can't prove this URI has a safe scheme at compile time. Either make sure one of ':', '/', '?', or '#' comes before the dynamic value (e.g. foo/{$bar}), or move the print statement to the start of the URI to enable runtime validation (e.g. href=\"{'foo' + $bar}\" instead of href=\"foo{$bar}\").");
            }
            case DANGEROUS_SCHEME: {
                throw SoyAutoescapeException.createWithoutMetaInfo("Soy can't properly escape for this URI scheme. For image sources, you can print full data and blob URIs directly (e.g. src=\"{$someDataUri}\"). Otherwise, hardcode the full URI in the template or pass a complete SanitizedContent or SafeUri object.");
            }
        }
        switch (this.delimType) {
            case SPACE_OR_TAG_END: {
                if (escapingMode == EscapingMode.ESCAPE_HTML_ATTRIBUTE || escapingMode == EscapingMode.NORMALIZE_URI) {
                    escapingMode = EscapingMode.ESCAPE_HTML_ATTRIBUTE_NOSPACE;
                    break;
                }
                extraEscapingMode = EscapingMode.ESCAPE_HTML_ATTRIBUTE_NOSPACE;
                break;
            }
            case SINGLE_QUOTE: 
            case DOUBLE_QUOTE: {
                if (escapingMode == EscapingMode.NORMALIZE_URI) {
                    escapingMode = EscapingMode.ESCAPE_HTML_ATTRIBUTE;
                    break;
                }
                if (escapingMode.isHtmlEmbeddable) break;
                extraEscapingMode = EscapingMode.ESCAPE_HTML_ATTRIBUTE;
                break;
            }
        }
        ImmutableList.Builder escapingListBuilder = new ImmutableList.Builder();
        if (truMode != null) {
            escapingListBuilder.add((Object)truMode);
        }
        escapingListBuilder.add((Object)escapingMode);
        if (extraEscapingMode != null) {
            escapingListBuilder.add((Object)extraEscapingMode);
        }
        return escapingListBuilder.build();
    }

    Optional<MsgEscapingStrategy> getMsgEscapingStrategy() {
        switch (this.state) {
            case HTML_PCDATA: {
                return Optional.of((Object)new MsgEscapingStrategy(this, (ImmutableList<EscapingMode>)ImmutableList.of()));
            }
            case CSS_DQ_STRING: 
            case CSS_SQ_STRING: 
            case JS_DQ_STRING: 
            case JS_SQ_STRING: 
            case TEXT: 
            case URI: {
                if (this.state == HtmlContext.URI && this.uriPart != UriPart.QUERY) {
                    return Optional.absent();
                }
                return Optional.of((Object)new MsgEscapingStrategy(new Context(HtmlContext.TEXT), this.getEscapingModes((List<PrintDirectiveNode>)ImmutableList.of())));
            }
            case HTML_RCDATA: 
            case HTML_NORMAL_ATTR_VALUE: 
            case HTML_COMMENT: {
                return Optional.of((Object)new MsgEscapingStrategy(this, (ImmutableList<EscapingMode>)ImmutableList.of((Object)((Object)EscapingMode.NORMALIZE_HTML))));
            }
        }
        return Optional.absent();
    }

    public boolean isCompatibleWith(EscapingMode mode) {
        if (mode == EscapingMode.ESCAPE_JS_VALUE) {
            switch (this.state) {
                case CSS_DQ_STRING: 
                case CSS_SQ_STRING: 
                case JS_DQ_STRING: 
                case JS_SQ_STRING: {
                    return false;
                }
            }
            return true;
        }
        if (mode == EscapingMode.TEXT) {
            return this.state == HtmlContext.TEXT;
        }
        return this.delimType != AttributeEndDelimiter.SPACE_OR_TAG_END || mode != EscapingMode.ESCAPE_HTML && mode != EscapingMode.ESCAPE_HTML_ATTRIBUTE && mode != EscapingMode.ESCAPE_HTML_RCDATA;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Context)) {
            return false;
        }
        Context that = (Context)o;
        return this.state == that.state && this.elType == that.elType && this.attrType == that.attrType && this.delimType == that.delimType && this.slashType == that.slashType && this.uriPart == that.uriPart && this.uriType == that.uriType && this.templateNestDepth == that.templateNestDepth;
    }

    public int hashCode() {
        return this.packedBits();
    }

    public int packedBits() {
        int bits = this.templateNestDepth;
        bits = bits << 2 | this.uriType.ordinal();
        bits = bits << 4 | this.uriPart.ordinal();
        bits = bits << 2 | this.slashType.ordinal();
        bits = bits << 2 | this.delimType.ordinal();
        bits = bits << 3 | this.attrType.ordinal();
        bits = bits << 4 | this.elType.ordinal();
        bits = bits << 5 | this.state.ordinal();
        return bits;
    }

    private static UriPart unionUriParts(UriPart a, UriPart b) {
        Preconditions.checkArgument((a != b ? 1 : 0) != 0);
        if (a == UriPart.DANGEROUS_SCHEME || b == UriPart.DANGEROUS_SCHEME) {
            return UriPart.DANGEROUS_SCHEME;
        }
        if (a == UriPart.FRAGMENT || b == UriPart.FRAGMENT || a == UriPart.UNKNOWN || b == UriPart.UNKNOWN) {
            return UriPart.UNKNOWN;
        }
        if ((a == UriPart.MAYBE_VARIABLE_SCHEME || b == UriPart.MAYBE_VARIABLE_SCHEME) && a != UriPart.UNKNOWN_PRE_FRAGMENT && b != UriPart.UNKNOWN_PRE_FRAGMENT) {
            return UriPart.MAYBE_VARIABLE_SCHEME;
        }
        return UriPart.UNKNOWN_PRE_FRAGMENT;
    }

    static Optional<Context> union(Context a, Context b) {
        if (a.slashType != b.slashType) {
            a = a.derive(JsFollowingSlash.UNKNOWN);
            b = b.derive(JsFollowingSlash.UNKNOWN);
        }
        if (a.uriPart != b.uriPart) {
            UriPart unionedUriPart = Context.unionUriParts(a.uriPart, b.uriPart);
            a = a.derive(unionedUriPart);
            b = b.derive(unionedUriPart);
        }
        if (a.state != b.state) {
            if (a.state.compareTo(b.state) > 0) {
                Context swap = a;
                a = b;
                b = swap;
            }
            if (a.delimType == AttributeEndDelimiter.SPACE_OR_TAG_END && b.delimType == AttributeEndDelimiter.SPACE_OR_TAG_END && a.state != b.state) {
                a = a.toBuilder().withState(HtmlContext.HTML_TAG_NAME).withoutAttrContext().build();
            }
            if (a.state == HtmlContext.HTML_TAG_NAME && (b.state == HtmlContext.HTML_ATTRIBUTE_NAME || b.delimType == AttributeEndDelimiter.SPACE_OR_TAG_END)) {
                a = a.toBuilder().withoutAttrContext().build();
                b = b.toBuilder().withState(HtmlContext.HTML_TAG_NAME).withoutAttrContext().build();
            }
            if (a.state == HtmlContext.HTML_TAG_NAME && b.state == HtmlContext.HTML_TAG) {
                a = a.toBuilder().withState(HtmlContext.HTML_TAG).withoutAttrContext().build();
            }
            if (a.state == HtmlContext.HTML_TAG && (b.state == HtmlContext.HTML_ATTRIBUTE_NAME || b.delimType == AttributeEndDelimiter.SPACE_OR_TAG_END)) {
                b = b.toBuilder().withState(HtmlContext.HTML_TAG).withoutAttrContext().build();
            }
        }
        return a.equals(b) ? Optional.of((Object)a) : Optional.absent();
    }

    static Optional<Context> union(Iterable<Context> contexts) {
        Iterator<Context> iterator = contexts.iterator();
        Optional<Context> context = Optional.of((Object)iterator.next());
        while (iterator.hasNext() && context.isPresent()) {
            context = Context.union((Context)context.get(), iterator.next());
        }
        return context;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(Context ").append(this.state.name());
        if (this.elType != ElementType.NONE) {
            sb.append(' ').append(this.elType.name());
        }
        if (this.attrType != AttributeType.NONE) {
            sb.append(' ').append(this.attrType.name());
        }
        if (this.delimType != AttributeEndDelimiter.NONE) {
            sb.append(' ').append(this.delimType.name());
        }
        if (this.slashType != JsFollowingSlash.NONE) {
            sb.append(' ').append(this.slashType.name());
        }
        if (this.uriPart != UriPart.NONE) {
            sb.append(' ').append(this.uriPart.name());
        }
        if (this.uriType != UriType.NONE) {
            sb.append(' ').append(this.uriType.name());
        }
        if (this.templateNestDepth != 0) {
            sb.append(" templateNestDepth=").append(this.templateNestDepth);
        }
        if (this.jsTemplateLiteralNestDepth != 0) {
            sb.append(" jsTemplateLiteralNestDepth=").append(this.jsTemplateLiteralNestDepth);
        }
        return sb.append(')').toString();
    }

    @VisibleForTesting
    static Context parse(String text) {
        String prefix;
        String part;
        LinkedList parts = Lists.newLinkedList(Arrays.asList(text.split(" ")));
        Builder builder = HTML_PCDATA.toBuilder();
        builder.withState(HtmlContext.valueOf((String)parts.remove()));
        if (!parts.isEmpty()) {
            try {
                builder.withElType(ElementType.valueOf((String)parts.element()));
                parts.remove();
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        if (!parts.isEmpty()) {
            try {
                builder.withAttrType(AttributeType.valueOf((String)parts.element()));
                parts.remove();
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        if (!parts.isEmpty()) {
            try {
                builder.withDelimType(AttributeEndDelimiter.valueOf((String)parts.element()));
                parts.remove();
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        if (!parts.isEmpty()) {
            try {
                builder.withSlashType(JsFollowingSlash.valueOf((String)parts.element()));
                parts.remove();
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        if (!parts.isEmpty()) {
            try {
                builder.withUriPart(UriPart.valueOf((String)parts.element()));
                parts.remove();
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        if (!parts.isEmpty()) {
            try {
                builder.withUriType(UriType.valueOf((String)parts.element()));
                parts.remove();
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        if (!parts.isEmpty() && (part = (String)parts.element()).startsWith(prefix = "templateNestDepth=")) {
            try {
                builder.withTemplateNestDepth(Integer.parseInt(part.substring(prefix.length())));
                parts.remove();
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (!parts.isEmpty() && (part = (String)parts.element()).startsWith(prefix = "jsTemplateLiteralNestDepth=")) {
            try {
                builder.withJsTemplateLiteralNestDepth(Integer.parseInt(part.substring(prefix.length())));
                parts.remove();
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (!parts.isEmpty()) {
            throw new IllegalArgumentException("Unable to parse context \"" + text + "\". Unparsed portion: " + parts);
        }
        Context result = builder.build();
        return result;
    }

    public static Context getStartContextForContentKind(SanitizedContent.ContentKind contentKind) {
        return HTML_PCDATA.toBuilder().withStartKind(contentKind).build();
    }

    public boolean isValidStartContextForContentKind(SanitizedContent.ContentKind contentKind) {
        if (this.templateNestDepth != 0) {
            return false;
        }
        switch (contentKind) {
            case ATTRIBUTES: {
                return this.state == HtmlContext.HTML_ATTRIBUTE_NAME || this.state == HtmlContext.HTML_TAG;
            }
        }
        return this.equals(Context.getStartContextForContentKind(contentKind));
    }

    public boolean isValidStartContextForContentKindLoose(SanitizedContent.ContentKind contentKind) {
        switch (contentKind) {
            case URI: {
                return this.state == HtmlContext.URI;
            }
        }
        return this.isValidStartContextForContentKind(contentKind);
    }

    public SanitizedContent.ContentKind getMostAppropriateContentKind() {
        SanitizedContent.ContentKind kind = (SanitizedContent.ContentKind)((Object)STATE_TO_CONTENT_KIND.get((Object)this.state));
        if (kind != null && this.isValidStartContextForContentKindLoose(kind)) {
            return kind;
        }
        return SanitizedContent.ContentKind.TEXT;
    }

    public final boolean isValidEndContextForContentKind(SanitizedContent.ContentKind contentKind) {
        if (this.templateNestDepth != 0) {
            return false;
        }
        switch (contentKind) {
            case CSS: {
                return this.state == HtmlContext.CSS && this.elType == ElementType.NONE;
            }
            case HTML: {
                return this.state == HtmlContext.HTML_PCDATA && this.elType == ElementType.NONE;
            }
            case ATTRIBUTES: {
                return this.state == HtmlContext.HTML_ATTRIBUTE_NAME || this.state == HtmlContext.HTML_TAG;
            }
            case JS: {
                return this.state == HtmlContext.JS && this.elType == ElementType.NONE;
            }
            case URI: {
                return this.state == HtmlContext.URI && this.uriType == UriType.NORMAL && this.uriPart != UriPart.START;
            }
            case TEXT: {
                return this.state == HtmlContext.TEXT;
            }
        }
        throw new IllegalArgumentException("Specified content kind has no associated end context.");
    }

    public final String getLikelyEndContextMismatchCause(SanitizedContent.ContentKind contentKind) {
        Preconditions.checkArgument((!this.isValidEndContextForContentKind(contentKind) ? 1 : 0) != 0);
        if (contentKind == SanitizedContent.ContentKind.ATTRIBUTES) {
            return "an unterminated attribute value, or ending with an unquoted attribute";
        }
        switch (this.state) {
            case HTML_NORMAL_ATTR_VALUE: 
            case HTML_TAG_NAME: 
            case HTML_TAG: 
            case HTML_ATTRIBUTE_NAME: {
                return "an unterminated HTML tag or attribute";
            }
            case CSS: {
                return "an unclosed style block or attribute";
            }
            case JS: 
            case JS_LINE_COMMENT: {
                return "an unclosed script block or attribute";
            }
            case HTML_COMMENT: 
            case CSS_COMMENT: 
            case JS_BLOCK_COMMENT: {
                return "an unterminated comment";
            }
            case CSS_DQ_STRING: 
            case CSS_SQ_STRING: 
            case JS_DQ_STRING: 
            case JS_SQ_STRING: {
                return "an unterminated string literal";
            }
            case URI: 
            case CSS_URI: 
            case CSS_DQ_URI: 
            case CSS_SQ_URI: {
                return "an unterminated or empty URI";
            }
            case JS_REGEX: {
                return "an unterminated regular expression";
            }
        }
        if (this.templateNestDepth != 0) {
            return "an unterminated <template> element";
        }
        return "unknown to compiler";
    }

    @CheckReturnValue
    Context transitionToState(HtmlContext state) {
        Builder builder = this.toBuilder().withState(state).withUriPart(UriPart.NONE);
        if (this.uriPart != UriPart.NONE) {
            builder.withUriType(UriType.NONE);
        }
        return builder.build();
    }

    @CheckReturnValue
    Context transitionToTagName(String tagName) {
        tagName = Ascii.toLowerCase((String)tagName);
        boolean isEndTag = this.state == HtmlContext.HTML_BEFORE_CLOSE_TAG_NAME;
        ElementType elType = ElementType.NORMAL;
        int newTemplateNestDepth = this.templateNestDepth;
        if (tagName.equals("template")) {
            if ((newTemplateNestDepth += isEndTag ? -1 : 1) < 0) {
                throw SoyAutoescapeException.createWithoutMetaInfo("Saw an html5 </template> without encountering <template>.");
            }
        } else if (!isEndTag) {
            switch (tagName) {
                case "img": 
                case "image": {
                    elType = ElementType.MEDIA;
                    break;
                }
                case "script": {
                    elType = ElementType.SCRIPT;
                    break;
                }
                case "style": {
                    elType = ElementType.STYLE;
                    break;
                }
                case "textarea": {
                    elType = ElementType.TEXTAREA;
                    break;
                }
                case "title": {
                    elType = ElementType.TITLE;
                    break;
                }
                case "xmp": {
                    elType = ElementType.XMP;
                }
            }
        }
        return this.toBuilder().withState(HtmlContext.HTML_TAG_NAME).withoutAttrContext().withElType(elType).withTemplateNestDepth(newTemplateNestDepth).build();
    }

    @CheckReturnValue
    Context transitionToTagBody() {
        return this.toBuilder().withState(HtmlContext.HTML_TAG).withoutAttrContext().build();
    }

    @CheckReturnValue
    Context transitionToAfterTag() {
        Builder builder = this.toBuilder();
        builder.withoutAttrContext();
        switch (this.elType) {
            case SCRIPT: {
                builder.withState(HtmlContext.JS).withSlashType(JsFollowingSlash.REGEX).withElType(ElementType.NONE);
                break;
            }
            case STYLE: {
                builder.withState(HtmlContext.CSS).withElType(ElementType.NONE);
                break;
            }
            case TEXTAREA: 
            case TITLE: 
            case XMP: {
                builder.withState(HtmlContext.HTML_RCDATA);
                break;
            }
            case NORMAL: 
            case MEDIA: {
                builder.withState(HtmlContext.HTML_PCDATA).withElType(ElementType.NONE);
                break;
            }
            case NONE: {
                throw new IllegalStateException();
            }
            default: {
                throw new AssertionError((Object)("Unrecognized state " + (Object)((Object)this.elType)));
            }
        }
        return builder.build();
    }

    @CheckReturnValue
    Context transitionToAttrName(String attrName) {
        AttributeType attr;
        attrName = Ascii.toLowerCase((String)attrName);
        int colon = attrName.lastIndexOf(58);
        String localName = attrName.substring(colon + 1);
        UriType uriType = UriType.NONE;
        if (localName.startsWith("on")) {
            attr = AttributeType.SCRIPT;
        } else if ("ng-init".equals(attrName)) {
            attr = AttributeType.SCRIPT;
        } else if ("style".equals(localName)) {
            attr = AttributeType.STYLE;
        } else if (this.elType == ElementType.MEDIA && ("src".equals(attrName) || "xlink:href".equals(attrName))) {
            attr = AttributeType.URI;
            uriType = UriType.MEDIA;
        } else if (this.elType == ElementType.SCRIPT && "src".equals(attrName)) {
            attr = AttributeType.URI;
            uriType = UriType.TRUSTED_RESOURCE;
        } else if (URI_ATTR_NAMES.contains((Object)localName) || CUSTOM_URI_ATTR_NAMING_CONVENTION.matcher(localName).find() || "xmlns".equals(attrName) || attrName.startsWith("xmlns:")) {
            attr = AttributeType.URI;
            uriType = UriType.NORMAL;
        } else {
            attr = AttributeType.PLAIN_TEXT;
        }
        return this.toBuilder().withState(HtmlContext.HTML_ATTRIBUTE_NAME).withoutAttrContext().withAttrType(attr).withUriType(uriType).build();
    }

    @CheckReturnValue
    Context transitionToAttrValue(AttributeEndDelimiter delim) {
        return Context.computeContextAfterAttributeDelimiter(this.elType, this.attrType, delim, this.uriType, this.templateNestDepth);
    }

    static {
        if (32 < HtmlContext.values().length || 16 < ElementType.values().length || 8 < AttributeType.values().length || 4 < AttributeEndDelimiter.values().length || 4 < JsFollowingSlash.values().length || 16 < UriPart.values().length || 4 < UriType.values().length) {
            throw new AssertionError();
        }
        EnumMap<HtmlContext, SanitizedContent.ContentKind> stateToContextKind = new EnumMap<HtmlContext, SanitizedContent.ContentKind>(HtmlContext.class);
        stateToContextKind.put(HtmlContext.CSS, SanitizedContent.ContentKind.CSS);
        stateToContextKind.put(HtmlContext.HTML_PCDATA, SanitizedContent.ContentKind.HTML);
        stateToContextKind.put(HtmlContext.HTML_TAG, SanitizedContent.ContentKind.ATTRIBUTES);
        stateToContextKind.put(HtmlContext.JS, SanitizedContent.ContentKind.JS);
        stateToContextKind.put(HtmlContext.URI, SanitizedContent.ContentKind.URI);
        stateToContextKind.put(HtmlContext.TEXT, SanitizedContent.ContentKind.TEXT);
        STATE_TO_CONTENT_KIND = ImmutableMap.copyOf(stateToContextKind);
        URI_ATTR_NAMES = ImmutableSet.of((Object)"action", (Object)"archive", (Object)"base", (Object)"background", (Object)"cite", (Object)"classid", (Object[])new String[]{"codebase", "data", "dsync", "formaction", "href", "icon", "longdesc", "manifest", "poster", "src", "usemap", "entity"});
        CUSTOM_URI_ATTR_NAMING_CONVENTION = Pattern.compile("\\bur[il]|ur[il]s?$");
    }

    static final class Builder {
        private HtmlContext state;
        private ElementType elType;
        private AttributeType attrType;
        private AttributeEndDelimiter delimType;
        private JsFollowingSlash slashType;
        private UriPart uriPart;
        private UriType uriType;
        private int templateNestDepth;
        private int jsTemplateLiteralNestDepth;

        private Builder(Context context) {
            this.state = context.state;
            this.elType = context.elType;
            this.attrType = context.attrType;
            this.delimType = context.delimType;
            this.slashType = context.slashType;
            this.uriPart = context.uriPart;
            this.uriType = context.uriType;
            this.templateNestDepth = context.templateNestDepth;
            this.jsTemplateLiteralNestDepth = context.jsTemplateLiteralNestDepth;
        }

        Builder withState(HtmlContext state) {
            this.state = (HtmlContext)((Object)Preconditions.checkNotNull((Object)((Object)state)));
            return this;
        }

        Builder withElType(ElementType elType) {
            this.elType = (ElementType)((Object)Preconditions.checkNotNull((Object)((Object)elType)));
            return this;
        }

        Builder withAttrType(AttributeType attrType) {
            this.attrType = (AttributeType)((Object)Preconditions.checkNotNull((Object)((Object)attrType)));
            return this;
        }

        Builder withDelimType(AttributeEndDelimiter delimType) {
            this.delimType = (AttributeEndDelimiter)((Object)Preconditions.checkNotNull((Object)((Object)delimType)));
            return this;
        }

        Builder withSlashType(JsFollowingSlash slashType) {
            this.slashType = (JsFollowingSlash)((Object)Preconditions.checkNotNull((Object)((Object)slashType)));
            return this;
        }

        Builder withUriPart(UriPart uriPart) {
            this.uriPart = (UriPart)((Object)Preconditions.checkNotNull((Object)((Object)uriPart)));
            return this;
        }

        Builder withUriType(UriType uriType) {
            this.uriType = (UriType)((Object)Preconditions.checkNotNull((Object)((Object)uriType)));
            return this;
        }

        Builder withTemplateNestDepth(int templateNestDepth) {
            Preconditions.checkArgument((templateNestDepth >= 0 ? 1 : 0) != 0, (String)"expected template depth (%s) to be >= 0", (int)templateNestDepth);
            this.templateNestDepth = templateNestDepth;
            return this;
        }

        Builder withJsTemplateLiteralNestDepth(int jsTemplateLiteralNestDepth) {
            Preconditions.checkArgument((jsTemplateLiteralNestDepth >= 0 ? 1 : 0) != 0, (String)"expected js template string nest depth (%s) to be >= 0", (int)jsTemplateLiteralNestDepth);
            this.jsTemplateLiteralNestDepth = jsTemplateLiteralNestDepth;
            return this;
        }

        Builder withoutAttrContext() {
            return this.withAttrType(AttributeType.NONE).withDelimType(AttributeEndDelimiter.NONE).withSlashType(JsFollowingSlash.NONE).withUriPart(UriPart.NONE).withUriType(UriType.NONE);
        }

        Builder withStartKind(SanitizedContent.ContentKind contentKind) {
            boolean inTag = false;
            this.withoutAttrContext();
            switch (contentKind) {
                case CSS: {
                    this.withState(HtmlContext.CSS);
                    break;
                }
                case HTML: {
                    this.withState(HtmlContext.HTML_PCDATA);
                    break;
                }
                case ATTRIBUTES: {
                    this.withState(HtmlContext.HTML_TAG);
                    inTag = true;
                    break;
                }
                case JS: {
                    this.withState(HtmlContext.JS);
                    this.withSlashType(JsFollowingSlash.REGEX);
                    break;
                }
                case URI: {
                    this.withState(HtmlContext.URI);
                    this.withUriPart(UriPart.START);
                    this.withUriType(UriType.NORMAL);
                    break;
                }
                case TEXT: {
                    this.withState(HtmlContext.TEXT);
                    break;
                }
            }
            if (!inTag) {
                this.withElType(ElementType.NONE);
            }
            return this;
        }

        Context build() {
            return new Context(this.state, this.elType, this.attrType, this.delimType, this.slashType, this.uriPart, this.uriType, this.templateNestDepth, this.jsTemplateLiteralNestDepth);
        }
    }

    public static enum UriType {
        NONE,
        NORMAL,
        MEDIA,
        TRUSTED_RESOURCE;

    }

    public static enum UriPart {
        NONE,
        START,
        MAYBE_VARIABLE_SCHEME,
        MAYBE_SCHEME,
        AUTHORITY_OR_PATH,
        QUERY,
        FRAGMENT,
        UNKNOWN_PRE_FRAGMENT,
        UNKNOWN,
        DANGEROUS_SCHEME;

    }

    public static enum JsFollowingSlash {
        NONE,
        REGEX,
        DIV_OP,
        UNKNOWN;

    }

    public static enum AttributeEndDelimiter {
        NONE,
        DOUBLE_QUOTE("\""),
        SINGLE_QUOTE("'"),
        SPACE_OR_TAG_END("");

        @Nullable
        public final String text;

        private AttributeEndDelimiter(String text) {
            this.text = text;
        }

        private AttributeEndDelimiter() {
            this.text = null;
        }
    }

    public static enum AttributeType {
        NONE,
        SCRIPT,
        STYLE,
        URI,
        PLAIN_TEXT;

    }

    public static enum ElementType {
        NONE,
        SCRIPT,
        STYLE,
        TEXTAREA,
        TITLE,
        XMP,
        MEDIA,
        NORMAL;

    }

    static final class MsgEscapingStrategy {
        final Context childContext;
        final ImmutableList<EscapingMode> escapingModesForFullMessage;

        MsgEscapingStrategy(Context childContext, ImmutableList<EscapingMode> escapingModesForFullMessage) {
            this.childContext = childContext;
            this.escapingModesForFullMessage = escapingModesForFullMessage;
        }
    }
}

