/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralRemainderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.msgs.restricted.SoyMsgSelectPart;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachIfemptyNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.XidNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class TemplateAnalysis {
    private final ImmutableSet<ExprNode> resolvedExpressions;

    static TemplateAnalysis analyze(TemplateNode node) {
        AccessGraph templateGraph = new PseudoEvaluatorVisitor().evaluate(node);
        return new TemplateAnalysis(templateGraph.getResolvedExpressions());
    }

    private TemplateAnalysis(Set<ExprNode> definitelyAccessedRefs) {
        this.resolvedExpressions = ImmutableSet.copyOf(definitelyAccessedRefs);
    }

    boolean isResolved(VarRefNode ref) {
        return this.resolvedExpressions.contains((Object)ref);
    }

    boolean isResolved(DataAccessNode ref) {
        return this.resolvedExpressions.contains((Object)ref);
    }

    private static StaticAnalysisResult isListExpressionEmpty(ExprNode node) {
        ExprNode exprNode = node = node instanceof ExprRootNode ? ((ExprRootNode)node).getRoot() : node;
        if (node instanceof ListLiteralNode) {
            return ((ListLiteralNode)node).numChildren() > 0 ? StaticAnalysisResult.FALSE : StaticAnalysisResult.TRUE;
        }
        return StaticAnalysisResult.UNKNOWN;
    }

    private static void addPredecessors(Block start) {
        Set visited = Sets.newIdentityHashSet();
        TemplateAnalysis.addPredecessors(start, visited);
    }

    private static void addPredecessors(Block current, Set<Block> visited) {
        if (!visited.add(current)) {
            return;
        }
        for (Block successor : current.successors) {
            successor.predecessors.add(current);
            TemplateAnalysis.addPredecessors(successor, visited);
        }
    }

    private static final class Block {
        final List<ExprNode> exprs = new ArrayList<ExprNode>();
        final Collection<Block> successors = new LinkedHashSet<Block>();
        final Collection<Block> predecessors = new LinkedHashSet<Block>();

        private Block() {
        }

        static Block merge(Block ... preds) {
            return Block.merge(Arrays.asList(preds));
        }

        static Block merge(List<Block> preds) {
            Block end = new Block();
            for (Block pred : preds) {
                pred.successors.add(end);
            }
            return end;
        }

        void add(VarRefNode var) {
            this.exprs.add(var);
        }

        void add(DataAccessNode dataAccess) {
            this.exprs.add(dataAccess);
        }

        Block addBranch() {
            Block branch = new Block();
            this.successors.add(branch);
            return branch;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ImmutableMap.of((Object)"exprs", this.exprs, (Object)"in_edges", (Object)this.predecessors.size(), (Object)"out_edges", (Object)this.successors.size());
        }
    }

    private static final class AccessGraph {
        final Block start;
        final Block end;

        AccessGraph(Block start, Block end) {
            this.start = start;
            this.end = end;
        }

        AccessGraph copy() {
            IdentityHashMap<Block, Block> originalToCopy = new IdentityHashMap<Block, Block>();
            Block newStart = AccessGraph.shallowCopyBlock(this.start, originalToCopy);
            Block newEnd = (Block)originalToCopy.get(this.end);
            return new AccessGraph(newStart, newEnd);
        }

        Set<ExprNode> getResolvedExpressions() {
            Set resolvedExprs = Sets.newIdentityHashSet();
            IdentityHashMap<Block, Set<Equivalence.Wrapper<ExprNode>>> blockToAccessedExprs = new IdentityHashMap<Block, Set<Equivalence.Wrapper<ExprNode>>>();
            for (Block current : this.getTopologicalOrdering()) {
                Set<Equivalence.Wrapper<ExprNode>> currentBlockSet = AccessGraph.mergePredecessors(blockToAccessedExprs, current);
                for (ExprNode expr : current.exprs) {
                    Equivalence.Wrapper wrapped = ExprEquivalence.get().wrap(expr);
                    if (currentBlockSet.add((Equivalence.Wrapper<ExprNode>)wrapped)) continue;
                    resolvedExprs.add(expr);
                }
                blockToAccessedExprs.put(current, currentBlockSet);
            }
            return resolvedExprs;
        }

        static Set<Equivalence.Wrapper<ExprNode>> mergePredecessors(Map<Block, Set<Equivalence.Wrapper<ExprNode>>> blockToAccessedExprs, Block current) {
            HashSet<Object> currentBlockSet = null;
            for (Block predecessor : current.predecessors) {
                Set<Equivalence.Wrapper<ExprNode>> predecessorBlockSet = blockToAccessedExprs.get(predecessor);
                if (currentBlockSet == null) {
                    currentBlockSet = new HashSet<Equivalence.Wrapper<ExprNode>>(predecessorBlockSet);
                    continue;
                }
                currentBlockSet.retainAll(predecessorBlockSet);
            }
            if (currentBlockSet == null) {
                currentBlockSet = new HashSet();
            }
            return currentBlockSet;
        }

        private List<Block> getTopologicalOrdering() {
            ArrayList<Block> ordering = new ArrayList<Block>();
            Set visited = Sets.newIdentityHashSet();
            Set discoveredButNotVisited = Sets.newIdentityHashSet();
            discoveredButNotVisited.add(this.start);
            block0: while (!discoveredButNotVisited.isEmpty()) {
                for (Block notVisited : discoveredButNotVisited) {
                    if (!visited.containsAll(notVisited.predecessors)) continue;
                    discoveredButNotVisited.remove(notVisited);
                    visited.add(notVisited);
                    discoveredButNotVisited.addAll(notVisited.successors);
                    ordering.add(notVisited);
                    continue block0;
                }
                throw new AssertionError((Object)"failed to make progress");
            }
            return ordering;
        }

        private static Block shallowCopyBlock(Block original, Map<Block, Block> originalToCopy) {
            if (originalToCopy.containsKey(original)) {
                return originalToCopy.get(original);
            }
            Block copy = new Block();
            for (ExprNode expr : original.exprs) {
                copy.exprs.add(expr.copy(new CopyState()));
            }
            originalToCopy.put(original, copy);
            for (Block successor : original.successors) {
                copy.successors.add(AccessGraph.shallowCopyBlock(successor, originalToCopy));
            }
            for (Block predecessor : original.predecessors) {
                copy.predecessors.add(AccessGraph.shallowCopyBlock(predecessor, originalToCopy));
            }
            return copy;
        }
    }

    private static final class PseudoEvaluatorExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        final Map<VarDefn, AccessGraph> letNodes;
        Block current;

        PseudoEvaluatorExprVisitor(Map<VarDefn, AccessGraph> letNodes) {
            this.letNodes = letNodes;
        }

        Block eval(Block block, ExprNode expr) {
            Block orig = this.current;
            this.current = block;
            this.visit(expr);
            Block rVal = this.current;
            this.current = orig;
            return rVal;
        }

        @Override
        protected void visitExprRootNode(ExprRootNode node) {
            this.visit(node.getRoot());
        }

        @Override
        protected void visitVarRefNode(VarRefNode node) {
            AccessGraph letContent = this.letNodes.get(node.getDefnDecl());
            if (letContent != null) {
                AccessGraph copy = letContent.copy();
                this.current.successors.add(letContent.start);
                this.current.successors.add(copy.start);
                this.current = copy.end.addBranch();
            }
            this.current.add(node);
        }

        @Override
        protected void visitDataAccessNode(DataAccessNode node) {
            this.visitChildren(node);
            this.current.add(node);
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            if (node.getSoyFunction() instanceof BuiltinFunction) {
                switch ((BuiltinFunction)node.getSoyFunction()) {
                    case INDEX: 
                    case IS_FIRST: 
                    case IS_LAST: {
                        return;
                    }
                    case QUOTE_KEYS_IF_JS: 
                    case CHECK_NOT_NULL: 
                    case DEBUG_MODE: 
                    case CSS: 
                    case XID: {
                        break;
                    }
                    case V1_EXPRESSION: {
                        throw new UnsupportedOperationException("the v1Expression function can't be used in templates compiled to Java");
                    }
                    default: {
                        throw new AssertionError((Object)"unexpected builtin function");
                    }
                }
            }
            this.visitChildren(node);
        }

        @Override
        protected void visitPrimitiveNode(ExprNode.PrimitiveNode node) {
        }

        @Override
        protected void visitListLiteralNode(ListLiteralNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitMapLiteralNode(MapLiteralNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitOperatorNode(ExprNode.OperatorNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
            this.visit(node.getLeftChild());
            this.executeInBranch(node.getRightChild());
        }

        @Override
        protected void visitOrOpNode(OperatorNodes.OrOpNode node) {
            this.visit(node.getChild(0));
            this.executeInBranch(node.getChild(1));
        }

        @Override
        protected void visitAndOpNode(OperatorNodes.AndOpNode node) {
            this.visit(node.getChild(0));
            this.executeInBranch(node.getChild(1));
        }

        private void executeInBranch(ExprNode expr) {
            Block prev = this.current;
            Block branch = prev.addBranch();
            branch = this.eval(branch, expr);
            this.current = Block.merge(prev, branch);
        }

        @Override
        protected void visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
            this.visit(node.getChild(0));
            this.current = Block.merge(this.eval(this.current.addBranch(), node.getChild(1)), this.eval(this.current.addBranch(), node.getChild(2)));
        }
    }

    private static enum StaticAnalysisResult {
        TRUE,
        FALSE,
        UNKNOWN;

    }

    private static final class PseudoEvaluatorVisitor
    extends AbstractSoyNodeVisitor<Void> {
        final Map<VarDefn, AccessGraph> letNodes = new HashMap<VarDefn, AccessGraph>();
        final PseudoEvaluatorExprVisitor exprVisitor = new PseudoEvaluatorExprVisitor(this.letNodes);
        Block current;

        private PseudoEvaluatorVisitor() {
        }

        AccessGraph evaluate(TemplateNode node) {
            Block start = new Block();
            Block finalNode = this.exec(start, node);
            Preconditions.checkState((boolean)finalNode.successors.isEmpty());
            TemplateAnalysis.addPredecessors(start);
            return new AccessGraph(start, finalNode);
        }

        Block exec(Block block, SoyNode node) {
            Block original = this.current;
            this.current = block;
            this.visit(node);
            Block rVal = this.current;
            this.current = original;
            return rVal;
        }

        @Override
        protected void visitPrintNode(PrintNode node) {
            this.evalInline(node.getExpr());
            for (PrintDirectiveNode directive : node.getChildren()) {
                for (ExprRootNode arg : directive.getArgs()) {
                    this.evalInline(arg);
                }
            }
        }

        @Override
        protected void visitRawTextNode(RawTextNode node) {
        }

        @Override
        protected void visitLogNode(LogNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitDebuggerNode(DebuggerNode node) {
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitForeachNode(ForeachNode node) {
            this.evalInline(node.getExpr());
            Block loopBegin = this.current;
            Block loopBody = loopBegin.addBranch();
            Block loopEnd = this.exec(loopBody, (SoyNode)node.getChild(0));
            StaticAnalysisResult isLoopEmpty = TemplateAnalysis.isListExpressionEmpty(node.getExpr());
            if (node.numChildren() == 2) {
                Block ifEmptyBlock = loopBegin.addBranch();
                Block ifEmptyEnd = this.exec(ifEmptyBlock, (SoyNode)node.getChild(1));
                switch (isLoopEmpty) {
                    case FALSE: {
                        this.current = loopEnd.addBranch();
                        break;
                    }
                    case TRUE: {
                        this.current = ifEmptyEnd.addBranch();
                        break;
                    }
                    case UNKNOWN: {
                        this.current = Block.merge(loopEnd, ifEmptyEnd);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            } else {
                switch (isLoopEmpty) {
                    case FALSE: {
                        this.current = loopEnd.addBranch();
                        break;
                    }
                    case TRUE: {
                        this.current = loopBegin.addBranch();
                        break;
                    }
                    case UNKNOWN: {
                        this.current = Block.merge(loopEnd, loopBegin);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }

        @Override
        protected void visitForeachIfemptyNode(ForeachIfemptyNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitForeachNonemptyNode(ForeachNonemptyNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitForNode(ForNode node) {
            Block loopBody;
            ForNode.RangeArgs rangeArgs = node.getRangeArgs();
            this.evalInline(rangeArgs.start());
            this.evalInline(rangeArgs.increment());
            this.evalInline(rangeArgs.limit());
            Block loopBegin = this.current;
            Block loopEnd = loopBody = loopBegin.addBranch();
            for (SoyNode.StandaloneNode child : node.getChildren()) {
                loopEnd = this.exec(loopEnd, child);
            }
            this.current = rangeArgs.definitelyNotEmpty() ? loopEnd : Block.merge(loopBegin, loopEnd);
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            Block startBlock;
            Block block = startBlock = new Block();
            for (SoyNode.StandaloneNode child : node.getChildren()) {
                block = this.exec(block, child);
            }
            this.letNodes.put(node.getVar(), new AccessGraph(startBlock, block));
        }

        @Override
        protected void visitLetValueNode(LetValueNode node) {
            Block start = new Block();
            Block end = this.exprVisitor.eval(start, node.getExpr());
            this.letNodes.put(node.getVar(), new AccessGraph(start, end));
        }

        @Override
        protected void visitSwitchNode(SwitchNode node) {
            List children = node.getChildren();
            if (children.isEmpty()) {
                return;
            }
            if (children.size() == 1 && children.get(0) instanceof SwitchDefaultNode) {
                this.visitChildren((SoyNode.ParentSoyNode)children.get(0));
                return;
            }
            this.evalInline(node.getExpr());
            Block conditions = null;
            ArrayList<Block> branchEnds = new ArrayList<Block>();
            boolean hasDefault = false;
            for (SoyNode child : node.getChildren()) {
                if (child instanceof SwitchCaseNode) {
                    SwitchCaseNode scn = (SwitchCaseNode)child;
                    Block caseBlockStart = new Block();
                    Block caseBlockEnd = this.exec(caseBlockStart, scn);
                    branchEnds.add(caseBlockEnd);
                    for (ExprRootNode expr : scn.getExprList()) {
                        if (conditions == null) {
                            this.evalInline(expr);
                            conditions = this.current;
                        } else {
                            Block condition = conditions.addBranch();
                            conditions = this.exprVisitor.eval(condition, expr);
                        }
                        conditions.successors.add(caseBlockStart);
                    }
                    continue;
                }
                SwitchDefaultNode ien = (SwitchDefaultNode)child;
                Block defaultBlockStart = conditions.addBranch();
                Block defaultBlockEnd = this.exec(defaultBlockStart, ien);
                branchEnds.add(defaultBlockEnd);
                hasDefault = true;
            }
            if (!hasDefault) {
                branchEnds.add(conditions);
            }
            this.current = Block.merge(branchEnds);
        }

        @Override
        protected void visitSwitchCaseNode(SwitchCaseNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitSwitchDefaultNode(SwitchDefaultNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitIfNode(IfNode node) {
            Block conditionFork = null;
            ArrayList<Block> branchEnds = new ArrayList<Block>();
            boolean hasElse = false;
            for (SoyNode child : node.getChildren()) {
                if (child instanceof IfCondNode) {
                    IfCondNode icn = (IfCondNode)child;
                    ExprRootNode conditionExpression = icn.getExpr();
                    if (conditionFork == null) {
                        this.evalInline(conditionExpression);
                        conditionFork = this.current;
                    } else {
                        conditionFork = this.exprVisitor.eval(conditionFork.addBranch(), conditionExpression);
                    }
                    Block branch = conditionFork.addBranch();
                    branch = this.exec(branch, icn);
                    branchEnds.add(branch);
                    continue;
                }
                IfElseNode ien = (IfElseNode)child;
                Block branch = conditionFork.addBranch();
                branch = this.exec(branch, ien);
                branchEnds.add(branch);
                hasElse = true;
            }
            if (!hasElse) {
                branchEnds.add(conditionFork);
            }
            this.current = Block.merge(branchEnds);
        }

        @Override
        protected void visitIfCondNode(IfCondNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitIfElseNode(IfElseNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitCssNode(CssNode node) {
            if (node.getComponentNameExpr() != null) {
                this.evalInline(node.getComponentNameExpr());
            }
        }

        @Override
        protected void visitXidNode(XidNode node) {
        }

        @Override
        protected void visitCallNode(CallNode node) {
            ExprRootNode dataExpr = node.getDataExpr();
            if (dataExpr != null) {
                this.evalInline(dataExpr);
            }
            Block begin = this.current;
            ArrayList<Block> branchEnds = new ArrayList<Block>();
            branchEnds.add(begin);
            for (CallParamNode param : node.getChildren()) {
                Block paramBranch = begin.addBranch();
                Block paramBranchEnd = this.exec(paramBranch, param);
                branchEnds.add(paramBranchEnd);
            }
            this.current = Block.merge(branchEnds);
        }

        @Override
        protected void visitCallParamValueNode(CallParamValueNode node) {
            this.evalInline(node.getExpr());
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
            if (node.numChildren() == 1) {
                this.visit((SoyNode)node.getChild(0));
            } else {
                Block normalBranch = this.current.addBranch();
                Block fallbackBranch = this.current.addBranch();
                normalBranch = this.exec(normalBranch, (SoyNode)node.getChild(0));
                fallbackBranch = this.exec(fallbackBranch, (SoyNode)node.getChild(1));
                this.current = Block.merge(normalBranch, fallbackBranch);
            }
        }

        @Override
        protected void visitMsgNode(MsgNode node) {
            this.evaluateMsgParts(node, (Iterable<? extends SoyMsgPart>)MsgUtils.buildMsgPartsAndComputeMsgIdForDualFormat((MsgNode)node).parts);
        }

        private void evaluateMsgParts(MsgNode msgNode, Iterable<? extends SoyMsgPart> parts) {
            for (SoyMsgPart soyMsgPart : parts) {
                if (soyMsgPart instanceof SoyMsgRawTextPart || soyMsgPart instanceof SoyMsgPluralRemainderPart) continue;
                if (soyMsgPart instanceof SoyMsgPluralPart) {
                    SoyMsgPluralPart plural = (SoyMsgPluralPart)soyMsgPart;
                    this.evalInline(msgNode.getRepPluralNode(plural.getPluralVarName()).getExpr());
                    for (SoyMsgPart.Case caseOrDefault : plural.getCases()) {
                        this.evaluateMsgParts(msgNode, (Iterable<? extends SoyMsgPart>)caseOrDefault.parts());
                    }
                    continue;
                }
                if (soyMsgPart instanceof SoyMsgSelectPart) {
                    SoyMsgSelectPart select = (SoyMsgSelectPart)soyMsgPart;
                    this.evalInline(msgNode.getRepSelectNode(select.getSelectVarName()).getExpr());
                    for (SoyMsgPart.Case caseOrDefault : select.getCases()) {
                        this.evaluateMsgParts(msgNode, (Iterable<? extends SoyMsgPart>)caseOrDefault.parts());
                    }
                    continue;
                }
                if (soyMsgPart instanceof SoyMsgPlaceholderPart) {
                    SoyMsgPlaceholderPart placeholder = (SoyMsgPlaceholderPart)soyMsgPart;
                    this.visit((SoyNode)msgNode.getRepPlaceholderNode(placeholder.getPlaceholderName()).getChild(0));
                    continue;
                }
                throw new AssertionError((Object)("unexpected part: " + soyMsgPart));
            }
        }

        @Override
        protected void visitMsgPlaceholderNode(MsgPlaceholderNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            throw new UnsupportedOperationException("unsupported node type: " + (Object)((Object)node.getKind()));
        }

        @Override
        protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
            super.visitChildren(node);
        }

        void evalInline(ExprNode expr) {
            Block end;
            Block begin = this.current;
            this.current = end = this.exprVisitor.eval(begin, expr);
        }
    }
}

