/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.CodeBuilder;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.LocalVariable;
import com.google.template.soy.jbcsrc.MethodRef;
import com.google.template.soy.jbcsrc.Statement;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class AppendableExpression
extends Expression {
    private static final MethodRef APPEND = MethodRef.create(AdvisingAppendable.class, "append", CharSequence.class).asNonNullable();
    private static final MethodRef APPEND_CHAR = MethodRef.create(AdvisingAppendable.class, "append", Character.TYPE).asNonNullable();
    private static final MethodRef SOFT_LIMITED = MethodRef.create(AdvisingAppendable.class, "softLimitReached", new Class[0]).asCheap();
    private final Expression delegate;
    private final boolean hasSideEffects;
    private final boolean supportsSoftLimiting;

    static AppendableExpression forLocal(LocalVariable delegate) {
        return new AppendableExpression(delegate, false, true);
    }

    static AppendableExpression forStringBuilder(Expression delegate) {
        Preconditions.checkArgument((boolean)delegate.resultType().equals((Object)BytecodeUtils.ADVISING_BUILDER_TYPE));
        return new AppendableExpression(BytecodeUtils.ADVISING_BUILDER_TYPE, delegate, false, false);
    }

    static AppendableExpression logger() {
        return new AppendableExpression(MethodRef.RUNTIME_LOGGER.invoke(new Expression[0]), false, false);
    }

    private AppendableExpression(Expression delegate, boolean hasSideEffects, boolean supportsSoftLimiting) {
        this(BytecodeUtils.ADVISING_APPENDABLE_TYPE, delegate, hasSideEffects, supportsSoftLimiting);
    }

    private AppendableExpression(Type resultType, Expression delegate, boolean hasSideEffects, boolean supportsSoftLimiting) {
        super(resultType, delegate.features());
        delegate.checkAssignableTo(BytecodeUtils.ADVISING_APPENDABLE_TYPE);
        Preconditions.checkArgument((boolean)delegate.isNonNullable(), (Object)"advising appendable expressions should always be non null");
        this.delegate = delegate;
        this.hasSideEffects = hasSideEffects;
        this.supportsSoftLimiting = supportsSoftLimiting;
    }

    @Override
    void doGen(CodeBuilder adapter) {
        this.delegate.gen(adapter);
    }

    AppendableExpression appendString(Expression exp) {
        return this.withNewDelegate(this.delegate.invoke(APPEND, exp), true);
    }

    AppendableExpression appendChar(Expression exp) {
        return this.withNewDelegate(this.delegate.invoke(APPEND_CHAR, exp), true);
    }

    Expression softLimitReached() {
        Preconditions.checkArgument((boolean)this.supportsSoftLimiting);
        return this.delegate.invoke(SOFT_LIMITED, new Expression[0]);
    }

    @Override
    AppendableExpression labelStart(Label label) {
        return this.withNewDelegate(this.delegate.labelStart(label), this.hasSideEffects);
    }

    @Override
    Statement toStatement() {
        if (this.hasSideEffects) {
            return super.toStatement();
        }
        return Statement.NULL_STATEMENT;
    }

    private AppendableExpression withNewDelegate(Expression newDelegate, boolean hasSideEffects) {
        return new AppendableExpression(newDelegate, hasSideEffects, this.supportsSoftLimiting);
    }

    boolean supportsSoftLimiting() {
        return this.supportsSoftLimiting;
    }
}

