/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.shared.restricted.SoyFunction;
import javax.annotation.Nullable;

public final class FunctionNode
extends AbstractParentExprNode {
    private final String functionName;
    @Nullable
    private SoyFunction soyFunction;

    public FunctionNode(String functionName, SourceLocation sourceLocation) {
        super(sourceLocation);
        this.functionName = functionName;
    }

    private FunctionNode(FunctionNode orig, CopyState copyState) {
        super(orig, copyState);
        this.functionName = orig.functionName;
        this.soyFunction = orig.soyFunction;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.FUNCTION_NODE;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    @Nullable
    public SoyFunction getSoyFunction() {
        return this.soyFunction;
    }

    public void setSoyFunction(SoyFunction soyFunction) {
        this.soyFunction = soyFunction;
    }

    @Override
    public String toSourceString() {
        StringBuilder sourceSb = new StringBuilder();
        sourceSb.append(this.functionName).append('(');
        boolean isFirst = true;
        for (ExprNode child : this.getChildren()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sourceSb.append(", ");
            }
            sourceSb.append(child.toSourceString());
        }
        sourceSb.append(')');
        return sourceSb.toString();
    }

    @Override
    public FunctionNode copy(CopyState copyState) {
        return new FunctionNode(this, copyState);
    }
}

