/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.template.soy.types.proto.ProtoFlavor;

public final class JavaQualifiedNames {
    private static final ImmutableMap<String, String> SPECIAL_CASES = ImmutableMap.builder().put((Object)"cached_size", (Object)"CachedSize_").put((Object)"class", (Object)"Class_").put((Object)"serialized_size", (Object)"SerializedSize_").build();

    private JavaQualifiedNames() {
    }

    public static String getPackage(Descriptors.FileDescriptor fileDescriptor) {
        return JavaQualifiedNames.getPackage(fileDescriptor, ProtoFlavor.PROTO2);
    }

    public static String getOuterClassname(Descriptors.FileDescriptor fileDescriptor) {
        return JavaQualifiedNames.getFileClassName(fileDescriptor, ProtoFlavor.PROTO2);
    }

    public static String getQualifiedName(Descriptors.Descriptor msg) {
        return JavaQualifiedNames.getClassName(msg).replace('$', '.');
    }

    public static String getQualifiedName(Descriptors.EnumDescriptor enumType) {
        return JavaQualifiedNames.getClassName(enumType).replace('$', '.');
    }

    public static String getClassName(Descriptors.Descriptor msg) {
        return JavaQualifiedNames.getClassName(msg, ProtoFlavor.PROTO2);
    }

    public static String getClassName(Descriptors.EnumDescriptor enumType) {
        return JavaQualifiedNames.getClassName(enumType, ProtoFlavor.PROTO2);
    }

    public static String getClassName(Descriptors.Descriptor descriptor, ProtoFlavor flavor) {
        return JavaQualifiedNames.getClassName(JavaQualifiedNames.classNameWithoutPackage(descriptor), descriptor.getFile(), flavor);
    }

    public static String getClassName(Descriptors.EnumDescriptor descriptor, ProtoFlavor flavor) {
        return JavaQualifiedNames.getClassName(JavaQualifiedNames.classNameWithoutPackage(descriptor), descriptor.getFile(), flavor);
    }

    public static String getFieldName(Descriptors.FieldDescriptor field, boolean capitializeFirstLetter) {
        String fieldName = field.getName();
        if (SPECIAL_CASES.containsKey((Object)fieldName)) {
            String output = (String)SPECIAL_CASES.get((Object)fieldName);
            if (capitializeFirstLetter) {
                return output;
            }
            return (char)(output.charAt(0) + 32) + output.substring(1);
        }
        return JavaQualifiedNames.underscoresToCamelCase(fieldName, capitializeFirstLetter);
    }

    public static String getCaseEnumClassName(Descriptors.OneofDescriptor oneOfDescriptor) {
        return JavaQualifiedNames.getClassName(oneOfDescriptor.getContainingType()) + '$' + JavaQualifiedNames.underscoresToCamelCase(oneOfDescriptor.getName(), true) + "Case";
    }

    public static String underscoresToCamelCase(String input, boolean capitializeNextLetter) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                if (capitializeNextLetter) {
                    result.append((char)(ch + -32));
                } else {
                    result.append(ch);
                }
                capitializeNextLetter = false;
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                if (i == 0 && !capitializeNextLetter) {
                    result.append((char)(ch + 32));
                } else {
                    result.append(ch);
                }
                capitializeNextLetter = false;
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                result.append(ch);
                capitializeNextLetter = true;
                continue;
            }
            capitializeNextLetter = true;
        }
        return result.toString();
    }

    private static String getClassName(String nameWithoutPackage, Descriptors.FileDescriptor file, ProtoFlavor flavor) {
        StringBuilder sb = new StringBuilder();
        if (JavaQualifiedNames.multipleJavaFiles(file, flavor)) {
            sb.append(JavaQualifiedNames.getPackage(file, flavor));
            if (sb.length() > 0) {
                sb.append('.');
            }
        } else {
            sb.append(JavaQualifiedNames.getClassName(file, flavor));
            if (sb.length() > 0) {
                sb.append('$');
            }
        }
        sb.append(nameWithoutPackage.replace('.', '$'));
        return sb.toString();
    }

    private static String getClassName(Descriptors.FileDescriptor file, ProtoFlavor flavor) {
        StringBuilder sb = new StringBuilder();
        sb.append(JavaQualifiedNames.getPackage(file, flavor));
        if (sb.length() > 0) {
            sb.append('.');
        }
        sb.append(JavaQualifiedNames.getFileClassName(file, flavor));
        return sb.toString();
    }

    static String getPackage(Descriptors.FileDescriptor file, ProtoFlavor flavor) {
        DescriptorProtos.FileOptions fileOptions = file.getOptions();
        StringBuilder sb = new StringBuilder();
        if (fileOptions.hasJavaPackage()) {
            sb.append(fileOptions.getJavaPackage());
        } else {
            sb.append("com.google.protos");
            if (!file.getPackage().isEmpty()) {
                sb.append('.').append(file.getPackage());
            }
        }
        return sb.toString();
    }

    private static String classNameWithoutPackage(Descriptors.Descriptor descriptor) {
        return JavaQualifiedNames.stripPackageName(descriptor.getFullName(), descriptor.getFile());
    }

    private static String classNameWithoutPackage(Descriptors.EnumDescriptor descriptor) {
        Descriptors.Descriptor messageDescriptor = descriptor.getContainingType();
        if (messageDescriptor == null) {
            return descriptor.getName();
        }
        return JavaQualifiedNames.classNameWithoutPackage(messageDescriptor) + '.' + descriptor.getName();
    }

    private static String stripPackageName(String fullName, Descriptors.FileDescriptor file) {
        if (file.getPackage().isEmpty()) {
            return fullName;
        }
        return fullName.substring(file.getPackage().length() + 1);
    }

    private static boolean multipleJavaFiles(Descriptors.FileDescriptor fd, ProtoFlavor flavor) {
        DescriptorProtos.FileOptions options = fd.getOptions();
        switch (flavor) {
            case PROTO2: {
                return options.getJavaMultipleFiles();
            }
        }
        throw new AssertionError();
    }

    static String getFileClassName(Descriptors.FileDescriptor file, ProtoFlavor flavor) {
        switch (flavor) {
            case PROTO2: {
                return JavaQualifiedNames.getFileImmutableClassName(file);
            }
        }
        throw new AssertionError();
    }

    private static String getFileImmutableClassName(Descriptors.FileDescriptor file) {
        if (file.getOptions().hasJavaOuterClassname()) {
            return file.getOptions().getJavaOuterClassname();
        }
        String className = JavaQualifiedNames.getFileDefaultImmutableClassName(file);
        if (JavaQualifiedNames.hasConflictingClassName(file, className)) {
            return className + "OuterClass";
        }
        return className;
    }

    private static String getFileDefaultImmutableClassName(Descriptors.FileDescriptor file) {
        String name = file.getName();
        int lastSlash = name.lastIndexOf(47);
        String basename = lastSlash < 0 ? name : name.substring(lastSlash + 1);
        return JavaQualifiedNames.underscoresToCamelCase(JavaQualifiedNames.stripProto(basename), true);
    }

    private static String stripProto(String filename) {
        int lastDot = filename.lastIndexOf(46);
        if (lastDot >= 0) {
            switch (filename.substring(lastDot)) {
                case ".protodevel": 
                case ".proto": {
                    return filename.substring(0, lastDot);
                }
            }
        }
        return filename;
    }

    private static boolean hasConflictingClassName(Descriptors.Descriptor messageDesc, String name) {
        if (name.equals(messageDesc.getName())) {
            return true;
        }
        for (Descriptors.EnumDescriptor enumDesc : messageDesc.getEnumTypes()) {
            if (!name.equals(enumDesc.getName())) continue;
            return true;
        }
        for (Descriptors.Descriptor nestedMessageDesc : messageDesc.getNestedTypes()) {
            if (!JavaQualifiedNames.hasConflictingClassName(nestedMessageDesc, name)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasConflictingClassName(Descriptors.FileDescriptor file, String name) {
        for (Descriptors.EnumDescriptor enumDesc : file.getEnumTypes()) {
            if (!name.equals(enumDesc.getName())) continue;
            return true;
        }
        for (Descriptors.ServiceDescriptor serviceDesc : file.getServices()) {
            if (!name.equals(serviceDesc.getName())) continue;
            return true;
        }
        for (Descriptors.Descriptor messageDesc : file.getMessageTypes()) {
            if (!JavaQualifiedNames.hasConflictingClassName(messageDesc, name)) continue;
            return true;
        }
        return false;
    }
}

