/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.aggregate.ListType;
import com.google.template.soy.types.aggregate.MapType;
import com.google.template.soy.types.primitive.BoolType;
import com.google.template.soy.types.primitive.FloatType;
import com.google.template.soy.types.primitive.IntType;
import com.google.template.soy.types.primitive.StringType;
import com.google.template.soy.types.proto.Protos;
import com.google.template.soy.types.proto.SafeStringTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

abstract class FieldInterpreter {
    private static final FieldInterpreter BYTES = new FieldInterpreter(){

        @Override
        public SoyValueProvider soyFromProto(SoyValueConverter converter, Object field) {
            return StringData.forValue(BaseEncoding.base64().encode(((ByteString)field).toByteArray()));
        }

        @Override
        public SoyType type() {
            return StringType.getInstance();
        }

        @Override
        Object protoFromSoy(SoyValue field) {
            return ByteString.copyFrom((byte[])BaseEncoding.base64().decode((CharSequence)field.stringValue()));
        }
    };
    private static final FieldInterpreter BOOL = new FieldInterpreter(){

        @Override
        public SoyValueProvider soyFromProto(SoyValueConverter converter, Object field) {
            return BooleanData.forValue((Boolean)field);
        }

        @Override
        public SoyType type() {
            return BoolType.getInstance();
        }

        @Override
        Object protoFromSoy(SoyValue field) {
            return field.booleanValue();
        }
    };
    private static final FieldInterpreter INT = new FieldInterpreter(){

        @Override
        public SoyValueProvider soyFromProto(SoyValueConverter converter, Object field) {
            return IntegerData.forValue(((Number)field).longValue());
        }

        @Override
        public SoyType type() {
            return IntType.getInstance();
        }

        @Override
        Object protoFromSoy(SoyValue field) {
            return field.integerValue();
        }
    };
    private static final FieldInterpreter LONG_AS_INT = new FieldInterpreter(){

        @Override
        public SoyValueProvider soyFromProto(SoyValueConverter converter, Object field) {
            return IntegerData.forValue((Long)field);
        }

        @Override
        public SoyType type() {
            return IntType.getInstance();
        }

        @Override
        Object protoFromSoy(SoyValue field) {
            return field.longValue();
        }
    };
    private static final FieldInterpreter LONG_AS_STRING = new FieldInterpreter(){

        @Override
        public SoyValueProvider soyFromProto(SoyValueConverter converter, Object field) {
            return StringData.forValue(field.toString());
        }

        @Override
        public SoyType type() {
            return StringType.getInstance();
        }

        @Override
        Object protoFromSoy(SoyValue field) {
            return Long.parseLong(field.stringValue());
        }
    };
    private static final FieldInterpreter FLOAT = new FieldInterpreter(){

        @Override
        public SoyValueProvider soyFromProto(SoyValueConverter converter, Object field) {
            return FloatData.forValue(((Float)field).floatValue());
        }

        @Override
        public SoyType type() {
            return FloatType.getInstance();
        }

        @Override
        Object protoFromSoy(SoyValue field) {
            return Float.valueOf((float)field.floatValue());
        }
    };
    private static final FieldInterpreter DOUBLE_AS_FLOAT = new FieldInterpreter(){

        @Override
        public SoyValueProvider soyFromProto(SoyValueConverter converter, Object field) {
            return FloatData.forValue((Double)field);
        }

        @Override
        public SoyType type() {
            return FloatType.getInstance();
        }

        @Override
        Object protoFromSoy(SoyValue field) {
            return field.floatValue();
        }
    };
    private static final FieldInterpreter STRING = new FieldInterpreter(){

        @Override
        public SoyValueProvider soyFromProto(SoyValueConverter converter, Object field) {
            return StringData.forValue(field.toString());
        }

        @Override
        public SoyType type() {
            return StringType.getInstance();
        }

        @Override
        Object protoFromSoy(SoyValue field) {
            return field.stringValue();
        }
    };

    static FieldInterpreter create(SoyTypeRegistry typeRegistry, Descriptors.FieldDescriptor fieldDescriptor) {
        FieldInterpreter field = FieldInterpreter.getScalarType(typeRegistry, fieldDescriptor);
        if (fieldDescriptor.isRepeated()) {
            if (Protos.hasJsMapKey(fieldDescriptor)) {
                return FieldInterpreter.getMapType(typeRegistry, field, fieldDescriptor);
            }
            return FieldInterpreter.getListType(typeRegistry, field);
        }
        return field;
    }

    private static FieldInterpreter getListType(SoyTypeRegistry typeRegistry, final FieldInterpreter local) {
        final ListType listType = typeRegistry.getOrCreateListType(local.type());
        return new FieldInterpreter(){

            @Override
            public SoyValueProvider soyFromProto(SoyValueConverter converter, Object field) {
                List entries = (List)field;
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Object item : entries) {
                    builder.add((Object)local.soyFromProto(converter, item));
                }
                return ListImpl.forProviderList((ImmutableList<? extends SoyValueProvider>)builder.build());
            }

            @Override
            public SoyType type() {
                return listType;
            }

            @Override
            Object protoFromSoy(SoyValue field) {
                SoyList list = (SoyList)field;
                ArrayList<Object> uninterpretedValues = new ArrayList<Object>();
                for (SoyValue soyValue : list.asResolvedJavaList()) {
                    uninterpretedValues.add(local.protoFromSoy(soyValue));
                }
                return uninterpretedValues;
            }
        };
    }

    private static FieldInterpreter getMapType(SoyTypeRegistry typeRegistry, final FieldInterpreter scalarImpl, Descriptors.FieldDescriptor fieldDescriptor) {
        String keyFieldName = Protos.getJsMapKeyFieldName(fieldDescriptor);
        final Descriptors.FieldDescriptor keyDescriptor = fieldDescriptor.getMessageType().findFieldByName(keyFieldName);
        if (keyDescriptor == null) {
            throw new IllegalArgumentException("Cannot find field with name \"" + keyFieldName + "\".");
        }
        if (keyDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.STRING || keyDescriptor.isRepeated()) {
            throw new IllegalArgumentException("\"" + keyFieldName + "\" must be an optional/required string field.");
        }
        final MapType type = typeRegistry.getOrCreateMapType(StringType.getInstance(), scalarImpl.type());
        return new FieldInterpreter(){

            @Override
            public SoyValueProvider soyFromProto(SoyValueConverter converter, Object field) {
                List entries = (List)field;
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Message message : entries) {
                    String key = (String)message.getField(keyDescriptor);
                    if (key.isEmpty()) continue;
                    builder.put((Object)key, (Object)scalarImpl.soyFromProto(converter, message));
                }
                return DictImpl.forProviderMap((Map<String, ? extends SoyValueProvider>)builder.build());
            }

            @Override
            public SoyType type() {
                return type;
            }

            @Override
            Object protoFromSoy(SoyValue field) {
                throw new UnsupportedOperationException("assigning to mapkey fields is not currently supported");
            }
        };
    }

    private static FieldInterpreter getScalarType(SoyTypeRegistry typeRegistry, Descriptors.FieldDescriptor fieldDescriptor) {
        if (Protos.hasJsType(fieldDescriptor)) {
            Protos.JsType jsType = Protos.getJsType(fieldDescriptor);
            switch (jsType) {
                case INT52: 
                case NUMBER: {
                    return LONG_AS_INT;
                }
                case STRING: {
                    return LONG_AS_STRING;
                }
            }
        }
        switch (fieldDescriptor.getType()) {
            case BOOL: {
                return BOOL;
            }
            case DOUBLE: {
                return DOUBLE_AS_FLOAT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case BYTES: {
                return BYTES;
            }
            case GROUP: {
                throw new UnsupportedOperationException("soy doesn't support proto groups: " + fieldDescriptor.getFullName());
            }
            case INT64: {
                return LONG_AS_INT;
            }
            case INT32: 
            case SINT32: 
            case UINT32: 
            case FIXED32: 
            case SFIXED32: {
                return INT;
            }
            case FIXED64: 
            case SINT64: 
            case SFIXED64: 
            case UINT64: {
                throw new IllegalArgumentException(fieldDescriptor.getFullName() + ": 64-bit integer types are not supported.  " + "Instead, add [(jspb.jstype) = INT52] to the field.");
            }
            case ENUM: {
                return FieldInterpreter.dynamicTypeField(fieldDescriptor, typeRegistry.getType(fieldDescriptor.getEnumType().getFullName()));
            }
            case MESSAGE: {
                return FieldInterpreter.dynamicTypeField(fieldDescriptor, typeRegistry.getType(fieldDescriptor.getMessageType().getFullName()));
            }
            case STRING: {
                return STRING;
            }
        }
        throw new AssertionError((Object)"Unexpected field type in proto");
    }

    private static final FieldInterpreter dynamicTypeField(final Descriptors.FieldDescriptor fieldDescriptor, final SoyType type) {
        Preconditions.checkNotNull((Object)type);
        return new FieldInterpreter(){

            @Override
            public SoyType type() {
                return type;
            }

            @Override
            public SoyValueProvider soyFromProto(SoyValueConverter converter, Object field) {
                return converter.convert(field);
            }

            @Override
            Object protoFromSoy(SoyValue field) {
                if (type.getKind() == SoyType.Kind.PROTO_ENUM) {
                    Descriptors.EnumDescriptor enumDescriptor = fieldDescriptor.getEnumType();
                    int value = field.integerValue();
                    if (fieldDescriptor.getFile().getSyntax() == Descriptors.FileDescriptor.Syntax.PROTO3) {
                        return enumDescriptor.findValueByNumberCreatingIfUnknown(value);
                    }
                    return enumDescriptor.findValueByNumber(value);
                }
                if (type.getKind() == SoyType.Kind.PROTO) {
                    return ((SoyProtoValue)field).getProto();
                }
                if (type.getKind().isKnownSanitizedContent()) {
                    return SafeStringTypes.convertToProto((SanitizedContent)field, fieldDescriptor.getMessageType().getFullName());
                }
                throw new AssertionError((Object)("unexpected soyType: " + type));
            }
        };
    }

    private FieldInterpreter() {
    }

    abstract SoyType type();

    abstract SoyValueProvider soyFromProto(SoyValueConverter var1, Object var2);

    abstract Object protoFromSoy(SoyValue var1);
}

