/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchDefaultNode;

public final class SwitchNode
extends AbstractParentCommandNode<SoyNode.BlockNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<SoyNode.BlockNode>,
SoyNode.StatementNode,
SoyNode.ExprHolderNode {
    private final ExprRootNode expr;

    public SwitchNode(int id, SourceLocation location, ExprNode expr) {
        super(id, location, "switch", expr.toSourceString());
        this.expr = new ExprRootNode(expr);
    }

    private SwitchNode(SwitchNode orig, CopyState copyState) {
        super(orig, copyState);
        this.expr = orig.expr.copy(copyState);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.SWITCH_NODE;
    }

    public boolean hasDefaultCase() {
        return this.numChildren() > 0 && this.getChild(this.numChildren() - 1) instanceof SwitchDefaultNode;
    }

    public String getExprText() {
        return this.expr.toSourceString();
    }

    public ExprRootNode getExpr() {
        return this.expr;
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.expr);
    }

    @Override
    public String getCommandText() {
        return this.expr.toSourceString();
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public SwitchNode copy(CopyState copyState) {
        return new SwitchNode(this, copyState);
    }
}

