/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.StrictHtmlMode;
import java.util.List;
import javax.annotation.Nullable;

public final class NamespaceDeclaration {
    private static final AutoescapeMode DEFAULT_FILE_WIDE_DEFAULT_AUTOESCAPE_MODE = AutoescapeMode.STRICT;
    private final Identifier namespace;
    @Nullable
    private final AutoescapeMode autoescapeMode;
    @Nullable
    private final SourceLocation autoescapeModeLocation;
    private final ImmutableList<String> requiredCssNamespaces;
    private final String cssBaseNamespace;
    private final StrictHtmlMode strictHtml;
    @Nullable
    private final SourceLocation strictHtmlLocation;
    final ImmutableList<CommandTagAttribute> attrs;

    public NamespaceDeclaration(Identifier namespace, List<CommandTagAttribute> attrs, ErrorReporter errorReporter) {
        AutoescapeMode autoescapeMode = null;
        SourceLocation autoescapeModeLocation = null;
        ImmutableList<String> requiredCssNamespaces = ImmutableList.of();
        String cssBaseNamespace = null;
        StrictHtmlMode strictHtml = StrictHtmlMode.UNSET;
        SourceLocation strictHtmlLocation = null;
        block12: for (CommandTagAttribute attr : attrs) {
            switch (attr.getName().identifier()) {
                case "autoescape": {
                    autoescapeMode = attr.valueAsAutoescapeMode(errorReporter);
                    autoescapeModeLocation = attr.getValueLocation();
                    continue block12;
                }
                case "requirecss": {
                    requiredCssNamespaces = attr.valueAsRequireCss(errorReporter);
                    continue block12;
                }
                case "cssbase": {
                    cssBaseNamespace = attr.getValue();
                    continue block12;
                }
                case "stricthtml": {
                    strictHtml = attr.valueAsStrictHtmlMode(errorReporter);
                    strictHtmlLocation = attr.getValueLocation();
                    continue block12;
                }
            }
            errorReporter.report(attr.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, attr.getName().identifier(), ImmutableList.of((Object)"autoescape", (Object)"cssbase", (Object)"requirecss", (Object)"stricthtml"));
        }
        this.namespace = namespace;
        this.autoescapeMode = autoescapeMode;
        this.autoescapeModeLocation = autoescapeModeLocation;
        this.requiredCssNamespaces = requiredCssNamespaces;
        this.cssBaseNamespace = cssBaseNamespace;
        this.strictHtml = strictHtml;
        this.strictHtmlLocation = strictHtmlLocation;
        this.attrs = ImmutableList.copyOf(attrs);
    }

    public AutoescapeMode getDefaultAutoescapeMode() {
        return this.autoescapeMode == null ? DEFAULT_FILE_WIDE_DEFAULT_AUTOESCAPE_MODE : this.autoescapeMode;
    }

    public SourceLocation getAutoescapeModeLocation() {
        Preconditions.checkState((this.autoescapeModeLocation != null ? 1 : 0) != 0, (Object)"there is no autoescape attribute");
        return this.autoescapeModeLocation;
    }

    public String getNamespace() {
        return this.namespace.identifier();
    }

    ImmutableList<String> getRequiredCssNamespaces() {
        return this.requiredCssNamespaces;
    }

    @Nullable
    String getCssBaseNamespace() {
        return this.cssBaseNamespace;
    }

    public StrictHtmlMode getStrictHtmlMode() {
        return this.strictHtml;
    }

    public SourceLocation getStrictHtmlModeLocation() {
        Preconditions.checkState((this.strictHtmlLocation != null ? 1 : 0) != 0, (Object)"there is no stricthtml attribute");
        return this.strictHtmlLocation;
    }

    public String toSourceString() {
        return "{namespace " + this.namespace.identifier() + (this.attrs.isEmpty() ? "" : " " + Joiner.on((char)' ').join(this.attrs)) + "}\n";
    }
}

