/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.MsgSubstUnitBaseVarNameUtils;
import com.google.template.soy.soytree.SoyNode;
import javax.annotation.Nullable;

public final class MsgSelectNode
extends AbstractParentCommandNode<CaseOrDefaultNode>
implements SoyNode.MsgSubstUnitNode,
SoyNode.SplitLevelTopNode<CaseOrDefaultNode>,
SoyNode.ExprHolderNode {
    public static final String FALLBACK_BASE_SELECT_VAR_NAME = "STATUS";
    private final ExprRootNode selectExpr;
    private final String baseSelectVarName;

    private MsgSelectNode(int id, String commandText, ExprRootNode selectExpr, SourceLocation sourceLocation) {
        super(id, sourceLocation, "select", commandText);
        this.selectExpr = selectExpr;
        this.baseSelectVarName = MsgSubstUnitBaseVarNameUtils.genNaiveBaseNameForExpr(selectExpr.getRoot(), FALLBACK_BASE_SELECT_VAR_NAME);
    }

    public MsgSelectNode(int id, SourceLocation sourceLocation, ExprRootNode selectExpr, @Nullable String baseSelectVarName) {
        super(id, sourceLocation, "select", selectExpr.toSourceString() + (baseSelectVarName != null ? " phname=\"" + baseSelectVarName + "\"" : ""));
        this.selectExpr = selectExpr;
        this.baseSelectVarName = baseSelectVarName != null ? baseSelectVarName : MsgSubstUnitBaseVarNameUtils.genNaiveBaseNameForExpr(selectExpr.getRoot(), FALLBACK_BASE_SELECT_VAR_NAME);
    }

    private MsgSelectNode(MsgSelectNode orig, CopyState copyState) {
        super(orig, copyState);
        this.selectExpr = orig.selectExpr.copy(copyState);
        this.baseSelectVarName = orig.baseSelectVarName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_SELECT_NODE;
    }

    public ExprRootNode getExpr() {
        return this.selectExpr;
    }

    @Override
    public String getBaseVarName() {
        return this.baseSelectVarName;
    }

    @Override
    public boolean shouldUseSameVarNameAs(SoyNode.MsgSubstUnitNode other) {
        return other instanceof MsgSelectNode && this.getCommandText().equals(((MsgSelectNode)other).getCommandText());
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.selectExpr);
    }

    @Override
    public SoyNode.MsgBlockNode getParent() {
        return (SoyNode.MsgBlockNode)super.getParent();
    }

    @Override
    public MsgSelectNode copy(CopyState copyState) {
        return new MsgSelectNode(this, copyState);
    }

    public static final class Builder {
        private final int id;
        private final String commandText;
        private final SourceLocation sourceLocation;

        public Builder(int id, String commandText, SourceLocation sourceLocation) {
            this.id = id;
            this.commandText = commandText;
            this.sourceLocation = sourceLocation;
        }

        public MsgSelectNode build(SoyParsingContext context) {
            ExprNode selectExpr = new ExpressionParser(this.commandText, this.sourceLocation, context).parseExpression();
            return new MsgSelectNode(this.id, this.commandText, new ExprRootNode(selectExpr), this.sourceLocation);
        }
    }
}

