/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.MsgSubstUnitBaseVarNameUtils;
import com.google.template.soy.soytree.SoyNode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MsgPluralNode
extends AbstractParentCommandNode<CaseOrDefaultNode>
implements SoyNode.MsgSubstUnitNode,
SoyNode.SplitLevelTopNode<CaseOrDefaultNode>,
SoyNode.ExprHolderNode {
    private static final SoyErrorKind INVALID_PLURAL_COMMAND_TEXT = SoyErrorKind.of("Invalid ''plural'' command text \"{0}\".");
    private static final SoyErrorKind PLURAL_OFFSET_OUT_OF_BOUNDS = SoyErrorKind.of("The ''offset'' for plural must be a nonnegative integer.");
    private static final SoyErrorKind MALFORMED_PLURAL_OFFSET = SoyErrorKind.of("Invalid offset in ''plural'' command text \"{0}\".");
    private static final Pattern COMMAND_TEXT_PATTERN = Pattern.compile("(.+?) ( \\s+ offset= .+ )?", 4);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("plural", new CommandTextAttributesParser.Attribute("offset", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null));
    public static final String FALLBACK_BASE_PLURAL_VAR_NAME = "NUM";
    private final int offset;
    private final ExprRootNode pluralExpr;
    private final String basePluralVarName;

    private MsgPluralNode(int id, SourceLocation sourceLocation, String commandText, int offset, ExprRootNode pluralExpr, String basePluralVarName) {
        super(id, sourceLocation, "plural", commandText);
        this.offset = offset;
        this.pluralExpr = pluralExpr;
        this.basePluralVarName = basePluralVarName;
    }

    private MsgPluralNode(MsgPluralNode orig, CopyState copyState) {
        super(orig, copyState);
        this.offset = orig.offset;
        this.pluralExpr = orig.pluralExpr.copy(copyState);
        this.basePluralVarName = orig.basePluralVarName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_PLURAL_NODE;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getExprText() {
        return this.pluralExpr.toSourceString();
    }

    public ExprRootNode getExpr() {
        return this.pluralExpr;
    }

    @Override
    public String getBaseVarName() {
        return this.basePluralVarName;
    }

    @Override
    public boolean shouldUseSameVarNameAs(SoyNode.MsgSubstUnitNode other) {
        return other instanceof MsgPluralNode && this.getCommandText().equals(((MsgPluralNode)other).getCommandText());
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.pluralExpr);
    }

    @Override
    public SoyNode.MsgBlockNode getParent() {
        return (SoyNode.MsgBlockNode)super.getParent();
    }

    @Override
    public MsgPluralNode copy(CopyState copyState) {
        return new MsgPluralNode(this, copyState);
    }

    public static final class Builder {
        private final int id;
        private final String commandText;
        private final SourceLocation sourceLocation;

        private static MsgPluralNode error() {
            return new Builder(-1, "plural", SourceLocation.UNKNOWN).build(SoyParsingContext.exploding());
        }

        public Builder(int id, String commandText, SourceLocation sourceLocation) {
            this.id = id;
            this.commandText = commandText;
            this.sourceLocation = sourceLocation;
        }

        public MsgPluralNode build(SoyParsingContext context) {
            ErrorReporter.Checkpoint checkpoint = context.errorReporter().checkpoint();
            Matcher matcher = COMMAND_TEXT_PATTERN.matcher(this.commandText);
            if (!matcher.matches()) {
                context.report(this.sourceLocation, INVALID_PLURAL_COMMAND_TEXT, this.commandText);
            }
            ExprNode pluralExpr = new ExpressionParser(matcher.group(1), this.sourceLocation, context).parseExpression();
            int offset = 0;
            if (matcher.group(2) != null) {
                try {
                    Map<String, String> attributes = ATTRIBUTES_PARSER.parse(matcher.group(2).trim(), context, this.sourceLocation);
                    String offsetAttribute = attributes.get("offset");
                    offset = Integer.parseInt(offsetAttribute);
                    if (offset < 0) {
                        context.report(this.sourceLocation, PLURAL_OFFSET_OUT_OF_BOUNDS, new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    context.report(this.sourceLocation, MALFORMED_PLURAL_OFFSET, this.commandText);
                }
            }
            String basePluralVarName = MsgSubstUnitBaseVarNameUtils.genNaiveBaseNameForExpr(pluralExpr, MsgPluralNode.FALLBACK_BASE_PLURAL_VAR_NAME);
            if (context.errorReporter().errorsSince(checkpoint)) {
                return Builder.error();
            }
            return new MsgPluralNode(this.id, this.sourceLocation, this.commandText, offset, new ExprRootNode(pluralExpr), basePluralVarName);
        }
    }
}

