/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class MsgNode
extends AbstractBlockCommandNode
implements SoyNode.ExprHolderNode,
SoyNode.MsgBlockNode {
    static final SoyErrorKind WRONG_NUMBER_OF_GENDER_EXPRS = SoyErrorKind.of("Attribute ''genders'' does not contain 1-3 expressions");
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("msg", new CommandTextAttributesParser.Attribute("genders", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("meaning", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("desc", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, "__NDVBR__"), new CommandTextAttributesParser.Attribute("hidden", (Collection<String>)CommandTextAttributesParser.Attribute.BOOLEAN_VALUES, "false"));
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    @Nullable
    private List<ExprRootNode> genderExprs;
    private final String meaning;
    private final String desc;
    private final boolean isHidden;
    private SubstUnitInfo substUnitInfo = null;

    public static Builder msg(int id, String commandText, SourceLocation sourceLocation) {
        return new Builder(id, "msg", commandText, sourceLocation);
    }

    public static Builder fallbackmsg(int id, String commandText, SourceLocation sourceLocation) {
        return new Builder(id, "fallbackmsg", commandText, sourceLocation);
    }

    private MsgNode(int id, SourceLocation sourceLocation, @Nullable List<ExprRootNode> genderExprs, String commandName, String commandText, String meaning, String desc, boolean isHidden) {
        super(id, sourceLocation, commandName, commandText);
        this.genderExprs = genderExprs;
        this.meaning = meaning;
        this.desc = desc;
        this.isHidden = isHidden;
    }

    private MsgNode(MsgNode orig, CopyState copyState) {
        super(orig, copyState);
        if (orig.genderExprs != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ExprRootNode node : orig.genderExprs) {
                builder.add((Object)node.copy(copyState));
            }
            this.genderExprs = builder.build();
        } else {
            this.genderExprs = null;
        }
        this.meaning = orig.meaning;
        this.desc = orig.desc;
        this.isHidden = orig.isHidden;
        this.substUnitInfo = MsgNode.genSubstUnitInfo(this);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_NODE;
    }

    @Nullable
    public List<ExprRootNode> getAndRemoveGenderExprs() {
        List<ExprRootNode> genderExprs = this.genderExprs;
        this.genderExprs = null;
        return genderExprs;
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        if (this.genderExprs != null) {
            throw new AssertionError();
        }
        return ImmutableList.of();
    }

    @Nullable
    public String getMeaning() {
        return this.meaning;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public String getContentType() {
        return DEFAULT_CONTENT_TYPE;
    }

    public boolean isPlrselMsg() {
        return this.isSelectMsg() || this.isPluralMsg();
    }

    public boolean isSelectMsg() {
        return this.getChildren().size() == 1 && this.getChild(0) instanceof MsgSelectNode;
    }

    public boolean isPluralMsg() {
        return this.getChildren().size() == 1 && this.getChild(0) instanceof MsgPluralNode;
    }

    public boolean isRawTextMsg() {
        return this.getChildren().size() == 1 && this.getChild(0) instanceof RawTextNode;
    }

    public MsgPlaceholderNode getRepPlaceholderNode(String placeholderName) {
        if (this.substUnitInfo == null) {
            this.substUnitInfo = MsgNode.genSubstUnitInfo(this);
        }
        return (MsgPlaceholderNode)this.substUnitInfo.varNameToRepNodeMap.get((Object)placeholderName);
    }

    public String getPlaceholderName(MsgPlaceholderNode placeholderNode) {
        if (this.substUnitInfo == null) {
            this.substUnitInfo = MsgNode.genSubstUnitInfo(this);
        }
        return (String)this.substUnitInfo.nodeToVarNameMap.get((Object)placeholderNode);
    }

    public MsgPluralNode getRepPluralNode(String pluralVarName) {
        if (this.substUnitInfo == null) {
            this.substUnitInfo = MsgNode.genSubstUnitInfo(this);
        }
        return (MsgPluralNode)this.substUnitInfo.varNameToRepNodeMap.get((Object)pluralVarName);
    }

    public String getPluralVarName(MsgPluralNode pluralNode) {
        if (this.substUnitInfo == null) {
            this.substUnitInfo = MsgNode.genSubstUnitInfo(this);
        }
        return (String)this.substUnitInfo.nodeToVarNameMap.get((Object)pluralNode);
    }

    public MsgSelectNode getRepSelectNode(String selectVarName) {
        if (this.substUnitInfo == null) {
            this.substUnitInfo = MsgNode.genSubstUnitInfo(this);
        }
        return (MsgSelectNode)this.substUnitInfo.varNameToRepNodeMap.get((Object)selectVarName);
    }

    public String getSelectVarName(MsgSelectNode selectNode) {
        if (this.substUnitInfo == null) {
            this.substUnitInfo = MsgNode.genSubstUnitInfo(this);
        }
        return (String)this.substUnitInfo.nodeToVarNameMap.get((Object)selectNode);
    }

    public ImmutableMap<String, SoyNode.MsgSubstUnitNode> getVarNameToRepNodeMap() {
        if (this.substUnitInfo == null) {
            this.substUnitInfo = MsgNode.genSubstUnitInfo(this);
        }
        return this.substUnitInfo.varNameToRepNodeMap;
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTagString());
        this.appendSourceStringForChildren(sb);
        return sb.toString();
    }

    @Override
    public MsgNode copy(CopyState copyState) {
        return new MsgNode(this, copyState);
    }

    private static SubstUnitInfo genSubstUnitInfo(MsgNode msgNode) {
        return MsgNode.genFinalSubstUnitInfoMapsHelper(MsgNode.genPrelimSubstUnitInfoMapsHelper(msgNode));
    }

    private static Pair<ListMultimap<String, SoyNode.MsgSubstUnitNode>, Map<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode>> genPrelimSubstUnitInfoMapsHelper(MsgNode msgNode) {
        LinkedListMultimap baseNameToRepNodesMap = LinkedListMultimap.create();
        HashMap<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode> nonRepNodeToRepNodeMap = new HashMap<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode>();
        ArrayDeque<SoyNode.MsgSubstUnitNode> traversalQueue = new ArrayDeque<SoyNode.MsgSubstUnitNode>();
        for (SoyNode child : msgNode.getChildren()) {
            if (!(child instanceof SoyNode.MsgSubstUnitNode)) continue;
            traversalQueue.add((SoyNode.MsgSubstUnitNode)child);
        }
        while (!traversalQueue.isEmpty()) {
            String baseName;
            SoyNode.MsgSubstUnitNode node = (SoyNode.MsgSubstUnitNode)traversalQueue.remove();
            if (node instanceof MsgSelectNode || node instanceof MsgPluralNode) {
                for (CaseOrDefaultNode child : ((SoyNode.ParentSoyNode)((Object)node)).getChildren()) {
                    for (SoyNode grandchild : child.getChildren()) {
                        if (!(grandchild instanceof SoyNode.MsgSubstUnitNode)) continue;
                        traversalQueue.add((SoyNode.MsgSubstUnitNode)grandchild);
                    }
                }
            }
            if (!baseNameToRepNodesMap.containsKey((Object)(baseName = node.getBaseVarName()))) {
                baseNameToRepNodesMap.put((Object)baseName, (Object)node);
                continue;
            }
            boolean isNew = true;
            for (SoyNode.MsgSubstUnitNode other : baseNameToRepNodesMap.get((Object)baseName)) {
                if (!node.shouldUseSameVarNameAs(other)) continue;
                nonRepNodeToRepNodeMap.put(node, other);
                isNew = false;
                break;
            }
            if (!isNew) continue;
            baseNameToRepNodesMap.put((Object)baseName, (Object)node);
        }
        return Pair.of(baseNameToRepNodesMap, nonRepNodeToRepNodeMap);
    }

    private static SubstUnitInfo genFinalSubstUnitInfoMapsHelper(Pair<ListMultimap<String, SoyNode.MsgSubstUnitNode>, Map<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode>> prelimMaps) {
        ListMultimap baseNameToRepNodesMap = (ListMultimap)prelimMaps.first;
        Map nonRepNodeToRepNodeMap = (Map)prelimMaps.second;
        LinkedHashMap<String, Object> substUnitVarNameToRepNodeMap = new LinkedHashMap<String, Object>();
        for (String baseName : baseNameToRepNodesMap.keys()) {
            List nodesWithSameBaseName = baseNameToRepNodesMap.get((Object)baseName);
            if (nodesWithSameBaseName.size() == 1) {
                substUnitVarNameToRepNodeMap.put(baseName, nodesWithSameBaseName.get(0));
                continue;
            }
            int nextSuffix = 1;
            for (SoyNode.MsgSubstUnitNode repNode : nodesWithSameBaseName) {
                String newName;
                do {
                    newName = baseName + "_" + nextSuffix;
                    ++nextSuffix;
                } while (baseNameToRepNodesMap.containsKey((Object)newName));
                substUnitVarNameToRepNodeMap.put(newName, repNode);
            }
        }
        LinkedHashMap<Object, Object> substUnitNodeToVarNameMap = new LinkedHashMap<Object, Object>();
        for (Map.Entry entry : substUnitVarNameToRepNodeMap.entrySet()) {
            substUnitNodeToVarNameMap.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry entry : nonRepNodeToRepNodeMap.entrySet()) {
            SoyNode.MsgSubstUnitNode nonRepNode = (SoyNode.MsgSubstUnitNode)entry.getKey();
            SoyNode.MsgSubstUnitNode repNode = (SoyNode.MsgSubstUnitNode)entry.getValue();
            substUnitNodeToVarNameMap.put(nonRepNode, substUnitNodeToVarNameMap.get(repNode));
        }
        return new SubstUnitInfo((ImmutableMap<String, SoyNode.MsgSubstUnitNode>)ImmutableMap.copyOf(substUnitVarNameToRepNodeMap), (ImmutableMap<SoyNode.MsgSubstUnitNode, String>)ImmutableMap.copyOf(substUnitNodeToVarNameMap));
    }

    public static final class Builder {
        private final int id;
        private final String commandName;
        private final String commandText;
        private final SourceLocation sourceLocation;

        private Builder(int id, String commandName, String commandText, SourceLocation sourceLocation) {
            this.id = id;
            this.commandName = commandName;
            this.commandText = commandText;
            this.sourceLocation = sourceLocation;
        }

        public MsgNode build(SoyParsingContext context) {
            Map<String, String> attributes = ATTRIBUTES_PARSER.parse(this.commandText, context, this.sourceLocation);
            String gendersAttr = attributes.get("genders");
            ImmutableList<ExprRootNode> genderExprs = null;
            if (gendersAttr != null && ((genderExprs = ExprRootNode.wrap(new ExpressionParser(gendersAttr, this.sourceLocation, context).parseExpressionList())).isEmpty() || genderExprs.size() > 3)) {
                context.report(this.sourceLocation, WRONG_NUMBER_OF_GENDER_EXPRS, new Object[0]);
            }
            String meaning = attributes.get("meaning");
            String desc = attributes.get("desc");
            boolean isHidden = attributes.get("hidden").equals("true");
            return new MsgNode(this.id, this.sourceLocation, (List)genderExprs, this.commandName, this.commandText, meaning, desc, isHidden);
        }
    }

    private static class SubstUnitInfo {
        public final ImmutableMap<String, SoyNode.MsgSubstUnitNode> varNameToRepNodeMap;
        public final ImmutableMap<SoyNode.MsgSubstUnitNode, String> nodeToVarNameMap;

        public SubstUnitInfo(ImmutableMap<String, SoyNode.MsgSubstUnitNode> varNameToRepNodeMap, ImmutableMap<SoyNode.MsgSubstUnitNode, String> nodeToVarNameMap) {
            this.varNameToRepNodeMap = varNameToRepNodeMap;
            this.nodeToVarNameMap = nodeToVarNameMap;
        }
    }
}

