/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.defn.LocalVar;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class LetNode
extends AbstractCommandNode
implements SoyNode.StandaloneNode,
SoyNode.StatementNode,
SoyNode.LocalVarInlineNode {
    public static final SoyErrorKind INVALID_COMMAND_TEXT = SoyErrorKind.of("Invalid ''let'' command text.");
    private static final Pattern COMMAND_TEXT_PATTERN = Pattern.compile("( [$] \\w+ ) (?: \\s* : \\s* (\\S .*) | \\s+ (\\S .*) )?", 36);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("let", new CommandTextAttributesParser.Attribute("kind", NodeContentKinds.getAttributeValues(), null));
    protected final LocalVar var;

    protected LetNode(int id, SourceLocation sourceLocation, String localVarName, String commandText) {
        super(id, sourceLocation, "let", commandText);
        this.var = new LocalVar(localVarName, this, null);
    }

    protected LetNode(LetNode orig, CopyState copyState) {
        super(orig, copyState);
        this.var = new LocalVar(orig.var, this);
    }

    public static CommandTextParseResult parseCommandTextHelper(String commandText, SoyParsingContext context, SourceLocation sourceLocation) {
        SanitizedContent.ContentKind contentKind;
        ExprRootNode valueExpr;
        Matcher matcher = COMMAND_TEXT_PATTERN.matcher(commandText);
        if (!matcher.matches()) {
            context.report(sourceLocation, INVALID_COMMAND_TEXT, new Object[0]);
            return new CommandTextParseResult(commandText, "error", null, null);
        }
        String localVarName = new ExpressionParser(matcher.group(1), sourceLocation, context).parseVariable().getName();
        String valueExprString = matcher.group(2);
        ExprRootNode exprRootNode = valueExpr = valueExprString != null ? new ExprRootNode(new ExpressionParser(valueExprString, sourceLocation, context).parseExpression()) : null;
        if (matcher.group(3) != null) {
            Preconditions.checkState((matcher.group(2) == null ? 1 : 0) != 0, (Object)"Match groups for value expression and optional attributes should be mutually exclusive");
            Map<String, String> attributes = ATTRIBUTES_PARSER.parse(matcher.group(3), context, sourceLocation);
            contentKind = attributes.get("kind") != null ? NodeContentKinds.forAttributeValue(attributes.get("kind")) : null;
        } else {
            contentKind = null;
        }
        return new CommandTextParseResult(commandText, localVarName, valueExpr, contentKind);
    }

    public String getUniqueVarName() {
        return this.getVarName() + "__soy" + this.getId();
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public final LocalVar getVar() {
        return this.var;
    }

    public static final class CommandTextParseResult {
        final String originalCommandText;
        final String localVarName;
        @Nullable
        final ExprRootNode valueExpr;
        @Nullable
        public final SanitizedContent.ContentKind contentKind;

        private CommandTextParseResult(String originalCommandText, String localVarName, @Nullable ExprRootNode valueExpr, @Nullable SanitizedContent.ContentKind contentKind) {
            this.originalCommandText = originalCommandText;
            this.localVarName = localVarName;
            this.valueExpr = valueExpr;
            this.contentKind = contentKind;
        }
    }
}

