/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TagName;

public final class HtmlOpenTagNode
extends AbstractParentSoyNode<SoyNode.StandaloneNode>
implements SoyNode.StandaloneNode {
    private final boolean selfClosing;
    private final TagName tagName;

    public HtmlOpenTagNode(int id, TagName tagName, SourceLocation sourceLocation, boolean selfClosing) {
        super(id, sourceLocation);
        this.tagName = (TagName)Preconditions.checkNotNull((Object)tagName);
        this.selfClosing = selfClosing;
    }

    private HtmlOpenTagNode(HtmlOpenTagNode orig, CopyState copyState) {
        super(orig, copyState);
        this.selfClosing = orig.selfClosing;
        this.tagName = orig.tagName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.HTML_OPEN_TAG_NODE;
    }

    public boolean isSelfClosing() {
        return this.selfClosing;
    }

    public TagName getTagName() {
        return this.tagName;
    }

    @Override
    public HtmlOpenTagNode copy(CopyState copyState) {
        return new HtmlOpenTagNode(this, copyState);
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        for (int i = 0; i < this.numChildren(); ++i) {
            SoyNode.StandaloneNode child = (SoyNode.StandaloneNode)this.getChild(i);
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(child.toSourceString());
        }
        sb.append(this.selfClosing ? "/>" : ">");
        return sb.toString();
    }
}

