/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TagName;

public final class HtmlCloseTagNode
extends AbstractParentSoyNode<SoyNode.StandaloneNode>
implements SoyNode.StandaloneNode {
    private final TagName tagName;

    public HtmlCloseTagNode(int id, TagName tagName, SourceLocation sourceLocation) {
        super(id, sourceLocation);
        this.tagName = (TagName)Preconditions.checkNotNull((Object)tagName);
    }

    private HtmlCloseTagNode(HtmlCloseTagNode orig, CopyState copyState) {
        super(orig, copyState);
        this.tagName = orig.tagName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.HTML_CLOSE_TAG_NODE;
    }

    public TagName getTagName() {
        return this.tagName;
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public HtmlCloseTagNode copy(CopyState copyState) {
        return new HtmlCloseTagNode(this, copyState);
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append("</");
        for (int i = 0; i < this.numChildren(); ++i) {
            SoyNode.StandaloneNode child = (SoyNode.StandaloneNode)this.getChild(i);
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(child.toSourceString());
        }
        sb.append('>');
        return sb.toString();
    }
}

