/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.AutoValue_ForNode_RangeArgs;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.defn.LocalVar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ForNode
extends AbstractBlockCommandNode
implements SoyNode.StandaloneNode,
SoyNode.StatementNode,
SoyNode.ConditionalBlockNode,
SoyNode.LoopNode,
SoyNode.ExprHolderNode,
SoyNode.LocalVarBlockNode {
    private static final SoyErrorKind INVALID_COMMAND_TEXT = SoyErrorKind.of("Invalid ''for'' command text");
    private static final SoyErrorKind INVALID_RANGE_SPECIFICATION = SoyErrorKind.of("Invalid range specification");
    private static final SoyErrorKind RANGE_OUT_OF_RANGE = SoyErrorKind.of("Range specification is too large: {0}");
    private static final Pattern COMMAND_TEXT_PATTERN = Pattern.compile("( [$] \\w+ ) \\s+ in \\s+ range[(] \\s* (.*) \\s* [)]", 36);
    private final LocalVar var;
    private final RangeArgs rangeArgs;

    public ForNode(int id, String commandText, SourceLocation sourceLocation, SoyParsingContext context) {
        super(id, sourceLocation, "for", commandText);
        Matcher matcher = COMMAND_TEXT_PATTERN.matcher(commandText);
        if (!matcher.matches()) {
            context.report(sourceLocation, INVALID_COMMAND_TEXT, new Object[0]);
            this.rangeArgs = RangeArgs.ERROR;
            this.var = new LocalVar("error", this, null);
            return;
        }
        String varName = ForNode.parseVarName(matcher.group(1), sourceLocation, context);
        List<ExprNode> rangeArgs = ForNode.parseRangeArgs(matcher.group(2), sourceLocation, context);
        if (rangeArgs.size() > 3 || rangeArgs.isEmpty()) {
            context.report(sourceLocation, INVALID_RANGE_SPECIFICATION, new Object[0]);
            this.rangeArgs = RangeArgs.ERROR;
        } else {
            ExprNode start = rangeArgs.size() >= 2 ? rangeArgs.get(0) : new IntegerNode(0L, sourceLocation);
            ExprNode increment = rangeArgs.size() == 3 ? rangeArgs.get(2) : new IntegerNode(1L, sourceLocation);
            ExprNode limit = rangeArgs.get(rangeArgs.size() == 1 ? 0 : 1);
            this.rangeArgs = RangeArgs.create(start, limit, increment);
            if (ForNode.isOutOfRange(start)) {
                context.report(sourceLocation, RANGE_OUT_OF_RANGE, ((IntegerNode)start).getValue());
            }
            if (ForNode.isOutOfRange(increment)) {
                context.report(sourceLocation, RANGE_OUT_OF_RANGE, ((IntegerNode)increment).getValue());
            }
            if (ForNode.isOutOfRange(limit)) {
                context.report(sourceLocation, RANGE_OUT_OF_RANGE, ((IntegerNode)limit).getValue());
            }
        }
        this.var = new LocalVar(varName, this, null);
    }

    private static String parseVarName(String input, SourceLocation sourceLocation, SoyParsingContext context) {
        return new ExpressionParser(input, sourceLocation, context).parseVariable().getName();
    }

    private static List<ExprNode> parseRangeArgs(String input, SourceLocation sourceLocation, SoyParsingContext context) {
        return new ExpressionParser(input, sourceLocation, context).parseExpressionList();
    }

    private static boolean isOutOfRange(ExprNode node) {
        if (node instanceof IntegerNode) {
            long n = ((IntegerNode)node).getValue();
            return n > Integer.MAX_VALUE || n < Integer.MIN_VALUE;
        }
        return false;
    }

    private ForNode(ForNode orig, CopyState copyState) {
        super(orig, copyState);
        this.var = new LocalVar(orig.var, this);
        this.rangeArgs = orig.rangeArgs.copy(copyState);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.FOR_NODE;
    }

    @Override
    public final LocalVar getVar() {
        return this.var;
    }

    @Override
    public final String getVarName() {
        return this.var.name();
    }

    public RangeArgs getRangeArgs() {
        return this.rangeArgs;
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.rangeArgs.start(), (Object)this.rangeArgs.limit(), (Object)this.rangeArgs.increment());
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public ForNode copy(CopyState copyState) {
        return new ForNode(this, copyState);
    }

    public static abstract class RangeArgs {
        private static final RangeArgs ERROR = RangeArgs.create(VarRefNode.ERROR, VarRefNode.ERROR, VarRefNode.ERROR);

        static RangeArgs create(ExprNode start, ExprNode limit, ExprNode increment) {
            return new AutoValue_ForNode_RangeArgs(new ExprRootNode(start), new ExprRootNode(limit), new ExprRootNode(increment));
        }

        RangeArgs() {
        }

        public abstract ExprRootNode start();

        public abstract ExprRootNode limit();

        public abstract ExprRootNode increment();

        public final boolean definitelyNotEmpty() {
            if (!(this.start().getRoot() instanceof IntegerNode)) {
                return false;
            }
            long start = ((IntegerNode)this.start().getRoot()).getValue();
            if (!(this.limit().getRoot() instanceof IntegerNode)) {
                return false;
            }
            long limit = ((IntegerNode)this.limit().getRoot()).getValue();
            return start < limit;
        }

        private RangeArgs copy(CopyState copyState) {
            return RangeArgs.create(this.start().getRoot().copy(copyState), this.limit().getRoot().copy(copyState), this.increment().getRoot().copy(copyState));
        }
    }
}

