/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public final class CallDelegateNode
extends CallNode {
    private static final SoyErrorKind MISSING_CALLEE_NAME = SoyErrorKind.of("The ''delcall'' command text must contain the callee name (encountered command text \"{0}\").");
    public static final SoyErrorKind INVALID_DELEGATE_NAME = SoyErrorKind.of("Invalid delegate name \"{0}\" for ''delcall'' command.");
    private static final SoyErrorKind INVALID_VARIANT_EXPRESSION = SoyErrorKind.of("Invalid variant expression \"{0}\" in ''delcall'' (variant expression must evaluate to an identifier).");
    private static final Pattern NONATTRIBUTE_CALLEE_NAME = Pattern.compile("^\\s* ([.\\w]+) (?= \\s | $)", 4);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("delcall", new CommandTextAttributesParser.Attribute("variant", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("data", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("allowemptydefault", (Collection<String>)CommandTextAttributesParser.Attribute.BOOLEAN_VALUES, null));
    private final String delCalleeName;
    @Nullable
    private final ExprRootNode delCalleeVariantExpr;
    private Boolean allowsEmptyDefault;
    private ImmutableMap<TemplateDelegateNode, ImmutableList<TemplateParam>> paramsToRuntimeCheckByDelegate;

    private CallDelegateNode(int id, SourceLocation sourceLocation, CommandTextInfo commandTextInfo, ImmutableList<String> escapingDirectiveNames) {
        super(id, sourceLocation, "delcall", commandTextInfo, escapingDirectiveNames);
        this.delCalleeName = commandTextInfo.delCalleeName;
        this.delCalleeVariantExpr = commandTextInfo.delCalleeVariantExpr;
        this.allowsEmptyDefault = commandTextInfo.allowsEmptyDefault;
    }

    private CallDelegateNode(CallDelegateNode orig, CopyState copyState) {
        super(orig, copyState);
        this.delCalleeName = orig.delCalleeName;
        this.delCalleeVariantExpr = orig.delCalleeVariantExpr != null ? orig.delCalleeVariantExpr.copy(copyState) : null;
        this.allowsEmptyDefault = orig.allowsEmptyDefault;
        this.paramsToRuntimeCheckByDelegate = orig.paramsToRuntimeCheckByDelegate;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_DELEGATE_NODE;
    }

    public String getDelCalleeName() {
        return this.delCalleeName;
    }

    @Nullable
    public ExprRootNode getDelCalleeVariantExpr() {
        return this.delCalleeVariantExpr;
    }

    public void setParamsToRuntimeCheck(ImmutableMap<TemplateDelegateNode, ImmutableList<TemplateParam>> paramsToRuntimeCheck) {
        this.paramsToRuntimeCheckByDelegate = (ImmutableMap)Preconditions.checkNotNull(paramsToRuntimeCheck);
    }

    @Override
    public Collection<TemplateParam> getParamsToRuntimeCheck(TemplateNode callee) {
        if (this.paramsToRuntimeCheckByDelegate == null) {
            return callee.getParams();
        }
        ImmutableList params = (ImmutableList)this.paramsToRuntimeCheckByDelegate.get((Object)callee);
        if (params == null) {
            return callee.getParams();
        }
        return params;
    }

    public boolean allowsEmptyDefault() {
        if (this.allowsEmptyDefault == null) {
            return false;
        }
        return this.allowsEmptyDefault;
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        ImmutableList.Builder allExprs = ImmutableList.builder();
        if (this.delCalleeVariantExpr != null) {
            allExprs.add((Object)this.delCalleeVariantExpr);
        }
        allExprs.addAll(super.getExprList());
        return allExprs.build();
    }

    @Override
    public CallDelegateNode copy(CopyState copyState) {
        return new CallDelegateNode(this, copyState);
    }

    public static final class Builder
    extends CallNode.Builder {
        private final int id;
        private final SourceLocation sourceLocation;
        private boolean allowEmptyDefault;
        private CallNode.DataAttribute dataAttribute = CallNode.DataAttribute.none();
        private ImmutableList<String> escapingDirectiveNames = ImmutableList.of();
        @Nullable
        private String commandText;
        @Nullable
        private String delCalleeName;
        @Nullable
        private ExprRootNode delCalleeVariantExpr;
        @Nullable
        private String userSuppliedPlaceholderName;

        private static CallDelegateNode error() {
            return new Builder(-1, SourceLocation.UNKNOWN).commandText("error.error").build(SoyParsingContext.exploding());
        }

        public Builder(int id, SourceLocation sourceLocation) {
            this.id = id;
            this.sourceLocation = sourceLocation;
        }

        public Builder allowEmptyDefault(boolean allowEmptyDefault) {
            this.allowEmptyDefault = allowEmptyDefault;
            return this;
        }

        @Override
        public SourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public Builder commandText(String commandText) {
            this.commandText = commandText;
            return this;
        }

        public Builder delCalleeName(String delCalleeName) {
            this.delCalleeName = delCalleeName;
            return this;
        }

        public Builder delCalleeVariantExpr(ExprRootNode delCalleeVariantExpr) {
            this.delCalleeVariantExpr = delCalleeVariantExpr;
            return this;
        }

        public Builder escapingDirectiveNames(ImmutableList<String> escapingDirectiveNames) {
            this.escapingDirectiveNames = escapingDirectiveNames;
            return this;
        }

        public Builder dataAttribute(CallNode.DataAttribute dataAttribute) {
            this.dataAttribute = dataAttribute;
            return this;
        }

        @Override
        public Builder userSuppliedPlaceholderName(String userSuppliedPlaceholderName) {
            this.userSuppliedPlaceholderName = userSuppliedPlaceholderName;
            return this;
        }

        @Override
        public CallDelegateNode build(SoyParsingContext context) {
            CommandTextInfo commandTextInfo;
            ErrorReporter.Checkpoint checkpoint = context.errorReporter().checkpoint();
            CommandTextInfo commandTextInfo2 = commandTextInfo = this.commandText != null ? this.parseCommandText(context) : this.buildCommandText();
            if (context.errorReporter().errorsSince(checkpoint)) {
                return Builder.error();
            }
            CallDelegateNode callDelegateNode = new CallDelegateNode(this.id, this.sourceLocation, commandTextInfo, this.escapingDirectiveNames);
            return callDelegateNode;
        }

        private CommandTextInfo parseCommandText(SoyParsingContext context) {
            ExprRootNode delCalleeVariantExpr;
            String delCalleeName;
            String commandTextWithoutPhnameAttr = this.commandText;
            String commandText = commandTextWithoutPhnameAttr + (this.userSuppliedPlaceholderName != null ? " phname=\"" + this.userSuppliedPlaceholderName + "\"" : "");
            Matcher ncnMatcher = NONATTRIBUTE_CALLEE_NAME.matcher(commandTextWithoutPhnameAttr);
            if (ncnMatcher.find()) {
                delCalleeName = ncnMatcher.group(1);
                if (!BaseUtils.isDottedIdentifier(delCalleeName)) {
                    context.report(this.sourceLocation, INVALID_DELEGATE_NAME, delCalleeName);
                }
                commandTextWithoutPhnameAttr = commandTextWithoutPhnameAttr.substring(ncnMatcher.end()).trim();
            } else {
                delCalleeName = null;
                context.report(this.sourceLocation, MISSING_CALLEE_NAME, commandText);
            }
            Map<String, String> attributes = ATTRIBUTES_PARSER.parse(commandTextWithoutPhnameAttr, context, this.sourceLocation);
            String variantExprText = attributes.get("variant");
            if (variantExprText == null) {
                delCalleeVariantExpr = null;
            } else {
                String fixedVariantStr;
                ExprNode expr = new ExpressionParser(variantExprText, this.sourceLocation, context).parseExpression();
                if (expr instanceof StringNode && !BaseUtils.isIdentifier(fixedVariantStr = ((StringNode)expr).getValue())) {
                    context.report(this.sourceLocation, INVALID_VARIANT_EXPRESSION, variantExprText);
                }
                delCalleeVariantExpr = new ExprRootNode(expr);
            }
            CallNode.DataAttribute dataAttrInfo = CallNode.parseDataAttributeHelper(attributes.get("data"), this.sourceLocation, context);
            String allowemptydefaultAttr = attributes.get("allowemptydefault");
            Boolean allowsEmptyDefault = allowemptydefaultAttr == null ? null : Boolean.valueOf(allowemptydefaultAttr.equals("true"));
            return new CommandTextInfo(commandText, delCalleeName, delCalleeVariantExpr, allowsEmptyDefault, dataAttrInfo, this.userSuppliedPlaceholderName);
        }

        private CommandTextInfo buildCommandText() {
            Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(this.delCalleeName));
            String commandText = "";
            commandText = commandText + this.delCalleeName;
            if (this.dataAttribute.isPassingAllData()) {
                commandText = commandText + " data=\"all\"";
            } else if (this.dataAttribute.isPassingData()) {
                assert (this.dataAttribute.dataExpr() != null);
                commandText = commandText + " data=\"" + this.dataAttribute.dataExpr().toSourceString() + '\"';
            }
            if (this.userSuppliedPlaceholderName != null) {
                commandText = commandText + " phname=\"" + this.userSuppliedPlaceholderName + '\"';
            }
            return new CommandTextInfo(commandText, this.delCalleeName, this.delCalleeVariantExpr, this.allowEmptyDefault, this.dataAttribute, this.userSuppliedPlaceholderName);
        }
    }

    @Immutable
    private static class CommandTextInfo
    extends CallNode.CommandTextInfo {
        public final String delCalleeName;
        @Nullable
        public final ExprRootNode delCalleeVariantExpr;
        public final Boolean allowsEmptyDefault;

        public CommandTextInfo(String commandText, String delCalleeName, @Nullable ExprRootNode delCalleeVariantExpr, Boolean allowsEmptyDefault, CallNode.DataAttribute dataAttr, @Nullable String userSuppliedPlaceholderName) {
            super(commandText, dataAttr, userSuppliedPlaceholderName, null);
            this.delCalleeName = delCalleeName;
            this.delCalleeVariantExpr = delCalleeVariantExpr;
            this.allowsEmptyDefault = allowsEmptyDefault;
        }
    }
}

