/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.LegacyInternalSyntaxException;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.exprtree.AbstractPrimitiveNode;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.internal.base.UnescapeUtils;
import com.google.template.soy.soyparse.ForeachBuilder;
import com.google.template.soy.soyparse.ParseErrors;
import com.google.template.soy.soyparse.ParseException;
import com.google.template.soy.soyparse.RawTextBuilder;
import com.google.template.soy.soyparse.SimpleCharStream;
import com.google.template.soy.soyparse.SourceItemInfo;
import com.google.template.soy.soyparse.SoyFileParserConstants;
import com.google.template.soy.soyparse.SoyFileParserTokenManager;
import com.google.template.soy.soyparse.Token;
import com.google.template.soy.soyparse.TokenMgrError;
import com.google.template.soy.soyparse.Tokens;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNodeBuilder;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.XidNode;
import com.google.template.soy.soytree.defn.HeaderParam;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.ast.GenericTypeNode;
import com.google.template.soy.types.ast.NamedTypeNode;
import com.google.template.soy.types.ast.RecordTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.UnionTypeNode;
import com.google.template.soy.types.primitive.ErrorType;
import com.google.template.soy.types.primitive.NullType;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class SoyFileParser
implements SoyFileParserConstants {
    private static final String LINE_BOUNDARY_REGEX = "\\s*?(\\n|\\r)\\s*";
    private static final Pattern LINE_BOUNDARY_PATTERN = Pattern.compile("\\s*?(\\n|\\r)\\s*");
    private static final Pattern INVALID_PRINT_PREFIX_PATTERN = Pattern.compile("^(" + Joiner.on((String)"|").join((Iterable)FluentIterable.from(Arrays.asList(tokenImage)).filter(Predicates.containsPattern((String)"^\"\\{[a-z]+\\}\"$")).transform((Function)new RegexFromTokenImageFunction())) + ")\\b.+");
    private static final Pattern INVALID_PRINT_FILE_PREFIX_PATTERN = Pattern.compile("^(namespace|(del)?template|typedef|alias)\\b.*");
    private static final Joiner NO_SEP_JOINER = Joiner.on((String)"");
    private static final SoyErrorKind FOUND_DOUBLE_BRACE = SoyErrorKind.of("Soy '{{command}}' syntax is no longer supported.  Use single braces.");
    private static final SoyErrorKind INVALID_ALIAS_NAME = SoyErrorKind.of("An alias must be a single identifier. Found ''{0}''.");
    private static final SoyErrorKind INVALID_DECLARATION = SoyErrorKind.of("Invalid declaration ''{0}''.");
    private static final SoyErrorKind INVALID_DELTEMPLATE_NAME = SoyErrorKind.of("Deltemplate ''{0}'' must have a fully qualified name.");
    private static final SoyErrorKind INVALID_PRINT_PREFIX = SoyErrorKind.of("Command ''{0}'' cannot have arguments.");
    private static final SoyErrorKind INVALID_PRINT_COMMAND_TEXT = SoyErrorKind.of("Invalid ''print'' command text \"{0}\" (check the directives).");
    private static final SoyErrorKind INVALID_TEMPLATE_COMMAND = SoyErrorKind.of("Command ''{0}'' cannot appear in templates.");
    private static final SoyErrorKind INVALID_TEMPLATE_NAME = SoyErrorKind.of("Template name ''{0}'' must be relative to the file namespace, i.e. a dot followed by an identifier.");
    private static final SoyErrorKind MULTIPLE_PHNAME_ATTRIBUTES_IN_COMMAND = SoyErrorKind.of("Found multiple ''phname'' attributes in command text \"{0}\".");
    private static final SoyErrorKind PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK = SoyErrorKind.of("Tags ''plural'' and ''select'' are not allowed inside ''plural'' blocks.");
    private static final SoyErrorKind PLURAL_CASE_OUT_OF_BOUNDS = SoyErrorKind.of("Plural case ''{0}'' must be nonnegative integers.");
    private static final SoyErrorKind PLURAL_CASE_MALFORMED = SoyErrorKind.of("Invalid number in ''plural case'' command text");
    private static final SoyErrorKind PRINT_COMMAND_WITH_EMPTY_TEXT = SoyErrorKind.of("Found ''print'' command with empty command text.");
    private static final SoyErrorKind SELECT_CASE_INVALID_STRING = SoyErrorKind.of("Invalid string for select ''case''.");
    private static final SoyErrorKind UNEXPECTED_CLOSING_TAG = SoyErrorKind.of("Unexpected closing tag ''{0}''.");
    private static final SoyErrorKind UNEXPECTED_CONTENT_AFTER = SoyErrorKind.of("Unexpected content after ''{0}'', expected only comments or whitespace.");
    private static final SoyErrorKind UNEXPECTED_CONTENT_BEFORE = SoyErrorKind.of("Unexpected content before ''{0}'', expected only comments or whitespace.");
    private static final SoyErrorKind DUPLICATE_PARAM_NAME = SoyErrorKind.of("Duplicate param name ''{0}''");
    private static final SoyErrorKind INTEGER_OUT_OF_RANGE = SoyErrorKind.of("Soy integers are constrained to the range of JavaScript integers: https://www.ecma-international.org/ecma-262/5.1/#sec-8.5");
    private static final SoyErrorKind INVALID_FUNCTION_NAME = SoyErrorKind.of("Invalid function name ''{0}''");
    private static final SoyErrorKind INVALID_PARAM_NAME = SoyErrorKind.of("Invalid param name ''{0}''");
    private static final SoyErrorKind INVALID_VAR_NAME_IJ = SoyErrorKind.of("Invalid var name ''ij'' (''ij'' is for injected data ref).");
    private static final SoyErrorKind SINGLE_IDENTIFIER_KEY_IN_MAP_LITERAL = SoyErrorKind.of("Disallowed single-identifier key \"{0}\" in map literal (please surround with single quotes for string or parentheses for global).");
    private static final SoyErrorKind UNEXPECTED_IJ_DATA_REFERENCE = SoyErrorKind.of("Expected a variable name, but found an ''ij'' data reference.");
    private SoyTypeRegistry typeRegistry;
    private IdGenerator nodeIdGen;
    private SoyFileKind soyFileKind;
    private String filePath;
    private ErrorReporter errorReporter;
    private SoyParsingContext context;
    public SoyFileParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[93];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public SoyFileParser(SoyTypeRegistry typeRegistry, IdGenerator nodeIdGen, Reader input, SoyFileKind soyFileKind, String filePath, ErrorReporter errorReporter) {
        this(input);
        Preconditions.checkNotNull((Object)typeRegistry);
        Preconditions.checkNotNull((Object)nodeIdGen);
        this.typeRegistry = typeRegistry;
        this.nodeIdGen = nodeIdGen;
        this.soyFileKind = soyFileKind;
        this.filePath = filePath;
        this.errorReporter = errorReporter;
    }

    public SoyFileNode parseSoyFile() {
        Preconditions.checkNotNull((Object)this.typeRegistry);
        Preconditions.checkNotNull((Object)this.nodeIdGen);
        ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
        SoyFileNode soyFileNode = null;
        try {
            soyFileNode = this.SoyFile();
        }
        catch (ParseException e) {
            ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, e);
        }
        catch (LegacyInternalSyntaxException e) {
            ParseErrors.report(this.errorReporter, this.filePath, e);
        }
        catch (TokenMgrError e) {
            ParseErrors.reportTokenMgrError(this.errorReporter, this.filePath, e);
        }
        if (this.errorReporter.errorsSince(checkpoint)) {
            return null;
        }
        return soyFileNode;
    }

    private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, Token token) {
        return this.newSourceItemInfo(parsed, token.beginLine, token.beginColumn, token.endLine, token.endColumn);
    }

    private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, Token begin, Token end) {
        return this.newSourceItemInfo(parsed, begin.beginLine, begin.beginColumn, end.endLine, end.endColumn);
    }

    private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, SourceItemInfo<?> begin, SourceItemInfo<?> end) {
        return new SourceItemInfo<T>(parsed, begin, end);
    }

    private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, int lineNum, int columnNum, int lineNumEnd, int columnNumEnd) {
        return new SourceItemInfo<T>(this.filePath, parsed, lineNum, columnNum, lineNumEnd, columnNumEnd);
    }

    private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, SourceLocation location) {
        return new SourceItemInfo<T>(parsed, location);
    }

    private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, SourceLocation begin, SourceLocation end) {
        return new SourceItemInfo<T>(parsed, begin.extend(end));
    }

    private SourceLocation createSrcLoc(Token tok1, Token ... rest) {
        return Tokens.createSrcLoc(this.filePath, tok1, rest);
    }

    private ExprNode errorExpr(Token tok1, Token ... rest) {
        return VarRefNode.error(this.createSrcLoc(tok1, rest));
    }

    private void pushState(int nextState) {
        Tokens.checkLexerIsExactlyOneTokenAhead(this);
        this.token_source.pushState(nextState);
    }

    private void popState() {
        Tokens.checkLexerIsExactlyOneTokenAhead(this);
        this.token_source.popState();
    }

    private void popStateIfStateIs(int state) {
        Tokens.checkLexerIsExactlyOneTokenAhead(this);
        this.token_source.popStateIfStateIs(state);
    }

    private final SoyFileNode SoyFile() throws ParseException {
        Identifier delpackageName = null;
        Object aliases = ImmutableList.of();
        AliasDeclaration alias = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: {
                delpackageName = this.DelPackage();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        NamespaceDeclaration namespace = this.Namespace();
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block9;
                }
            }
            alias = this.Alias();
            if (aliases.isEmpty()) {
                aliases = new ArrayList();
            }
            if (alias == null) continue;
            aliases.add(alias);
        }
        TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo = new TemplateNode.SoyFileHeaderInfo(this.errorReporter, delpackageName, namespace, (Collection<AliasDeclaration>)aliases);
        this.context = SoyParsingContext.create(this.errorReporter, soyFileHeaderInfo.namespace, soyFileHeaderInfo.aliasToNamespaceMap);
        SoyFileNode sfn = new SoyFileNode(this.nodeIdGen.genId(), this.filePath, this.soyFileKind, namespace, soyFileHeaderInfo);
        block10: while (true) {
            TemplateNode template;
            if ((template = this.Template(soyFileHeaderInfo)) != null) {
                sfn.addChild(template);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 17: 
                case 18: {
                    continue block10;
                }
            }
            break;
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(0);
        if ("" != null) {
            return sfn;
        }
        throw new Error("Missing return statement in function");
    }

    private final AliasDeclaration Alias() throws ParseException {
        String aliasString;
        Identifier alias = null;
        Token as = null;
        Token open = this.jj_consume_token(9);
        Identifier namespace = this.DottedIdent();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: {
                as = this.jj_consume_token(16);
                alias = this.DottedIdent();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        Token close = this.jj_consume_token(70);
        SourceLocation srcLoc = this.createSrcLoc(open, close);
        if (alias != null && !BaseUtils.isIdentifier(alias.identifier())) {
            this.errorReporter.report(srcLoc, INVALID_ALIAS_NAME, alias.identifier());
            if ("" != null) {
                return null;
            }
        }
        String string = aliasString = alias == null ? BaseUtils.extractPartAfterLastDot(namespace.identifier()) : alias.identifier();
        if ("" != null) {
            return new AliasDeclaration(namespace.identifier(), aliasString, srcLoc);
        }
        throw new Error("Missing return statement in function");
    }

    private final NamespaceDeclaration Namespace() throws ParseException {
        Token open = this.jj_consume_token(10);
        Identifier name = this.DottedIdent();
        List<CommandTagAttribute> attributes = this.CommandAttributes();
        Token close = this.jj_consume_token(70);
        if ("" != null) {
            return new NamespaceDeclaration(name, attributes, this.errorReporter);
        }
        throw new Error("Missing return statement in function");
    }

    private final List<CommandTagAttribute> CommandAttributes() throws ParseException {
        Object attributes = ImmutableList.of();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 75: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            CommandTagAttribute attr = this.Attribute();
            if (attributes.isEmpty()) {
                attributes = new ArrayList();
            }
            attributes.add(attr);
        }
        CommandTagAttribute.removeDuplicatesAndReportErrors((Iterable<CommandTagAttribute>)attributes, this.errorReporter);
        if ("" != null) {
            return attributes;
        }
        throw new Error("Missing return statement in function");
    }

    private final CommandTagAttribute Attribute() throws ParseException {
        Token name = this.jj_consume_token(75);
        Token eq = this.jj_consume_token(77);
        Token value = this.jj_consume_token(13);
        if ("" != null) {
            return new CommandTagAttribute(Identifier.create(name.image, this.createSrcLoc(name, new Token[0])), value.image.substring(1, value.image.length() - 1).replace("\\\"", "\""), this.createSrcLoc(value, new Token[0]));
        }
        throw new Error("Missing return statement in function");
    }

    private final Identifier DelPackage() throws ParseException {
        this.jj_consume_token(11);
        Identifier name = this.DottedIdent();
        this.jj_consume_token(70);
        if ("" != null) {
            return name;
        }
        throw new Error("Missing return statement in function");
    }

    private final TemplateNode Template(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo) throws ParseException {
        TemplateNode templateNode = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18: {
                Token open = this.jj_consume_token(18);
                TemplateBasicNodeBuilder builder = new TemplateBasicNodeBuilder(soyFileHeaderInfo, this.errorReporter);
                try {
                    templateNode = this.TemplateHelper(builder, open, false);
                    this.jj_consume_token(20);
                    break;
                }
                catch (ParseException e) {
                    this.reportErrorAndSkipTo(e, 20);
                    break;
                }
                catch (AbortParsingError e) {
                    if ("" == null) break;
                    return null;
                }
            }
            case 17: {
                Token open = this.jj_consume_token(17);
                TemplateDelegateNodeBuilder builder = new TemplateDelegateNodeBuilder(soyFileHeaderInfo, this.errorReporter);
                try {
                    templateNode = this.TemplateHelper(builder, open, true);
                    this.jj_consume_token(21);
                    break;
                }
                catch (ParseException e) {
                    this.reportErrorAndSkipTo(e, 21);
                    break;
                }
                catch (AbortParsingError e) {
                    if ("" == null) break;
                    return null;
                }
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return templateNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final TemplateNode TemplateHelper(TemplateNodeBuilder builder, Token open, boolean isDeltemplate) throws ParseException {
        builder.setId(this.nodeIdGen.genId());
        Identifier templateName = this.TemplateName(isDeltemplate);
        List<CommandTagAttribute> attributes = this.CommandAttributes();
        builder.setCommandValues(templateName, attributes);
        Token soyDoc = open.specialToken;
        if (soyDoc != null && soyDoc.kind == 8) {
            builder.setSoyDoc(soyDoc.image, this.createSrcLoc(soyDoc, new Token[0]));
        }
        this.pushState(5);
        Token close = this.jj_consume_token(70);
        builder.setSourceLocation(this.createSrcLoc(open, close));
        RawTextNode initialWhitespace = this.TemplateHeader(builder);
        List<SoyNode.StandaloneNode> templateBodyNodes = this.TemplateBlock();
        TemplateNode templateNode = builder.build();
        if (initialWhitespace != null) {
            templateNode.addChild(initialWhitespace);
        }
        templateNode.addChildren(templateBodyNodes);
        if ("" != null) {
            return templateNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final Identifier TemplateName(boolean isDeltemplate) throws ParseException {
        Identifier ident;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 78: {
                Token dot = this.jj_consume_token(78);
                Token name = this.jj_consume_token(75);
                ident = Identifier.create("." + name.image, this.createSrcLoc(dot, name));
                if (!isDeltemplate) break;
                this.errorReporter.report(ident.location(), INVALID_DELTEMPLATE_NAME, ident.identifier());
                break;
            }
            case 75: {
                ident = this.DottedIdent();
                if (isDeltemplate) break;
                this.errorReporter.report(ident.location(), INVALID_TEMPLATE_NAME, ident.identifier());
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return ident;
        }
        throw new Error("Missing return statement in function");
    }

    private final Identifier DottedIdent() throws ParseException {
        StringBuilder sb = null;
        Token next = null;
        Token name = this.jj_consume_token(75);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 78: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block3;
                }
            }
            Token dot = this.jj_consume_token(78);
            next = this.jj_consume_token(75);
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(name.image);
            }
            sb.append('.').append(next.image);
        }
        if ("" != null) {
            return sb == null ? Identifier.create(name.image, this.createSrcLoc(name, new Token[0])) : Identifier.create(sb.toString(), this.createSrcLoc(name, next));
        }
        throw new Error("Missing return statement in function");
    }

    private Token reportErrorAndSkipTo(ParseException error, int kind) throws ParseException {
        Token t;
        ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, error);
        do {
            t = this.getNextToken();
        } while (t.kind != kind && t.kind != 0);
        return t;
    }

    private Token reportTemplateBodyErrorAndSkipTo(ParseException error, int kind) throws ParseException {
        Token t;
        ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, error);
        do {
            t = this.getNextToken();
            if (t.kind != 20 && t.kind != 21) continue;
            throw new AbortParsingError();
        } while (t.kind != kind && t.kind != 0);
        return t;
    }

    private final String CmdText() throws ParseException {
        List<String> cmdTextParts = this.CmdTextParts();
        if ("" != null) {
            return NO_SEP_JOINER.join(cmdTextParts);
        }
        throw new Error("Missing return statement in function");
    }

    private final SourceItemInfo<String> CmdTextWithSource() throws ParseException {
        SourceItemInfo<List<String>> parts = this.CmdTextPartsWithSource();
        if ("" != null) {
            return this.newSourceItemInfo(NO_SEP_JOINER.join((Iterable)parts.parsedContent()), parts.srcLocation());
        }
        throw new Error("Missing return statement in function");
    }

    private final List<String> CmdTextParts() throws ParseException {
        SourceItemInfo<List<String>> parts = this.CmdTextPartsWithSource();
        if ("" != null) {
            return parts.parsedContent();
        }
        throw new Error("Missing return statement in function");
    }

    private final SourceItemInfo<List<String>> CmdTextPartsWithSource() throws ParseException {
        Token first = null;
        Token current = null;
        ArrayList<String> cmdTextParts = new ArrayList<String>();
        StringBuilder currCmdTextPartSb = new StringBuilder();
        block11: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 72: 
                case 73: 
                case 90: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block11;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 90: {
                    current = this.jj_consume_token(90);
                    currCmdTextPartSb.append(current.image);
                    break;
                }
                case 72: 
                case 73: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 72: {
                            current = this.jj_consume_token(72);
                            break;
                        }
                        case 73: {
                            current = this.jj_consume_token(73);
                            break;
                        }
                        default: {
                            this.jj_la1[9] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    if (currCmdTextPartSb.length() > 0) {
                        cmdTextParts.add(currCmdTextPartSb.toString());
                        currCmdTextPartSb.setLength(0);
                    }
                    cmdTextParts.add(current.image);
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (first != null) continue;
            first = current;
        }
        if (currCmdTextPartSb.length() > 0) {
            cmdTextParts.add(currCmdTextPartSb.toString());
            currCmdTextPartSb.setLength(0);
        }
        int n = cmdTextParts.size();
        for (int i = 0; i < n; ++i) {
            String cmdTextPart = (String)cmdTextParts.get(i);
            if (i == 0) {
                cmdTextPart = CharMatcher.whitespace().trimLeadingFrom((CharSequence)cmdTextPart);
            }
            if (i == n - 1) {
                cmdTextPart = CharMatcher.whitespace().trimTrailingFrom((CharSequence)cmdTextPart);
            }
            cmdTextPart = LINE_BOUNDARY_PATTERN.matcher(cmdTextPart).replaceAll(" ");
            cmdTextParts.set(i, cmdTextPart);
        }
        SourceLocation location = current == null ? this.createSrcLoc(this.getToken(0), new Token[0]) : (current == first ? this.createSrcLoc(first, new Token[0]) : this.createSrcLoc(first, current));
        if ("" != null) {
            return this.newSourceItemInfo(cmdTextParts, location);
        }
        throw new Error("Missing return statement in function");
    }

    private final void SkipWhitespace() throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 96: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(96);
        }
    }

    private final RawTextNode RawText() throws ParseException {
        RawTextBuilder builder = new RawTextBuilder(this.filePath, this.nodeIdGen);
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 96: 
                case 97: {
                    Token token;
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 97: {
                            token = this.jj_consume_token(97);
                            break;
                        }
                        case 96: {
                            token = this.jj_consume_token(96);
                            break;
                        }
                        default: {
                            this.jj_la1[12] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    builder.addBasic(token);
                    break;
                }
                case 34: {
                    this.jj_consume_token(34);
                    Token token = this.jj_consume_token(95);
                    builder.addLiteral(token);
                    break;
                }
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    Token token;
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 27: {
                            token = this.jj_consume_token(27);
                            break;
                        }
                        case 28: {
                            token = this.jj_consume_token(28);
                            break;
                        }
                        case 30: {
                            token = this.jj_consume_token(30);
                            break;
                        }
                        case 29: {
                            token = this.jj_consume_token(29);
                            break;
                        }
                        case 31: {
                            token = this.jj_consume_token(31);
                            break;
                        }
                        case 32: {
                            token = this.jj_consume_token(32);
                            break;
                        }
                        case 33: {
                            token = this.jj_consume_token(33);
                            break;
                        }
                        default: {
                            this.jj_la1[13] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    builder.addTextualCommand(token);
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 96: 
                case 97: {
                    continue block21;
                }
            }
            break;
        }
        this.jj_la1[15] = this.jj_gen;
        if ("" != null) {
            return builder.build();
        }
        throw new Error("Missing return statement in function");
    }

    private final RawTextNode TemplateHeader(TemplateNodeBuilder templateBuilder) throws ParseException {
        RawTextNode whitespace;
        Object params;
        block15: {
            params = ImmutableList.of();
            whitespace = null;
            String soyDoc = null;
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 96: {
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        break block15;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 96: {
                        RawTextBuilder builder = new RawTextBuilder(this.filePath, this.nodeIdGen);
                        block11: while (true) {
                            Token tok = this.jj_consume_token(96);
                            if (tok.specialToken != null) {
                                soyDoc = tok.specialToken.image;
                            }
                            builder.addBasic(tok);
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 96: {
                                    continue block11;
                                }
                            }
                            break;
                        }
                        this.jj_la1[17] = this.jj_gen;
                        whitespace = builder.build();
                        continue block10;
                    }
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        HeaderParam param = this.ParamDecl(soyDoc);
                        whitespace = null;
                        soyDoc = null;
                        if (params.isEmpty()) {
                            params = new ArrayList();
                        }
                        params.add(param);
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[18] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        templateBuilder.addParams((Iterable<? extends TemplateParam>)params);
        if ("" != null) {
            return whitespace;
        }
        throw new Error("Missing return statement in function");
    }

    private final HeaderParam ParamDecl(@Nullable String desc) throws ParseException {
        Token tagBegin;
        TypeNode paramTypeNode = null;
        SoyType paramType = ErrorType.getInstance();
        boolean optional = false;
        boolean inject = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 22: {
                tagBegin = this.jj_consume_token(22);
                break;
            }
            case 23: {
                tagBegin = this.jj_consume_token(23);
                optional = true;
                break;
            }
            case 24: {
                tagBegin = this.jj_consume_token(24);
                inject = true;
                break;
            }
            case 25: {
                tagBegin = this.jj_consume_token(25);
                inject = true;
                optional = true;
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (tagBegin.specialToken != null) {
            desc = tagBegin.specialToken.image;
        }
        Token name = this.jj_consume_token(75);
        this.jj_consume_token(76);
        this.token_source.SwitchTo(3);
        try {
            paramTypeNode = this.TypeExpr();
            paramType = this.typeRegistry.getOrCreateType(paramTypeNode, this.errorReporter);
            Token tagEnd = this.jj_consume_token(70);
        }
        catch (ParseException parseException) {
            Token tagEnd = this.reportTemplateBodyErrorAndSkipTo(parseException, 70);
        }
        if (desc != null) {
            desc = desc.substring(3, desc.length() - 2).trim();
        }
        if ("" != null) {
            return new HeaderParam(name.image, this.createSrcLoc(name, new Token[0]), optional ? this.typeRegistry.getOrCreateUnionType(paramType, NullType.getInstance()) : paramType, paramTypeNode, !optional && !SoyTypes.isNullable(paramType), inject, desc);
        }
        throw new Error("Missing return statement in function");
    }

    private final List<SoyNode.StandaloneNode> TemplateBlock() throws ParseException {
        ArrayList<SoyNode.StandaloneNode> templateBlock = new ArrayList<SoyNode.StandaloneNode>();
        block7: while (true) {
            SoyNode.StandaloneNode node;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 41: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 51: 
                case 53: 
                case 59: 
                case 63: 
                case 66: 
                case 68: 
                case 69: 
                case 96: 
                case 97: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 96: 
                case 97: {
                    node = this.RawText();
                    break;
                }
                case 35: 
                case 36: 
                case 41: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 51: 
                case 53: 
                case 59: 
                case 63: 
                case 66: 
                case 68: 
                case 69: {
                    node = this.Stmt();
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            templateBlock.add(node);
        }
        if ("" != null) {
            return templateBlock;
        }
        throw new Error("Missing return statement in function");
    }

    private final SoyNode.StatementNode Stmt() throws ParseException {
        SoyNode.StatementNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 51: 
            case 66: 
            case 68: {
                stmt = this.NonPrintableStmt();
                break;
            }
            case 35: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 69: {
                stmt = this.PrintableStmt();
                break;
            }
            case 47: 
            case 53: 
            case 59: 
            case 63: {
                stmt = this.ControlFlowStmt();
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    private final SoyNode.StatementNode NonPrintableStmt() throws ParseException {
        AbstractCommandNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 51: {
                stmt = this.LetStmt();
                break;
            }
            case 66: {
                stmt = this.LogStmt();
                break;
            }
            case 68: {
                stmt = this.DebuggerStmt();
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    private final SoyNode.StatementNode PrintableStmt() throws ParseException {
        AbstractSoyNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 41: {
                stmt = this.MsgStmt();
                break;
            }
            case 45: {
                stmt = this.XidStmt();
                break;
            }
            case 46: {
                stmt = this.CssStmt();
                break;
            }
            case 35: 
            case 36: {
                stmt = this.CallStmt();
                break;
            }
            case 44: 
            case 69: {
                stmt = this.PrintStmt();
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    private final SoyNode.StatementNode ControlFlowStmt() throws ParseException {
        AbstractSoyNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 47: {
                stmt = this.IfStmt();
                break;
            }
            case 59: {
                stmt = this.SwitchStmt();
                break;
            }
            case 63: {
                stmt = this.ForeachStmt();
                break;
            }
            case 53: {
                stmt = this.ForStmt();
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    private final MsgFallbackGroupNode MsgStmt() throws ParseException {
        Token tagBegin = this.jj_consume_token(41);
        String cmdText = this.CmdText();
        this.pushState(6);
        ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
        Token tagEnd = this.jj_consume_token(70);
        SourceLocation location = this.createSrcLoc(tagBegin, tagEnd);
        MsgFallbackGroupNode msgFbGrpNode = new MsgFallbackGroupNode(this.nodeIdGen.genId(), location);
        MsgNode msgNode = MsgNode.msg(this.nodeIdGen.genId(), cmdText, location).build(this.context);
        msgFbGrpNode.addChild(msgNode);
        List<SoyNode.StandaloneNode> templateBlockForMsg = this.TemplateBlockForMsg();
        msgNode.addChildren(templateBlockForMsg);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42: {
                tagBegin = this.jj_consume_token(42);
                cmdText = this.CmdText();
                tagEnd = this.jj_consume_token(70);
                location = this.createSrcLoc(tagBegin, tagEnd);
                msgNode = MsgNode.fallbackmsg(this.nodeIdGen.genId(), cmdText, location).build(this.context);
                msgFbGrpNode.addChild(msgNode);
                templateBlockForMsg = this.TemplateBlockForMsg();
                msgNode.addChildren(templateBlockForMsg);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        if (this.errorReporter.errorsSince(checkpoint) || this.getToken((int)1).kind != 43) {
            this.popStateIfStateIs(6);
        } else {
            this.popState();
        }
        this.jj_consume_token(43);
        if ("" != null) {
            return msgFbGrpNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final List<SoyNode.StandaloneNode> TemplateBlockForMsg() throws ParseException {
        ArrayList<SoyNode.StandaloneNode> templateBlock;
        int pluralOrSelectIndex;
        block28: {
            RawTextNode rawText;
            pluralOrSelectIndex = -1;
            boolean firstNodeIsWhitespace = false;
            templateBlock = new ArrayList<SoyNode.StandaloneNode>();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 96: {
                    RawTextBuilder builder = new RawTextBuilder(this.filePath, this.nodeIdGen);
                    block20: while (true) {
                        Token tok = this.jj_consume_token(96);
                        builder.addBasic(tok);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 96: {
                                continue block20;
                            }
                        }
                        break;
                    }
                    this.jj_la1[27] = this.jj_gen;
                    rawText = builder.build();
                    if (rawText == null) break;
                    firstNodeIsWhitespace = true;
                    templateBlock.add(rawText);
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                }
            }
            block21: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 44: 
                    case 55: 
                    case 57: 
                    case 69: 
                    case 92: 
                    case 96: 
                    case 97: {
                        break;
                    }
                    default: {
                        this.jj_la1[29] = this.jj_gen;
                        break block28;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 55: 
                    case 57: {
                        AbstractParentCommandNode msgPluralOrSelectNode;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 55: {
                                msgPluralOrSelectNode = this.MsgPlural();
                                break;
                            }
                            case 57: {
                                msgPluralOrSelectNode = this.MsgSelect();
                                break;
                            }
                            default: {
                                this.jj_la1[30] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.SkipWhitespace();
                        if (firstNodeIsWhitespace) {
                            templateBlock.remove(0);
                            firstNodeIsWhitespace = false;
                        }
                        if (pluralOrSelectIndex == -1) {
                            pluralOrSelectIndex = templateBlock.size();
                        }
                        templateBlock.add((SoyNode.StandaloneNode)((Object)msgPluralOrSelectNode));
                        continue block21;
                    }
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 96: 
                    case 97: {
                        rawText = this.RawText();
                        templateBlock.add(rawText);
                        continue block21;
                    }
                    case 35: 
                    case 36: {
                        AbstractParentCommandNode stmt = this.CallStmt();
                        templateBlock.add(new MsgPlaceholderNode(this.nodeIdGen.genId(), (SoyNode.MsgPlaceholderInitialNode)((Object)stmt)));
                        continue block21;
                    }
                    case 44: 
                    case 69: {
                        AbstractParentCommandNode stmt = this.PrintStmt();
                        templateBlock.add(new MsgPlaceholderNode(this.nodeIdGen.genId(), (SoyNode.MsgPlaceholderInitialNode)((Object)stmt)));
                        continue block21;
                    }
                    case 92: {
                        MsgHtmlTagNode msgHtmlTag = this.MsgHtmlTag();
                        templateBlock.add(new MsgPlaceholderNode(this.nodeIdGen.genId(), msgHtmlTag));
                        continue block21;
                    }
                }
                break;
            }
            this.jj_la1[31] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (pluralOrSelectIndex != -1) {
            SoyNode.StandaloneNode pluralOrSelect = (SoyNode.StandaloneNode)templateBlock.get(pluralOrSelectIndex);
            for (int i = 0; i < templateBlock.size(); ++i) {
                if (i == pluralOrSelectIndex) continue;
                this.errorReporter.report(((SoyNode.StandaloneNode)templateBlock.get(i)).getSourceLocation(), i < pluralOrSelectIndex ? UNEXPECTED_CONTENT_BEFORE : UNEXPECTED_CONTENT_AFTER, pluralOrSelect instanceof MsgPluralNode ? "{plural" : "{select");
            }
            if ("" != null) {
                return ImmutableList.of((Object)pluralOrSelect);
            }
        }
        if ("" != null) {
            return templateBlock;
        }
        throw new Error("Missing return statement in function");
    }

    private final MsgPluralNode MsgPlural() throws ParseException {
        Token cmdBegin = this.jj_consume_token(55);
        String cmdText = this.CmdText();
        Token cmdEnd = this.jj_consume_token(70);
        MsgPluralNode msgPluralNode = new MsgPluralNode.Builder(this.nodeIdGen.genId(), cmdText, this.createSrcLoc(cmdBegin, cmdEnd)).build(this.context);
        this.SkipWhitespace();
        try {
            List<SoyNode.StandaloneNode> templateBlock;
            block5: while (true) {
                int value;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 61: {
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                        break block5;
                    }
                }
                cmdBegin = this.jj_consume_token(61);
                ExprNode caseExpr = this.Expr();
                cmdEnd = this.jj_consume_token(70);
                if (!(caseExpr instanceof IntegerNode)) {
                    this.errorReporter.report(caseExpr.getSourceLocation(), PLURAL_CASE_MALFORMED, new Object[0]);
                    value = 0;
                } else {
                    value = (int)((IntegerNode)caseExpr).getValue();
                    if (value < 0) {
                        this.errorReporter.report(caseExpr.getSourceLocation(), PLURAL_CASE_OUT_OF_BOUNDS, value);
                        value = 0;
                    }
                }
                MsgPluralCaseNode caseNode = new MsgPluralCaseNode(this.nodeIdGen.genId(), this.createSrcLoc(cmdBegin, cmdEnd), value);
                msgPluralNode.addChild(caseNode);
                templateBlock = this.TemplateBlockForMsg();
                if (templateBlock.size() == 1 && (templateBlock.get(0) instanceof MsgPluralNode || templateBlock.get(0) instanceof MsgSelectNode)) {
                    this.errorReporter.report(templateBlock.get(0).getSourceLocation(), PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK, new Object[0]);
                }
                caseNode.addChildren(templateBlock);
            }
            Token defaultTag = this.jj_consume_token(62);
            MsgPluralDefaultNode defaultNode = new MsgPluralDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(defaultTag, new Token[0]));
            msgPluralNode.addChild(defaultNode);
            templateBlock = this.TemplateBlockForMsg();
            if (templateBlock.size() == 1 && (templateBlock.get(0) instanceof MsgPluralNode || templateBlock.get(0) instanceof MsgSelectNode)) {
                this.errorReporter.report(templateBlock.get(0).getSourceLocation(), PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK, new Object[0]);
            }
            defaultNode.addChildren(templateBlock);
            this.jj_consume_token(56);
        }
        catch (ParseException e) {
            this.reportTemplateBodyErrorAndSkipTo(e, 56);
        }
        if ("" != null) {
            return msgPluralNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final MsgSelectNode MsgSelect() throws ParseException {
        Token cmdBegin = this.jj_consume_token(57);
        String cmdText = this.CmdText();
        Token cmdEnd = this.jj_consume_token(70);
        MsgSelectNode msgSelectNode = new MsgSelectNode.Builder(this.nodeIdGen.genId(), cmdText, this.createSrcLoc(cmdBegin, cmdEnd)).build(this.context);
        this.SkipWhitespace();
        try {
            List<SoyNode.StandaloneNode> templateBlock;
            block5: while (true) {
                String value;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 61: {
                        break;
                    }
                    default: {
                        this.jj_la1[33] = this.jj_gen;
                        break block5;
                    }
                }
                cmdBegin = this.jj_consume_token(61);
                ExprNode caseExpr = this.Expr();
                cmdEnd = this.jj_consume_token(70);
                if (!(caseExpr instanceof StringNode)) {
                    this.errorReporter.report(caseExpr.getSourceLocation(), SELECT_CASE_INVALID_STRING, new Object[0]);
                    value = "";
                } else {
                    value = ((StringNode)caseExpr).getValue();
                }
                MsgSelectCaseNode caseNode = new MsgSelectCaseNode(this.nodeIdGen.genId(), this.createSrcLoc(cmdBegin, cmdEnd), value);
                msgSelectNode.addChild(caseNode);
                templateBlock = this.TemplateBlockForMsg();
                caseNode.addChildren(templateBlock);
            }
            Token defaultTag = this.jj_consume_token(62);
            MsgSelectDefaultNode defaultNode = new MsgSelectDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(defaultTag, new Token[0]));
            msgSelectNode.addChild(defaultNode);
            templateBlock = this.TemplateBlockForMsg();
            defaultNode.addChildren(templateBlock);
            this.jj_consume_token(58);
        }
        catch (ParseException e) {
            this.reportTemplateBodyErrorAndSkipTo(e, 58);
        }
        if ("" != null) {
            return msgSelectNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final MsgHtmlTagNode MsgHtmlTag() throws ParseException {
        Token htmlTagOpen = this.jj_consume_token(92);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        this.jj_consume_token(93);
        SourceLocation srcLoc = this.createSrcLoc(htmlTagOpen, new Token[0]);
        if (templateBlock.get(0) instanceof RawTextNode) {
            RawTextNode firstNode = (RawTextNode)templateBlock.get(0);
            RawTextNode newNode = new RawTextNode(this.nodeIdGen.genId(), "<" + firstNode.getRawText(), srcLoc.extend(firstNode.getSourceLocation()));
            templateBlock.set(0, newNode);
        } else {
            templateBlock.add(0, new RawTextNode(this.nodeIdGen.genId(), "<", srcLoc));
        }
        int lastNodeIndex = templateBlock.size() - 1;
        if (templateBlock.get(lastNodeIndex) instanceof RawTextNode) {
            RawTextNode lastNode = (RawTextNode)templateBlock.get(lastNodeIndex);
            RawTextNode newNode = new RawTextNode(this.nodeIdGen.genId(), lastNode.getRawText() + ">", lastNode.getSourceLocation().extend(srcLoc));
            templateBlock.set(lastNodeIndex, newNode);
        } else {
            templateBlock.add(new RawTextNode(this.nodeIdGen.genId(), ">", srcLoc));
        }
        if ("" != null) {
            return new MsgHtmlTagNode.Builder(this.nodeIdGen.genId(), (ImmutableList<SoyNode.StandaloneNode>)ImmutableList.copyOf(templateBlock), this.createSrcLoc(htmlTagOpen, new Token[0])).build(this.errorReporter);
        }
        throw new Error("Missing return statement in function");
    }

    private final SourceItemInfo<List<String>> PrintTag() throws ParseException {
        Token tagBegin;
        ArrayList<String> printTagParts = new ArrayList<String>();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 44: {
                tagBegin = this.jj_consume_token(44);
                printTagParts.add("print");
                break;
            }
            case 69: {
                tagBegin = this.jj_consume_token(69);
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        List<String> cmdTextParts = this.CmdTextParts();
        printTagParts.addAll(cmdTextParts);
        Token tagEnd = this.jj_consume_token(70);
        if (!printTagParts.isEmpty()) {
            if (((String)printTagParts.get(0)).startsWith("/")) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, tagEnd), UNEXPECTED_CLOSING_TAG, "{" + Joiner.on((String)"").join(printTagParts) + "}");
            } else if (((String)printTagParts.get(0)).startsWith("@")) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, tagEnd), INVALID_DECLARATION, "{" + (String)printTagParts.get(0));
            } else if (((String)printTagParts.get(0)).startsWith("{")) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, tagEnd), FOUND_DOUBLE_BRACE, new Object[0]);
            } else if (INVALID_PRINT_FILE_PREFIX_PATTERN.matcher((CharSequence)printTagParts.get(0)).matches()) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, tagEnd), INVALID_TEMPLATE_COMMAND, "{" + (String)printTagParts.get(0));
            } else if (INVALID_PRINT_PREFIX_PATTERN.matcher((CharSequence)printTagParts.get(0)).matches()) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, tagEnd), INVALID_PRINT_PREFIX, "{" + (String)printTagParts.get(0));
            }
        }
        if ("" != null) {
            return this.newSourceItemInfo(printTagParts, tagBegin, tagEnd);
        }
        throw new Error("Missing return statement in function");
    }

    private final PrintNode PrintStmt() throws ParseException {
        String userSuppliedPhName;
        boolean isImplicit;
        Token tagBegin;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 44: {
                tagBegin = this.jj_consume_token(44);
                isImplicit = false;
                break;
            }
            case 69: {
                tagBegin = this.jj_consume_token(69);
                isImplicit = true;
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        List<String> cmdTextParts = this.CmdTextParts();
        Token tagEnd = this.jj_consume_token(70);
        SourceLocation location = this.createSrcLoc(tagBegin, tagEnd);
        if (cmdTextParts.isEmpty()) {
            this.errorReporter.report(location, PRINT_COMMAND_WITH_EMPTY_TEXT, new Object[0]);
        } else if (cmdTextParts.get(0).startsWith("/")) {
            this.errorReporter.report(location, UNEXPECTED_CLOSING_TAG, "{" + Joiner.on((String)"").join(cmdTextParts) + "}");
        } else if (cmdTextParts.get(0).startsWith("@")) {
            this.errorReporter.report(location, INVALID_DECLARATION, "{" + cmdTextParts.get(0));
        } else if (cmdTextParts.get(0).startsWith("{")) {
            this.errorReporter.report(location, FOUND_DOUBLE_BRACE, new Object[0]);
        } else if (INVALID_PRINT_FILE_PREFIX_PATTERN.matcher(cmdTextParts.get(0)).matches()) {
            this.errorReporter.report(location, INVALID_TEMPLATE_COMMAND, "{" + cmdTextParts.get(0));
        } else if (INVALID_PRINT_PREFIX_PATTERN.matcher(cmdTextParts.get(0)).matches()) {
            this.errorReporter.report(location, INVALID_PRINT_PREFIX, "{" + cmdTextParts.get(0));
        }
        String cmdText = Joiner.on((String)"").join(cmdTextParts);
        String phnameAttr = null;
        for (String cmdTextPart : cmdTextParts) {
            if (!cmdTextPart.startsWith(" phname=\"") || !cmdTextPart.endsWith("\"")) continue;
            if (phnameAttr != null) {
                this.errorReporter.report(location, MULTIPLE_PHNAME_ATTRIBUTES_IN_COMMAND, cmdText);
            }
            phnameAttr = cmdTextPart;
        }
        if (phnameAttr != null) {
            cmdTextParts.remove(phnameAttr);
            userSuppliedPhName = phnameAttr.substring(9, phnameAttr.length() - 1);
        } else {
            userSuppliedPhName = null;
        }
        String exprText = cmdTextParts.isEmpty() ? "''" : cmdTextParts.get(0).trim();
        PrintNode printNode = new PrintNode.Builder(this.nodeIdGen.genId(), isImplicit, location).exprText(exprText).userSuppliedPlaceholderName(userSuppliedPhName).build(this.context);
        String directiveName = null;
        int n = cmdTextParts.size();
        for (int i = 1; i < n; ++i) {
            String cmdTextPart = cmdTextParts.get(i);
            if (cmdTextPart.startsWith("|")) {
                if (directiveName != null) {
                    printNode.addChild(new PrintDirectiveNode.Builder(this.nodeIdGen.genId(), directiveName, "", location).build(this.context));
                }
                directiveName = cmdTextPart;
                continue;
            }
            if (cmdTextPart.startsWith(":")) {
                if (directiveName == null) {
                    throw new AssertionError();
                }
                String argsText = cmdTextPart.substring(1);
                printNode.addChild(new PrintDirectiveNode.Builder(this.nodeIdGen.genId(), directiveName, argsText, location).build(this.context));
                directiveName = null;
                continue;
            }
            if (cmdTextPart.trim().length() == 0) continue;
            this.errorReporter.report(printNode.getSourceLocation(), INVALID_PRINT_COMMAND_TEXT, cmdText);
        }
        if (directiveName != null) {
            printNode.addChild(new PrintDirectiveNode.Builder(this.nodeIdGen.genId(), directiveName, "", location).build(this.context));
        }
        if ("" != null) {
            return printNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final XidNode XidStmt() throws ParseException {
        String xid;
        Token cmdBegin;
        StringBuilder value;
        Token first;
        Token cmdEnd;
        block20: {
            cmdEnd = null;
            first = null;
            value = null;
            cmdBegin = this.jj_consume_token(45);
            try {
                first = this.jj_consume_token(75);
                block1 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 78: 
                    case 79: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 78: {
                                block15: while (true) {
                                    this.jj_consume_token(78);
                                    Token tok = this.jj_consume_token(75);
                                    if (value == null) {
                                        value = new StringBuilder().append(first.image);
                                    }
                                    value.append('.').append(tok.image);
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 78: {
                                            continue block15;
                                        }
                                    }
                                    break;
                                }
                                this.jj_la1[36] = this.jj_gen;
                                break block1;
                            }
                            case 79: {
                                block16: while (true) {
                                    this.jj_consume_token(79);
                                    Token tok = this.jj_consume_token(75);
                                    if (value == null) {
                                        value = new StringBuilder().append(first.image);
                                    }
                                    value.append('-').append(tok.image);
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 79: {
                                            continue block16;
                                        }
                                    }
                                    break;
                                }
                                this.jj_la1[37] = this.jj_gen;
                                break block1;
                            }
                        }
                        this.jj_la1[38] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[39] = this.jj_gen;
                    }
                }
                cmdEnd = this.jj_consume_token(70);
            }
            catch (ParseException e) {
                this.reportTemplateBodyErrorAndSkipTo(e, 70);
                if ("" == null) break block20;
                return XidNode.error(this.createSrcLoc(cmdBegin, new Token[0]));
            }
        }
        String string = xid = value == null ? first.image : value.toString();
        if ("" != null) {
            return new XidNode(this.nodeIdGen.genId(), this.createSrcLoc(cmdBegin, cmdEnd), xid);
        }
        throw new Error("Missing return statement in function");
    }

    private final CssNode CssStmt() throws ParseException {
        Token cmdBegin = this.jj_consume_token(46);
        String cmdText = this.CmdText();
        Token cmdEnd = this.jj_consume_token(70);
        if ("" != null) {
            return new CssNode.Builder(this.nodeIdGen.genId(), cmdText, this.createSrcLoc(cmdBegin, cmdEnd)).build(this.context);
        }
        throw new Error("Missing return statement in function");
    }

    private final LetNode LetStmt() throws ParseException {
        LetNode letNode;
        Token tagBegin = this.jj_consume_token(51);
        SourceItemInfo<String> cmdText = this.CmdTextWithSource();
        ErrorReporter.Checkpoint cmdTextCheckpoint = this.errorReporter.checkpoint();
        LetNode.CommandTextParseResult result = LetNode.parseCommandTextHelper(cmdText.parsedContent(), this.context, cmdText.srcLocation());
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 71: {
                Token tagEnd = this.jj_consume_token(71);
                letNode = new LetValueNode.Builder(this.nodeIdGen.genId(), result, this.createSrcLoc(tagBegin, tagEnd)).build(cmdTextCheckpoint, this.errorReporter);
                break;
            }
            case 70: {
                this.pushState(5);
                ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
                Token tagEnd = this.jj_consume_token(70);
                LetContentNode letContentNode = new LetContentNode.Builder(this.nodeIdGen.genId(), result, this.createSrcLoc(tagBegin, tagEnd)).build(cmdTextCheckpoint, this.errorReporter);
                List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
                letContentNode.addChildren((List<? extends SoyNode.StandaloneNode>)templateBlock);
                letNode = letContentNode;
                if (this.errorReporter.errorsSince(checkpoint) || this.getToken((int)1).kind != 52) {
                    this.popStateIfStateIs(5);
                } else {
                    this.popState();
                }
                this.jj_consume_token(52);
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return letNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final IfNode IfStmt() throws ParseException {
        Token cmdEnd;
        ExprNode ifExpr;
        Token cmdBegin = this.jj_consume_token(47);
        try {
            ifExpr = this.Expr();
            cmdEnd = this.jj_consume_token(70);
        }
        catch (ParseException e) {
            ifExpr = this.errorExpr(cmdBegin, new Token[0]);
            cmdEnd = this.reportTemplateBodyErrorAndSkipTo(e, 70);
        }
        SourceLocation location = this.createSrcLoc(cmdBegin, cmdEnd);
        IfNode ifNode = new IfNode(this.nodeIdGen.genId(), location);
        IfCondNode ifCondNode = new IfCondNode(this.nodeIdGen.genId(), location, "if", ifExpr);
        ifNode.addChild(ifCondNode);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        ifCondNode.addChildren(templateBlock);
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 48: {
                    break;
                }
                default: {
                    this.jj_la1[41] = this.jj_gen;
                    break block10;
                }
            }
            cmdBegin = this.jj_consume_token(48);
            try {
                ifExpr = this.Expr();
                cmdEnd = this.jj_consume_token(70);
            }
            catch (ParseException e) {
                ifExpr = this.errorExpr(cmdBegin, new Token[0]);
                cmdEnd = this.reportTemplateBodyErrorAndSkipTo(e, 70);
            }
            location = this.createSrcLoc(cmdBegin, cmdEnd);
            ifCondNode = new IfCondNode(this.nodeIdGen.genId(), location, "elseif", ifExpr);
            ifNode.addChild(ifCondNode);
            templateBlock = this.TemplateBlock();
            ifCondNode.addChildren(templateBlock);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 49: {
                Token elseTag = this.jj_consume_token(49);
                IfElseNode ifElseNode = new IfElseNode(this.nodeIdGen.genId(), this.createSrcLoc(elseTag, new Token[0]));
                ifNode.addChild(ifElseNode);
                templateBlock = this.TemplateBlock();
                ifElseNode.addChildren(templateBlock);
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
            }
        }
        this.jj_consume_token(50);
        if ("" != null) {
            return ifNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final SwitchNode SwitchStmt() throws ParseException {
        Token cmdEnd;
        ExprNode switchExpr;
        Token cmdBegin = this.jj_consume_token(59);
        try {
            switchExpr = this.Expr();
            cmdEnd = this.jj_consume_token(70);
        }
        catch (ParseException e) {
            switchExpr = this.errorExpr(cmdBegin, new Token[0]);
            cmdEnd = this.reportTemplateBodyErrorAndSkipTo(e, 70);
        }
        SwitchNode switchNode = new SwitchNode(this.nodeIdGen.genId(), this.createSrcLoc(cmdBegin, cmdEnd), switchExpr);
        this.SkipWhitespace();
        try {
            List<SoyNode.StandaloneNode> templateBlock;
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 61: {
                        break;
                    }
                    default: {
                        this.jj_la1[43] = this.jj_gen;
                        break block10;
                    }
                }
                cmdBegin = this.jj_consume_token(61);
                ImmutableList<ExprNode> caseExprs = this.ExprList();
                cmdEnd = this.jj_consume_token(70);
                SwitchCaseNode caseNode = new SwitchCaseNode(this.nodeIdGen.genId(), this.createSrcLoc(cmdBegin, cmdEnd), caseExprs);
                switchNode.addChild(caseNode);
                templateBlock = this.TemplateBlock();
                caseNode.addChildren(templateBlock);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 62: {
                    Token defaultTag = this.jj_consume_token(62);
                    SwitchDefaultNode defaultNode = new SwitchDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(defaultTag, new Token[0]));
                    switchNode.addChild(defaultNode);
                    templateBlock = this.TemplateBlock();
                    defaultNode.addChildren(templateBlock);
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                }
            }
            this.jj_consume_token(60);
        }
        catch (ParseException e) {
            this.reportTemplateBodyErrorAndSkipTo(e, 60);
        }
        if ("" != null) {
            return switchNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final ForeachNode ForeachStmt() throws ParseException {
        Token cmdBegin = this.jj_consume_token(63);
        String cmdText = this.CmdText();
        Token cmdEnd = this.jj_consume_token(70);
        ForeachBuilder builder = ForeachBuilder.create(this.nodeIdGen, this.context).setCommandLocation(this.createSrcLoc(cmdBegin, cmdEnd)).setCommandText(cmdText);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        builder.setLoopBody(templateBlock);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 64: {
                Token ifemptyTag = this.jj_consume_token(64);
                templateBlock = this.TemplateBlock();
                builder.setIfEmptyBody(this.createSrcLoc(ifemptyTag, new Token[0]), templateBlock);
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
            }
        }
        this.jj_consume_token(65);
        if ("" != null) {
            return builder.build();
        }
        throw new Error("Missing return statement in function");
    }

    private final ForNode ForStmt() throws ParseException {
        Token cmdBegin = this.jj_consume_token(53);
        String cmdText = this.CmdText();
        Token cmdEnd = this.jj_consume_token(70);
        ForNode forNode = new ForNode(this.nodeIdGen.genId(), cmdText, this.createSrcLoc(cmdBegin, cmdEnd), this.context);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        forNode.addChildren(templateBlock);
        this.jj_consume_token(54);
        if ("" != null) {
            return forNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final CallNode CallStmt() throws ParseException {
        CallNode callNode = null;
        block2 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: {
                Token tagBegin = this.jj_consume_token(35);
                List<String> cmdTextParts = this.CmdTextParts();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 71: {
                        Token tagEnd = this.jj_consume_token(71);
                        callNode = this.setCommandTextAndPlaceholderName(new CallBasicNode.Builder(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd)), cmdTextParts).build(this.context);
                        break block2;
                    }
                    case 70: {
                        Token tagEnd = this.jj_consume_token(70);
                        callNode = this.setCommandTextAndPlaceholderName(new CallBasicNode.Builder(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd)), cmdTextParts).build(this.context);
                        try {
                            this.AddParams(callNode);
                            this.jj_consume_token(37);
                        }
                        catch (ParseException e) {
                            this.reportTemplateBodyErrorAndSkipTo(e, 37);
                        }
                        break block2;
                    }
                }
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 36: {
                Token tagBegin = this.jj_consume_token(36);
                List<String> cmdTextParts = this.CmdTextParts();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 71: {
                        Token tagEnd = this.jj_consume_token(71);
                        callNode = this.setCommandTextAndPlaceholderName(new CallDelegateNode.Builder(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd)), cmdTextParts).build(this.context);
                        break block2;
                    }
                    case 70: {
                        Token tagEnd = this.jj_consume_token(70);
                        callNode = this.setCommandTextAndPlaceholderName(new CallDelegateNode.Builder(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd)), cmdTextParts).build(this.context);
                        try {
                            this.AddParams(callNode);
                            this.jj_consume_token(38);
                        }
                        catch (ParseException e) {
                            this.reportTemplateBodyErrorAndSkipTo(e, 38);
                        }
                        break block2;
                    }
                }
                this.jj_la1[47] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return callNode;
        }
        throw new Error("Missing return statement in function");
    }

    private CallNode.Builder setCommandTextAndPlaceholderName(CallNode.Builder builder, List<String> cmdTextParts) throws ParseException {
        StringBuilder cmdTextSb = new StringBuilder();
        String phnameAttr = null;
        for (int i = 0; i < cmdTextParts.size(); ++i) {
            String cmdTextPart = cmdTextParts.get(i);
            if (cmdTextPart.startsWith(" phname=\"") && cmdTextPart.endsWith("\"")) {
                if (phnameAttr != null) {
                    this.errorReporter.report(builder.getSourceLocation(), MULTIPLE_PHNAME_ATTRIBUTES_IN_COMMAND, Joiner.on((String)"").join(cmdTextParts));
                }
                phnameAttr = cmdTextPart;
                continue;
            }
            cmdTextSb.append(cmdTextPart);
        }
        String userSuppliedPhName = phnameAttr != null ? phnameAttr.substring(9, phnameAttr.length() - 1) : null;
        return builder.commandText(cmdTextSb.toString()).userSuppliedPlaceholderName(userSuppliedPhName);
    }

    private final void AddParams(CallNode callNode) throws ParseException {
        this.SkipWhitespace();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 39: {
                    break;
                }
                default: {
                    this.jj_la1[49] = this.jj_gen;
                    break block3;
                }
            }
            CallParamNode callParam = this.CallParam();
            callNode.addChild(callParam);
            this.SkipWhitespace();
        }
    }

    private final CallParamNode CallParam() throws ParseException {
        CallParamNode callParamNode = null;
        Token tagBegin = this.jj_consume_token(39);
        SourceItemInfo<String> cmdText = this.CmdTextWithSource();
        ErrorReporter.Checkpoint cmdTextCheckpoint = this.errorReporter.checkpoint();
        CallParamNode.CommandTextParseResult result = CallParamNode.parseCommandTextHelper(cmdText.parsedContent(), this.context, cmdText.srcLocation());
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 71: {
                Token tagEnd = this.jj_consume_token(71);
                callParamNode = new CallParamValueNode.Builder(this.nodeIdGen.genId(), result, this.createSrcLoc(tagBegin, tagEnd)).build(cmdTextCheckpoint, this.errorReporter);
                break;
            }
            case 70: {
                this.pushState(5);
                ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
                Token tagEnd = this.jj_consume_token(70);
                CallParamContentNode cpcn = new CallParamContentNode.Builder(this.nodeIdGen.genId(), result, this.createSrcLoc(tagBegin, tagEnd)).build(cmdTextCheckpoint, this.errorReporter);
                List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
                cpcn.addChildren((List<? extends SoyNode.StandaloneNode>)templateBlock);
                callParamNode = cpcn;
                if (this.errorReporter.errorsSince(checkpoint) || this.getToken((int)1).kind != 40) {
                    this.popStateIfStateIs(5);
                } else {
                    this.popState();
                }
                this.jj_consume_token(40);
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return callParamNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final LogNode LogStmt() throws ParseException {
        Token open = this.jj_consume_token(66);
        LogNode logNode = new LogNode(this.nodeIdGen.genId(), this.createSrcLoc(open, new Token[0]));
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        logNode.addChildren(templateBlock);
        this.jj_consume_token(67);
        if ("" != null) {
            return logNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final DebuggerNode DebuggerStmt() throws ParseException {
        Token token = this.jj_consume_token(68);
        if ("" != null) {
            return new DebuggerNode(this.nodeIdGen.genId(), this.createSrcLoc(token, new Token[0]));
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode.PrimitiveNode Primitive() throws ParseException {
        AbstractPrimitiveNode primitive;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 98: {
                Token tok = this.jj_consume_token(98);
                primitive = new NullNode(this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 99: {
                Token tok = this.jj_consume_token(99);
                primitive = new BooleanNode(true, this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 100: {
                Token tok = this.jj_consume_token(100);
                primitive = new BooleanNode(false, this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 101: {
                Token tok = this.jj_consume_token(101);
                SourceLocation loc = this.createSrcLoc(tok, new Token[0]);
                Long parsed = Longs.tryParse((String)tok.image, (int)10);
                if (parsed == null || !IntegerNode.isInRange(parsed)) {
                    this.errorReporter.report(loc, INTEGER_OUT_OF_RANGE, new Object[0]);
                    parsed = 0L;
                }
                primitive = new IntegerNode(parsed, loc);
                break;
            }
            case 102: {
                Token tok = this.jj_consume_token(102);
                SourceLocation loc = this.createSrcLoc(tok, new Token[0]);
                Long parsed = Longs.tryParse((String)tok.image.substring(2), (int)16);
                if (parsed == null || !IntegerNode.isInRange(parsed)) {
                    this.errorReporter.report(loc, INTEGER_OUT_OF_RANGE, new Object[0]);
                    parsed = 0L;
                }
                primitive = new IntegerNode(parsed, loc);
                break;
            }
            case 103: {
                Token tok = this.jj_consume_token(103);
                primitive = new FloatNode(Double.parseDouble(tok.image), this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 104: {
                Token tok = this.jj_consume_token(104);
                String strNoQuotes = tok.image.substring(1, tok.image.length() - 1);
                primitive = new StringNode(UnescapeUtils.unescapeJs(strNoQuotes), this.createSrcLoc(tok, new Token[0]));
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return primitive;
        }
        throw new Error("Missing return statement in function");
    }

    private final ImmutableList<ExprNode> ExprList() throws ParseException {
        ImmutableList.Builder exprList = ImmutableList.builder();
        ExprNode expr = this.Expr();
        exprList.add((Object)expr);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 129: {
                    break;
                }
                default: {
                    this.jj_la1[52] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(129);
            expr = this.Expr();
            exprList.add((Object)expr);
        }
        if ("" != null) {
            return exprList.build();
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode Expr() throws ParseException {
        ExprNode expr = this.PrecExpr1();
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr1() throws ParseException {
        ExprNode expr = this.PrecExpr2();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 107: 
            case 109: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 109: {
                        this.jj_consume_token(109);
                        ExprNode expr1 = this.PrecExpr1();
                        expr = Operator.NULL_COALESCING.createNode(expr, expr1);
                        break block0;
                    }
                    case 107: {
                        this.jj_consume_token(107);
                        ExprNode expr1 = this.PrecExpr1();
                        this.jj_consume_token(108);
                        ExprNode expr2 = this.PrecExpr1();
                        expr = Operator.CONDITIONAL.createNode(expr, expr1, expr2);
                        break block0;
                    }
                }
                this.jj_la1[53] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
            }
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr2() throws ParseException {
        ExprNode expr = this.PrecExpr3();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 110: {
                    break;
                }
                default: {
                    this.jj_la1[55] = this.jj_gen;
                    break block3;
                }
            }
            Token op = this.jj_consume_token(110);
            ExprNode rightHand = this.PrecExpr3();
            expr = Operator.createOperatorNode(op.image, 2, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr3() throws ParseException {
        ExprNode expr = this.PrecExpr4();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 111: {
                    break;
                }
                default: {
                    this.jj_la1[56] = this.jj_gen;
                    break block3;
                }
            }
            Token op = this.jj_consume_token(111);
            ExprNode rightHand = this.PrecExpr4();
            expr = Operator.createOperatorNode(op.image, 3, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr4() throws ParseException {
        ExprNode expr = this.PrecExpr5();
        block7: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 112: 
                case 113: {
                    break;
                }
                default: {
                    this.jj_la1[57] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 112: {
                    op = this.jj_consume_token(112);
                    break;
                }
                case 113: {
                    op = this.jj_consume_token(113);
                    break;
                }
                default: {
                    this.jj_la1[58] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr5();
            expr = Operator.createOperatorNode(op.image, 4, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr5() throws ParseException {
        ExprNode expr = this.PrecExpr6();
        block9: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 114: 
                case 115: 
                case 116: 
                case 117: {
                    break;
                }
                default: {
                    this.jj_la1[59] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 114: {
                    op = this.jj_consume_token(114);
                    break;
                }
                case 115: {
                    op = this.jj_consume_token(115);
                    break;
                }
                case 116: {
                    op = this.jj_consume_token(116);
                    break;
                }
                case 117: {
                    op = this.jj_consume_token(117);
                    break;
                }
                default: {
                    this.jj_la1[60] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr6();
            expr = Operator.createOperatorNode(op.image, 5, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr6() throws ParseException {
        ExprNode expr = this.PrecExpr7();
        block7: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 118: 
                case 119: {
                    break;
                }
                default: {
                    this.jj_la1[61] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 118: {
                    op = this.jj_consume_token(118);
                    break;
                }
                case 119: {
                    op = this.jj_consume_token(119);
                    break;
                }
                default: {
                    this.jj_la1[62] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr7();
            expr = Operator.createOperatorNode(op.image, 6, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr7() throws ParseException {
        ExprNode expr = this.PrecExpr8();
        block8: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 120: 
                case 121: 
                case 122: {
                    break;
                }
                default: {
                    this.jj_la1[63] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 120: {
                    op = this.jj_consume_token(120);
                    break;
                }
                case 121: {
                    op = this.jj_consume_token(121);
                    break;
                }
                case 122: {
                    op = this.jj_consume_token(122);
                    break;
                }
                default: {
                    this.jj_la1[64] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr8();
            expr = Operator.createOperatorNode(op.image, 7, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr8() throws ParseException {
        ExprNode expr;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 126: 
            case 130: 
            case 132: 
            case 133: 
            case 134: {
                expr = this.PrecExpr9();
                break;
            }
            case 119: 
            case 123: {
                Token unaryOp;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 123: {
                        unaryOp = this.jj_consume_token(123);
                        break;
                    }
                    case 119: {
                        unaryOp = this.jj_consume_token(119);
                        break;
                    }
                    default: {
                        this.jj_la1[65] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                expr = this.PrecExpr8();
                expr = Operator.createOperatorNode(unaryOp.image, 8, expr);
                break;
            }
            default: {
                this.jj_la1[66] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr9() throws ParseException {
        ExprNode expr;
        block17: {
            expr = this.Primary();
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 124: 
                    case 125: 
                    case 126: 
                    case 128: {
                        break;
                    }
                    default: {
                        this.jj_la1[67] = this.jj_gen;
                        break block17;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 124: 
                    case 125: {
                        Token op;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 124: {
                                op = this.jj_consume_token(124);
                                break;
                            }
                            case 125: {
                                op = this.jj_consume_token(125);
                                break;
                            }
                            default: {
                                this.jj_la1[68] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        Token ident = this.jj_consume_token(132);
                        expr = new FieldAccessNode(expr, ident.image, this.createSrcLoc(op, ident), op.kind == 125);
                        continue block15;
                    }
                    case 126: 
                    case 128: {
                        Token open;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 126: {
                                open = this.jj_consume_token(126);
                                break;
                            }
                            case 128: {
                                open = this.jj_consume_token(128);
                                break;
                            }
                            default: {
                                this.jj_la1[69] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        ExprNode keyExpr = this.Expr();
                        Token close = this.jj_consume_token(127);
                        expr = new ItemAccessNode(expr, keyExpr, this.createSrcLoc(open, close), open.kind == 128);
                        continue block15;
                    }
                }
                break;
            }
            this.jj_la1[70] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode Primary() throws ParseException {
        ExprNode primary;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 130: {
                this.jj_consume_token(130);
                primary = this.Expr();
                this.jj_consume_token(131);
                break;
            }
            case 133: 
            case 134: {
                primary = this.VarRef();
                break;
            }
            case 132: {
                primary = this.GlobalOrFunction();
                break;
            }
            case 126: {
                primary = this.CollectionLiteral();
                break;
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                primary = this.Primitive();
                break;
            }
            default: {
                this.jj_la1[71] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return primary;
        }
        throw new Error("Missing return statement in function");
    }

    private final VarRefNode VarRef() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 133: {
                Token ij = this.jj_consume_token(133);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 124: {
                        this.jj_consume_token(124);
                        Token ident = this.jj_consume_token(132);
                        if ("" == null) break;
                        return new VarRefNode(ident.image, this.createSrcLoc(ij, ident), true, null);
                    }
                    default: {
                        this.jj_la1[72] = this.jj_gen;
                    }
                }
                SourceLocation loc = this.createSrcLoc(ij, new Token[0]);
                this.errorReporter.report(loc, INVALID_VAR_NAME_IJ, new Object[0]);
                if ("" == null) break;
                return new VarRefNode("ij", loc, false, null);
            }
            case 134: {
                Token ident = this.jj_consume_token(134);
                if ("" == null) break;
                return new VarRefNode(ident.image.substring(1), this.createSrcLoc(ident, new Token[0]), false, null);
            }
            default: {
                this.jj_la1[73] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode GlobalOrFunction() throws ParseException {
        Token openParen = null;
        Token closeParen = null;
        ArrayList<ExprNode> params = new ArrayList<ExprNode>();
        Identifier ident = this.Identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 130: {
                openParen = this.jj_consume_token(130);
                block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 119: 
                    case 123: 
                    case 126: 
                    case 130: 
                    case 132: 
                    case 133: 
                    case 134: {
                        ExprNode first = this.Expr();
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 108: {
                                this.jj_consume_token(108);
                                ExprNode expr = this.Expr();
                                if (!(first instanceof GlobalNode) || !BaseUtils.isIdentifier(((GlobalNode)first).getName())) {
                                    this.errorReporter.report(first.getSourceLocation(), INVALID_PARAM_NAME, first.toSourceString());
                                    first = GlobalNode.ERROR;
                                }
                                LinkedHashSet<String> paramNames = new LinkedHashSet<String>();
                                paramNames.add(((GlobalNode)first).getName());
                                params.add(expr);
                                block16: while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 129: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[74] = this.jj_gen;
                                            break block16;
                                        }
                                    }
                                    this.jj_consume_token(129);
                                    Token paramName = this.jj_consume_token(132);
                                    if (!paramNames.add(paramName.image)) {
                                        this.errorReporter.report(this.createSrcLoc(paramName, new Token[0]), DUPLICATE_PARAM_NAME, paramName.image);
                                    }
                                    this.jj_consume_token(108);
                                    expr = this.Expr();
                                    params.add(expr);
                                }
                                closeParen = this.jj_consume_token(131);
                                ProtoInitNode pNode = new ProtoInitNode(ident.identifier(), paramNames, ident.location().extend(this.createSrcLoc(closeParen, new Token[0])));
                                pNode.addChildren((List<? extends ExprNode>)params);
                                if ("" == null) break block3;
                                return pNode;
                            }
                            case 129: 
                            case 131: {
                                params.add(first);
                                block17: while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 129: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[75] = this.jj_gen;
                                            break block17;
                                        }
                                    }
                                    this.jj_consume_token(129);
                                    ExprNode expr = this.Expr();
                                    params.add(expr);
                                }
                                closeParen = this.jj_consume_token(131);
                                FunctionNode fnNode = new FunctionNode(ident.identifier(), ident.location().extend(this.createSrcLoc(closeParen, new Token[0])));
                                fnNode.addChildren((List<? extends ExprNode>)params);
                                if ("" == null) break block3;
                                return fnNode;
                            }
                            default: {
                                this.jj_la1[76] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                    }
                    default: {
                        this.jj_la1[77] = this.jj_gen;
                    }
                }
                closeParen = this.jj_consume_token(131);
                break;
            }
            default: {
                this.jj_la1[78] = this.jj_gen;
            }
        }
        if (openParen == null && "" != null) {
            return new GlobalNode(ident.identifier(), ident.location());
        }
        if ("" != null) {
            return new FunctionNode(ident.identifier(), ident.location().extend(this.createSrcLoc(closeParen, new Token[0])));
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode CollectionLiteral() throws ParseException {
        Object items = ImmutableList.of();
        Token begin = this.jj_consume_token(126);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 108: {
                this.jj_consume_token(108);
                Token end = this.jj_consume_token(127);
                if ("" == null) break;
                return new MapLiteralNode((List<ExprNode>)items, this.createSrcLoc(begin, end));
            }
            case 127: {
                Token end = this.jj_consume_token(127);
                if ("" == null) break;
                return new ListLiteralNode((List<ExprNode>)items, this.createSrcLoc(begin, end));
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 119: 
            case 123: 
            case 126: 
            case 130: 
            case 132: 
            case 133: 
            case 134: {
                ExprNode itemExpr = this.MapKeyOrExpr();
                items = new ArrayList();
                items.add(itemExpr);
                if (this.jj_2_1(1)) {
                    while (this.getToken((int)1).kind == 129 && this.getToken((int)2).kind != 127) {
                        this.jj_consume_token(129);
                        itemExpr = this.Expr();
                        items.add(itemExpr);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 129: {
                            this.jj_consume_token(129);
                            break;
                        }
                        default: {
                            this.jj_la1[79] = this.jj_gen;
                        }
                    }
                    Token end = this.jj_consume_token(127);
                    if ("" == null) break;
                    return new ListLiteralNode((List<ExprNode>)items, this.createSrcLoc(begin, end));
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 108: {
                        this.jj_consume_token(108);
                        itemExpr = this.Expr();
                        items.add(itemExpr);
                        while (this.getToken((int)1).kind == 129 && this.getToken((int)2).kind != 127) {
                            this.jj_consume_token(129);
                            itemExpr = this.MapKeyOrExpr();
                            items.add(itemExpr);
                            this.jj_consume_token(108);
                            itemExpr = this.Expr();
                            items.add(itemExpr);
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 129: {
                                this.jj_consume_token(129);
                                break;
                            }
                            default: {
                                this.jj_la1[80] = this.jj_gen;
                            }
                        }
                        Token end = this.jj_consume_token(127);
                        if ("" == null) break block0;
                        return new MapLiteralNode((List<ExprNode>)items, this.createSrcLoc(begin, end));
                    }
                    default: {
                        this.jj_la1[81] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            default: {
                this.jj_la1[82] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode MapKeyOrExpr() throws ParseException {
        ExprNode itemExpr;
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            Token ident = this.jj_consume_token(132);
            itemExpr = new GlobalNode(ident.image, this.createSrcLoc(ident, new Token[0]));
            this.errorReporter.report(this.createSrcLoc(ident, new Token[0]), SINGLE_IDENTIFIER_KEY_IN_MAP_LITERAL, ident.image);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 119: 
                case 123: 
                case 126: 
                case 130: 
                case 132: 
                case 133: 
                case 134: {
                    itemExpr = this.Expr();
                    break;
                }
                default: {
                    this.jj_la1[83] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if ("" != null) {
            return itemExpr;
        }
        throw new Error("Missing return statement in function");
    }

    private final Identifier Identifier() throws ParseException {
        Token next = null;
        StringBuilder sb = null;
        Token first = this.jj_consume_token(132);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 124: {
                    break;
                }
                default: {
                    this.jj_la1[84] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(124);
            next = this.jj_consume_token(132);
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(first.image);
            }
            sb.append('.').append(next.image);
        }
        if (sb != null) {
            if ("" != null) {
                return Identifier.create(sb.toString(), this.createSrcLoc(first, next));
            }
        } else if ("" != null) {
            return Identifier.create(first.image, this.createSrcLoc(first, new Token[0]));
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode TypeExpr() throws ParseException {
        TypeNode first = null;
        TypeNode next = null;
        ArrayList<TypeNode> members = null;
        first = this.PrimaryType();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 88: {
                    break;
                }
                default: {
                    this.jj_la1[85] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(88);
            next = this.PrimaryType();
            if (members == null) {
                members = new ArrayList<TypeNode>();
                members.add(first);
            }
            members.add(next);
        }
        if ("" != null) {
            return members == null ? first : UnionTypeNode.create((Iterable<TypeNode>)members);
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode PrimaryType() throws ParseException {
        TypeNode type;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 80: {
                type = this.NamedType();
                break;
            }
            case 89: {
                type = this.UnknownType();
                break;
            }
            case 84: {
                type = this.RecordType();
                break;
            }
            default: {
                this.jj_la1[86] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return type;
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode RecordType() throws ParseException {
        Object properties = ImmutableList.of();
        Token open = this.jj_consume_token(84);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 80: {
                RecordTypeNode.Property prop = this.RecordField();
                properties = new ArrayList();
                properties.add(prop);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 86: {
                            break;
                        }
                        default: {
                            this.jj_la1[87] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(86);
                    prop = this.RecordField();
                    properties.add(prop);
                }
            }
            default: {
                this.jj_la1[88] = this.jj_gen;
            }
        }
        Token close = this.jj_consume_token(85);
        if ("" != null) {
            return RecordTypeNode.create(this.createSrcLoc(open, close), (Iterable<RecordTypeNode.Property>)properties);
        }
        throw new Error("Missing return statement in function");
    }

    private final RecordTypeNode.Property RecordField() throws ParseException {
        Token fieldName = this.jj_consume_token(80);
        this.jj_consume_token(87);
        TypeNode fieldType = this.TypeExpr();
        if ("" != null) {
            return RecordTypeNode.Property.create(this.createSrcLoc(fieldName, new Token[0]), fieldName.image, fieldType);
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode NamedType() throws ParseException {
        Token next = null;
        Object genericArgs = ImmutableList.of();
        StringBuilder sb = null;
        Token first = this.jj_consume_token(80);
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 81: {
                    break;
                }
                default: {
                    this.jj_la1[89] = this.jj_gen;
                    break block12;
                }
            }
            this.jj_consume_token(81);
            next = this.jj_consume_token(80);
            if (sb == null) {
                sb = new StringBuilder(first.image);
            }
            sb.append('.');
            sb.append(next.image);
        }
        String ident = sb == null ? first.image : sb.toString();
        SourceLocation fullLocation = next == null ? this.createSrcLoc(first, new Token[0]) : this.createSrcLoc(first, next);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 82: {
                Token open = this.jj_consume_token(82);
                block6 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 80: 
                    case 84: 
                    case 89: {
                        TypeNode arg = this.TypeExpr();
                        genericArgs = new ArrayList();
                        genericArgs.add(arg);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 86: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[90] = this.jj_gen;
                                    break block6;
                                }
                            }
                            this.jj_consume_token(86);
                            arg = this.TypeExpr();
                            genericArgs.add(arg);
                        }
                    }
                    default: {
                        this.jj_la1[91] = this.jj_gen;
                    }
                }
                Token close = this.jj_consume_token(83);
                if ("" == null) break;
                return GenericTypeNode.create(fullLocation.extend(this.createSrcLoc(close, new Token[0])), ident, (Iterable<? extends TypeNode>)genericArgs);
            }
            default: {
                this.jj_la1[92] = this.jj_gen;
            }
        }
        if ("" != null) {
            return NamedTypeNode.create(fullLocation, ident);
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode UnknownType() throws ParseException {
        Token tok = this.jj_consume_token(89);
        if ("" != null) {
            return NamedTypeNode.create(this.createSrcLoc(tok, new Token[0]), "?");
        }
        throw new Error("Missing return statement in function");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(132)) {
            return true;
        }
        return this.jj_scan_token(108);
    }

    private boolean jj_3R_37() {
        return this.jj_scan_token(129);
    }

    private boolean jj_3_1() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_37());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_scan_token(129)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(127);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{2048, 512, 393216, 65536, 0, 393216, 0, 0, 0, 0, 0, 0, 0, -134217728, -134217728, -134217728, 0x3C00000, 0, 0x3C00000, 0x3C00000, -134217728, -134217728, 0, 0, 0, 0, 0, 0, 0, -134217728, 0, -134217728, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 7, 7, 0, 0, 0, 0, -2010582497, -2010582497, -2010582504, 524288, 29208, -2011136000, 1024, 0, 0, 41947167, 0x2800000, 41947167, 0x20000000, 0x20000000, 4096, 4096, 0, 0, 0, 0, 0, 65536, 131072, 0x20000000, 0x40000000, 0, 0, 0, 24, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 2048, 0, 18432, 16384, 0x4000300, 768, 0x4000300, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 52, 52, 20, 32, 0, 0, 0, 0, 0x10000020, 0, 0x10000020, 0, 0, 32, 32, 16384, 32768, 49152, 49152, 192, 0, 0, 0, 0, 1, 192, 192, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1000000, 0x2110000, 0x400000, 65536, 131072, 0x400000, 0x2110000, 262144};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 0, 3, 3, 1, 1, 1, 0, 3, 3, 0, 0, 0, 0, 0, 1, 1, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 508, 0, 10240, 10240, 16384, 32768, 196608, 196608, 0x3C0000, 0x3C0000, 0xC00000, 0xC00000, 0x7000000, 0x7000000, 0x8800000, 1216348668, 0x70000000, 0x30000000, 0x40000000, 0x70000000, 1073742332, 0x10000000, 0, 0, 0, 4096, 1216348668, 0, 0, 0, 4096, -931130884, 1216348668, 0x10000000, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116, 1, 0, 1, 1, 116, 0, 96, 2, 2, 10, 116, 4, 2, 2, 0, 116, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public SoyFileParser(InputStream stream) {
        this(stream, null);
    }

    public SoyFileParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 93; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 93; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SoyFileParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 93; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 93; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SoyFileParser(SoyFileParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 93; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(SoyFileParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 93; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[148];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 93; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) == 0) continue;
                la1tokens[128 + j] = true;
            }
        }
        for (i = 0; i < 148; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        SoyFileParser.jj_la1_init_0();
        SoyFileParser.jj_la1_init_1();
        SoyFileParser.jj_la1_init_2();
        SoyFileParser.jj_la1_init_3();
        SoyFileParser.jj_la1_init_4();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    private static final class AbortParsingError
    extends Error {
        private AbortParsingError() {
        }
    }

    private static class RegexFromTokenImageFunction
    implements Function<String, String> {
        private RegexFromTokenImageFunction() {
        }

        public String apply(String o) {
            return Pattern.quote(o.substring(2, o.length() - 2));
        }
    }
}

