/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyNode;

public final class RewriteRemaindersVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind REMAINDER_ARITY_MISMATCH = SoyErrorKind.of("''remainder'' called with {0} arguments, expected 1.");
    private static final SoyErrorKind REMAINDER_OUTSIDE_PLURAL = SoyErrorKind.of("Special function ''remainder'' is for use in plural messages only.");
    private static final SoyErrorKind REMAINDER_PLURAL_EXPR_MISMATCH = SoyErrorKind.of("Argument to ''remainder'' must be the same as the ''plural'' variable");
    private static final SoyErrorKind REMAINDER_UNNECESSARY_AT_OFFSET_0 = SoyErrorKind.of("''remainder'' is unnecessary since offset=0.");
    private static final SoyErrorKind REMAINDER_WITH_PHNAME = SoyErrorKind.of("Special function ''remainder'' cannot be used with ''phname''.");
    private MsgPluralNode currPluralNode;
    private final ErrorReporter errorReporter;

    public RewriteRemaindersVisitor(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        FunctionNode functionNode;
        SoyParsingContext context = SoyParsingContext.empty(this.errorReporter, "fake.namespace");
        ExprRootNode exprRootNode = node.getExpr();
        if (exprRootNode.getRoot() instanceof FunctionNode && (functionNode = (FunctionNode)exprRootNode.getRoot()).getFunctionName().equals("remainder")) {
            if (this.currPluralNode == null) {
                this.errorReporter.report(functionNode.getSourceLocation(), REMAINDER_OUTSIDE_PLURAL, new Object[0]);
                return;
            }
            if (functionNode.numChildren() != 1) {
                this.errorReporter.report(functionNode.getSourceLocation(), REMAINDER_ARITY_MISMATCH, functionNode.numChildren());
            }
            if (!functionNode.getChild(0).toSourceString().equals(this.currPluralNode.getExpr().toSourceString())) {
                this.errorReporter.report(functionNode.getSourceLocation(), REMAINDER_PLURAL_EXPR_MISMATCH, new Object[0]);
            }
            if (this.currPluralNode.getOffset() == 0) {
                this.errorReporter.report(functionNode.getSourceLocation(), REMAINDER_UNNECESSARY_AT_OFFSET_0, new Object[0]);
            }
            if (node.getUserSuppliedPhName() != null) {
                this.errorReporter.report(functionNode.getSourceLocation(), REMAINDER_WITH_PHNAME, new Object[0]);
            }
            String newExprText = "(" + this.currPluralNode.getExpr().toSourceString() + ") - " + this.currPluralNode.getOffset();
            PrintNode newPrintNode = new PrintNode.Builder(node.getId(), node.isImplicit(), SourceLocation.UNKNOWN).exprText(newExprText).build(context);
            newPrintNode.addChildren(node.getChildren());
            node.getParent().replaceChild(node, newPrintNode);
        }
    }

    @Override
    protected void visitMsgPluralNode(MsgPluralNode node) {
        this.currPluralNode = node;
        this.visitChildren(node);
        this.currPluralNode = null;
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)node);
        }
    }
}

