/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.NodeVisitor;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.basetree.SyntaxVersionUpperBound;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;

final class ReportSyntaxVersionErrors {
    private static final SoyErrorKind SYNTAX_VERSION_OUT_OF_BOUNDS = SoyErrorKind.of("{0}: {1}");
    private final SyntaxVersion requiredSyntaxVersion;
    private final ErrorReporter errorReporter;
    private final String errorPreamble;

    ReportSyntaxVersionErrors(SyntaxVersion requiredSyntaxVersion, boolean isDeclared, ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.requiredSyntaxVersion = requiredSyntaxVersion;
        this.errorPreamble = requiredSyntaxVersion == SyntaxVersion.V1_0 ? "incorrect v1 syntax" : (isDeclared ? "declared" : "inferred") + " syntax version " + (Object)((Object)requiredSyntaxVersion) + " not satisfied";
    }

    public void report(SoyFileNode node) {
        for (final TemplateNode template : node.getChildren()) {
            SoyTreeUtils.visitAllNodes(template, (NodeVisitor<? super Node, Boolean>)new NodeVisitor<Node, Boolean>(){

                @Override
                public Boolean exec(Node node) {
                    ReportSyntaxVersionErrors.this.visitNode(template, node);
                    return true;
                }
            });
        }
    }

    private void visitNode(TemplateNode template, Node node) {
        String functionName;
        if (!node.couldHaveSyntaxVersionAtLeast(this.requiredSyntaxVersion)) {
            SyntaxVersionUpperBound syntaxVersionBound = node.getSyntaxVersionUpperBound();
            Preconditions.checkNotNull((Object)syntaxVersionBound);
            this.errorReporter.report(node.getSourceLocation(), SYNTAX_VERSION_OUT_OF_BOUNDS, this.errorPreamble, syntaxVersionBound.reasonStr);
        }
        if (node instanceof FunctionNode && (functionName = ((FunctionNode)node).getFunctionName()).equals(BuiltinFunction.V1_EXPRESSION.getName()) && template.couldHaveSyntaxVersionAtLeast(SyntaxVersion.V2_0)) {
            this.errorReporter.report(node.getSourceLocation(), SYNTAX_VERSION_OUT_OF_BOUNDS, this.errorPreamble, "The v1Expression function can only be used in templates marked with the deprecatedV1=\"true\" attribute");
        }
    }
}

