/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.internal.base.UnescapeUtils;
import com.google.template.soy.parsepasses.contextautoesc.Context;
import com.google.template.soy.parsepasses.contextautoesc.JsUtil;
import com.google.template.soy.parsepasses.contextautoesc.SlicedRawTextNode;
import com.google.template.soy.parsepasses.contextautoesc.SoyAutoescapeException;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.RawTextNode;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class RawTextContextUpdater {
    private int numCharsConsumed;
    private Context next;
    private static final ImmutableMap<String, Context.ElementType> SPECIAL_ELEMENT_TYPES = ImmutableMap.builder().put((Object)"img", (Object)Context.ElementType.MEDIA).put((Object)"image", (Object)Context.ElementType.MEDIA).put((Object)"script", (Object)Context.ElementType.SCRIPT).put((Object)"style", (Object)Context.ElementType.STYLE).put((Object)"textarea", (Object)Context.ElementType.TEXTAREA).put((Object)"title", (Object)Context.ElementType.TITLE).put((Object)"xmp", (Object)Context.ElementType.XMP).build();
    private static final Transition TRANSITION_TO_TAG_NAME = new Transition("(?i)^([a-z][a-z0-9:-]*)"){

        @Override
        Context computeNextContext(Context prior, Matcher matcher) {
            String tagName = matcher.group(1).toLowerCase(Locale.ENGLISH);
            Context.ElementType elType = (Context.ElementType)((Object)SPECIAL_ELEMENT_TYPES.get((Object)tagName));
            if (elType == null) {
                elType = Context.ElementType.NORMAL;
            }
            if (prior.state == HtmlContext.HTML_BEFORE_CLOSE_TAG_NAME && elType != Context.ElementType.NORMAL && elType != Context.ElementType.MEDIA) {
                throw SoyAutoescapeException.createWithoutMetaInfo("Saw unmatched close tag for context-changing tag: " + tagName);
            }
            return prior.toBuilder().withState(HtmlContext.HTML_TAG_NAME).withoutAttrContext().withElType(elType).build();
        }
    };
    private static final Transition TRANSITION_TO_TAG_BODY = new Transition("^(?=[/\\s>])"){

        @Override
        Context computeNextContext(Context prior, Matcher matcher) {
            Preconditions.checkArgument((prior.elType != Context.ElementType.NONE ? 1 : 0) != 0);
            return prior.toBuilder().withState(HtmlContext.HTML_TAG).withoutAttrContext().build();
        }
    };
    private static final ImmutableSet<String> URI_ATTR_NAMES = ImmutableSet.of((Object)"action", (Object)"archive", (Object)"base", (Object)"background", (Object)"cite", (Object)"classid", (Object[])new String[]{"codebase", "data", "dsync", "formaction", "href", "icon", "longdesc", "manifest", "poster", "src", "usemap", "entity"});
    private static final Pattern CUSTOM_URI_ATTR_NAMING_CONVENTION = Pattern.compile("\\bur[il]|ur[il]s?$");
    private static final Transition TRANSITION_TO_SELF = RawTextContextUpdater.makeTransitionToSelf("\\z");
    private static final Transition URI_PART_TRANSITION = new Transition("([:./&?=#])|\\z"){

        @Override
        boolean isApplicableTo(Context prior, Matcher matcher) {
            return true;
        }

        @Override
        Context computeNextContext(Context prior, Matcher matcher) {
            String match;
            Context.UriPart uriPart = prior.uriPart;
            if (uriPart == Context.UriPart.START) {
                uriPart = Context.UriPart.MAYBE_SCHEME;
            }
            if ((match = matcher.group(1)) != null) {
                uriPart = RawTextContextUpdater.getNextUriPart(uriPart, match.charAt(0));
            }
            return prior.derive(uriPart);
        }
    };
    private static final Transition URI_START_TRANSITION = new Transition("(?i)^(javascript|data|blob|filesystem):"){

        @Override
        boolean isApplicableTo(Context prior, Matcher matcher) {
            return prior.uriPart == Context.UriPart.START;
        }

        @Override
        Context computeNextContext(Context prior, Matcher matcher) {
            return prior.derive(Context.UriPart.DANGEROUS_SCHEME);
        }
    };
    private static final String JS_LINEBREAKS = "\\r\\n\u2028\u2029";
    private static final ImmutableMap<HtmlContext, List<Transition>> TRANSITIONS = ImmutableMap.builder().put((Object)HtmlContext.HTML_PCDATA, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("<!--", HtmlContext.HTML_COMMENT), (Object)RawTextContextUpdater.makeTemplateTagTransition(), (Object)RawTextContextUpdater.makeTransitionToState("<", HtmlContext.HTML_BEFORE_OPEN_TAG_NAME), (Object)RawTextContextUpdater.makeTransitionToSelf("[^<]+"))).put((Object)HtmlContext.HTML_BEFORE_OPEN_TAG_NAME, (Object)ImmutableList.of((Object)TRANSITION_TO_TAG_NAME, (Object)RawTextContextUpdater.makeTransitionToState("^/", HtmlContext.HTML_BEFORE_CLOSE_TAG_NAME), (Object)RawTextContextUpdater.makeTransitionTo("", SanitizedContent.ContentKind.HTML))).put((Object)HtmlContext.HTML_BEFORE_CLOSE_TAG_NAME, (Object)ImmutableList.of((Object)TRANSITION_TO_TAG_NAME, (Object)RawTextContextUpdater.makeTransitionToError("", "Invalid end-tag name."))).put((Object)HtmlContext.HTML_TAG_NAME, (Object)ImmutableList.of((Object)TRANSITION_TO_TAG_BODY, (Object)RawTextContextUpdater.makeTransitionToError("\\z", "Tag names should not be split up. For example, Soy can't easily understand that <s{if 1}cript{/if}> is a script tag."))).put((Object)HtmlContext.HTML_TAG, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToAttrName("(?i)^\\s*([a-z](?:[a-z0-9_:?$\\-]*[a-z0-9?$])?)"), (Object)new Transition("^\\s*/?>"){

        @Override
        Context computeNextContext(Context prior, Matcher matcher) {
            Context.Builder builder = prior.toBuilder();
            builder.withoutAttrContext();
            switch (prior.elType) {
                case SCRIPT: {
                    builder.withState(HtmlContext.JS).withSlashType(Context.JsFollowingSlash.REGEX).withElType(Context.ElementType.NONE);
                    break;
                }
                case STYLE: {
                    builder.withState(HtmlContext.CSS).withElType(Context.ElementType.NONE);
                    break;
                }
                case TEXTAREA: 
                case TITLE: 
                case XMP: {
                    builder.withState(HtmlContext.HTML_RCDATA);
                    break;
                }
                case NORMAL: 
                case MEDIA: {
                    builder.withState(HtmlContext.HTML_PCDATA).withElType(Context.ElementType.NONE);
                    break;
                }
                case NONE: {
                    throw new IllegalStateException();
                }
                default: {
                    throw new AssertionError((Object)("Unrecognized state " + (Object)((Object)prior.elType)));
                }
            }
            return builder.build();
        }
    }, (Object)RawTextContextUpdater.makeTransitionToSelf("^\\s+\\z"))).put((Object)HtmlContext.HTML_ATTRIBUTE_NAME, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("^\\s*=", HtmlContext.HTML_BEFORE_ATTRIBUTE_VALUE), (Object)RawTextContextUpdater.makeTransitionBackToTag("^"))).put((Object)HtmlContext.HTML_BEFORE_ATTRIBUTE_VALUE, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToAttrValue("^\\s*\"", Context.AttributeEndDelimiter.DOUBLE_QUOTE), (Object)RawTextContextUpdater.makeTransitionToAttrValue("^\\s*'", Context.AttributeEndDelimiter.SINGLE_QUOTE), (Object)RawTextContextUpdater.makeTransitionToAttrValue("^(?=[^\"'\\s>])", Context.AttributeEndDelimiter.SPACE_OR_TAG_END), (Object)RawTextContextUpdater.makeTransitionBackToTag("^(?=>|\\s+[\\w-]+\\s*=)"), (Object)RawTextContextUpdater.makeTransitionToSelf("^\\s+"))).put((Object)HtmlContext.HTML_COMMENT, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionTo("-->", SanitizedContent.ContentKind.HTML), (Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.HTML_NORMAL_ATTR_VALUE, (Object)ImmutableList.of((Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.CSS, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("/\\*", HtmlContext.CSS_COMMENT), (Object)RawTextContextUpdater.makeTransitionToState("\"", HtmlContext.CSS_DQ_STRING), (Object)RawTextContextUpdater.makeTransitionToState("'", HtmlContext.CSS_SQ_STRING), (Object)RawTextContextUpdater.makeCssUriTransition("(?i)(?:[^a-z0-9-]|^)\\s*(?:background|background-image|border-image|content|cursor|list-style|list-style-image)\\s*:\\s*url\\s*\\(\\s*(['\"]?)", Context.UriType.MEDIA), (Object)RawTextContextUpdater.makeCssUriTransition("(?i)\\burl\\s*\\(\\s*(['\"]?)", Context.UriType.NORMAL), (Object)RawTextContextUpdater.makeEndTagTransition("style"), (Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.CSS_COMMENT, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("\\*/", HtmlContext.CSS), (Object)RawTextContextUpdater.makeEndTagTransition("style"), (Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.CSS_DQ_STRING, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("\"", HtmlContext.CSS), (Object)RawTextContextUpdater.makeTransitionToSelf("\\\\(?:\r\n?|[\n\f\"])"), (Object)RawTextContextUpdater.makeTransitionToError("[\n\r\f]", "Newlines not permitted in string literals."), (Object)RawTextContextUpdater.makeEndTagTransition("style"), (Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.CSS_SQ_STRING, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("'", HtmlContext.CSS), (Object)RawTextContextUpdater.makeTransitionToSelf("\\\\(?:\r\n?|[\n\f'])"), (Object)RawTextContextUpdater.makeTransitionToError("[\n\r\f]", "Newlines not permitted in string literals."), (Object)RawTextContextUpdater.makeEndTagTransition("style"), (Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.CSS_URI, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("[\\)\\s]", HtmlContext.CSS), (Object)URI_PART_TRANSITION, (Object)URI_START_TRANSITION, (Object)RawTextContextUpdater.makeTransitionToError("[\"']", "Quotes not permitted in CSS URIs."), (Object)RawTextContextUpdater.makeEndTagTransition("style"))).put((Object)HtmlContext.CSS_SQ_URI, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("'", HtmlContext.CSS), (Object)URI_PART_TRANSITION, (Object)URI_START_TRANSITION, (Object)RawTextContextUpdater.makeTransitionToSelf("\\\\(?:\r\n?|[\n\f'])"), (Object)RawTextContextUpdater.makeTransitionToError("[\n\r\f]", "Newlines not permitted in string literal."), (Object)RawTextContextUpdater.makeEndTagTransition("style"))).put((Object)HtmlContext.CSS_DQ_URI, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("\"", HtmlContext.CSS), (Object)URI_PART_TRANSITION, (Object)URI_START_TRANSITION, (Object)RawTextContextUpdater.makeTransitionToSelf("\\\\(?:\r\n?|[\n\f\"])"), (Object)RawTextContextUpdater.makeTransitionToError("[\n\r\f]", "Newlines not permitted in string literal."), (Object)RawTextContextUpdater.makeEndTagTransition("style"))).put((Object)HtmlContext.JS, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("/\\*", HtmlContext.JS_BLOCK_COMMENT), (Object)RawTextContextUpdater.makeTransitionToState("//", HtmlContext.JS_LINE_COMMENT), (Object)RawTextContextUpdater.makeTransitionToJsString("\"", HtmlContext.JS_DQ_STRING), (Object)RawTextContextUpdater.makeTransitionToJsString("'", HtmlContext.JS_SQ_STRING), (Object)new Transition("/"){

        @Override
        Context computeNextContext(Context prior, Matcher matcher) {
            switch (prior.slashType) {
                case DIV_OP: {
                    return prior.toBuilder().withState(HtmlContext.JS).withSlashType(Context.JsFollowingSlash.REGEX).build();
                }
                case REGEX: {
                    return prior.toBuilder().withState(HtmlContext.JS_REGEX).withSlashType(Context.JsFollowingSlash.NONE).build();
                }
            }
            StringBuffer rest = new StringBuffer();
            matcher.appendTail(rest);
            throw SoyAutoescapeException.createWithoutMetaInfo("Slash (/) cannot follow the preceding branches since it is unclear whether the slash is a RegExp literal or division operator.  Please add parentheses in the branches leading to `" + rest + "`");
        }
    }, (Object)new Transition("(?i)(?:[^</\"'\\s\\\\]+|<(?!/script))+"){

        @Override
        Context computeNextContext(Context prior, Matcher matcher) {
            return prior.derive(JsUtil.isRegexPreceder(matcher.group()) ? Context.JsFollowingSlash.REGEX : Context.JsFollowingSlash.DIV_OP);
        }
    }, (Object)RawTextContextUpdater.makeTransitionToSelf("\\s+"), (Object)RawTextContextUpdater.makeEndTagTransition("script"))).put((Object)HtmlContext.JS_BLOCK_COMMENT, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("\\*/", HtmlContext.JS), (Object)RawTextContextUpdater.makeEndTagTransition("script"), (Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.JS_LINE_COMMENT, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("[\\r\\n\u2028\u2029]", HtmlContext.JS), (Object)RawTextContextUpdater.makeEndTagTransition("script"), (Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.JS_DQ_STRING, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeDivPreceder("\""), (Object)RawTextContextUpdater.makeEndTagTransition("script"), (Object)RawTextContextUpdater.makeTransitionToSelf("(?i)^(?:[^\"\\\\\\r\\n\u2028\u2029<]+|\\\\(?:\\r\\n?|[^\\r<]|<(?!/script))|<(?!/script))+"))).put((Object)HtmlContext.JS_SQ_STRING, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeDivPreceder("'"), (Object)RawTextContextUpdater.makeEndTagTransition("script"), (Object)RawTextContextUpdater.makeTransitionToSelf("(?i)^(?:[^'\\\\\\r\\n\u2028\u2029<]+|\\\\(?:\\r\\n?|[^\\r<]|<(?!/script))|<(?!/script))+"))).put((Object)HtmlContext.JS_REGEX, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeDivPreceder("/"), (Object)RawTextContextUpdater.makeEndTagTransition("script"), (Object)RawTextContextUpdater.makeTransitionToSelf("(?i)^(?:[^\\[\\\\/<\\r\\n\u2028\u2029]|\\\\[^\\r\\n\u2028\u2029]|\\\\?<(?!/script)|\\[(?:[^\\]\\\\<\\r\\n\u2028\u2029]|\\\\(?:[^\\r\\n\u2028\u2029]))*|\\\\?<(?!/script)\\])+"))).put((Object)HtmlContext.URI, (Object)ImmutableList.of((Object)URI_PART_TRANSITION, (Object)URI_START_TRANSITION)).put((Object)HtmlContext.HTML_RCDATA, (Object)ImmutableList.of((Object)new Transition("</(\\w+)\\b"){

        @Override
        boolean isApplicableTo(Context prior, Matcher matcher) {
            String tagName = matcher.group(1).toUpperCase(Locale.ENGLISH);
            return prior.elType.name().equals(tagName);
        }

        @Override
        Context computeNextContext(Context prior, Matcher matcher) {
            return prior.toBuilder().withState(HtmlContext.HTML_TAG).withElType(Context.ElementType.NORMAL).withoutAttrContext().build();
        }
    }, (Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.TEXT, (Object)ImmutableList.of((Object)TRANSITION_TO_SELF)).build();

    public static SlicedRawTextNode processRawText(RawTextNode rawTextNode, Context context) throws SoyAutoescapeException {
        SlicedRawTextNode slicedRawTextNode = new SlicedRawTextNode(rawTextNode, context);
        String rawText = rawTextNode.getRawText();
        int offset = 0;
        int length = rawText.length();
        while (offset < length) {
            Context endContext;
            int endOffset;
            String unprocessedRawText = rawText.substring(offset);
            int startOffset = offset;
            Context startContext = context;
            int attrValueEnd = RawTextContextUpdater.findEndOfAttributeValue(unprocessedRawText, context.delimType);
            if (attrValueEnd == -1) {
                RawTextContextUpdater cu = new RawTextContextUpdater();
                cu.processNextToken(unprocessedRawText, context);
                endOffset = offset + cu.numCharsConsumed;
                endContext = cu.next;
            } else {
                int unprocessedRawTextLen = unprocessedRawText.length();
                int attrEnd = attrValueEnd < unprocessedRawTextLen ? attrValueEnd + context.delimType.text.length() : -1;
                String attrValueTail = UnescapeUtils.unescapeHtml(unprocessedRawText.substring(0, attrValueEnd));
                RawTextContextUpdater cu = new RawTextContextUpdater();
                Context attrContext = startContext;
                while (attrValueTail.length() != 0) {
                    cu.processNextToken(attrValueTail, attrContext);
                    attrValueTail = attrValueTail.substring(cu.numCharsConsumed);
                    attrContext = cu.next;
                }
                if (attrEnd != -1) {
                    endOffset = offset + attrEnd;
                    endContext = context.toBuilder().withState(HtmlContext.HTML_TAG).withoutAttrContext().build();
                } else {
                    if (attrValueEnd != unprocessedRawTextLen) {
                        throw new IllegalStateException();
                    }
                    endOffset = length;
                    endContext = attrContext;
                }
            }
            slicedRawTextNode.addSlice(startOffset, endOffset, startContext);
            context = endContext;
            offset = endOffset;
        }
        slicedRawTextNode.setEndContext(context);
        return slicedRawTextNode;
    }

    private static int findEndOfAttributeValue(String rawText, Context.AttributeEndDelimiter delim) {
        int rawTextLen = rawText.length();
        switch (delim) {
            case DOUBLE_QUOTE: 
            case SINGLE_QUOTE: {
                int quote = rawText.indexOf(delim.text.charAt(0));
                return quote >= 0 ? quote : rawTextLen;
            }
            case SPACE_OR_TAG_END: {
                for (int i = 0; i < rawTextLen; ++i) {
                    char ch = rawText.charAt(i);
                    if (ch != '>' && !Character.isWhitespace(ch)) continue;
                    return i;
                }
                return rawTextLen;
            }
            case NONE: {
                return -1;
            }
        }
        throw new AssertionError((Object)("Unrecognized delimiter " + (Object)((Object)delim)));
    }

    private RawTextContextUpdater() {
    }

    private void processNextToken(String text, Context context) throws SoyAutoescapeException {
        int earliestStart = Integer.MAX_VALUE;
        int earliestEnd = -1;
        Transition earliestTransition = null;
        Matcher earliestMatcher = null;
        for (Transition transition : (List)TRANSITIONS.get((Object)context.state)) {
            Matcher matcher = transition.pattern.matcher(text);
            try {
                int start;
                if (!matcher.find() || (start = matcher.start()) >= earliestStart) continue;
                int end = matcher.end();
                if (!transition.isApplicableTo(context, matcher)) continue;
                earliestStart = start;
                earliestEnd = end;
                earliestTransition = transition;
                earliestMatcher = matcher;
            }
            catch (StackOverflowError soe) {
                throw new RuntimeException("StackOverflow while matching: " + transition.pattern, soe);
            }
        }
        if (earliestTransition == null) {
            throw SoyAutoescapeException.createWithoutMetaInfo("Error determining next state when encountering \"" + text + "\" in " + context);
        }
        this.next = earliestTransition.computeNextContext(context, earliestMatcher);
        this.numCharsConsumed = earliestEnd;
        if (this.numCharsConsumed == 0 && this.next.state == context.state) {
            throw new IllegalStateException("Infinite loop at `" + text + "` / " + context);
        }
    }

    private static Transition makeTransitionTo(String regex, final SanitizedContent.ContentKind kind) {
        return new Transition(regex){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                return prior.toBuilder().withStartKind(kind).build();
            }
        };
    }

    private static String regexForSpecialTagNamed(String tagName, boolean allowClose) {
        return "(?i)<" + (allowClose ? "(/?)" : "") + tagName + "(?=" + "[\\s>/]|\\z" + ")";
    }

    private static Transition makeTemplateTagTransition() {
        String regex = RawTextContextUpdater.regexForSpecialTagNamed("template", true);
        return new Transition(regex){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                boolean isEndTag = "/".equals(matcher.group(1));
                if (isEndTag && prior.templateNestDepth == 0) {
                    throw SoyAutoescapeException.createWithoutMetaInfo("Saw an html5 </template> without encountering <template>.");
                }
                Context.Builder builder = prior.toBuilder().withTemplateNestDepth(prior.templateNestDepth + (isEndTag ? -1 : 1)).withoutAttrContext();
                if (isEndTag) {
                    builder.withState(HtmlContext.HTML_TAG).withElType(Context.ElementType.NORMAL);
                } else {
                    builder.withState(HtmlContext.HTML_PCDATA).withElType(Context.ElementType.NONE);
                }
                return builder.build();
            }
        };
    }

    private static Transition makeTransitionBackToTag(String regex) {
        return new Transition(regex){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                return prior.toBuilder().withState(HtmlContext.HTML_TAG).withoutAttrContext().build();
            }
        };
    }

    private static Transition makeTransitionToAttrName(String regex) {
        return new Transition(regex){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                Context.AttributeType attr;
                String attrName = matcher.group(1).toLowerCase(Locale.ENGLISH);
                int colon = attrName.lastIndexOf(58);
                String localName = attrName.substring(colon + 1);
                Context.UriType uriType = Context.UriType.NONE;
                if (localName.startsWith("on")) {
                    attr = Context.AttributeType.SCRIPT;
                } else if ("style".equals(localName)) {
                    attr = Context.AttributeType.STYLE;
                } else if (prior.elType == Context.ElementType.MEDIA && ("src".equals(attrName) || "xlink:href".equals(attrName))) {
                    attr = Context.AttributeType.URI;
                    uriType = Context.UriType.MEDIA;
                } else if (prior.elType == Context.ElementType.SCRIPT && "src".equals(attrName)) {
                    attr = Context.AttributeType.URI;
                    uriType = Context.UriType.TRUSTED_RESOURCE;
                } else if (URI_ATTR_NAMES.contains((Object)localName) || CUSTOM_URI_ATTR_NAMING_CONVENTION.matcher(localName).find() || "xmlns".equals(attrName) || attrName.startsWith("xmlns:")) {
                    attr = Context.AttributeType.URI;
                    uriType = Context.UriType.NORMAL;
                } else {
                    attr = Context.AttributeType.PLAIN_TEXT;
                }
                return prior.toBuilder().withState(HtmlContext.HTML_ATTRIBUTE_NAME).withoutAttrContext().withAttrType(attr).withUriType(uriType).build();
            }
        };
    }

    private static Transition makeTransitionToAttrValue(String regex, final Context.AttributeEndDelimiter delim) {
        return new Transition(regex){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                return Context.computeContextAfterAttributeDelimiter(prior.elType, prior.attrType, delim, prior.uriType, prior.templateNestDepth);
            }
        };
    }

    private static Transition makeTransitionToState(String regex, final HtmlContext state) {
        return new Transition(regex){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                Context.Builder builder = prior.toBuilder().withState(state).withUriPart(Context.UriPart.NONE);
                if (prior.uriPart != Context.UriPart.NONE) {
                    builder.withUriType(Context.UriType.NONE);
                }
                return builder.build();
            }
        };
    }

    private static Transition makeTransitionToError(String regex, final String message) {
        return new Transition(regex){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                throw SoyAutoescapeException.createWithoutMetaInfo(message);
            }
        };
    }

    private static Transition makeTransitionToJsString(String regex, final HtmlContext state) {
        return new Transition(regex){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                return prior.toBuilder().withState(state).withSlashType(Context.JsFollowingSlash.NONE).withUriPart(Context.UriPart.NONE).build();
            }
        };
    }

    private static Transition makeTransitionToSelf(String regex) {
        return new Transition(regex){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                return prior;
            }
        };
    }

    private static Context.UriPart getNextUriPart(Context.UriPart uriPart, char matchChar) {
        switch (uriPart) {
            case MAYBE_SCHEME: 
            case MAYBE_VARIABLE_SCHEME: {
                if (matchChar == ':') {
                    if (uriPart == Context.UriPart.MAYBE_VARIABLE_SCHEME) {
                        throw SoyAutoescapeException.createWithoutMetaInfo("Soy can't safely process a URI that might start with a variable scheme. For example, {$x}:{$y} could have an XSS if $x is 'javascript' and $y is attacker-controlled. Either use a hard-coded scheme, or introduce disambiguating characters (e.g. http://{$x}:{$y}, ./{$x}:{$y}, or {$x}?foo=:{$y})");
                    }
                    return Context.UriPart.AUTHORITY_OR_PATH;
                }
                if (matchChar == '/') {
                    return Context.UriPart.AUTHORITY_OR_PATH;
                }
                if ((matchChar == '=' || matchChar == '&') && uriPart == Context.UriPart.MAYBE_VARIABLE_SCHEME) {
                    return Context.UriPart.QUERY;
                }
            }
            case AUTHORITY_OR_PATH: 
            case UNKNOWN_PRE_FRAGMENT: {
                if (matchChar == '?') {
                    return Context.UriPart.QUERY;
                }
            }
            case QUERY: 
            case UNKNOWN: {
                if (matchChar == '#') {
                    return Context.UriPart.FRAGMENT;
                }
            }
            case FRAGMENT: {
                return uriPart;
            }
            case DANGEROUS_SCHEME: {
                return Context.UriPart.DANGEROUS_SCHEME;
            }
        }
        throw new AssertionError((Object)("Unanticipated URI part: " + (Object)((Object)uriPart)));
    }

    private static Transition makeEndTagTransition(String tagName) {
        return new Transition("(?i)</" + tagName + "\\b"){

            @Override
            boolean isApplicableTo(Context prior, Matcher matcher) {
                return prior.attrType == Context.AttributeType.NONE;
            }

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                return prior.toBuilder().withState(HtmlContext.HTML_TAG).withElType(Context.ElementType.NORMAL).withoutAttrContext().build();
            }
        };
    }

    private static Transition makeCssUriTransition(String regex, final Context.UriType uriType) {
        return new Transition(regex){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                String delim = matcher.group(1);
                HtmlContext state = "\"".equals(delim) ? HtmlContext.CSS_DQ_URI : ("'".equals(delim) ? HtmlContext.CSS_SQ_URI : HtmlContext.CSS_URI);
                return prior.toBuilder().withState(state).withUriType(uriType).withUriPart(Context.UriPart.START).build();
            }
        };
    }

    private static Transition makeDivPreceder(String regex) {
        return new Transition(regex){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                return prior.toBuilder().withState(HtmlContext.JS).withSlashType(Context.JsFollowingSlash.DIV_OP).build();
            }
        };
    }

    private static abstract class Transition {
        final Pattern pattern;

        Transition(Pattern pattern) {
            this.pattern = pattern;
        }

        Transition(String regex) {
            this(Pattern.compile(regex, 32));
        }

        boolean isApplicableTo(Context prior, Matcher matcher) {
            return true;
        }

        abstract Context computeNextContext(Context var1, Matcher var2) throws SoyAutoescapeException;
    }
}

