/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.TreeMultimap;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.base.internal.UniqueNameGenerator;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.html.AbstractHtmlSoyNodeVisitor;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.ConditionalBuilder;
import com.google.template.soy.jssrc.dsl.Declaration;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.SwitchBuilder;
import com.google.template.soy.jssrc.internal.AliasUtils;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.DelTemplateNamer;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitorAssistantForMsgs;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsCodeBuilder;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.JsSrcNameGenerators;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.internal.JsType;
import com.google.template.soy.jssrc.internal.SoyToJsVariableMappings;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.passes.FindIndirectParamsVisitor;
import com.google.template.soy.passes.ShouldEnsureDataIsDefinedVisitor;
import com.google.template.soy.shared.internal.FindCalleesNotInFileVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeOps;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.primitive.AnyType;
import com.google.template.soy.types.primitive.NullType;
import com.google.template.soy.types.primitive.StringType;
import com.google.template.soy.types.primitive.UnknownType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;

public class GenJsCodeVisitor
extends AbstractHtmlSoyNodeVisitor<List<String>> {
    private static final Pattern DOT = Pattern.compile("\\.");
    protected final SoyJsSrcOptions jsSrcOptions;
    protected final JsExprTranslator jsExprTranslator;
    private final DelTemplateNamer delTemplateNamer;
    protected final GenCallCodeUtils genCallCodeUtils;
    protected final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final CanInitOutputVarVisitor canInitOutputVarVisitor;
    private final GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory;
    private List<String> jsFilesContents;
    @VisibleForTesting
    JsCodeBuilder jsCodeBuilder;
    protected GenJsExprsVisitor genJsExprsVisitor;
    @VisibleForTesting
    GenJsCodeVisitorAssistantForMsgs assistantForMsgs;
    protected TemplateRegistry templateRegistry;
    private final SoyTypeOps typeOps;
    protected ErrorReporter errorReporter;
    protected TranslationContext templateTranslationContext;
    @VisibleForTesting
    protected TemplateAliases templateAliases;

    @Inject
    protected GenJsCodeVisitor(SoyJsSrcOptions jsSrcOptions, JsExprTranslator jsExprTranslator, DelTemplateNamer delTemplateNamer, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory, SoyTypeOps typeOps) {
        this.jsSrcOptions = jsSrcOptions;
        this.jsExprTranslator = jsExprTranslator;
        this.delTemplateNamer = delTemplateNamer;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.canInitOutputVarVisitor = canInitOutputVarVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
        this.typeOps = typeOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> gen(SoyFileSetNode node, TemplateRegistry registry, ErrorReporter errorReporter) {
        this.templateRegistry = (TemplateRegistry)Preconditions.checkNotNull((Object)registry);
        this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
        try {
            this.jsFilesContents = new ArrayList<String>();
            this.jsCodeBuilder = null;
            this.genJsExprsVisitor = null;
            this.assistantForMsgs = null;
            this.visit(node);
            List<String> list = this.jsFilesContents;
            return list;
        }
        finally {
            this.templateRegistry = null;
            this.errorReporter = null;
        }
    }

    @Override
    @Deprecated
    public final List<String> exec(SoyNode node) {
        throw new UnsupportedOperationException();
    }

    public void visitForUseByAssistants(SoyNode node) {
        this.visit(node);
    }

    @VisibleForTesting
    void visitForTesting(SoyNode node, ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.visit(node);
    }

    @Override
    protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
        if (node.numChildren() == 0 || !((Boolean)this.canInitOutputVarVisitor.exec(node.getChild(0))).booleanValue()) {
            this.jsCodeBuilder.initOutputVarIfNecessary();
        }
        ArrayList<CodeChunk.WithValue> consecChunks = new ArrayList<CodeChunk.WithValue>();
        for (SoyNode child : node.getChildren()) {
            if (((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) {
                consecChunks.addAll(this.genJsExprsVisitor.exec(child));
                continue;
            }
            if (!consecChunks.isEmpty()) {
                this.jsCodeBuilder.addChunksToOutputVar(consecChunks);
                consecChunks.clear();
            }
            this.visit(child);
        }
        if (!consecChunks.isEmpty()) {
            this.jsCodeBuilder.addChunksToOutputVar(consecChunks);
            consecChunks.clear();
        }
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        for (SoyFileNode soyFile : node.getChildren()) {
            this.visit(soyFile);
        }
    }

    protected JsCodeBuilder createCodeBuilder() {
        return new JsCodeBuilder();
    }

    protected JsCodeBuilder createChildJsCodeBuilder() {
        return new JsCodeBuilder(this.jsCodeBuilder);
    }

    protected JsCodeBuilder getJsCodeBuilder() {
        return this.jsCodeBuilder;
    }

    private CodeChunk visitNodeReturningCodeChunk(SoyNode.ParentSoyNode<?> node) {
        return this.doVisitReturningCodeChunk(node, false);
    }

    private CodeChunk visitChildrenReturningCodeChunk(SoyNode.ParentSoyNode<?> node) {
        return this.doVisitReturningCodeChunk(node, true);
    }

    private CodeChunk doVisitReturningCodeChunk(SoyNode node, boolean visitChildren) {
        JsCodeBuilder original = this.jsCodeBuilder;
        this.jsCodeBuilder = this.createChildJsCodeBuilder();
        this.jsCodeBuilder.increaseIndent();
        if (visitChildren) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        } else {
            this.visit(node);
        }
        this.jsCodeBuilder.decreaseIndent();
        CodeChunk chunk = CodeChunk.treatRawStringAsStatementLegacyOnly(this.jsCodeBuilder.getCode(), this.jsCodeBuilder.googRequires());
        original.setIndent(this.jsCodeBuilder.getIndent());
        this.jsCodeBuilder = original;
        return chunk;
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        if (node.getSoyFileKind() != SoyFileKind.SRC) {
            return;
        }
        StringBuilder file = new StringBuilder();
        file.append("// This file was automatically generated from ").append(node.getFileName()).append(".\n");
        file.append("// Please don't edit this file by hand.\n");
        file.append("\n");
        file.append("/**\n");
        String fileOverviewDescription = " Templates in namespace " + node.getNamespace() + ".";
        file.append(" * @fileoverview").append(fileOverviewDescription).append('\n');
        if (node.getDelPackageName() != null) {
            file.append(" * @modName {").append(node.getDelPackageName()).append("}\n");
        }
        this.addJsDocToProvideDelTemplates(file, node);
        this.addJsDocToRequireDelTemplates(file, node);
        GenJsCodeVisitor.addCodeToRequireCss(file, node);
        file.append(" * @public\n").append(" */\n\n");
        this.templateAliases = AliasUtils.IDENTITY_ALIASES;
        this.jsCodeBuilder = this.createCodeBuilder();
        if (this.jsSrcOptions.shouldGenerateGoogModules()) {
            this.templateAliases = AliasUtils.createTemplateAliases(node);
            this.addCodeToDeclareGoogModule(file, node);
            this.addCodeToRequireGoogModules(node);
        } else if (this.jsSrcOptions.shouldProvideRequireSoyNamespaces()) {
            GenJsCodeVisitor.addCodeToProvideSoyNamespace(file, node);
            if (this.jsSrcOptions.shouldProvideBothSoyNamespacesAndJsFunctions()) {
                GenJsCodeVisitor.addCodeToProvideJsFunctions(file, node);
            }
            file.append('\n');
            this.addCodeToRequireSoyNamespaces(node);
        } else if (this.jsSrcOptions.shouldProvideRequireJsFunctions()) {
            if (this.jsSrcOptions.shouldProvideBothSoyNamespacesAndJsFunctions()) {
                GenJsCodeVisitor.addCodeToProvideSoyNamespace(file, node);
            }
            GenJsCodeVisitor.addCodeToProvideJsFunctions(file, node);
            file.append('\n');
            this.addCodeToRequireJsFunctions(node);
        } else {
            this.addCodeToDefineJsNamespaces(file, node);
        }
        for (TemplateNode template : node.getChildren()) {
            this.jsCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            this.visit(template);
        }
        if (this.jsSrcOptions.shouldProvideRequireSoyNamespaces() || this.jsSrcOptions.shouldProvideRequireJsFunctions() || this.jsSrcOptions.shouldGenerateGoogModules()) {
            this.jsCodeBuilder.appendGoogRequires(file);
        }
        this.jsCodeBuilder.appendCode(file);
        this.jsFilesContents.add(file.toString());
        this.jsCodeBuilder = null;
    }

    private static void addCodeToRequireCss(StringBuilder header, SoyFileNode soyFile) {
        TreeSet<String> requiredCssNamespaces = new TreeSet<String>();
        requiredCssNamespaces.addAll((Collection<String>)soyFile.getRequiredCssNamespaces());
        for (TemplateNode template : soyFile.getChildren()) {
            requiredCssNamespaces.addAll((Collection<String>)template.getRequiredCssNamespaces());
        }
        for (String requiredCssNamespace : requiredCssNamespaces) {
            header.append(" * @requirecss {").append(requiredCssNamespace).append("}\n");
        }
    }

    private void addCodeToDefineJsNamespaces(StringBuilder header, SoyFileNode soyFile) {
        TreeSet<String> jsNamespaces = new TreeSet<String>();
        for (TemplateNode template : soyFile.getChildren()) {
            String templateName = template.getTemplateName();
            Matcher dotMatcher = DOT.matcher(templateName);
            while (dotMatcher.find()) {
                jsNamespaces.add(templateName.substring(0, dotMatcher.start()));
            }
        }
        for (String jsNamespace : jsNamespaces) {
            boolean hasDot;
            boolean bl = hasDot = jsNamespace.indexOf(46) >= 0;
            if (!this.jsSrcOptions.shouldDeclareTopLevelNamespaces() && !hasDot) continue;
            header.append("if (typeof ").append(jsNamespace).append(" == 'undefined') { ").append(hasDot ? "" : "var ").append(jsNamespace).append(" = {}; }\n");
        }
    }

    private static void addCodeToProvideSoyNamespace(StringBuilder header, SoyFileNode soyFile) {
        header.append("goog.provide('").append(soyFile.getNamespace()).append("');\n");
    }

    protected String getGoogModuleNamespace(String soyNamespace) {
        return soyNamespace;
    }

    private void addCodeToDeclareGoogModule(StringBuilder header, SoyFileNode soyFile) {
        String exportNamespace = this.getGoogModuleNamespace(soyFile.getNamespace());
        header.append("goog.module('").append(exportNamespace).append("');\n\n");
    }

    private void addCodeToRequireGoogModules(SoyFileNode soyFile) {
        int counter = 1;
        HashSet<String> calls = new HashSet<String>();
        for (CallBasicNode callNode : SoyTreeUtils.getAllNodesOfType(soyFile, CallBasicNode.class)) {
            calls.add(callNode.getCalleeName());
        }
        TreeMultimap namespaceToTemplates = TreeMultimap.create();
        for (String call : calls) {
            namespaceToTemplates.put((Object)call.substring(0, call.lastIndexOf(46)), (Object)call);
        }
        for (String namespace : namespaceToTemplates.keySet()) {
            if (namespace.equals(soyFile.getNamespace())) continue;
            String namespaceAlias = "$import" + counter++;
            String importNamespace = this.getGoogModuleNamespace(namespace);
            this.jsCodeBuilder.append(CodeChunk.declare(namespaceAlias, JsRuntime.GOOG_REQUIRE.call(CodeChunk.stringLiteral(importNamespace))));
            for (String fullyQualifiedName : namespaceToTemplates.get((Object)namespace)) {
                String alias = this.templateAliases.get(fullyQualifiedName);
                String shortName = fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(46));
                this.jsCodeBuilder.append(CodeChunk.declare(alias, CodeChunk.dottedIdNoRequire(namespaceAlias + shortName)));
            }
        }
    }

    private static void addCodeToProvideJsFunctions(StringBuilder header, SoyFileNode soyFile) {
        TreeSet<String> templateNames = new TreeSet<String>();
        for (TemplateNode template : soyFile.getChildren()) {
            templateNames.add(template.getTemplateName());
        }
        for (String templateName : templateNames) {
            header.append("goog.provide('").append(templateName).append("');\n");
        }
    }

    private void addJsDocToProvideDelTemplates(StringBuilder header, SoyFileNode soyFile) {
        TreeSet<String> delTemplateNames = new TreeSet<String>();
        for (TemplateNode template : soyFile.getChildren()) {
            if (!(template instanceof TemplateDelegateNode)) continue;
            delTemplateNames.add(this.delTemplateNamer.getDelegateName((TemplateDelegateNode)template));
        }
        for (String delTemplateName : delTemplateNames) {
            header.append(" * @hassoydeltemplate {").append(delTemplateName).append("}\n");
        }
    }

    private void addJsDocToRequireDelTemplates(StringBuilder header, SoyFileNode soyFile) {
        TreeSet<String> delTemplateNames = new TreeSet<String>();
        for (CallDelegateNode delCall : SoyTreeUtils.getAllNodesOfType(soyFile, CallDelegateNode.class)) {
            delTemplateNames.add(this.delTemplateNamer.getDelegateName(delCall));
        }
        for (String delTemplateName : delTemplateNames) {
            header.append(" * @hassoydelcall {").append(delTemplateName).append("}\n");
        }
    }

    private void addCodeToRequireSoyNamespaces(SoyFileNode soyFile) {
        String prevCalleeNamespace = null;
        TreeSet<String> calleeNamespaces = new TreeSet<String>();
        for (CallBasicNode node : new FindCalleesNotInFileVisitor().exec(soyFile)) {
            String calleeNotInFile = node.getCalleeName();
            int lastDotIndex = calleeNotInFile.lastIndexOf(46);
            calleeNamespaces.add(calleeNotInFile.substring(0, lastDotIndex));
        }
        for (String calleeNamespace : calleeNamespaces) {
            if (calleeNamespace.length() <= 0 || calleeNamespace.equals(prevCalleeNamespace)) continue;
            this.jsCodeBuilder.addGoogRequire(GoogRequire.create(calleeNamespace));
            prevCalleeNamespace = calleeNamespace;
        }
    }

    private void addCodeToRequireJsFunctions(SoyFileNode soyFile) {
        for (CallBasicNode node : new FindCalleesNotInFileVisitor().exec(soyFile)) {
            this.jsCodeBuilder.addGoogRequire(GoogRequire.create(node.getCalleeName()));
        }
    }

    protected String getTemplateReturnType(TemplateNode node) {
        return node.getContentKind() == null ? "string" : "!" + NodeContentKinds.toJsSanitizedContentCtorName(node.getContentKind());
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        boolean useStrongTyping = this.hasStrictParams(node);
        String templateName = node.getTemplateName();
        String partialName = node.getPartialTemplateName();
        boolean addToExports = this.jsSrcOptions.shouldGenerateGoogModules();
        String alias = addToExports && node instanceof TemplateDelegateNode ? node.getPartialTemplateName().substring(1) : this.templateAliases.get(templateName);
        UniqueNameGenerator nameGenerator = JsSrcNameGenerators.forLocalVariables();
        CodeChunk.Generator codeGenerator = CodeChunk.Generator.create(nameGenerator);
        this.templateTranslationContext = TranslationContext.of(SoyToJsVariableMappings.forNewTemplate(), codeGenerator, nameGenerator);
        this.genJsExprsVisitor = this.genJsExprsVisitorFactory.create(this.templateTranslationContext, this.templateAliases, this.errorReporter);
        this.assistantForMsgs = null;
        String paramsRecordType = null;
        if (this.jsSrcOptions.shouldGenerateJsdoc()) {
            this.jsCodeBuilder.appendLine("/**");
            this.jsCodeBuilder.append(" * @param {");
            if (useStrongTyping) {
                paramsRecordType = this.genParamsRecordType(node);
                this.jsCodeBuilder.append(paramsRecordType);
            } else {
                this.jsCodeBuilder.append("Object<string, *>=");
            }
            this.jsCodeBuilder.appendLine("} opt_data");
            this.jsCodeBuilder.appendLine(" * @param {Object<string, *>=} opt_ijData");
            this.jsCodeBuilder.appendLine(" * @param {Object<string, *>=} opt_ijData_deprecated");
            String returnType = this.getTemplateReturnType(node);
            this.jsCodeBuilder.appendLine(" * @return {", returnType, "}");
            String suppressions = "checkTypes";
            this.jsCodeBuilder.appendLine(" * @suppress {" + suppressions + "}");
            if (node.getVisibility() == Visibility.PRIVATE) {
                this.jsCodeBuilder.appendLine(" * @private");
            }
            this.jsCodeBuilder.appendLine(" */");
        }
        if (addToExports) {
            this.jsCodeBuilder.appendLine("function ", alias, "(opt_data, opt_ijData, opt_ijData_deprecated) {");
        } else {
            this.jsCodeBuilder.appendLine(alias, " = function(opt_data, opt_ijData, opt_ijData_deprecated) {");
        }
        this.jsCodeBuilder.increaseIndent();
        this.jsCodeBuilder.appendLine("opt_ijData = opt_ijData_deprecated || opt_ijData;");
        if (!SoyTreeUtils.getAllNodesOfType(node, OperatorNodes.NullCoalescingOpNode.class).isEmpty() || !SoyTreeUtils.getAllNodesOfType(node, SwitchNode.class).isEmpty()) {
            this.jsCodeBuilder.appendLine("var $$temp;");
        }
        if (new ShouldEnsureDataIsDefinedVisitor().exec(node)) {
            this.jsCodeBuilder.append(CodeChunk.assign("opt_data", JsRuntime.OPT_DATA.or(CodeChunk.WithValue.EMPTY_OBJECT_LITERAL, codeGenerator)));
        }
        if (GenJsCodeVisitor.shouldEnsureIjDataIsDefined(node)) {
            this.jsCodeBuilder.append(CodeChunk.assign("opt_ijData", JsRuntime.OPT_IJ_DATA.or(CodeChunk.WithValue.EMPTY_OBJECT_LITERAL, codeGenerator)));
        }
        this.generateFunctionBody(node);
        this.jsCodeBuilder.decreaseIndent();
        if (addToExports) {
            this.jsCodeBuilder.appendLine("}");
            this.jsCodeBuilder.append(CodeChunk.assign("exports" + partialName, CodeChunk.id(alias)));
        } else {
            this.jsCodeBuilder.appendLine("};");
        }
        if (paramsRecordType != null) {
            this.jsCodeBuilder.appendLine("/**");
            this.jsCodeBuilder.appendLine(" * @typedef {", paramsRecordType, "}");
            this.jsCodeBuilder.appendLine(" */");
            this.jsCodeBuilder.appendLine(alias + ".Params;");
        }
        this.jsCodeBuilder.append(CodeChunk.ifStatement(JsRuntime.GOOG_DEBUG, CodeChunk.assign(alias + ".soyTemplateName", CodeChunk.stringLiteral(templateName))).build());
        if (node instanceof TemplateDelegateNode) {
            TemplateDelegateNode nodeAsDelTemplate = (TemplateDelegateNode)node;
            this.jsCodeBuilder.append(JsRuntime.SOY_REGISTER_DELEGATE_FN.call(JsRuntime.SOY_GET_DELTEMPLATE_ID.call(CodeChunk.stringLiteral(this.delTemplateNamer.getDelegateName(nodeAsDelTemplate))), CodeChunk.stringLiteral(nodeAsDelTemplate.getDelTemplateVariant()), CodeChunk.number(nodeAsDelTemplate.getDelPriority().getValue()), CodeChunk.dottedIdNoRequire(alias)));
        }
    }

    private static boolean shouldEnsureIjDataIsDefined(TemplateNode node) {
        for (VarRefNode ref : SoyTreeUtils.getAllNodesOfType(node, VarRefNode.class)) {
            if (ref.isDollarSignIjParameter()) {
                if (!ref.getName().equals("csp_nonce")) continue;
                return true;
            }
            if (!ref.getDefnDecl().isInjected() || ref.getDefnDecl().kind() != VarDefn.Kind.PARAM) continue;
            return false;
        }
        return false;
    }

    protected void generateFunctionBody(TemplateNode node) {
        CodeChunk.WithValue templateBody;
        this.genParamTypeChecks(node);
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            List<CodeChunk.WithValue> templateBodyChunks = this.genJsExprsVisitor.exec(node);
            templateBody = node.getContentKind() == null ? CodeChunkUtils.concatChunksForceString(templateBodyChunks) : CodeChunkUtils.concatChunks(templateBodyChunks);
        } else {
            this.jsCodeBuilder.pushOutputVar("output");
            this.visitChildren(node);
            templateBody = CodeChunk.id("output");
            this.jsCodeBuilder.popOutputVar();
        }
        if (node.getContentKind() != null) {
            templateBody = JsRuntime.sanitizedContentOrdainerFunction(node.getContentKind()).call(templateBody);
        }
        this.jsCodeBuilder.append(CodeChunk.return_(templateBody));
    }

    protected GenJsCodeVisitorAssistantForMsgs getAssistantForMsgs() {
        if (this.assistantForMsgs == null) {
            this.assistantForMsgs = new GenJsCodeVisitorAssistantForMsgs(this, this.jsSrcOptions, this.jsExprTranslator, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, this.templateAliases, this.genJsExprsVisitor, this.templateTranslationContext, this.errorReporter);
        }
        return this.assistantForMsgs;
    }

    @Override
    protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        throw new AssertionError((Object)"Inconceivable! LetContentNode should catch this directly.");
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        this.jsCodeBuilder.addChunksToOutputVar(this.genJsExprsVisitor.exec(node));
    }

    @Override
    protected void visitLetValueNode(LetValueNode node) {
        String generatedVarName = node.getUniqueVarName();
        CodeChunk.WithValue value = this.jsExprTranslator.translateToCodeChunk(node.getValueExpr(), this.templateTranslationContext, this.errorReporter);
        this.jsCodeBuilder.append(CodeChunk.declare(generatedVarName, value));
        this.templateTranslationContext.soyToJsVariableMappings().put(node.getVarName(), CodeChunk.id(generatedVarName));
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        if (node.getChildren().size() == 1 && node.getChild(0) instanceof MsgFallbackGroupNode) {
            String msgVar = this.getAssistantForMsgs().generateMsgGroupVariable((MsgFallbackGroupNode)node.getChild(0));
            this.templateTranslationContext.soyToJsVariableMappings().put(node.getVarName(), CodeChunk.id(msgVar));
            return;
        }
        String generatedVarName = node.getUniqueVarName();
        CodeChunk.WithValue generatedVar = CodeChunk.id(generatedVarName);
        this.jsCodeBuilder.pushOutputVar(generatedVarName);
        this.visitChildren(node);
        this.jsCodeBuilder.popOutputVar();
        if (node.getContentKind() != null) {
            this.jsCodeBuilder.append(CodeChunk.assign(generatedVarName, JsRuntime.sanitizedContentOrdainerFunctionForInternalBlocks(node.getContentKind()).call(generatedVar)));
        }
        this.templateTranslationContext.soyToJsVariableMappings().put(node.getVarName(), generatedVar);
    }

    @Override
    protected void visitIfNode(IfNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            this.jsCodeBuilder.addChunksToOutputVar(this.genJsExprsVisitor.exec(node));
        } else {
            this.generateNonExpressionIfNode(node);
        }
    }

    protected void generateNonExpressionIfNode(IfNode node) {
        ConditionalBuilder conditional = null;
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode condNode = (IfCondNode)child;
                CodeChunk.WithValue predicate = this.jsExprTranslator.translateToCodeChunk(condNode.getExpr(), this.templateTranslationContext, this.errorReporter);
                CodeChunk consequent = this.visitChildrenReturningCodeChunk(condNode);
                if (conditional == null) {
                    conditional = CodeChunk.ifStatement(predicate, consequent);
                    continue;
                }
                conditional.elseif_(predicate, consequent);
                continue;
            }
            if (child instanceof IfElseNode) {
                CodeChunk trailingElse = this.visitChildrenReturningCodeChunk((IfElseNode)child);
                conditional.else_(trailingElse);
                continue;
            }
            throw new AssertionError();
        }
        this.jsCodeBuilder.append(conditional.build());
    }

    @Override
    protected void visitSwitchNode(SwitchNode node) {
        CodeChunk.WithValue switchOn = this.coerceTypeForSwitchComparison(node.getExpr());
        SwitchBuilder switchBuilder = CodeChunk.switch_(switchOn);
        for (SoyNode child : node.getChildren()) {
            if (child instanceof SwitchCaseNode) {
                SwitchCaseNode scn = (SwitchCaseNode)child;
                ImmutableList.Builder caseChunks = ImmutableList.builder();
                for (ExprNode caseExpr : scn.getExprList()) {
                    CodeChunk.WithValue caseChunk = this.jsExprTranslator.translateToCodeChunk(caseExpr, this.templateTranslationContext, this.errorReporter);
                    caseChunks.add((Object)caseChunk);
                }
                CodeChunk body = this.visitChildrenReturningCodeChunk(scn);
                switchBuilder.case_((ImmutableList<CodeChunk.WithValue>)caseChunks.build(), body);
                continue;
            }
            if (child instanceof SwitchDefaultNode) {
                CodeChunk body = this.visitChildrenReturningCodeChunk((SwitchDefaultNode)child);
                switchBuilder.default_(body);
                continue;
            }
            throw new AssertionError();
        }
        this.jsCodeBuilder.append(switchBuilder.build());
    }

    private CodeChunk.WithValue coerceTypeForSwitchComparison(ExprRootNode expr) {
        CodeChunk.WithValue switchOn = this.jsExprTranslator.translateToCodeChunk(expr, this.templateTranslationContext, this.errorReporter);
        SoyType type = expr.getType();
        if (SoyTypes.makeNullable(StringType.getInstance()).isAssignableFrom(type) || type.equals(AnyType.getInstance()) || type.equals(UnknownType.getInstance())) {
            CodeChunk.Generator codeGenerator = this.templateTranslationContext.codeGenerator();
            CodeChunk.WithValue tmp = codeGenerator.declare(switchOn).ref();
            return CodeChunk.ifExpression(JsRuntime.GOOG_IS_OBJECT.call(tmp), tmp.dotAccess("toString").call(new CodeChunk.WithValue[0])).else_(tmp).build(codeGenerator);
        }
        return switchOn;
    }

    @Override
    protected void visitForeachNode(ForeachNode node) {
        boolean hasIfempty = node.numChildren() == 2;
        ForeachNonemptyNode nonEmptyNode = (ForeachNonemptyNode)node.getChild(0);
        String varPrefix = nonEmptyNode.getVarName() + node.getId();
        String listName = varPrefix + "List";
        String limitName = varPrefix + "ListLen";
        CodeChunk.WithValue dataRef = this.jsExprTranslator.translateToCodeChunk(node.getExpr(), this.templateTranslationContext, this.errorReporter);
        this.jsCodeBuilder.append(CodeChunk.declare(listName, dataRef));
        this.jsCodeBuilder.append(CodeChunk.declare(limitName, CodeChunk.dottedIdNoRequire(listName + ".length")));
        CodeChunk foreachBody = this.visitNodeReturningCodeChunk(nonEmptyNode);
        if (hasIfempty) {
            CodeChunk ifemptyBody = this.visitChildrenReturningCodeChunk((SoyNode.ParentSoyNode)node.getChild(1));
            CodeChunk.WithValue limitCheck = CodeChunk.id(limitName).op(Operator.GREATER_THAN, CodeChunk.number(0L));
            CodeChunk foreach = CodeChunk.ifStatement(limitCheck, foreachBody).else_(ifemptyBody).build();
            this.jsCodeBuilder.append(foreach);
        } else {
            this.jsCodeBuilder.append(foreachBody);
        }
    }

    @Override
    protected void visitForeachNonemptyNode(ForeachNonemptyNode node) {
        String varName = node.getVarName();
        String varPrefix = varName + node.getForeachNodeId();
        String listName = varPrefix + "List";
        String loopIndexName = varPrefix + "Index";
        String dataName = varPrefix + "Data";
        String limitName = varPrefix + "ListLen";
        CodeChunk.WithValue loopIndex = CodeChunk.id(loopIndexName);
        CodeChunk.WithValue limit = CodeChunk.id(limitName);
        this.templateTranslationContext.soyToJsVariableMappings().put(varName, CodeChunk.id(dataName)).put(varName + "__isFirst", loopIndex.doubleEquals(CodeChunk.number(0L))).put(varName + "__isLast", loopIndex.doubleEquals(limit.minus(CodeChunk.number(1L)))).put(varName + "__index", loopIndex);
        Declaration data = CodeChunk.declare(dataName, CodeChunk.id(listName).bracketAccess(loopIndex));
        CodeChunk foreachBody = this.visitChildrenReturningCodeChunk(node);
        CodeChunk body = data.concat(foreachBody);
        CodeChunk forChunk = CodeChunk.forLoop(loopIndexName, limit, body);
        this.jsCodeBuilder.append(forChunk);
    }

    @Override
    protected void visitForNode(ForNode node) {
        String varName = node.getVarName();
        String localVar = varName + node.getId();
        ForNode.RangeArgs range = node.getRangeArgs();
        CodeChunk.WithValue initial = this.jsExprTranslator.translateToCodeChunk(range.start(), this.templateTranslationContext, this.errorReporter);
        CodeChunk.WithValue limit = this.jsExprTranslator.translateToCodeChunk(range.limit(), this.templateTranslationContext, this.errorReporter);
        CodeChunk.WithValue increment = this.jsExprTranslator.translateToCodeChunk(range.increment(), this.templateTranslationContext, this.errorReporter);
        if (!(range.limit().getRoot() instanceof IntegerNode)) {
            limit = CodeChunk.declare(localVar + "Limit", limit).ref();
        }
        if (!(range.increment().getRoot() instanceof IntegerNode)) {
            increment = CodeChunk.declare(localVar + "Increment", increment).ref();
        }
        this.templateTranslationContext.soyToJsVariableMappings().put(varName, CodeChunk.id(localVar));
        CodeChunk body = this.visitChildrenReturningCodeChunk(node);
        CodeChunk forChunk = CodeChunk.forLoop(localVar, initial, limit, increment, body);
        this.jsCodeBuilder.append(forChunk);
    }

    @Override
    protected void visitCallNode(CallNode node) {
        for (CallParamNode child : node.getChildren()) {
            if (!(child instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) continue;
            this.visit(child);
        }
        CodeChunk.WithValue call = this.genCallCodeUtils.gen(node, this.templateAliases, this.templateTranslationContext, this.errorReporter);
        this.jsCodeBuilder.addChunkToOutputVar(call);
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            throw new AssertionError((Object)"Should only define 'param<n>' when not computable as JS expressions.");
        }
        this.jsCodeBuilder.pushOutputVar("param" + node.getId());
        this.visitChildren(node);
        this.jsCodeBuilder.popOutputVar();
    }

    @Override
    protected void visitLogNode(LogNode node) {
        if (this.isComputableAsJsExprsVisitor.execOnChildren(node).booleanValue()) {
            List<CodeChunk.WithValue> logMsgChunks = this.genJsExprsVisitor.execOnChildren(node);
            this.jsCodeBuilder.append(JsRuntime.WINDOW_CONSOLE_LOG.call(CodeChunkUtils.concatChunks(logMsgChunks)));
        } else {
            String outputVarName = "logMsg_s" + node.getId();
            this.jsCodeBuilder.pushOutputVar(outputVarName);
            this.visitChildren(node);
            this.jsCodeBuilder.popOutputVar();
            this.jsCodeBuilder.append(JsRuntime.WINDOW_CONSOLE_LOG.call(CodeChunk.id(outputVarName)));
        }
    }

    @Override
    protected void visitDebuggerNode(DebuggerNode node) {
        this.jsCodeBuilder.appendLine("debugger;");
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            if (node instanceof SoyNode.BlockNode) {
                this.visitChildren((SoyNode.BlockNode)node);
            } else {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
            return;
        }
        if (!((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            throw new UnsupportedOperationException();
        }
        this.jsCodeBuilder.addChunksToOutputVar(this.genJsExprsVisitor.exec(node));
    }

    private String genParamsRecordType(TemplateNode node) {
        HashSet<String> paramNames = new HashSet<String>();
        LinkedHashMap<String, String> record = new LinkedHashMap<String, String>();
        for (TemplateParam param : node.getParams()) {
            JsType jsType = this.getJsType(param.type());
            record.put(this.genParamAlias(param.name()), jsType.typeExprForRecordMember());
            for (GoogRequire require : jsType.getGoogRequires()) {
                this.jsCodeBuilder.addGoogRequire(require);
            }
            paramNames.add(param.name());
        }
        FindIndirectParamsVisitor.IndirectParamsInfo ipi = new FindIndirectParamsVisitor(this.templateRegistry).exec(node);
        if (!ipi.mayHaveIndirectParamsInExternalCalls && !ipi.mayHaveIndirectParamsInExternalDelCalls) {
            for (String indirectParamName : ipi.indirectParamTypes.keySet()) {
                if (paramNames.contains(indirectParamName)) continue;
                Collection paramTypes = ipi.indirectParamTypes.get((Object)indirectParamName);
                SoyType combinedType = this.typeOps.computeLowestCommonType(paramTypes);
                SoyType indirectParamType = this.typeOps.getTypeRegistry().getOrCreateUnionType(combinedType, NullType.getInstance());
                JsType jsType = this.getJsType(indirectParamType);
                record.put(this.genParamAlias(indirectParamName), jsType.typeExprForRecordMember());
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{\n *  ");
        Joiner.on((String)",\n *  ").withKeyValueSeparator(": ").appendTo(sb, record);
        sb.append("\n * }");
        return sb.toString();
    }

    protected void genParamTypeChecks(TemplateNode node) {
        for (TemplateParam param : node.getAllParams()) {
            Optional<CodeChunk.WithValue> typeAssertion;
            if (param.declLoc() != TemplateParam.DeclLoc.HEADER) continue;
            String paramName = param.name();
            SoyType paramType = param.type();
            CodeChunk.Generator generator = this.templateTranslationContext.codeGenerator();
            CodeChunk.WithValue paramChunk = TranslateExprNodeVisitor.genCodeForParamAccess(paramName, param.isInjected());
            JsType jsType = this.getJsType(paramType);
            String paramAlias = this.genParamAlias(paramName);
            CodeChunk.WithValue coerced = jsType.getValueCoercion(paramChunk, generator);
            if (coerced != null) {
                paramChunk = generator.declare(coerced).ref();
            }
            CodeChunk.WithValue value = (typeAssertion = jsType.getTypeAssertion(paramChunk, generator)).isPresent() ? JsRuntime.SOY_ASSERTS_ASSERT_TYPE.call((CodeChunk.WithValue)typeAssertion.get(), CodeChunk.stringLiteral(paramName), paramChunk, CodeChunk.stringLiteral(jsType.typeExpr())) : paramChunk;
            String closureTypeExpr = this.jsSrcOptions.shouldGenerateJsdoc() ? jsType.typeExpr() : null;
            this.jsCodeBuilder.append(CodeChunk.declare(paramAlias, value, closureTypeExpr, jsType.getGoogRequires()));
            this.templateTranslationContext.soyToJsVariableMappings().put(paramName, CodeChunk.id(paramAlias));
        }
    }

    private JsType getJsType(SoyType paramType) {
        boolean isIncrementalDom = !this.getClass().equals(GenJsCodeVisitor.class);
        return JsType.forSoyType(paramType, isIncrementalDom);
    }

    private String genParamAlias(String paramName) {
        return JsSrcUtils.isReservedWord(paramName) ? "param$" + paramName : paramName;
    }

    private boolean hasStrictParams(TemplateNode template) {
        for (TemplateParam param : template.getParams()) {
            if (param.declLoc() != TemplateParam.DeclLoc.HEADER) continue;
            return true;
        }
        return false;
    }
}

