/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_Composite;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OutputContext;
import com.google.template.soy.jssrc.dsl.VariableReference;
import com.google.template.soy.jssrc.restricted.JsExpr;

@Immutable
public abstract class Composite
extends CodeChunk.WithValue {
    abstract ImmutableList<CodeChunk> initialStmts();

    abstract CodeChunk.WithValue value();

    static Composite create(ImmutableList<CodeChunk> initialStatements, CodeChunk.WithValue value) {
        Preconditions.checkState((!initialStatements.isEmpty() ? 1 : 0) != 0);
        return new AutoValue_Composite((ImmutableSet<CodeChunk>)ImmutableSet.builder().addAll(initialStatements).addAll(value.initialStatements()).build(), initialStatements, value);
    }

    @Override
    String getCode(int startingIndent, OutputContext outputContext) {
        return this.value() instanceof VariableReference ? new FormattingContext(startingIndent).appendInitialStatements(this).toString() : super.getCode(startingIndent, outputContext);
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        for (CodeChunk stmt : this.initialStmts()) {
            ctx.appendAll(stmt);
        }
        ctx.appendInitialStatements(this.value());
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (CodeChunk stmt : this.initialStmts()) {
            stmt.collectRequires(collector);
        }
        this.value().collectRequires(collector);
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.appendOutputExpression(this.value());
    }

    @Override
    public JsExpr singleExprOrName() {
        return this.value().singleExprOrName();
    }
}

