/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.jbcsrc.shared.TemplateMetadata;
import com.google.template.soy.shared.internal.DelTemplateSelector;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public final class CompiledTemplates {
    private final ClassLoader loader;
    private final ConcurrentHashMap<String, TemplateData> templateNameToFactory = new ConcurrentHashMap();
    private final DelTemplateSelector<TemplateData> selector;

    public CompiledTemplates(ImmutableSet<String> delTemplateNames) {
        this(delTemplateNames, CompiledTemplates.class.getClassLoader());
    }

    public CompiledTemplates(ImmutableSet<String> delTemplateNames, ClassLoader loader) {
        this.loader = (ClassLoader)Preconditions.checkNotNull((Object)loader);
        DelTemplateSelector.Builder<TemplateData> builder = new DelTemplateSelector.Builder<TemplateData>();
        for (String delTemplateImplName : delTemplateNames) {
            TemplateData data = this.getTemplateData(delTemplateImplName);
            if (!data.delTemplateName.isPresent()) {
                throw new IllegalArgumentException("Expected " + delTemplateImplName + " to be a deltemplate");
            }
            String delTemplateName = (String)data.delTemplateName.get();
            if (data.delPackage.isPresent()) {
                String delpackage = (String)data.delPackage.get();
                TemplateData prev = builder.add(delTemplateName, delpackage, data.variant, data);
                if (prev == null) continue;
                throw new IllegalArgumentException(String.format("Found multiple deltemplates with the same name (%s) and package (%s). %s and %s", delTemplateName, delpackage, delTemplateImplName, Names.soyTemplateNameFromJavaClassName(prev.factory.getClass().getDeclaringClass().getName())));
            }
            TemplateData prev = builder.addDefault(delTemplateName, data.variant, data);
            if (prev == null) continue;
            throw new IllegalArgumentException(String.format("Found multiple default deltemplates with the same name (%s). %s and %s", delTemplateName, delTemplateImplName, Names.soyTemplateNameFromJavaClassName(prev.factory.getClass().getDeclaringClass().getName())));
        }
        this.selector = builder.build();
    }

    public Optional<SanitizedContent.ContentKind> getTemplateContentKind(String name) {
        return this.getTemplateData((String)name).kind;
    }

    public CompiledTemplate.Factory getTemplateFactory(String name) {
        return this.getTemplateData((String)name).factory;
    }

    public void loadAll(Iterable<String> templateNames) {
        for (String templateName : templateNames) {
            this.getTemplateData(templateName);
        }
    }

    public ImmutableSortedSet<String> getTransitiveIjParamsForTemplate(String templateName) {
        TemplateData templateData = this.getTemplateData(templateName);
        ImmutableSortedSet transitiveIjParams = templateData.transitiveIjParams;
        if (transitiveIjParams != null) {
            return transitiveIjParams;
        }
        HashSet<TemplateData> all = new HashSet<TemplateData>();
        this.collectTransitiveCallees(templateData, all);
        ImmutableSortedSet.Builder ijs = ImmutableSortedSet.naturalOrder();
        for (TemplateData callee : all) {
            ijs.addAll(callee.injectedParams);
        }
        templateData.transitiveIjParams = transitiveIjParams = ijs.build();
        return transitiveIjParams;
    }

    @Nullable
    CompiledTemplate.Factory selectDelTemplate(String delTemplateName, String variant, Predicate<String> activeDelPackageSelector) {
        TemplateData selectedTemplate = this.selector.selectTemplate(delTemplateName, variant, activeDelPackageSelector);
        return selectedTemplate == null ? null : selectedTemplate.factory;
    }

    private TemplateData getTemplateData(String name) {
        TemplateData old;
        Preconditions.checkNotNull((Object)name);
        TemplateData template = this.templateNameToFactory.get(name);
        if (template == null && (old = this.templateNameToFactory.putIfAbsent(name, template = CompiledTemplates.loadFactory(name, this.loader))) != null) {
            return old;
        }
        return template;
    }

    private static TemplateData loadFactory(String name, ClassLoader loader) {
        CompiledTemplate.Factory factory;
        try {
            String factoryName = Names.javaClassNameFromSoyTemplateName(name) + "$Factory";
            Class<CompiledTemplate.Factory> factoryClass = Class.forName(factoryName, true, loader).asSubclass(CompiledTemplate.Factory.class);
            factory = factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No class was compiled for template: " + name, e);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
        return new TemplateData(factory);
    }

    private void collectTransitiveCallees(TemplateData templateData, Set<TemplateData> visited) {
        if (!visited.add(templateData)) {
            return;
        }
        for (String callee : templateData.callees) {
            this.collectTransitiveCallees(this.getTemplateData(callee), visited);
        }
        for (String delCallee : templateData.delCallees) {
            for (TemplateData potentialCallee : this.selector.delTemplateNameToValues().get((Object)delCallee)) {
                this.collectTransitiveCallees(potentialCallee, visited);
            }
        }
    }

    private static final class TemplateData {
        final CompiledTemplate.Factory factory;
        final Optional<SanitizedContent.ContentKind> kind;
        final ImmutableSet<String> callees;
        final ImmutableSet<String> delCallees;
        final ImmutableSet<String> injectedParams;
        final Optional<String> delTemplateName;
        final Optional<String> delPackage;
        final String variant;
        ImmutableSortedSet<String> transitiveIjParams;

        TemplateData(CompiledTemplate.Factory factory) {
            this.factory = factory;
            TemplateMetadata annotation = factory.getClass().getDeclaringClass().getAnnotation(TemplateMetadata.class);
            String contentKind = annotation.contentKind();
            this.kind = contentKind.isEmpty() ? Optional.absent() : Optional.of((Object)((Object)SanitizedContent.ContentKind.valueOf(contentKind)));
            this.callees = ImmutableSet.copyOf((Object[])annotation.callees());
            this.delCallees = ImmutableSet.copyOf((Object[])annotation.delCallees());
            this.injectedParams = ImmutableSet.copyOf((Object[])annotation.injectedParams());
            TemplateMetadata.DelTemplateMetadata deltemplateMetadata = annotation.deltemplateMetadata();
            this.variant = deltemplateMetadata.variant();
            if (!deltemplateMetadata.name().isEmpty()) {
                this.delTemplateName = Optional.of((Object)deltemplateMetadata.name());
                this.delPackage = deltemplateMetadata.delPackage().isEmpty() ? Optional.absent() : Optional.of((Object)deltemplateMetadata.delPackage());
            } else {
                this.delTemplateName = Optional.absent();
                this.delPackage = Optional.absent();
            }
        }
    }
}

